import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionUrlMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full or partial URL of the defaultService resource to which traffic is directed if
  none of the hostRules match. If defaultRouteAction is additionally specified, advanced
  routing actions like URL Rewrites, etc. take effect prior to sending the request to the
  backend. However, if defaultService is specified, defaultRouteAction cannot contain any
  weightedBackendServices. Conversely, if routeAction specifies any
  weightedBackendServices, service must not be specified.  Only one of defaultService,
  defaultUrlRedirect or defaultRouteAction.weightedBackendService must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#default_service GoogleComputeRegionUrlMap#default_service}
    */
    readonly defaultService?: string;
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#description GoogleComputeRegionUrlMap#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#id GoogleComputeRegionUrlMap#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#name GoogleComputeRegionUrlMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#project GoogleComputeRegionUrlMap#project}
    */
    readonly project?: string;
    /**
    * The Region in which the url map should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#region GoogleComputeRegionUrlMap#region}
    */
    readonly region?: string;
    /**
    * default_url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#default_url_redirect GoogleComputeRegionUrlMap#default_url_redirect}
    */
    readonly defaultUrlRedirect?: GoogleComputeRegionUrlMapDefaultUrlRedirect;
    /**
    * host_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#host_rule GoogleComputeRegionUrlMap#host_rule}
    */
    readonly hostRule?: GoogleComputeRegionUrlMapHostRule[] | cdktf.IResolvable;
    /**
    * path_matcher block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#path_matcher GoogleComputeRegionUrlMap#path_matcher}
    */
    readonly pathMatcher?: GoogleComputeRegionUrlMapPathMatcher[] | cdktf.IResolvable;
    /**
    * test block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#test GoogleComputeRegionUrlMap#test}
    */
    readonly test?: GoogleComputeRegionUrlMapTest[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#timeouts GoogleComputeRegionUrlMap#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionUrlMapTimeouts;
}
export interface GoogleComputeRegionUrlMapDefaultUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was
  supplied in the request. The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#host_redirect GoogleComputeRegionUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set to
  false, the URL scheme of the redirected request will remain the same as that of the
  request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
  true for TargetHttpsProxy is not permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#https_redirect GoogleComputeRegionUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was
  supplied in the request. pathRedirect cannot be supplied together with
  prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
  original request will be used for the redirect. The value must be between 1 and 1024
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#path_redirect GoogleComputeRegionUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
  retaining the remaining portion of the URL before redirecting the request.
  prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
  neither. If neither is supplied, the path of the original request will be used for
  the redirect. The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#prefix_redirect GoogleComputeRegionUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#redirect_response_code GoogleComputeRegionUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed prior
  to redirecting the request. If set to false, the query portion of the original URL is
  retained.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#strip_query GoogleComputeRegionUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapDefaultUrlRedirectToTerraform(struct?: GoogleComputeRegionUrlMapDefaultUrlRedirectOutputReference | GoogleComputeRegionUrlMapDefaultUrlRedirect): any;
export declare class GoogleComputeRegionUrlMapDefaultUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapDefaultUrlRedirect | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapDefaultUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeRegionUrlMapHostRule {
    /**
    * An optional description of this HostRule. Provide this property
  when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#description GoogleComputeRegionUrlMap#description}
    */
    readonly description?: string;
    /**
    * The list of host patterns to match. They must be valid
  hostnames, except * will match any string of ([a-z0-9-.]*). In
  that case, * must be the first character and must be followed in
  the pattern by either - or ..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#hosts GoogleComputeRegionUrlMap#hosts}
    */
    readonly hosts: string[];
    /**
    * The name of the PathMatcher to use to match the path portion of
  the URL if the hostRule matches the URL's host portion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#path_matcher GoogleComputeRegionUrlMap#path_matcher}
    */
    readonly pathMatcher: string;
}
export declare function googleComputeRegionUrlMapHostRuleToTerraform(struct?: GoogleComputeRegionUrlMapHostRule | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapHostRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapHostRule | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapHostRule | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    get hostsInput(): string[] | undefined;
    private _pathMatcher?;
    get pathMatcher(): string;
    set pathMatcher(value: string);
    get pathMatcherInput(): string | undefined;
}
export declare class GoogleComputeRegionUrlMapHostRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapHostRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapHostRuleOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherDefaultUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was
  supplied in the request. The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#host_redirect GoogleComputeRegionUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set to
  false, the URL scheme of the redirected request will remain the same as that of the
  request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
  true for TargetHttpsProxy is not permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#https_redirect GoogleComputeRegionUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was
  supplied in the request. pathRedirect cannot be supplied together with
  prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
  original request will be used for the redirect. The value must be between 1 and 1024
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#path_redirect GoogleComputeRegionUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
  retaining the remaining portion of the URL before redirecting the request.
  prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
  neither. If neither is supplied, the path of the original request will be used for
  the redirect. The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#prefix_redirect GoogleComputeRegionUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#redirect_response_code GoogleComputeRegionUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed prior
  to redirecting the request. If set to false, the query portion of the original URL is
  retained.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#strip_query GoogleComputeRegionUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherDefaultUrlRedirectToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherDefaultUrlRedirectOutputReference | GoogleComputeRegionUrlMapPathMatcherDefaultUrlRedirect): any;
export declare class GoogleComputeRegionUrlMapPathMatcherDefaultUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherDefaultUrlRedirect | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherDefaultUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the
  actual request can include user credentials. This translates to the Access-
  Control-Allow-Credentials header. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#allow_credentials GoogleComputeRegionUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#allow_headers GoogleComputeRegionUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#allow_methods GoogleComputeRegionUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For
  regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#allow_origin_regexes GoogleComputeRegionUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests. An
  origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#allow_origins GoogleComputeRegionUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#disabled GoogleComputeRegionUrlMap#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#expose_headers GoogleComputeRegionUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long the results of a preflight request can be cached. This
  translates to the content for the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#max_age GoogleComputeRegionUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicyToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request. The value must be between 200
  and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#http_status GoogleComputeRegionUrlMap#http_status}
    */
    readonly httpStatus: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be
  aborted as part of fault injection. The value must be between 0.0 and 100.0
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#percentage GoogleComputeRegionUrlMap#percentage}
    */
    readonly percentage: number;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#nanos GoogleComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#seconds GoogleComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will
  be introduced as part of fault injection. The value must be between 0.0 and
  100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#percentage GoogleComputeRegionUrlMap#percentage}
    */
    readonly percentage: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#fixed_delay GoogleComputeRegionUrlMap#fixed_delay}
    */
    readonly fixedDelay: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    get fixedDelayInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#abort GoogleComputeRegionUrlMap#abort}
    */
    readonly abort?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#delay GoogleComputeRegionUrlMap#delay}
    */
    readonly delay?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy {
    /**
    * The RegionBackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#backend_service GoogleComputeRegionUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#nanos GoogleComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#seconds GoogleComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#num_retries GoogleComputeRegionUrlMap#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specifies one or more conditions when this retry rule applies. Valid values are:
  
  - 5xx: Loadbalancer will attempt a retry if the backend service responds with
  any 5xx response code, or if the backend service does not respond at all,
  example: disconnects, reset, read timeout, connection failure, and refused
  streams.
  - gateway-error: Similar to 5xx, but only applies to response codes
  502, 503 or 504.
  - connect-failure: Loadbalancer will retry on failures
  connecting to backend services, for example due to connection timeouts.
  - retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
  Currently the only retriable error supported is 409.
  - refused-stream: Loadbalancer will retry if the backend service resets the stream with a
  REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
  - cancelled: Loadbalancer will retry if the gRPC status code in the response
  header is set to cancelled
  - deadline-exceeded: Loadbalancer will retry if the
  gRPC status code in the response header is set to deadline-exceeded
  - resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
  header is set to resource-exhausted
  - unavailable: Loadbalancer will retry if
  the gRPC status code in the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#retry_conditions GoogleComputeRegionUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#per_try_timeout GoogleComputeRegionUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#nanos GoogleComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#seconds GoogleComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeoutToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host
  header is replaced with contents of hostRewrite. The value must be between 1 and
  255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#host_rewrite GoogleComputeRegionUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching
  portion of the request's path is replaced by pathPrefixRewrite. The value must
  be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#path_prefix_rewrite GoogleComputeRegionUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewriteToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_name GoogleComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_value GoogleComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#replace GoogleComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_name GoogleComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_value GoogleComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#replace GoogleComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#request_headers_to_remove GoogleComputeRegionUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#response_headers_to_remove GoogleComputeRegionUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#request_headers_to_add GoogleComputeRegionUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#response_headers_to_add GoogleComputeRegionUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices {
    /**
    * The default RegionBackendService resource. Before
  forwarding the request to backendService, the loadbalancer applies any relevant
  headerActions specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#backend_service GoogleComputeRegionUrlMap#backend_service}
    */
    readonly backendService: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as weight /
  (sum of all weightedBackendService weights in routeAction) . The selection of a
  backend service is determined only for new traffic. Once a user's request has
  been directed to a backendService, subsequent requests will be sent to the same
  backendService as determined by the BackendService's session affinity policy.
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#weight GoogleComputeRegionUrlMap#weight}
    */
    readonly weight: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_action GoogleComputeRegionUrlMap#header_action}
    */
    readonly headerAction?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#cors_policy GoogleComputeRegionUrlMap#cors_policy}
    */
    readonly corsPolicy?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#fault_injection_policy GoogleComputeRegionUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#request_mirror_policy GoogleComputeRegionUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#retry_policy GoogleComputeRegionUrlMap#retry_policy}
    */
    readonly retryPolicy?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#timeout GoogleComputeRegionUrlMap#timeout}
    */
    readonly timeout?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#url_rewrite GoogleComputeRegionUrlMap#url_rewrite}
    */
    readonly urlRewrite?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#weighted_backend_services GoogleComputeRegionUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleRouteActionToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteAction): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteAction | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference;
    putTimeout(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRuleUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one
  that was supplied in the request. The value must be between 1 and 255
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#host_redirect GoogleComputeRegionUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https.
  If set to false, the URL scheme of the redirected request will remain the
  same as that of the request. This must only be set for UrlMaps used in
  TargetHttpProxys. Setting this true for TargetHttpsProxy is not
  permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#https_redirect GoogleComputeRegionUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one
  that was supplied in the request. pathRedirect cannot be supplied
  together with prefixRedirect. Supply one alone or neither. If neither is
  supplied, the path of the original request will be used for the redirect.
  The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#path_redirect GoogleComputeRegionUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the
  HttpRouteRuleMatch, retaining the remaining portion of the URL before
  redirecting the request. prefixRedirect cannot be supplied together with
  pathRedirect. Supply one alone or neither. If neither is supplied, the
  path of the original request will be used for the redirect. The value
  must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#prefix_redirect GoogleComputeRegionUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#redirect_response_code GoogleComputeRegionUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed
  prior to redirecting the request. If set to false, the query portion of the
  original URL is retained.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#strip_query GoogleComputeRegionUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleUrlRedirectToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRuleUrlRedirectOutputReference | GoogleComputeRegionUrlMapPathMatcherPathRuleUrlRedirect): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRuleUrlRedirect | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRuleUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherPathRule {
    /**
    * The list of path patterns to match. Each must start with / and the only place a
  \* is allowed is at the end following a /. The string fed to the path matcher
  does not include any text after the first ? or #, and those chars are not
  allowed here.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#paths GoogleComputeRegionUrlMap#paths}
    */
    readonly paths: string[];
    /**
    * The region backend service resource to which traffic is
  directed if this rule is matched. If routeAction is additionally specified,
  advanced routing actions like URL Rewrites, etc. take effect prior to sending
  the request to the backend. However, if service is specified, routeAction cannot
  contain any weightedBackendService s. Conversely, if routeAction specifies any
  weightedBackendServices, service must not be specified. Only one of urlRedirect,
  service or routeAction.weightedBackendService must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#service GoogleComputeRegionUrlMap#service}
    */
    readonly service?: string;
    /**
    * route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#route_action GoogleComputeRegionUrlMap#route_action}
    */
    readonly routeAction?: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteAction;
    /**
    * url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#url_redirect GoogleComputeRegionUrlMap#url_redirect}
    */
    readonly urlRedirect?: GoogleComputeRegionUrlMapPathMatcherPathRuleUrlRedirect;
}
export declare function googleComputeRegionUrlMapPathMatcherPathRuleToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherPathRule | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherPathRule | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherPathRule | cdktf.IResolvable | undefined);
    private _paths?;
    get paths(): string[];
    set paths(value: string[]);
    get pathsInput(): string[] | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _routeAction;
    get routeAction(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteActionOutputReference;
    putRouteAction(value: GoogleComputeRegionUrlMapPathMatcherPathRuleRouteAction): void;
    resetRouteAction(): void;
    get routeActionInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleRouteAction | undefined;
    private _urlRedirect;
    get urlRedirect(): GoogleComputeRegionUrlMapPathMatcherPathRuleUrlRedirectOutputReference;
    putUrlRedirect(value: GoogleComputeRegionUrlMapPathMatcherPathRuleUrlRedirect): void;
    resetUrlRedirect(): void;
    get urlRedirectInput(): GoogleComputeRegionUrlMapPathMatcherPathRuleUrlRedirect | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherPathRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherPathRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherPathRuleOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_name GoogleComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_value GoogleComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#replace GoogleComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_name GoogleComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_value GoogleComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#replace GoogleComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#request_headers_to_remove GoogleComputeRegionUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#response_headers_to_remove GoogleComputeRegionUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#request_headers_to_add GoogleComputeRegionUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#response_headers_to_add GoogleComputeRegionUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderAction): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderAction | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch {
    /**
    * The end of the range (exclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#range_end GoogleComputeRegionUrlMap#range_end}
    */
    readonly rangeEnd: number;
    /**
    * The start of the range (inclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#range_start GoogleComputeRegionUrlMap#range_start}
    */
    readonly rangeStart: number;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined);
    private _rangeEnd?;
    get rangeEnd(): number;
    set rangeEnd(value: number);
    get rangeEndInput(): number | undefined;
    private _rangeStart?;
    get rangeStart(): number;
    set rangeStart(value: number);
    get rangeStartInput(): number | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches {
    /**
    * The value should exactly match contents of exactMatch. Only one of exactMatch,
  prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#exact_match GoogleComputeRegionUrlMap#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The name of the HTTP header to match. For matching against the HTTP request's
  authority, use a headerMatch with the header name ":authority". For matching a
  request's method, use the headerName ":method".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_name GoogleComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * If set to false, the headerMatch is considered a match if the match criteria
  above are met. If set to true, the headerMatch is considered a match if the
  match criteria above are NOT met. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#invert_match GoogleComputeRegionUrlMap#invert_match}
    */
    readonly invertMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must start with the contents of prefixMatch. Only one of
  exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#prefix_match GoogleComputeRegionUrlMap#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * A header with the contents of headerName must exist. The match takes place
  whether or not the request's header has a value or not. Only one of exactMatch,
  prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#present_match GoogleComputeRegionUrlMap#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must match the regular expression specified in
  regexMatch. For regular expression grammar, please see:
  en.cppreference.com/w/cpp/regex/ecmascript  For matching against a port
  specified in the HTTP request, use a headerMatch with headerName set to PORT and
  a regular expression that satisfies the RFC2616 Host header's port specifier.
  Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
  rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#regex_match GoogleComputeRegionUrlMap#regex_match}
    */
    readonly regexMatch?: string;
    /**
    * The value of the header must end with the contents of suffixMatch. Only one of
  exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#suffix_match GoogleComputeRegionUrlMap#suffix_match}
    */
    readonly suffixMatch?: string;
    /**
    * range_match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#range_match GoogleComputeRegionUrlMap#range_match}
    */
    readonly rangeMatch?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable | undefined);
    private _exactMatch?;
    get exactMatch(): string;
    set exactMatch(value: string);
    resetExactMatch(): void;
    get exactMatchInput(): string | undefined;
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _invertMatch?;
    get invertMatch(): boolean | cdktf.IResolvable;
    set invertMatch(value: boolean | cdktf.IResolvable);
    resetInvertMatch(): void;
    get invertMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string;
    set prefixMatch(value: string);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string | undefined;
    private _presentMatch?;
    get presentMatch(): boolean | cdktf.IResolvable;
    set presentMatch(value: boolean | cdktf.IResolvable);
    resetPresentMatch(): void;
    get presentMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
    private _suffixMatch?;
    get suffixMatch(): string;
    set suffixMatch(value: string);
    resetSuffixMatch(): void;
    get suffixMatchInput(): string | undefined;
    private _rangeMatch;
    get rangeMatch(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference;
    putRangeMatch(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch): void;
    resetRangeMatch(): void;
    get rangeMatchInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels {
    /**
    * Name of metadata label. The name can have a maximum length of 1024 characters
  and must be at least 1 character long.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#name GoogleComputeRegionUrlMap#name}
    */
    readonly name: string;
    /**
    * The value of the label must match the specified value. value can have a maximum
  length of 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#value GoogleComputeRegionUrlMap#value}
    */
    readonly value: string;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters {
    /**
    * Specifies how individual filterLabel matches within the list of filterLabels
  contribute towards the overall metadataFilter match. Supported values are:
  
  * MATCH_ANY: At least one of the filterLabels must have a matching label in the
  provided metadata.
  * MATCH_ALL: All filterLabels must have matching labels in
  the provided metadata. Possible values: ["MATCH_ALL", "MATCH_ANY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#filter_match_criteria GoogleComputeRegionUrlMap#filter_match_criteria}
    */
    readonly filterMatchCriteria: string;
    /**
    * filter_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#filter_labels GoogleComputeRegionUrlMap#filter_labels}
    */
    readonly filterLabels: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable | undefined);
    private _filterMatchCriteria?;
    get filterMatchCriteria(): string;
    set filterMatchCriteria(value: string);
    get filterMatchCriteriaInput(): string | undefined;
    private _filterLabels;
    get filterLabels(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsList;
    putFilterLabels(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable): void;
    get filterLabelsInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches {
    /**
    * The queryParameterMatch matches if the value of the parameter exactly matches
  the contents of exactMatch. Only one of presentMatch, exactMatch and regexMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#exact_match GoogleComputeRegionUrlMap#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The name of the query parameter to match. The query parameter must exist in the
  request, in the absence of which the request match fails.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#name GoogleComputeRegionUrlMap#name}
    */
    readonly name: string;
    /**
    * Specifies that the queryParameterMatch matches if the request contains the query
  parameter, irrespective of whether the parameter has a value or not. Only one of
  presentMatch, exactMatch and regexMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#present_match GoogleComputeRegionUrlMap#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The queryParameterMatch matches if the value of the parameter matches the
  regular expression specified by regexMatch. For the regular expression grammar,
  please see en.cppreference.com/w/cpp/regex/ecmascript  Only one of presentMatch,
  exactMatch and regexMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#regex_match GoogleComputeRegionUrlMap#regex_match}
    */
    readonly regexMatch?: string;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable | undefined);
    private _exactMatch?;
    get exactMatch(): string;
    set exactMatch(value: string);
    resetExactMatch(): void;
    get exactMatchInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _presentMatch?;
    get presentMatch(): boolean | cdktf.IResolvable;
    set presentMatch(value: boolean | cdktf.IResolvable);
    resetPresentMatch(): void;
    get presentMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRules {
    /**
    * For satisfying the matchRule condition, the path of the request must exactly
  match the value specified in fullPathMatch after removing any query parameters
  and anchor that may be part of the original URL. FullPathMatch must be between 1
  and 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must
  be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#full_path_match GoogleComputeRegionUrlMap#full_path_match}
    */
    readonly fullPathMatch?: string;
    /**
    * Specifies that prefixMatch and fullPathMatch matches are case sensitive.
  Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#ignore_case GoogleComputeRegionUrlMap#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * For satisfying the matchRule condition, the request's path must begin with the
  specified prefixMatch. prefixMatch must begin with a /. The value must be
  between 1 and 1024 characters. Only one of prefixMatch, fullPathMatch or
  regexMatch must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#prefix_match GoogleComputeRegionUrlMap#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * For satisfying the matchRule condition, the path of the request must satisfy the
  regular expression specified in regexMatch after removing any query parameters
  and anchor supplied with the original URL. For regular expression grammar please
  see en.cppreference.com/w/cpp/regex/ecmascript  Only one of prefixMatch,
  fullPathMatch or regexMatch must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#regex_match GoogleComputeRegionUrlMap#regex_match}
    */
    readonly regexMatch?: string;
    /**
    * header_matches block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_matches GoogleComputeRegionUrlMap#header_matches}
    */
    readonly headerMatches?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable;
    /**
    * metadata_filters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#metadata_filters GoogleComputeRegionUrlMap#metadata_filters}
    */
    readonly metadataFilters?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable;
    /**
    * query_parameter_matches block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#query_parameter_matches GoogleComputeRegionUrlMap#query_parameter_matches}
    */
    readonly queryParameterMatches?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable | undefined);
    private _fullPathMatch?;
    get fullPathMatch(): string;
    set fullPathMatch(value: string);
    resetFullPathMatch(): void;
    get fullPathMatchInput(): string | undefined;
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string;
    set prefixMatch(value: string);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
    private _headerMatches;
    get headerMatches(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesList;
    putHeaderMatches(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable): void;
    resetHeaderMatches(): void;
    get headerMatchesInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | undefined;
    private _metadataFilters;
    get metadataFilters(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersList;
    putMetadataFilters(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable): void;
    resetMetadataFilters(): void;
    get metadataFiltersInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | undefined;
    private _queryParameterMatches;
    get queryParameterMatches(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesList;
    putQueryParameterMatches(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable): void;
    resetQueryParameterMatches(): void;
    get queryParameterMatchesInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the
  actual request can include user credentials. This translates to the Access-
  Control-Allow-Credentials header. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#allow_credentials GoogleComputeRegionUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#allow_headers GoogleComputeRegionUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#allow_methods GoogleComputeRegionUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For
  regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#allow_origin_regexes GoogleComputeRegionUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests. An
  origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#allow_origins GoogleComputeRegionUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled.
  which indicates that the CORS policy is in effect. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#disabled GoogleComputeRegionUrlMap#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#expose_headers GoogleComputeRegionUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long the results of a preflight request can be cached. This
  translates to the content for the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#max_age GoogleComputeRegionUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicyToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request. The value must be between 200
  and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#http_status GoogleComputeRegionUrlMap#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be
  aborted as part of fault injection. The value must be between 0.0 and 100.0
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#percentage GoogleComputeRegionUrlMap#percentage}
    */
    readonly percentage?: number;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#nanos GoogleComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#seconds GoogleComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will
  be introduced as part of fault injection. The value must be between 0.0 and
  100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#percentage GoogleComputeRegionUrlMap#percentage}
    */
    readonly percentage?: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#fixed_delay GoogleComputeRegionUrlMap#fixed_delay}
    */
    readonly fixedDelay?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#abort GoogleComputeRegionUrlMap#abort}
    */
    readonly abort?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#delay GoogleComputeRegionUrlMap#delay}
    */
    readonly delay?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy {
    /**
    * The RegionBackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#backend_service GoogleComputeRegionUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#nanos GoogleComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#seconds GoogleComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#num_retries GoogleComputeRegionUrlMap#num_retries}
    */
    readonly numRetries: number;
    /**
    * Specifies one or more conditions when this retry rule applies. Valid values are:
  
  * 5xx: Loadbalancer will attempt a retry if the backend service responds with
    any 5xx response code, or if the backend service does not respond at all,
    example: disconnects, reset, read timeout, connection failure, and refused
    streams.
  * gateway-error: Similar to 5xx, but only applies to response codes
    502, 503 or 504.
  * connect-failure: Loadbalancer will retry on failures
    connecting to backend services, for example due to connection timeouts.
  * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
    Currently the only retriable error supported is 409.
  * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
    REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
  * cancelled: Loadbalancer will retry if the gRPC status code in the response
    header is set to cancelled
  * deadline-exceeded: Loadbalancer will retry if the
    gRPC status code in the response header is set to deadline-exceeded
  * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
    header is set to resource-exhausted
  * unavailable: Loadbalancer will retry if the gRPC status code in
    the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#retry_conditions GoogleComputeRegionUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#per_try_timeout GoogleComputeRegionUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#nanos GoogleComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#seconds GoogleComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeoutToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host
  header is replaced with contents of hostRewrite. The value must be between 1 and
  255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#host_rewrite GoogleComputeRegionUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching
  portion of the request's path is replaced by pathPrefixRewrite. The value must
  be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#path_prefix_rewrite GoogleComputeRegionUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewriteToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_name GoogleComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_value GoogleComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#replace GoogleComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_name GoogleComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_value GoogleComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#replace GoogleComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#request_headers_to_remove GoogleComputeRegionUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#response_headers_to_remove GoogleComputeRegionUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#request_headers_to_add GoogleComputeRegionUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#response_headers_to_add GoogleComputeRegionUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices {
    /**
    * The default RegionBackendService resource. Before
  forwarding the request to backendService, the loadbalancer applies any relevant
  headerActions specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#backend_service GoogleComputeRegionUrlMap#backend_service}
    */
    readonly backendService: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as weight /
  (sum of all weightedBackendService weights in routeAction) . The selection of a
  backend service is determined only for new traffic. Once a user's request has
  been directed to a backendService, subsequent requests will be sent to the same
  backendService as determined by the BackendService's session affinity policy.
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#weight GoogleComputeRegionUrlMap#weight}
    */
    readonly weight: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_action GoogleComputeRegionUrlMap#header_action}
    */
    readonly headerAction?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#cors_policy GoogleComputeRegionUrlMap#cors_policy}
    */
    readonly corsPolicy?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#fault_injection_policy GoogleComputeRegionUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#request_mirror_policy GoogleComputeRegionUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#retry_policy GoogleComputeRegionUrlMap#retry_policy}
    */
    readonly retryPolicy?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#timeout GoogleComputeRegionUrlMap#timeout}
    */
    readonly timeout?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#url_rewrite GoogleComputeRegionUrlMap#url_rewrite}
    */
    readonly urlRewrite?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#weighted_backend_services GoogleComputeRegionUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesRouteActionToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteAction): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteAction | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference;
    putTimeout(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one
  that was supplied in the request. The value must be between 1 and 255
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#host_redirect GoogleComputeRegionUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https.
  If set to false, the URL scheme of the redirected request will remain the
  same as that of the request. This must only be set for UrlMaps used in
  TargetHttpProxys. Setting this true for TargetHttpsProxy is not
  permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#https_redirect GoogleComputeRegionUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one
  that was supplied in the request. pathRedirect cannot be supplied
  together with prefixRedirect. Supply one alone or neither. If neither is
  supplied, the path of the original request will be used for the redirect.
  The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#path_redirect GoogleComputeRegionUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the
  HttpRouteRuleMatch, retaining the remaining portion of the URL before
  redirecting the request. prefixRedirect cannot be supplied together with
  pathRedirect. Supply one alone or neither. If neither is supplied, the
  path of the original request will be used for the redirect. The value
  must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#prefix_redirect GoogleComputeRegionUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#redirect_response_code GoogleComputeRegionUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is
  removed prior to redirecting the request. If set to false, the query
  portion of the original URL is retained. The default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#strip_query GoogleComputeRegionUrlMap#strip_query}
    */
    readonly stripQuery?: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirectToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirectOutputReference | GoogleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    resetStripQuery(): void;
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeRegionUrlMapPathMatcherRouteRules {
    /**
    * For routeRules within a given pathMatcher, priority determines the order
  in which load balancer will interpret routeRules. RouteRules are evaluated
  in order of priority, from the lowest to highest number. The priority of
  a rule decreases as its number increases (1, 2, 3, N+1). The first rule
  that matches the request is applied.
  
  You cannot configure two or more routeRules with the same priority.
  Priority for each rule must be set to a number between 0 and
  2147483647 inclusive.
  
  Priority numbers can have gaps, which enable you to add or remove rules
  in the future without affecting the rest of the rules. For example,
  1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which
  you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the
  future without any impact on existing rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#priority GoogleComputeRegionUrlMap#priority}
    */
    readonly priority: number;
    /**
    * The region backend service resource to which traffic is
  directed if this rule is matched. If routeAction is additionally specified,
  advanced routing actions like URL Rewrites, etc. take effect prior to sending
  the request to the backend. However, if service is specified, routeAction cannot
  contain any weightedBackendService s. Conversely, if routeAction specifies any
  weightedBackendServices, service must not be specified. Only one of urlRedirect,
  service or routeAction.weightedBackendService must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#service GoogleComputeRegionUrlMap#service}
    */
    readonly service?: string;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#header_action GoogleComputeRegionUrlMap#header_action}
    */
    readonly headerAction?: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderAction;
    /**
    * match_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#match_rules GoogleComputeRegionUrlMap#match_rules}
    */
    readonly matchRules?: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable;
    /**
    * route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#route_action GoogleComputeRegionUrlMap#route_action}
    */
    readonly routeAction?: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteAction;
    /**
    * url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#url_redirect GoogleComputeRegionUrlMap#url_redirect}
    */
    readonly urlRedirect?: GoogleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect;
}
export declare function googleComputeRegionUrlMapPathMatcherRouteRulesToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcherRouteRules | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcherRouteRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcherRouteRules | cdktf.IResolvable | undefined);
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesHeaderAction | undefined;
    private _matchRules;
    get matchRules(): GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRulesList;
    putMatchRules(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable): void;
    resetMatchRules(): void;
    get matchRulesInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRulesMatchRules[] | undefined;
    private _routeAction;
    get routeAction(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteActionOutputReference;
    putRouteAction(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteAction): void;
    resetRouteAction(): void;
    get routeActionInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesRouteAction | undefined;
    private _urlRedirect;
    get urlRedirect(): GoogleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirectOutputReference;
    putUrlRedirect(value: GoogleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect): void;
    resetUrlRedirect(): void;
    get urlRedirectInput(): GoogleComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherRouteRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcherRouteRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherRouteRulesOutputReference;
}
export interface GoogleComputeRegionUrlMapPathMatcher {
    /**
    * A reference to a RegionBackendService resource. This will be used if
  none of the pathRules defined by this PathMatcher is matched by
  the URL's path portion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#default_service GoogleComputeRegionUrlMap#default_service}
    */
    readonly defaultService?: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#description GoogleComputeRegionUrlMap#description}
    */
    readonly description?: string;
    /**
    * The name to which this PathMatcher is referred by the HostRule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#name GoogleComputeRegionUrlMap#name}
    */
    readonly name: string;
    /**
    * default_url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#default_url_redirect GoogleComputeRegionUrlMap#default_url_redirect}
    */
    readonly defaultUrlRedirect?: GoogleComputeRegionUrlMapPathMatcherDefaultUrlRedirect;
    /**
    * path_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#path_rule GoogleComputeRegionUrlMap#path_rule}
    */
    readonly pathRule?: GoogleComputeRegionUrlMapPathMatcherPathRule[] | cdktf.IResolvable;
    /**
    * route_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#route_rules GoogleComputeRegionUrlMap#route_rules}
    */
    readonly routeRules?: GoogleComputeRegionUrlMapPathMatcherRouteRules[] | cdktf.IResolvable;
}
export declare function googleComputeRegionUrlMapPathMatcherToTerraform(struct?: GoogleComputeRegionUrlMapPathMatcher | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapPathMatcherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapPathMatcher | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapPathMatcher | cdktf.IResolvable | undefined);
    private _defaultService?;
    get defaultService(): string;
    set defaultService(value: string);
    resetDefaultService(): void;
    get defaultServiceInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _defaultUrlRedirect;
    get defaultUrlRedirect(): GoogleComputeRegionUrlMapPathMatcherDefaultUrlRedirectOutputReference;
    putDefaultUrlRedirect(value: GoogleComputeRegionUrlMapPathMatcherDefaultUrlRedirect): void;
    resetDefaultUrlRedirect(): void;
    get defaultUrlRedirectInput(): GoogleComputeRegionUrlMapPathMatcherDefaultUrlRedirect | undefined;
    private _pathRule;
    get pathRule(): GoogleComputeRegionUrlMapPathMatcherPathRuleList;
    putPathRule(value: GoogleComputeRegionUrlMapPathMatcherPathRule[] | cdktf.IResolvable): void;
    resetPathRule(): void;
    get pathRuleInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherPathRule[] | undefined;
    private _routeRules;
    get routeRules(): GoogleComputeRegionUrlMapPathMatcherRouteRulesList;
    putRouteRules(value: GoogleComputeRegionUrlMapPathMatcherRouteRules[] | cdktf.IResolvable): void;
    resetRouteRules(): void;
    get routeRulesInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcherRouteRules[] | undefined;
}
export declare class GoogleComputeRegionUrlMapPathMatcherList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapPathMatcher[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapPathMatcherOutputReference;
}
export interface GoogleComputeRegionUrlMapTest {
    /**
    * Description of this test case.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#description GoogleComputeRegionUrlMap#description}
    */
    readonly description?: string;
    /**
    * Host portion of the URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#host GoogleComputeRegionUrlMap#host}
    */
    readonly host: string;
    /**
    * Path portion of the URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#path GoogleComputeRegionUrlMap#path}
    */
    readonly path: string;
    /**
    * A reference to expected RegionBackendService resource the given URL should be mapped to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#service GoogleComputeRegionUrlMap#service}
    */
    readonly service: string;
}
export declare function googleComputeRegionUrlMapTestToTerraform(struct?: GoogleComputeRegionUrlMapTest | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapTestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionUrlMapTest | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapTest | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export declare class GoogleComputeRegionUrlMapTestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionUrlMapTest[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionUrlMapTestOutputReference;
}
export interface GoogleComputeRegionUrlMapTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#create GoogleComputeRegionUrlMap#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#delete GoogleComputeRegionUrlMap#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map#update GoogleComputeRegionUrlMap#update}
    */
    readonly update?: string;
}
export declare function googleComputeRegionUrlMapTimeoutsToTerraform(struct?: GoogleComputeRegionUrlMapTimeoutsOutputReference | GoogleComputeRegionUrlMapTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionUrlMapTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionUrlMapTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionUrlMapTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map google_compute_region_url_map}
*/
export declare class GoogleComputeRegionUrlMap extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_url_map";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_url_map google_compute_region_url_map} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionUrlMapConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionUrlMapConfig);
    get creationTimestamp(): string;
    private _defaultService?;
    get defaultService(): string;
    set defaultService(value: string);
    resetDefaultService(): void;
    get defaultServiceInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get mapId(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _defaultUrlRedirect;
    get defaultUrlRedirect(): GoogleComputeRegionUrlMapDefaultUrlRedirectOutputReference;
    putDefaultUrlRedirect(value: GoogleComputeRegionUrlMapDefaultUrlRedirect): void;
    resetDefaultUrlRedirect(): void;
    get defaultUrlRedirectInput(): GoogleComputeRegionUrlMapDefaultUrlRedirect | undefined;
    private _hostRule;
    get hostRule(): GoogleComputeRegionUrlMapHostRuleList;
    putHostRule(value: GoogleComputeRegionUrlMapHostRule[] | cdktf.IResolvable): void;
    resetHostRule(): void;
    get hostRuleInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapHostRule[] | undefined;
    private _pathMatcher;
    get pathMatcher(): GoogleComputeRegionUrlMapPathMatcherList;
    putPathMatcher(value: GoogleComputeRegionUrlMapPathMatcher[] | cdktf.IResolvable): void;
    resetPathMatcher(): void;
    get pathMatcherInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapPathMatcher[] | undefined;
    private _test;
    get test(): GoogleComputeRegionUrlMapTestList;
    putTest(value: GoogleComputeRegionUrlMapTest[] | cdktf.IResolvable): void;
    resetTest(): void;
    get testInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapTest[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionUrlMapTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionUrlMapTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionUrlMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
