import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRouterNatConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of URLs of the IP resources to be drained. These IPs must be
  valid static external IPs that have been assigned to the NAT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#drain_nat_ips GoogleComputeRouterNat#drain_nat_ips}
    */
    readonly drainNatIps?: string[];
    /**
    * Enable Dynamic Port Allocation.
  If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
  If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
  If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
  If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
  
  Mutually exclusive with enableEndpointIndependentMapping.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#enable_dynamic_port_allocation GoogleComputeRouterNat#enable_dynamic_port_allocation}
    */
    readonly enableDynamicPortAllocation?: boolean | cdktf.IResolvable;
    /**
    * Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information
  see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#enable_endpoint_independent_mapping GoogleComputeRouterNat#enable_endpoint_independent_mapping}
    */
    readonly enableEndpointIndependentMapping?: boolean | cdktf.IResolvable;
    /**
    * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#icmp_idle_timeout_sec GoogleComputeRouterNat#icmp_idle_timeout_sec}
    */
    readonly icmpIdleTimeoutSec?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#id GoogleComputeRouterNat#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Maximum number of ports allocated to a VM from this NAT.
  This field can only be set when enableDynamicPortAllocation is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#max_ports_per_vm GoogleComputeRouterNat#max_ports_per_vm}
    */
    readonly maxPortsPerVm?: number;
    /**
    * Minimum number of ports allocated to a VM from this NAT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#min_ports_per_vm GoogleComputeRouterNat#min_ports_per_vm}
    */
    readonly minPortsPerVm?: number;
    /**
    * Name of the NAT service. The name must be 1-63 characters long and
  comply with RFC1035.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#name GoogleComputeRouterNat#name}
    */
    readonly name: string;
    /**
    * How external IPs should be allocated for this NAT. Valid values are
  'AUTO_ONLY' for only allowing NAT IPs allocated by Google Cloud
  Platform, or 'MANUAL_ONLY' for only user-allocated NAT IP addresses. Possible values: ["MANUAL_ONLY", "AUTO_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#nat_ip_allocate_option GoogleComputeRouterNat#nat_ip_allocate_option}
    */
    readonly natIpAllocateOption: string;
    /**
    * Self-links of NAT IPs. Only valid if natIpAllocateOption
  is set to MANUAL_ONLY.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#nat_ips GoogleComputeRouterNat#nat_ips}
    */
    readonly natIps?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#project GoogleComputeRouterNat#project}
    */
    readonly project?: string;
    /**
    * Region where the router and NAT reside.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#region GoogleComputeRouterNat#region}
    */
    readonly region?: string;
    /**
    * The name of the Cloud Router in which this NAT will be configured.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#router GoogleComputeRouterNat#router}
    */
    readonly router: string;
    /**
    * How NAT should be configured per Subnetwork.
  If 'ALL_SUBNETWORKS_ALL_IP_RANGES', all of the
  IP ranges in every Subnetwork are allowed to Nat.
  If 'ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES', all of the primary IP
  ranges in every Subnetwork are allowed to Nat.
  'LIST_OF_SUBNETWORKS': A list of Subnetworks are allowed to Nat
  (specified in the field subnetwork below). Note that if this field
  contains ALL_SUBNETWORKS_ALL_IP_RANGES or
  ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
  other RouterNat section in any Router for this network in this region. Possible values: ["ALL_SUBNETWORKS_ALL_IP_RANGES", "ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES", "LIST_OF_SUBNETWORKS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#source_subnetwork_ip_ranges_to_nat GoogleComputeRouterNat#source_subnetwork_ip_ranges_to_nat}
    */
    readonly sourceSubnetworkIpRangesToNat: string;
    /**
    * Timeout (in seconds) for TCP established connections.
  Defaults to 1200s if not set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#tcp_established_idle_timeout_sec GoogleComputeRouterNat#tcp_established_idle_timeout_sec}
    */
    readonly tcpEstablishedIdleTimeoutSec?: number;
    /**
    * Timeout (in seconds) for TCP transitory connections.
  Defaults to 30s if not set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#tcp_transitory_idle_timeout_sec GoogleComputeRouterNat#tcp_transitory_idle_timeout_sec}
    */
    readonly tcpTransitoryIdleTimeoutSec?: number;
    /**
    * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#udp_idle_timeout_sec GoogleComputeRouterNat#udp_idle_timeout_sec}
    */
    readonly udpIdleTimeoutSec?: number;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#log_config GoogleComputeRouterNat#log_config}
    */
    readonly logConfig?: GoogleComputeRouterNatLogConfig;
    /**
    * subnetwork block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#subnetwork GoogleComputeRouterNat#subnetwork}
    */
    readonly subnetwork?: GoogleComputeRouterNatSubnetwork[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#timeouts GoogleComputeRouterNat#timeouts}
    */
    readonly timeouts?: GoogleComputeRouterNatTimeouts;
}
export interface GoogleComputeRouterNatLogConfig {
    /**
    * Indicates whether or not to export logs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#enable GoogleComputeRouterNat#enable}
    */
    readonly enable: boolean | cdktf.IResolvable;
    /**
    * Specifies the desired filtering of logs on this NAT. Possible values: ["ERRORS_ONLY", "TRANSLATIONS_ONLY", "ALL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#filter GoogleComputeRouterNat#filter}
    */
    readonly filter: string;
}
export declare function googleComputeRouterNatLogConfigToTerraform(struct?: GoogleComputeRouterNatLogConfigOutputReference | GoogleComputeRouterNatLogConfig): any;
export declare class GoogleComputeRouterNatLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRouterNatLogConfig | undefined;
    set internalValue(value: GoogleComputeRouterNatLogConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
}
export interface GoogleComputeRouterNatSubnetwork {
    /**
    * Self-link of subnetwork to NAT
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#name GoogleComputeRouterNat#name}
    */
    readonly name: string;
    /**
    * List of the secondary ranges of the subnetwork that are allowed
  to use NAT. This can be populated only if
  'LIST_OF_SECONDARY_IP_RANGES' is one of the values in
  sourceIpRangesToNat
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#secondary_ip_range_names GoogleComputeRouterNat#secondary_ip_range_names}
    */
    readonly secondaryIpRangeNames?: string[];
    /**
    * List of options for which source IPs in the subnetwork
  should have NAT enabled. Supported values include:
  'ALL_IP_RANGES', 'LIST_OF_SECONDARY_IP_RANGES',
  'PRIMARY_IP_RANGE'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#source_ip_ranges_to_nat GoogleComputeRouterNat#source_ip_ranges_to_nat}
    */
    readonly sourceIpRangesToNat: string[];
}
export declare function googleComputeRouterNatSubnetworkToTerraform(struct?: GoogleComputeRouterNatSubnetwork | cdktf.IResolvable): any;
export declare class GoogleComputeRouterNatSubnetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRouterNatSubnetwork | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRouterNatSubnetwork | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secondaryIpRangeNames?;
    get secondaryIpRangeNames(): string[];
    set secondaryIpRangeNames(value: string[]);
    resetSecondaryIpRangeNames(): void;
    get secondaryIpRangeNamesInput(): string[] | undefined;
    private _sourceIpRangesToNat?;
    get sourceIpRangesToNat(): string[];
    set sourceIpRangesToNat(value: string[]);
    get sourceIpRangesToNatInput(): string[] | undefined;
}
export declare class GoogleComputeRouterNatSubnetworkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRouterNatSubnetwork[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRouterNatSubnetworkOutputReference;
}
export interface GoogleComputeRouterNatTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#create GoogleComputeRouterNat#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#delete GoogleComputeRouterNat#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat#update GoogleComputeRouterNat#update}
    */
    readonly update?: string;
}
export declare function googleComputeRouterNatTimeoutsToTerraform(struct?: GoogleComputeRouterNatTimeoutsOutputReference | GoogleComputeRouterNatTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRouterNatTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRouterNatTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRouterNatTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat google_compute_router_nat}
*/
export declare class GoogleComputeRouterNat extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_router_nat";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_nat google_compute_router_nat} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRouterNatConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRouterNatConfig);
    private _drainNatIps?;
    get drainNatIps(): string[];
    set drainNatIps(value: string[]);
    resetDrainNatIps(): void;
    get drainNatIpsInput(): string[] | undefined;
    private _enableDynamicPortAllocation?;
    get enableDynamicPortAllocation(): boolean | cdktf.IResolvable;
    set enableDynamicPortAllocation(value: boolean | cdktf.IResolvable);
    resetEnableDynamicPortAllocation(): void;
    get enableDynamicPortAllocationInput(): boolean | cdktf.IResolvable | undefined;
    private _enableEndpointIndependentMapping?;
    get enableEndpointIndependentMapping(): boolean | cdktf.IResolvable;
    set enableEndpointIndependentMapping(value: boolean | cdktf.IResolvable);
    resetEnableEndpointIndependentMapping(): void;
    get enableEndpointIndependentMappingInput(): boolean | cdktf.IResolvable | undefined;
    private _icmpIdleTimeoutSec?;
    get icmpIdleTimeoutSec(): number;
    set icmpIdleTimeoutSec(value: number);
    resetIcmpIdleTimeoutSec(): void;
    get icmpIdleTimeoutSecInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxPortsPerVm?;
    get maxPortsPerVm(): number;
    set maxPortsPerVm(value: number);
    resetMaxPortsPerVm(): void;
    get maxPortsPerVmInput(): number | undefined;
    private _minPortsPerVm?;
    get minPortsPerVm(): number;
    set minPortsPerVm(value: number);
    resetMinPortsPerVm(): void;
    get minPortsPerVmInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _natIpAllocateOption?;
    get natIpAllocateOption(): string;
    set natIpAllocateOption(value: string);
    get natIpAllocateOptionInput(): string | undefined;
    private _natIps?;
    get natIps(): string[];
    set natIps(value: string[]);
    resetNatIps(): void;
    get natIpsInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    get routerInput(): string | undefined;
    private _sourceSubnetworkIpRangesToNat?;
    get sourceSubnetworkIpRangesToNat(): string;
    set sourceSubnetworkIpRangesToNat(value: string);
    get sourceSubnetworkIpRangesToNatInput(): string | undefined;
    private _tcpEstablishedIdleTimeoutSec?;
    get tcpEstablishedIdleTimeoutSec(): number;
    set tcpEstablishedIdleTimeoutSec(value: number);
    resetTcpEstablishedIdleTimeoutSec(): void;
    get tcpEstablishedIdleTimeoutSecInput(): number | undefined;
    private _tcpTransitoryIdleTimeoutSec?;
    get tcpTransitoryIdleTimeoutSec(): number;
    set tcpTransitoryIdleTimeoutSec(value: number);
    resetTcpTransitoryIdleTimeoutSec(): void;
    get tcpTransitoryIdleTimeoutSecInput(): number | undefined;
    private _udpIdleTimeoutSec?;
    get udpIdleTimeoutSec(): number;
    set udpIdleTimeoutSec(value: number);
    resetUdpIdleTimeoutSec(): void;
    get udpIdleTimeoutSecInput(): number | undefined;
    private _logConfig;
    get logConfig(): GoogleComputeRouterNatLogConfigOutputReference;
    putLogConfig(value: GoogleComputeRouterNatLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): GoogleComputeRouterNatLogConfig | undefined;
    private _subnetwork;
    get subnetwork(): GoogleComputeRouterNatSubnetworkList;
    putSubnetwork(value: GoogleComputeRouterNatSubnetwork[] | cdktf.IResolvable): void;
    resetSubnetwork(): void;
    get subnetworkInput(): cdktf.IResolvable | GoogleComputeRouterNatSubnetwork[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRouterNatTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRouterNatTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRouterNatTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
