import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRouterPeerConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-specified flag to indicate which mode to use for advertisement.
  Valid values of this enum field are: 'DEFAULT', 'CUSTOM' Default value: "DEFAULT" Possible values: ["DEFAULT", "CUSTOM"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#advertise_mode GoogleComputeRouterPeer#advertise_mode}
    */
    readonly advertiseMode?: string;
    /**
    * User-specified list of prefix groups to advertise in custom
  mode, which can take one of the following options:
  
  * 'ALL_SUBNETS': Advertises all available subnets, including peer VPC subnets.
  * 'ALL_VPC_SUBNETS': Advertises the router's own VPC subnets.
  * 'ALL_PEER_VPC_SUBNETS': Advertises peer subnets of the router's VPC network.
  
  
  Note that this field can only be populated if advertiseMode is 'CUSTOM'
  and overrides the list defined for the router (in the "bgp" message).
  These groups are advertised in addition to any specified prefixes.
  Leave this field blank to advertise no custom groups.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#advertised_groups GoogleComputeRouterPeer#advertised_groups}
    */
    readonly advertisedGroups?: string[];
    /**
    * The priority of routes advertised to this BGP peer.
  Where there is more than one matching route of maximum
  length, the routes with the lowest priority value win.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#advertised_route_priority GoogleComputeRouterPeer#advertised_route_priority}
    */
    readonly advertisedRoutePriority?: number;
    /**
    * The status of the BGP peer connection. If set to false, any active session
  with the peer is terminated and all associated routing information is removed.
  If set to true, the peer connection can be established with routing information.
  The default is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#enable GoogleComputeRouterPeer#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#id GoogleComputeRouterPeer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the interface the BGP peer is associated with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#interface GoogleComputeRouterPeer#interface}
    */
    readonly interface: string;
    /**
    * IP address of the interface inside Google Cloud Platform.
  Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#ip_address GoogleComputeRouterPeer#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Name of this BGP peer. The name must be 1-63 characters long,
  and comply with RFC1035. Specifically, the name must be 1-63 characters
  long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which
  means the first character must be a lowercase letter, and all
  following characters must be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#name GoogleComputeRouterPeer#name}
    */
    readonly name: string;
    /**
    * Peer BGP Autonomous System Number (ASN).
  Each BGP interface may use a different value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#peer_asn GoogleComputeRouterPeer#peer_asn}
    */
    readonly peerAsn: number;
    /**
    * IP address of the BGP interface outside Google Cloud Platform.
  Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#peer_ip_address GoogleComputeRouterPeer#peer_ip_address}
    */
    readonly peerIpAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#project GoogleComputeRouterPeer#project}
    */
    readonly project?: string;
    /**
    * Region where the router and BgpPeer reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#region GoogleComputeRouterPeer#region}
    */
    readonly region?: string;
    /**
    * The name of the Cloud Router in which this BgpPeer will be configured.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#router GoogleComputeRouterPeer#router}
    */
    readonly router: string;
    /**
    * advertised_ip_ranges block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#advertised_ip_ranges GoogleComputeRouterPeer#advertised_ip_ranges}
    */
    readonly advertisedIpRanges?: GoogleComputeRouterPeerAdvertisedIpRanges[] | cdktf.IResolvable;
    /**
    * bfd block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#bfd GoogleComputeRouterPeer#bfd}
    */
    readonly bfd?: GoogleComputeRouterPeerBfd;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#timeouts GoogleComputeRouterPeer#timeouts}
    */
    readonly timeouts?: GoogleComputeRouterPeerTimeouts;
}
export interface GoogleComputeRouterPeerAdvertisedIpRanges {
    /**
    * User-specified description for the IP range.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#description GoogleComputeRouterPeer#description}
    */
    readonly description?: string;
    /**
    * The IP range to advertise. The value must be a
  CIDR-formatted string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#range GoogleComputeRouterPeer#range}
    */
    readonly range: string;
}
export declare function googleComputeRouterPeerAdvertisedIpRangesToTerraform(struct?: GoogleComputeRouterPeerAdvertisedIpRanges | cdktf.IResolvable): any;
export declare class GoogleComputeRouterPeerAdvertisedIpRangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRouterPeerAdvertisedIpRanges | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRouterPeerAdvertisedIpRanges | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _range?;
    get range(): string;
    set range(value: string);
    get rangeInput(): string | undefined;
}
export declare class GoogleComputeRouterPeerAdvertisedIpRangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRouterPeerAdvertisedIpRanges[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRouterPeerAdvertisedIpRangesOutputReference;
}
export interface GoogleComputeRouterPeerBfd {
    /**
    * The minimum interval, in milliseconds, between BFD control packets
  received from the peer router. The actual value is negotiated
  between the two routers and is equal to the greater of this value
  and the transmit interval of the other router. If set, this value
  must be between 1000 and 30000.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#min_receive_interval GoogleComputeRouterPeer#min_receive_interval}
    */
    readonly minReceiveInterval?: number;
    /**
    * The minimum interval, in milliseconds, between BFD control packets
  transmitted to the peer router. The actual value is negotiated
  between the two routers and is equal to the greater of this value
  and the corresponding receive interval of the other router. If set,
  this value must be between 1000 and 30000.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#min_transmit_interval GoogleComputeRouterPeer#min_transmit_interval}
    */
    readonly minTransmitInterval?: number;
    /**
    * The number of consecutive BFD packets that must be missed before
  BFD declares that a peer is unavailable. If set, the value must
  be a value between 5 and 16.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#multiplier GoogleComputeRouterPeer#multiplier}
    */
    readonly multiplier?: number;
    /**
    * The BFD session initialization mode for this BGP peer.
  If set to 'ACTIVE', the Cloud Router will initiate the BFD session
  for this BGP peer. If set to 'PASSIVE', the Cloud Router will wait
  for the peer router to initiate the BFD session for this BGP peer.
  If set to 'DISABLED', BFD is disabled for this BGP peer. Possible values: ["ACTIVE", "DISABLED", "PASSIVE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#session_initialization_mode GoogleComputeRouterPeer#session_initialization_mode}
    */
    readonly sessionInitializationMode: string;
}
export declare function googleComputeRouterPeerBfdToTerraform(struct?: GoogleComputeRouterPeerBfdOutputReference | GoogleComputeRouterPeerBfd): any;
export declare class GoogleComputeRouterPeerBfdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRouterPeerBfd | undefined;
    set internalValue(value: GoogleComputeRouterPeerBfd | undefined);
    private _minReceiveInterval?;
    get minReceiveInterval(): number;
    set minReceiveInterval(value: number);
    resetMinReceiveInterval(): void;
    get minReceiveIntervalInput(): number | undefined;
    private _minTransmitInterval?;
    get minTransmitInterval(): number;
    set minTransmitInterval(value: number);
    resetMinTransmitInterval(): void;
    get minTransmitIntervalInput(): number | undefined;
    private _multiplier?;
    get multiplier(): number;
    set multiplier(value: number);
    resetMultiplier(): void;
    get multiplierInput(): number | undefined;
    private _sessionInitializationMode?;
    get sessionInitializationMode(): string;
    set sessionInitializationMode(value: string);
    get sessionInitializationModeInput(): string | undefined;
}
export interface GoogleComputeRouterPeerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#create GoogleComputeRouterPeer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#delete GoogleComputeRouterPeer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer#update GoogleComputeRouterPeer#update}
    */
    readonly update?: string;
}
export declare function googleComputeRouterPeerTimeoutsToTerraform(struct?: GoogleComputeRouterPeerTimeoutsOutputReference | GoogleComputeRouterPeerTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRouterPeerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRouterPeerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRouterPeerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer google_compute_router_peer}
*/
export declare class GoogleComputeRouterPeer extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_router_peer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_router_peer google_compute_router_peer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRouterPeerConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRouterPeerConfig);
    private _advertiseMode?;
    get advertiseMode(): string;
    set advertiseMode(value: string);
    resetAdvertiseMode(): void;
    get advertiseModeInput(): string | undefined;
    private _advertisedGroups?;
    get advertisedGroups(): string[];
    set advertisedGroups(value: string[]);
    resetAdvertisedGroups(): void;
    get advertisedGroupsInput(): string[] | undefined;
    private _advertisedRoutePriority?;
    get advertisedRoutePriority(): number;
    set advertisedRoutePriority(value: number);
    resetAdvertisedRoutePriority(): void;
    get advertisedRoutePriorityInput(): number | undefined;
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    get interfaceInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    get managementType(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerAsn?;
    get peerAsn(): number;
    set peerAsn(value: number);
    get peerAsnInput(): number | undefined;
    private _peerIpAddress?;
    get peerIpAddress(): string;
    set peerIpAddress(value: string);
    get peerIpAddressInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    get routerInput(): string | undefined;
    private _advertisedIpRanges;
    get advertisedIpRanges(): GoogleComputeRouterPeerAdvertisedIpRangesList;
    putAdvertisedIpRanges(value: GoogleComputeRouterPeerAdvertisedIpRanges[] | cdktf.IResolvable): void;
    resetAdvertisedIpRanges(): void;
    get advertisedIpRangesInput(): cdktf.IResolvable | GoogleComputeRouterPeerAdvertisedIpRanges[] | undefined;
    private _bfd;
    get bfd(): GoogleComputeRouterPeerBfdOutputReference;
    putBfd(value: GoogleComputeRouterPeerBfd): void;
    resetBfd(): void;
    get bfdInput(): GoogleComputeRouterPeerBfd | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRouterPeerTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRouterPeerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRouterPeerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
