import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeSecurityPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this security policy. Max size is 2048.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#description GoogleComputeSecurityPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#id GoogleComputeSecurityPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the security policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#name GoogleComputeSecurityPolicy#name}
    */
    readonly name: string;
    /**
    * The project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#project GoogleComputeSecurityPolicy#project}
    */
    readonly project?: string;
    /**
    * The type indicates the intended use of the security policy. CLOUD_ARMOR - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. CLOUD_ARMOR_EDGE - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#type GoogleComputeSecurityPolicy#type}
    */
    readonly type?: string;
    /**
    * adaptive_protection_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#adaptive_protection_config GoogleComputeSecurityPolicy#adaptive_protection_config}
    */
    readonly adaptiveProtectionConfig?: GoogleComputeSecurityPolicyAdaptiveProtectionConfig;
    /**
    * advanced_options_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#advanced_options_config GoogleComputeSecurityPolicy#advanced_options_config}
    */
    readonly advancedOptionsConfig?: GoogleComputeSecurityPolicyAdvancedOptionsConfig;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#rule GoogleComputeSecurityPolicy#rule}
    */
    readonly rule?: GoogleComputeSecurityPolicyRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#timeouts GoogleComputeSecurityPolicy#timeouts}
    */
    readonly timeouts?: GoogleComputeSecurityPolicyTimeouts;
}
export interface GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig {
    /**
    * If set to true, enables CAAP for L7 DDoS detection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#enable GoogleComputeSecurityPolicy#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
    * Rule visibility. Supported values include: "STANDARD", "PREMIUM".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#rule_visibility GoogleComputeSecurityPolicy#rule_visibility}
    */
    readonly ruleVisibility?: string;
}
export declare function googleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigToTerraform(struct?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOutputReference | GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig): any;
export declare class GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleVisibility?;
    get ruleVisibility(): string;
    set ruleVisibility(value: string);
    resetRuleVisibility(): void;
    get ruleVisibilityInput(): string | undefined;
}
export interface GoogleComputeSecurityPolicyAdaptiveProtectionConfig {
    /**
    * layer_7_ddos_defense_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#layer_7_ddos_defense_config GoogleComputeSecurityPolicy#layer_7_ddos_defense_config}
    */
    readonly layer7DdosDefenseConfig?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig;
}
export declare function googleComputeSecurityPolicyAdaptiveProtectionConfigToTerraform(struct?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigOutputReference | GoogleComputeSecurityPolicyAdaptiveProtectionConfig): any;
export declare class GoogleComputeSecurityPolicyAdaptiveProtectionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyAdaptiveProtectionConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyAdaptiveProtectionConfig | undefined);
    private _layer7DdosDefenseConfig;
    get layer7DdosDefenseConfig(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOutputReference;
    putLayer7DdosDefenseConfig(value: GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig): void;
    resetLayer7DdosDefenseConfig(): void;
    get layer7DdosDefenseConfigInput(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig | undefined;
}
export interface GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig {
    /**
    * A list of custom Content-Type header values to apply the JSON parsing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#content_types GoogleComputeSecurityPolicy#content_types}
    */
    readonly contentTypes: string[];
}
export declare function googleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfigToTerraform(struct?: GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfigOutputReference | GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig): any;
export declare class GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig | undefined);
    private _contentTypes?;
    get contentTypes(): string[];
    set contentTypes(value: string[]);
    get contentTypesInput(): string[] | undefined;
}
export interface GoogleComputeSecurityPolicyAdvancedOptionsConfig {
    /**
    * JSON body parsing. Supported values include: "DISABLED", "STANDARD".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#json_parsing GoogleComputeSecurityPolicy#json_parsing}
    */
    readonly jsonParsing?: string;
    /**
    * Logging level. Supported values include: "NORMAL", "VERBOSE".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#log_level GoogleComputeSecurityPolicy#log_level}
    */
    readonly logLevel?: string;
    /**
    * json_custom_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#json_custom_config GoogleComputeSecurityPolicy#json_custom_config}
    */
    readonly jsonCustomConfig?: GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig;
}
export declare function googleComputeSecurityPolicyAdvancedOptionsConfigToTerraform(struct?: GoogleComputeSecurityPolicyAdvancedOptionsConfigOutputReference | GoogleComputeSecurityPolicyAdvancedOptionsConfig): any;
export declare class GoogleComputeSecurityPolicyAdvancedOptionsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyAdvancedOptionsConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyAdvancedOptionsConfig | undefined);
    private _jsonParsing?;
    get jsonParsing(): string;
    set jsonParsing(value: string);
    resetJsonParsing(): void;
    get jsonParsingInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _jsonCustomConfig;
    get jsonCustomConfig(): GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfigOutputReference;
    putJsonCustomConfig(value: GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig): void;
    resetJsonCustomConfig(): void;
    get jsonCustomConfigInput(): GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig | undefined;
}
export interface GoogleComputeSecurityPolicyRuleMatchConfig {
    /**
    * Set of IP addresses or ranges (IPV4 or IPV6) in CIDR notation to match against inbound traffic. There is a limit of 10 IP ranges per rule. A value of '*' matches all IPs (can be used to override the default behavior).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#src_ip_ranges GoogleComputeSecurityPolicy#src_ip_ranges}
    */
    readonly srcIpRanges: string[];
}
export declare function googleComputeSecurityPolicyRuleMatchConfigToTerraform(struct?: GoogleComputeSecurityPolicyRuleMatchConfigOutputReference | GoogleComputeSecurityPolicyRuleMatchConfig): any;
export declare class GoogleComputeSecurityPolicyRuleMatchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleMatchConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleMatchConfig | undefined);
    private _srcIpRanges?;
    get srcIpRanges(): string[];
    set srcIpRanges(value: string[]);
    get srcIpRangesInput(): string[] | undefined;
}
export interface GoogleComputeSecurityPolicyRuleMatchExpr {
    /**
    * Textual representation of an expression in Common Expression Language syntax. The application context of the containing message determines which well-known feature set of CEL is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#expression GoogleComputeSecurityPolicy#expression}
    */
    readonly expression: string;
}
export declare function googleComputeSecurityPolicyRuleMatchExprToTerraform(struct?: GoogleComputeSecurityPolicyRuleMatchExprOutputReference | GoogleComputeSecurityPolicyRuleMatchExpr): any;
export declare class GoogleComputeSecurityPolicyRuleMatchExprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleMatchExpr | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleMatchExpr | undefined);
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
}
export interface GoogleComputeSecurityPolicyRuleMatch {
    /**
    * Predefined rule expression. If this field is specified, config must also be specified. Available options:   SRC_IPS_V1: Must specify the corresponding src_ip_ranges field in config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#versioned_expr GoogleComputeSecurityPolicy#versioned_expr}
    */
    readonly versionedExpr?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#config GoogleComputeSecurityPolicy#config}
    */
    readonly config?: GoogleComputeSecurityPolicyRuleMatchConfig;
    /**
    * expr block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#expr GoogleComputeSecurityPolicy#expr}
    */
    readonly expr?: GoogleComputeSecurityPolicyRuleMatchExpr;
}
export declare function googleComputeSecurityPolicyRuleMatchToTerraform(struct?: GoogleComputeSecurityPolicyRuleMatchOutputReference | GoogleComputeSecurityPolicyRuleMatch): any;
export declare class GoogleComputeSecurityPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleMatch | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleMatch | undefined);
    private _versionedExpr?;
    get versionedExpr(): string;
    set versionedExpr(value: string);
    resetVersionedExpr(): void;
    get versionedExprInput(): string | undefined;
    private _config;
    get config(): GoogleComputeSecurityPolicyRuleMatchConfigOutputReference;
    putConfig(value: GoogleComputeSecurityPolicyRuleMatchConfig): void;
    resetConfig(): void;
    get configInput(): GoogleComputeSecurityPolicyRuleMatchConfig | undefined;
    private _expr;
    get expr(): GoogleComputeSecurityPolicyRuleMatchExprOutputReference;
    putExpr(value: GoogleComputeSecurityPolicyRuleMatchExpr): void;
    resetExpr(): void;
    get exprInput(): GoogleComputeSecurityPolicyRuleMatchExpr | undefined;
}
export interface GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold {
    /**
    * Number of HTTP(S) requests for calculating the threshold.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#count GoogleComputeSecurityPolicy#count}
    */
    readonly count: number;
    /**
    * Interval over which the threshold is computed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#interval_sec GoogleComputeSecurityPolicy#interval_sec}
    */
    readonly intervalSec: number;
}
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsBanThresholdToTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThresholdOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold): any;
export declare class GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _intervalSec?;
    get intervalSec(): number;
    set intervalSec(value: number);
    get intervalSecInput(): number | undefined;
}
export interface GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions {
    /**
    * Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#target GoogleComputeSecurityPolicy#target}
    */
    readonly target?: string;
    /**
    * Type of the redirect action.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#type GoogleComputeSecurityPolicy#type}
    */
    readonly type: string;
}
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsToTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions): any;
export declare class GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions | undefined);
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold {
    /**
    * Number of HTTP(S) requests for calculating the threshold.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#count GoogleComputeSecurityPolicy#count}
    */
    readonly count: number;
    /**
    * Interval over which the threshold is computed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#interval_sec GoogleComputeSecurityPolicy#interval_sec}
    */
    readonly intervalSec: number;
}
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdToTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold): any;
export declare class GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _intervalSec?;
    get intervalSec(): number;
    set intervalSec(value: number);
    get intervalSecInput(): number | undefined;
}
export interface GoogleComputeSecurityPolicyRuleRateLimitOptions {
    /**
    * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#ban_duration_sec GoogleComputeSecurityPolicy#ban_duration_sec}
    */
    readonly banDurationSec?: number;
    /**
    * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#conform_action GoogleComputeSecurityPolicy#conform_action}
    */
    readonly conformAction: string;
    /**
    * Determines the key to enforce the rateLimitThreshold on
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#enforce_on_key GoogleComputeSecurityPolicy#enforce_on_key}
    */
    readonly enforceOnKey?: string;
    /**
    * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#enforce_on_key_name GoogleComputeSecurityPolicy#enforce_on_key_name}
    */
    readonly enforceOnKeyName?: string;
    /**
    * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are "deny()" where valid values for status are 403, 404, 429, and 502, and "redirect" where the redirect parameters come from exceedRedirectOptions below.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#exceed_action GoogleComputeSecurityPolicy#exceed_action}
    */
    readonly exceedAction: string;
    /**
    * ban_threshold block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#ban_threshold GoogleComputeSecurityPolicy#ban_threshold}
    */
    readonly banThreshold?: GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold;
    /**
    * exceed_redirect_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#exceed_redirect_options GoogleComputeSecurityPolicy#exceed_redirect_options}
    */
    readonly exceedRedirectOptions?: GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions;
    /**
    * rate_limit_threshold block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#rate_limit_threshold GoogleComputeSecurityPolicy#rate_limit_threshold}
    */
    readonly rateLimitThreshold: GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold;
}
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsToTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptions): any;
export declare class GoogleComputeSecurityPolicyRuleRateLimitOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleRateLimitOptions | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRateLimitOptions | undefined);
    private _banDurationSec?;
    get banDurationSec(): number;
    set banDurationSec(value: number);
    resetBanDurationSec(): void;
    get banDurationSecInput(): number | undefined;
    private _conformAction?;
    get conformAction(): string;
    set conformAction(value: string);
    get conformActionInput(): string | undefined;
    private _enforceOnKey?;
    get enforceOnKey(): string;
    set enforceOnKey(value: string);
    resetEnforceOnKey(): void;
    get enforceOnKeyInput(): string | undefined;
    private _enforceOnKeyName?;
    get enforceOnKeyName(): string;
    set enforceOnKeyName(value: string);
    resetEnforceOnKeyName(): void;
    get enforceOnKeyNameInput(): string | undefined;
    private _exceedAction?;
    get exceedAction(): string;
    set exceedAction(value: string);
    get exceedActionInput(): string | undefined;
    private _banThreshold;
    get banThreshold(): GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThresholdOutputReference;
    putBanThreshold(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold): void;
    resetBanThreshold(): void;
    get banThresholdInput(): GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold | undefined;
    private _exceedRedirectOptions;
    get exceedRedirectOptions(): GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsOutputReference;
    putExceedRedirectOptions(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions): void;
    resetExceedRedirectOptions(): void;
    get exceedRedirectOptionsInput(): GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions | undefined;
    private _rateLimitThreshold;
    get rateLimitThreshold(): GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdOutputReference;
    putRateLimitThreshold(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold): void;
    get rateLimitThresholdInput(): GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold | undefined;
}
export interface GoogleComputeSecurityPolicyRuleRedirectOptions {
    /**
    * Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#target GoogleComputeSecurityPolicy#target}
    */
    readonly target?: string;
    /**
    * Type of the redirect action. Available options: EXTERNAL_302: Must specify the corresponding target field in config. GOOGLE_RECAPTCHA: Cannot specify target field in config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#type GoogleComputeSecurityPolicy#type}
    */
    readonly type: string;
}
export declare function googleComputeSecurityPolicyRuleRedirectOptionsToTerraform(struct?: GoogleComputeSecurityPolicyRuleRedirectOptionsOutputReference | GoogleComputeSecurityPolicyRuleRedirectOptions): any;
export declare class GoogleComputeSecurityPolicyRuleRedirectOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleRedirectOptions | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRedirectOptions | undefined);
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleComputeSecurityPolicyRule {
    /**
    * Action to take when match matches the request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#action GoogleComputeSecurityPolicy#action}
    */
    readonly action: string;
    /**
    * An optional description of this rule. Max size is 64.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#description GoogleComputeSecurityPolicy#description}
    */
    readonly description?: string;
    /**
    * When set to true, the action specified above is not enforced. Stackdriver logs for requests that trigger a preview action are annotated as such.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#preview GoogleComputeSecurityPolicy#preview}
    */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
    * An unique positive integer indicating the priority of evaluation for a rule. Rules are evaluated from highest priority (lowest numerically) to lowest priority (highest numerically) in order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#priority GoogleComputeSecurityPolicy#priority}
    */
    readonly priority: number;
    /**
    * match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#match GoogleComputeSecurityPolicy#match}
    */
    readonly match: GoogleComputeSecurityPolicyRuleMatch;
    /**
    * rate_limit_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#rate_limit_options GoogleComputeSecurityPolicy#rate_limit_options}
    */
    readonly rateLimitOptions?: GoogleComputeSecurityPolicyRuleRateLimitOptions;
    /**
    * redirect_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#redirect_options GoogleComputeSecurityPolicy#redirect_options}
    */
    readonly redirectOptions?: GoogleComputeSecurityPolicyRuleRedirectOptions;
}
export declare function googleComputeSecurityPolicyRuleToTerraform(struct?: GoogleComputeSecurityPolicyRule | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeSecurityPolicyRule | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _preview?;
    get preview(): boolean | cdktf.IResolvable;
    set preview(value: boolean | cdktf.IResolvable);
    resetPreview(): void;
    get previewInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _match;
    get match(): GoogleComputeSecurityPolicyRuleMatchOutputReference;
    putMatch(value: GoogleComputeSecurityPolicyRuleMatch): void;
    get matchInput(): GoogleComputeSecurityPolicyRuleMatch | undefined;
    private _rateLimitOptions;
    get rateLimitOptions(): GoogleComputeSecurityPolicyRuleRateLimitOptionsOutputReference;
    putRateLimitOptions(value: GoogleComputeSecurityPolicyRuleRateLimitOptions): void;
    resetRateLimitOptions(): void;
    get rateLimitOptionsInput(): GoogleComputeSecurityPolicyRuleRateLimitOptions | undefined;
    private _redirectOptions;
    get redirectOptions(): GoogleComputeSecurityPolicyRuleRedirectOptionsOutputReference;
    putRedirectOptions(value: GoogleComputeSecurityPolicyRuleRedirectOptions): void;
    resetRedirectOptions(): void;
    get redirectOptionsInput(): GoogleComputeSecurityPolicyRuleRedirectOptions | undefined;
}
export declare class GoogleComputeSecurityPolicyRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeSecurityPolicyRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeSecurityPolicyRuleOutputReference;
}
export interface GoogleComputeSecurityPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#create GoogleComputeSecurityPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#delete GoogleComputeSecurityPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy#update GoogleComputeSecurityPolicy#update}
    */
    readonly update?: string;
}
export declare function googleComputeSecurityPolicyTimeoutsToTerraform(struct?: GoogleComputeSecurityPolicyTimeoutsOutputReference | GoogleComputeSecurityPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy google_compute_security_policy}
*/
export declare class GoogleComputeSecurityPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_security_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_security_policy google_compute_security_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeSecurityPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeSecurityPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _adaptiveProtectionConfig;
    get adaptiveProtectionConfig(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigOutputReference;
    putAdaptiveProtectionConfig(value: GoogleComputeSecurityPolicyAdaptiveProtectionConfig): void;
    resetAdaptiveProtectionConfig(): void;
    get adaptiveProtectionConfigInput(): GoogleComputeSecurityPolicyAdaptiveProtectionConfig | undefined;
    private _advancedOptionsConfig;
    get advancedOptionsConfig(): GoogleComputeSecurityPolicyAdvancedOptionsConfigOutputReference;
    putAdvancedOptionsConfig(value: GoogleComputeSecurityPolicyAdvancedOptionsConfig): void;
    resetAdvancedOptionsConfig(): void;
    get advancedOptionsConfigInput(): GoogleComputeSecurityPolicyAdvancedOptionsConfig | undefined;
    private _rule;
    get rule(): GoogleComputeSecurityPolicyRuleList;
    putRule(value: GoogleComputeSecurityPolicyRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyRule[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeSecurityPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeSecurityPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
