import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeSnapshotIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding#id GoogleComputeSnapshotIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding#members GoogleComputeSnapshotIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding#name GoogleComputeSnapshotIamBinding#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding#project GoogleComputeSnapshotIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding#role GoogleComputeSnapshotIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding#condition GoogleComputeSnapshotIamBinding#condition}
    */
    readonly condition?: GoogleComputeSnapshotIamBindingCondition;
}
export interface GoogleComputeSnapshotIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding#description GoogleComputeSnapshotIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding#expression GoogleComputeSnapshotIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding#title GoogleComputeSnapshotIamBinding#title}
    */
    readonly title: string;
}
export declare function googleComputeSnapshotIamBindingConditionToTerraform(struct?: GoogleComputeSnapshotIamBindingConditionOutputReference | GoogleComputeSnapshotIamBindingCondition): any;
export declare class GoogleComputeSnapshotIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSnapshotIamBindingCondition | undefined;
    set internalValue(value: GoogleComputeSnapshotIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding google_compute_snapshot_iam_binding}
*/
export declare class GoogleComputeSnapshotIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_snapshot_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_snapshot_iam_binding google_compute_snapshot_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeSnapshotIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeSnapshotIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleComputeSnapshotIamBindingConditionOutputReference;
    putCondition(value: GoogleComputeSnapshotIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleComputeSnapshotIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
