import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeSslPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Profile specifies the set of SSL features that can be used by the
  load balancer when negotiating SSL with clients. This can be one of
  'COMPATIBLE', 'MODERN', 'RESTRICTED', or 'CUSTOM'. If using 'CUSTOM',
  the set of SSL features to enable must be specified in the
  'customFeatures' field.
  
  See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
  for which ciphers are available to use. **Note**: this argument
  *must* be present when using the 'CUSTOM' profile. This argument
  *must not* be present when using any other profile.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#custom_features GoogleComputeSslPolicy#custom_features}
    */
    readonly customFeatures?: string[];
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#description GoogleComputeSslPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#id GoogleComputeSslPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The minimum version of SSL protocol that can be used by the clients
  to establish a connection with the load balancer. Default value: "TLS_1_0" Possible values: ["TLS_1_0", "TLS_1_1", "TLS_1_2"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#min_tls_version GoogleComputeSslPolicy#min_tls_version}
    */
    readonly minTlsVersion?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#name GoogleComputeSslPolicy#name}
    */
    readonly name: string;
    /**
    * Profile specifies the set of SSL features that can be used by the
  load balancer when negotiating SSL with clients. If using 'CUSTOM',
  the set of SSL features to enable must be specified in the
  'customFeatures' field.
  
  See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
  for information on what cipher suites each profile provides. If
  'CUSTOM' is used, the 'custom_features' attribute **must be set**. Default value: "COMPATIBLE" Possible values: ["COMPATIBLE", "MODERN", "RESTRICTED", "CUSTOM"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#profile GoogleComputeSslPolicy#profile}
    */
    readonly profile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#project GoogleComputeSslPolicy#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#timeouts GoogleComputeSslPolicy#timeouts}
    */
    readonly timeouts?: GoogleComputeSslPolicyTimeouts;
}
export interface GoogleComputeSslPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#create GoogleComputeSslPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#delete GoogleComputeSslPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy#update GoogleComputeSslPolicy#update}
    */
    readonly update?: string;
}
export declare function googleComputeSslPolicyTimeoutsToTerraform(struct?: GoogleComputeSslPolicyTimeoutsOutputReference | GoogleComputeSslPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeSslPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSslPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSslPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy google_compute_ssl_policy}
*/
export declare class GoogleComputeSslPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_ssl_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ssl_policy google_compute_ssl_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeSslPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeSslPolicyConfig);
    get creationTimestamp(): string;
    private _customFeatures?;
    get customFeatures(): string[];
    set customFeatures(value: string[]);
    resetCustomFeatures(): void;
    get customFeaturesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get enabledFeatures(): string[];
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _minTlsVersion?;
    get minTlsVersion(): string;
    set minTlsVersion(value: string);
    resetMinTlsVersion(): void;
    get minTlsVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _profile?;
    get profile(): string;
    set profile(value: string);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): GoogleComputeSslPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeSslPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeSslPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
