import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeTargetGrpcProxyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy#description GoogleComputeTargetGrpcProxy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy#id GoogleComputeTargetGrpcProxy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource
  is created. The name must be 1-63 characters long, and comply
  with RFC1035. Specifically, the name must be 1-63 characters long
  and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which
  means the first character must be a lowercase letter, and all
  following characters must be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy#name GoogleComputeTargetGrpcProxy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy#project GoogleComputeTargetGrpcProxy#project}
    */
    readonly project?: string;
    /**
    * URL to the UrlMap resource that defines the mapping from URL to
  the BackendService. The protocol field in the BackendService
  must be set to GRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy#url_map GoogleComputeTargetGrpcProxy#url_map}
    */
    readonly urlMap?: string;
    /**
    * If true, indicates that the BackendServices referenced by
  the urlMap may be accessed by gRPC applications without using
  a sidecar proxy. This will enable configuration checks on urlMap
  and its referenced BackendServices to not allow unsupported features.
  A gRPC application must use "xds:///" scheme in the target URI
  of the service it is connecting to. If false, indicates that the
  BackendServices referenced by the urlMap will be accessed by gRPC
  applications via a sidecar proxy. In this case, a gRPC application
  must not use "xds:///" scheme in the target URI of the service
  it is connecting to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy#validate_for_proxyless GoogleComputeTargetGrpcProxy#validate_for_proxyless}
    */
    readonly validateForProxyless?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy#timeouts GoogleComputeTargetGrpcProxy#timeouts}
    */
    readonly timeouts?: GoogleComputeTargetGrpcProxyTimeouts;
}
export interface GoogleComputeTargetGrpcProxyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy#create GoogleComputeTargetGrpcProxy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy#delete GoogleComputeTargetGrpcProxy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy#update GoogleComputeTargetGrpcProxy#update}
    */
    readonly update?: string;
}
export declare function googleComputeTargetGrpcProxyTimeoutsToTerraform(struct?: GoogleComputeTargetGrpcProxyTimeoutsOutputReference | GoogleComputeTargetGrpcProxyTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeTargetGrpcProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeTargetGrpcProxyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeTargetGrpcProxyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy google_compute_target_grpc_proxy}
*/
export declare class GoogleComputeTargetGrpcProxy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_target_grpc_proxy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_grpc_proxy google_compute_target_grpc_proxy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeTargetGrpcProxyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeTargetGrpcProxyConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get selfLinkWithId(): string;
    private _urlMap?;
    get urlMap(): string;
    set urlMap(value: string);
    resetUrlMap(): void;
    get urlMapInput(): string | undefined;
    private _validateForProxyless?;
    get validateForProxyless(): boolean | cdktf.IResolvable;
    set validateForProxyless(value: boolean | cdktf.IResolvable);
    resetValidateForProxyless(): void;
    get validateForProxylessInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeTargetGrpcProxyTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeTargetGrpcProxyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeTargetGrpcProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
