import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeTargetHttpsProxyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A reference to the CertificateMap resource uri that identifies a certificate map
  associated with the given target proxy. This field can only be set for global target proxies.
  Accepted format is '//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#certificate_map GoogleComputeTargetHttpsProxy#certificate_map}
    */
    readonly certificateMap?: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#description GoogleComputeTargetHttpsProxy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#id GoogleComputeTargetHttpsProxy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#name GoogleComputeTargetHttpsProxy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#project GoogleComputeTargetHttpsProxy#project}
    */
    readonly project?: string;
    /**
    * This field only applies when the forwarding rule that references
  this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#proxy_bind GoogleComputeTargetHttpsProxy#proxy_bind}
    */
    readonly proxyBind?: boolean | cdktf.IResolvable;
    /**
    * Specifies the QUIC override policy for this resource. This determines
  whether the load balancer will attempt to negotiate QUIC with clients
  or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
  specified, uses the QUIC policy with no user overrides, which is
  equivalent to DISABLE. Default value: "NONE" Possible values: ["NONE", "ENABLE", "DISABLE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#quic_override GoogleComputeTargetHttpsProxy#quic_override}
    */
    readonly quicOverride?: string;
    /**
    * A list of SslCertificate resources that are used to authenticate
  connections between users and the load balancer. At least one SSL
  certificate must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#ssl_certificates GoogleComputeTargetHttpsProxy#ssl_certificates}
    */
    readonly sslCertificates?: string[];
    /**
    * A reference to the SslPolicy resource that will be associated with
  the TargetHttpsProxy resource. If not set, the TargetHttpsProxy
  resource will not have any SSL policy configured.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#ssl_policy GoogleComputeTargetHttpsProxy#ssl_policy}
    */
    readonly sslPolicy?: string;
    /**
    * A reference to the UrlMap resource that defines the mapping from URL
  to the BackendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#url_map GoogleComputeTargetHttpsProxy#url_map}
    */
    readonly urlMap: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#timeouts GoogleComputeTargetHttpsProxy#timeouts}
    */
    readonly timeouts?: GoogleComputeTargetHttpsProxyTimeouts;
}
export interface GoogleComputeTargetHttpsProxyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#create GoogleComputeTargetHttpsProxy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#delete GoogleComputeTargetHttpsProxy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy#update GoogleComputeTargetHttpsProxy#update}
    */
    readonly update?: string;
}
export declare function googleComputeTargetHttpsProxyTimeoutsToTerraform(struct?: GoogleComputeTargetHttpsProxyTimeoutsOutputReference | GoogleComputeTargetHttpsProxyTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeTargetHttpsProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeTargetHttpsProxyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeTargetHttpsProxyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy google_compute_target_https_proxy}
*/
export declare class GoogleComputeTargetHttpsProxy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_target_https_proxy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_target_https_proxy google_compute_target_https_proxy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeTargetHttpsProxyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeTargetHttpsProxyConfig);
    private _certificateMap?;
    get certificateMap(): string;
    set certificateMap(value: string);
    resetCertificateMap(): void;
    get certificateMapInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _proxyBind?;
    get proxyBind(): boolean | cdktf.IResolvable;
    set proxyBind(value: boolean | cdktf.IResolvable);
    resetProxyBind(): void;
    get proxyBindInput(): boolean | cdktf.IResolvable | undefined;
    get proxyId(): number;
    private _quicOverride?;
    get quicOverride(): string;
    set quicOverride(value: string);
    resetQuicOverride(): void;
    get quicOverrideInput(): string | undefined;
    get selfLink(): string;
    private _sslCertificates?;
    get sslCertificates(): string[];
    set sslCertificates(value: string[]);
    resetSslCertificates(): void;
    get sslCertificatesInput(): string[] | undefined;
    private _sslPolicy?;
    get sslPolicy(): string;
    set sslPolicy(value: string);
    resetSslPolicy(): void;
    get sslPolicyInput(): string | undefined;
    private _urlMap?;
    get urlMap(): string;
    set urlMap(value: string);
    get urlMapInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeTargetHttpsProxyTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeTargetHttpsProxyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeTargetHttpsProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
