import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeUrlMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * The backend service or backend bucket to use when none of the given rules match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#default_service GoogleComputeUrlMap#default_service}
    */
    readonly defaultService?: string;
    /**
    * An optional description of this resource. Provide this property when you create
  the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#description GoogleComputeUrlMap#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#id GoogleComputeUrlMap#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is created. The
  name must be 1-63 characters long, and comply with RFC1035. Specifically, the
  name must be 1-63 characters long and match the regular expression
  '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first character must be a lowercase
  letter, and all following characters must be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#name GoogleComputeUrlMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#project GoogleComputeUrlMap#project}
    */
    readonly project?: string;
    /**
    * default_route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#default_route_action GoogleComputeUrlMap#default_route_action}
    */
    readonly defaultRouteAction?: GoogleComputeUrlMapDefaultRouteAction;
    /**
    * default_url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#default_url_redirect GoogleComputeUrlMap#default_url_redirect}
    */
    readonly defaultUrlRedirect?: GoogleComputeUrlMapDefaultUrlRedirect;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_action GoogleComputeUrlMap#header_action}
    */
    readonly headerAction?: GoogleComputeUrlMapHeaderAction;
    /**
    * host_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#host_rule GoogleComputeUrlMap#host_rule}
    */
    readonly hostRule?: GoogleComputeUrlMapHostRule[] | cdktf.IResolvable;
    /**
    * path_matcher block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_matcher GoogleComputeUrlMap#path_matcher}
    */
    readonly pathMatcher?: GoogleComputeUrlMapPathMatcher[] | cdktf.IResolvable;
    /**
    * test block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#test GoogleComputeUrlMap#test}
    */
    readonly test?: GoogleComputeUrlMapTest[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#timeouts GoogleComputeUrlMap#timeouts}
    */
    readonly timeouts?: GoogleComputeUrlMapTimeouts;
}
export interface GoogleComputeUrlMapDefaultRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
  This translates to the Access-Control-Allow-Credentials header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_credentials GoogleComputeUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_headers GoogleComputeUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_methods GoogleComputeUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For regular expression grammar
  please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_origin_regexes GoogleComputeUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests.
  An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_origins GoogleComputeUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#disabled GoogleComputeUrlMap#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#expose_headers GoogleComputeUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long results of a preflight request can be cached in seconds.
  This translates to the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#max_age GoogleComputeUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function googleComputeUrlMapDefaultRouteActionCorsPolicyToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionCorsPolicyOutputReference | GoogleComputeUrlMapDefaultRouteActionCorsPolicy): any;
export declare class GoogleComputeUrlMapDefaultRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionCorsPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request.
  The value must be between 200 and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#http_status GoogleComputeUrlMap#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
  The value must be between 0.0 and 100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#percentage GoogleComputeUrlMap#percentage}
    */
    readonly percentage?: number;
}
export declare function googleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbortToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference | GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort): any;
export declare class GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are
  represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function googleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
  The value must be between 0.0 and 100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#percentage GoogleComputeUrlMap#percentage}
    */
    readonly percentage?: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#fixed_delay GoogleComputeUrlMap#fixed_delay}
    */
    readonly fixedDelay?: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function googleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference | GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay): any;
export declare class GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#abort GoogleComputeUrlMap#abort}
    */
    readonly abort?: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#delay GoogleComputeUrlMap#delay}
    */
    readonly delay?: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay;
}
export declare function googleComputeUrlMapDefaultRouteActionFaultInjectionPolicyToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference | GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicy): any;
export declare class GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionRequestMirrorPolicy {
    /**
    * The full or partial URL to the BackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#backend_service GoogleComputeUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function googleComputeUrlMapDefaultRouteActionRequestMirrorPolicyToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference | GoogleComputeUrlMapDefaultRouteActionRequestMirrorPolicy): any;
export declare class GoogleComputeUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are
  represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function googleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference | GoogleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout): any;
export declare class GoogleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#num_retries GoogleComputeUrlMap#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specfies one or more conditions when this retry rule applies. Valid values are:
  
  * 5xx: Loadbalancer will attempt a retry if the backend service responds with any 5xx response code,
    or if the backend service does not respond at all, example: disconnects, reset, read timeout,
  * connection failure, and refused streams.
  * gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504.
  * connect-failure: Loadbalancer will retry on failures connecting to backend services,
    for example due to connection timeouts.
  * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
    Currently the only retriable error supported is 409.
  * refused-stream:Loadbalancer will retry if the backend service resets the stream with a REFUSED_STREAM error code.
    This reset type indicates that it is safe to retry.
  * cancelled: Loadbalancer will retry if the gRPC status code in the response header is set to cancelled
  * deadline-exceeded: Loadbalancer will retry if the gRPC status code in the response header is set to deadline-exceeded
  * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response header is set to resource-exhausted
  * unavailable: Loadbalancer will retry if the gRPC status code in the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#retry_conditions GoogleComputeUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#per_try_timeout GoogleComputeUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: GoogleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout;
}
export declare function googleComputeUrlMapDefaultRouteActionRetryPolicyToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionRetryPolicyOutputReference | GoogleComputeUrlMapDefaultRouteActionRetryPolicy): any;
export declare class GoogleComputeUrlMapDefaultRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionRetryPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): GoogleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: GoogleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): GoogleComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented
  with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function googleComputeUrlMapDefaultRouteActionTimeoutToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionTimeoutOutputReference | GoogleComputeUrlMapDefaultRouteActionTimeout): any;
export declare class GoogleComputeUrlMapDefaultRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionTimeout | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host header is replaced
  with contents of hostRewrite.
  
  The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#host_rewrite GoogleComputeUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching portion of the
  request's path is replaced by pathPrefixRewrite.
  
  The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_prefix_rewrite GoogleComputeUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function googleComputeUrlMapDefaultRouteActionUrlRewriteToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionUrlRewriteOutputReference | GoogleComputeUrlMapDefaultRouteActionUrlRewrite): any;
export declare class GoogleComputeUrlMapDefaultRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionUrlRewrite | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName?: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue?: string;
    /**
    * If false, headerValue is appended to any values that already exist for the header.
  If true, headerValue is set for the header, discarding any values that were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName?: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue?: string;
    /**
    * If false, headerValue is appended to any values that already exist for the header.
  If true, headerValue is set for the header, discarding any values that were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request prior to
  forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_remove GoogleComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response prior to sending the
  response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_remove GoogleComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_add GoogleComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_add GoogleComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference | GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction): any;
export declare class GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface GoogleComputeUrlMapDefaultRouteActionWeightedBackendServices {
    /**
    * The full or partial URL to the default BackendService resource. Before forwarding the
  request to backendService, the loadbalancer applies any relevant headerActions
  specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#backend_service GoogleComputeUrlMap#backend_service}
    */
    readonly backendService?: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as
  weight / (sum of all weightedBackendService weights in routeAction) .
  
  The selection of a backend service is determined only for new traffic. Once a user's request
  has been directed to a backendService, subsequent requests will be sent to the same backendService
  as determined by the BackendService's session affinity policy.
  
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#weight GoogleComputeUrlMap#weight}
    */
    readonly weight?: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_action GoogleComputeUrlMap#header_action}
    */
    readonly headerAction?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction;
}
export declare function googleComputeUrlMapDefaultRouteActionWeightedBackendServicesToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    resetBackendService(): void;
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesOutputReference;
}
export interface GoogleComputeUrlMapDefaultRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#cors_policy GoogleComputeUrlMap#cors_policy}
    */
    readonly corsPolicy?: GoogleComputeUrlMapDefaultRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#fault_injection_policy GoogleComputeUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_mirror_policy GoogleComputeUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: GoogleComputeUrlMapDefaultRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#retry_policy GoogleComputeUrlMap#retry_policy}
    */
    readonly retryPolicy?: GoogleComputeUrlMapDefaultRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#timeout GoogleComputeUrlMap#timeout}
    */
    readonly timeout?: GoogleComputeUrlMapDefaultRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#url_rewrite GoogleComputeUrlMap#url_rewrite}
    */
    readonly urlRewrite?: GoogleComputeUrlMapDefaultRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#weighted_backend_services GoogleComputeUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapDefaultRouteActionToTerraform(struct?: GoogleComputeUrlMapDefaultRouteActionOutputReference | GoogleComputeUrlMapDefaultRouteAction): any;
export declare class GoogleComputeUrlMapDefaultRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultRouteAction | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): GoogleComputeUrlMapDefaultRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: GoogleComputeUrlMapDefaultRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): GoogleComputeUrlMapDefaultRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): GoogleComputeUrlMapDefaultRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): GoogleComputeUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: GoogleComputeUrlMapDefaultRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): GoogleComputeUrlMapDefaultRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): GoogleComputeUrlMapDefaultRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: GoogleComputeUrlMapDefaultRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): GoogleComputeUrlMapDefaultRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): GoogleComputeUrlMapDefaultRouteActionTimeoutOutputReference;
    putTimeout(value: GoogleComputeUrlMapDefaultRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): GoogleComputeUrlMapDefaultRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): GoogleComputeUrlMapDefaultRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: GoogleComputeUrlMapDefaultRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): GoogleComputeUrlMapDefaultRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): GoogleComputeUrlMapDefaultRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: GoogleComputeUrlMapDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | GoogleComputeUrlMapDefaultRouteActionWeightedBackendServices[] | undefined;
}
export interface GoogleComputeUrlMapDefaultUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was
  supplied in the request. The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#host_redirect GoogleComputeUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set to
  false, the URL scheme of the redirected request will remain the same as that of the
  request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
  true for TargetHttpsProxy is not permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#https_redirect GoogleComputeUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was
  supplied in the request. pathRedirect cannot be supplied together with
  prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
  original request will be used for the redirect. The value must be between 1 and 1024
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_redirect GoogleComputeUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
  retaining the remaining portion of the URL before redirecting the request.
  prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
  neither. If neither is supplied, the path of the original request will be used for
  the redirect. The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#prefix_redirect GoogleComputeUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#redirect_response_code GoogleComputeUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed prior
  to redirecting the request. If set to false, the query portion of the original URL is
  retained. The default is set to false.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#strip_query GoogleComputeUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapDefaultUrlRedirectToTerraform(struct?: GoogleComputeUrlMapDefaultUrlRedirectOutputReference | GoogleComputeUrlMapDefaultUrlRedirect): any;
export declare class GoogleComputeUrlMapDefaultUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapDefaultUrlRedirect | undefined;
    set internalValue(value: GoogleComputeUrlMapDefaultUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeUrlMapHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapHeaderActionRequestHeadersToAddToTerraform(struct?: GoogleComputeUrlMapHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapHeaderActionRequestHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapHeaderActionResponseHeadersToAddToTerraform(struct?: GoogleComputeUrlMapHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapHeaderActionResponseHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_remove GoogleComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_remove GoogleComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_add GoogleComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: GoogleComputeUrlMapHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_add GoogleComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: GoogleComputeUrlMapHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapHeaderActionToTerraform(struct?: GoogleComputeUrlMapHeaderActionOutputReference | GoogleComputeUrlMapHeaderAction): any;
export declare class GoogleComputeUrlMapHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapHeaderAction | undefined;
    set internalValue(value: GoogleComputeUrlMapHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): GoogleComputeUrlMapHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: GoogleComputeUrlMapHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): GoogleComputeUrlMapHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: GoogleComputeUrlMapHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface GoogleComputeUrlMapHostRule {
    /**
    * An optional description of this resource. Provide this property when you create
  the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#description GoogleComputeUrlMap#description}
    */
    readonly description?: string;
    /**
    * The list of host patterns to match. They must be valid hostnames, except * will
  match any string of ([a-z0-9-.]*). In that case, * must be the first character
  and must be followed in the pattern by either - or ..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#hosts GoogleComputeUrlMap#hosts}
    */
    readonly hosts: string[];
    /**
    * The name of the PathMatcher to use to match the path portion of the URL if the
  hostRule matches the URL's host portion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_matcher GoogleComputeUrlMap#path_matcher}
    */
    readonly pathMatcher: string;
}
export declare function googleComputeUrlMapHostRuleToTerraform(struct?: GoogleComputeUrlMapHostRule | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapHostRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapHostRule | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapHostRule | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    get hostsInput(): string[] | undefined;
    private _pathMatcher?;
    get pathMatcher(): string;
    set pathMatcher(value: string);
    get pathMatcherInput(): string | undefined;
}
export declare class GoogleComputeUrlMapHostRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapHostRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapHostRuleOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
  This translates to the Access-Control-Allow-Credentials header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_credentials GoogleComputeUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_headers GoogleComputeUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_methods GoogleComputeUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For regular expression grammar
  please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_origin_regexes GoogleComputeUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests.
  An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_origins GoogleComputeUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#disabled GoogleComputeUrlMap#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#expose_headers GoogleComputeUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long results of a preflight request can be cached in seconds.
  This translates to the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#max_age GoogleComputeUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicyOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request.
  The value must be between 200 and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#http_status GoogleComputeUrlMap#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
  The value must be between 0.0 and 100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#percentage GoogleComputeUrlMap#percentage}
    */
    readonly percentage?: number;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbortToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbortOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are
  represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
  The value must be between 0.0 and 100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#percentage GoogleComputeUrlMap#percentage}
    */
    readonly percentage?: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#fixed_delay GoogleComputeUrlMap#fixed_delay}
    */
    readonly fixedDelay?: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#abort GoogleComputeUrlMap#abort}
    */
    readonly abort?: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#delay GoogleComputeUrlMap#delay}
    */
    readonly delay?: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy {
    /**
    * The full or partial URL to the BackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#backend_service GoogleComputeUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicyOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are
  represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#num_retries GoogleComputeUrlMap#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specfies one or more conditions when this retry rule applies. Valid values are:
  
  * 5xx: Loadbalancer will attempt a retry if the backend service responds with any 5xx response code,
    or if the backend service does not respond at all, example: disconnects, reset, read timeout,
  * connection failure, and refused streams.
  * gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504.
  * connect-failure: Loadbalancer will retry on failures connecting to backend services,
    for example due to connection timeouts.
  * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
    Currently the only retriable error supported is 409.
  * refused-stream:Loadbalancer will retry if the backend service resets the stream with a REFUSED_STREAM error code.
    This reset type indicates that it is safe to retry.
  * cancelled: Loadbalancer will retry if the gRPC status code in the response header is set to cancelled
  * deadline-exceeded: Loadbalancer will retry if the gRPC status code in the response header is set to deadline-exceeded
  * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response header is set to resource-exhausted
  * unavailable: Loadbalancer will retry if the gRPC status code in the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#retry_conditions GoogleComputeUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#per_try_timeout GoogleComputeUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented
  with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionTimeoutToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionTimeoutOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionTimeout): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionTimeout | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host header is replaced
  with contents of hostRewrite.
  
  The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#host_rewrite GoogleComputeUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching portion of the
  request's path is replaced by pathPrefixRewrite.
  
  The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_prefix_rewrite GoogleComputeUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionUrlRewriteToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionUrlRewriteOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName?: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue?: string;
    /**
    * If false, headerValue is appended to any values that already exist for the header.
  If true, headerValue is set for the header, discarding any values that were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName?: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue?: string;
    /**
    * If false, headerValue is appended to any values that already exist for the header.
  If true, headerValue is set for the header, discarding any values that were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request prior to
  forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_remove GoogleComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response prior to sending the
  response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_remove GoogleComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_add GoogleComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_add GoogleComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices {
    /**
    * The full or partial URL to the default BackendService resource. Before forwarding the
  request to backendService, the loadbalancer applies any relevant headerActions
  specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#backend_service GoogleComputeUrlMap#backend_service}
    */
    readonly backendService?: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as
  weight / (sum of all weightedBackendService weights in routeAction) .
  
  The selection of a backend service is determined only for new traffic. Once a user's request
  has been directed to a backendService, subsequent requests will be sent to the same backendService
  as determined by the BackendService's session affinity policy.
  
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#weight GoogleComputeUrlMap#weight}
    */
    readonly weight?: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_action GoogleComputeUrlMap#header_action}
    */
    readonly headerAction?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    resetBackendService(): void;
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherDefaultRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#cors_policy GoogleComputeUrlMap#cors_policy}
    */
    readonly corsPolicy?: GoogleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#fault_injection_policy GoogleComputeUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_mirror_policy GoogleComputeUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: GoogleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#retry_policy GoogleComputeUrlMap#retry_policy}
    */
    readonly retryPolicy?: GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#timeout GoogleComputeUrlMap#timeout}
    */
    readonly timeout?: GoogleComputeUrlMapPathMatcherDefaultRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#url_rewrite GoogleComputeUrlMap#url_rewrite}
    */
    readonly urlRewrite?: GoogleComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#weighted_backend_services GoogleComputeUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherDefaultRouteActionToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultRouteActionOutputReference | GoogleComputeUrlMapPathMatcherDefaultRouteAction): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultRouteAction | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): GoogleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): GoogleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): GoogleComputeUrlMapPathMatcherDefaultRouteActionTimeoutOutputReference;
    putTimeout(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): GoogleComputeUrlMapPathMatcherDefaultRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): GoogleComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | undefined;
}
export interface GoogleComputeUrlMapPathMatcherDefaultUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was
  supplied in the request. The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#host_redirect GoogleComputeUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set to
  false, the URL scheme of the redirected request will remain the same as that of the
  request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
  true for TargetHttpsProxy is not permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#https_redirect GoogleComputeUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was
  supplied in the request. pathRedirect cannot be supplied together with
  prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
  original request will be used for the redirect. The value must be between 1 and 1024
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_redirect GoogleComputeUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
  retaining the remaining portion of the URL before redirecting the request.
  prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
  neither. If neither is supplied, the path of the original request will be used for
  the redirect. The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#prefix_redirect GoogleComputeUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#redirect_response_code GoogleComputeUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed prior
  to redirecting the request. If set to false, the query portion of the original URL is
  retained.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#strip_query GoogleComputeUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherDefaultUrlRedirectToTerraform(struct?: GoogleComputeUrlMapPathMatcherDefaultUrlRedirectOutputReference | GoogleComputeUrlMapPathMatcherDefaultUrlRedirect): any;
export declare class GoogleComputeUrlMapPathMatcherDefaultUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherDefaultUrlRedirect | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherDefaultUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAddToTerraform(struct?: GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAddToTerraform(struct?: GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_remove GoogleComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_remove GoogleComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_add GoogleComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_add GoogleComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherHeaderActionToTerraform(struct?: GoogleComputeUrlMapPathMatcherHeaderActionOutputReference | GoogleComputeUrlMapPathMatcherHeaderAction): any;
export declare class GoogleComputeUrlMapPathMatcherHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherHeaderAction | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the
  actual request can include user credentials. This translates to the Access-
  Control-Allow-Credentials header. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_credentials GoogleComputeUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_headers GoogleComputeUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_methods GoogleComputeUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For
  regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_origin_regexes GoogleComputeUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests. An
  origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_origins GoogleComputeUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#disabled GoogleComputeUrlMap#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#expose_headers GoogleComputeUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long the results of a preflight request can be cached. This
  translates to the content for the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#max_age GoogleComputeUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request. The value must be between 200
  and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#http_status GoogleComputeUrlMap#http_status}
    */
    readonly httpStatus: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be
  aborted as part of fault injection. The value must be between 0.0 and 100.0
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#percentage GoogleComputeUrlMap#percentage}
    */
    readonly percentage: number;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will
  be introduced as part of fault injection. The value must be between 0.0 and
  100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#percentage GoogleComputeUrlMap#percentage}
    */
    readonly percentage: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#fixed_delay GoogleComputeUrlMap#fixed_delay}
    */
    readonly fixedDelay: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    get fixedDelayInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#abort GoogleComputeUrlMap#abort}
    */
    readonly abort?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#delay GoogleComputeUrlMap#delay}
    */
    readonly delay?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy {
    /**
    * The BackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#backend_service GoogleComputeUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#num_retries GoogleComputeUrlMap#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specifies one or more conditions when this retry rule applies. Valid values are:
  
  * 5xx: Loadbalancer will attempt a retry if the backend service responds with
  any 5xx response code, or if the backend service does not respond at all,
  example: disconnects, reset, read timeout, connection failure, and refused
  streams.
  * gateway-error: Similar to 5xx, but only applies to response codes
  502, 503 or 504.
  * connect-failure: Loadbalancer will retry on failures
  connecting to backend services, for example due to connection timeouts.
  * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
  Currently the only retriable error supported is 409.
  * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
  REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
  * cancelled: Loadbalancer will retry if the gRPC status code in the response
  header is set to cancelled
  * deadline-exceeded: Loadbalancer will retry if the
  gRPC status code in the response header is set to deadline-exceeded
  * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
  header is set to resource-exhausted
  * unavailable: Loadbalancer will retry if
  the gRPC status code in the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#retry_conditions GoogleComputeUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#per_try_timeout GoogleComputeUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionTimeoutToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionTimeout): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionTimeout | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host
  header is replaced with contents of hostRewrite. The value must be between 1 and
  255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#host_rewrite GoogleComputeUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching
  portion of the request's path is replaced by pathPrefixRewrite. The value must
  be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_prefix_rewrite GoogleComputeUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewriteToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_remove GoogleComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_remove GoogleComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_add GoogleComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_add GoogleComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices {
    /**
    * The default BackendService resource. Before
  forwarding the request to backendService, the loadbalancer applies any relevant
  headerActions specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#backend_service GoogleComputeUrlMap#backend_service}
    */
    readonly backendService: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as weight /
  (sum of all weightedBackendService weights in routeAction) . The selection of a
  backend service is determined only for new traffic. Once a user's request has
  been directed to a backendService, subsequent requests will be sent to the same
  backendService as determined by the BackendService's session affinity policy.
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#weight GoogleComputeUrlMap#weight}
    */
    readonly weight: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_action GoogleComputeUrlMap#header_action}
    */
    readonly headerAction?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#cors_policy GoogleComputeUrlMap#cors_policy}
    */
    readonly corsPolicy?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#fault_injection_policy GoogleComputeUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_mirror_policy GoogleComputeUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#retry_policy GoogleComputeUrlMap#retry_policy}
    */
    readonly retryPolicy?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#timeout GoogleComputeUrlMap#timeout}
    */
    readonly timeout?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#url_rewrite GoogleComputeUrlMap#url_rewrite}
    */
    readonly urlRewrite?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#weighted_backend_services GoogleComputeUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherPathRuleRouteActionToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleRouteActionOutputReference | GoogleComputeUrlMapPathMatcherPathRuleRouteAction): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleRouteAction | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference;
    putTimeout(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRuleUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one
  that was supplied in the request. The value must be between 1 and 255
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#host_redirect GoogleComputeUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https.
  If set to false, the URL scheme of the redirected request will remain the
  same as that of the request. This must only be set for UrlMaps used in
  TargetHttpProxys. Setting this true for TargetHttpsProxy is not
  permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#https_redirect GoogleComputeUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one
  that was supplied in the request. pathRedirect cannot be supplied
  together with prefixRedirect. Supply one alone or neither. If neither is
  supplied, the path of the original request will be used for the redirect.
  The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_redirect GoogleComputeUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the
  HttpRouteRuleMatch, retaining the remaining portion of the URL before
  redirecting the request. prefixRedirect cannot be supplied together with
  pathRedirect. Supply one alone or neither. If neither is supplied, the
  path of the original request will be used for the redirect. The value
  must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#prefix_redirect GoogleComputeUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#redirect_response_code GoogleComputeUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is
  removed prior to redirecting the request. If set to false, the query
  portion of the original URL is retained.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#strip_query GoogleComputeUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherPathRuleUrlRedirectToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRuleUrlRedirectOutputReference | GoogleComputeUrlMapPathMatcherPathRuleUrlRedirect): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRuleUrlRedirect | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRuleUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeUrlMapPathMatcherPathRule {
    /**
    * The list of path patterns to match. Each must start with / and the only place a
  \* is allowed is at the end following a /. The string fed to the path matcher
  does not include any text after the first ? or #, and those chars are not
  allowed here.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#paths GoogleComputeUrlMap#paths}
    */
    readonly paths: string[];
    /**
    * The backend service or backend bucket to use if any of the given paths match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#service GoogleComputeUrlMap#service}
    */
    readonly service?: string;
    /**
    * route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#route_action GoogleComputeUrlMap#route_action}
    */
    readonly routeAction?: GoogleComputeUrlMapPathMatcherPathRuleRouteAction;
    /**
    * url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#url_redirect GoogleComputeUrlMap#url_redirect}
    */
    readonly urlRedirect?: GoogleComputeUrlMapPathMatcherPathRuleUrlRedirect;
}
export declare function googleComputeUrlMapPathMatcherPathRuleToTerraform(struct?: GoogleComputeUrlMapPathMatcherPathRule | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherPathRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherPathRule | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherPathRule | cdktf.IResolvable | undefined);
    private _paths?;
    get paths(): string[];
    set paths(value: string[]);
    get pathsInput(): string[] | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _routeAction;
    get routeAction(): GoogleComputeUrlMapPathMatcherPathRuleRouteActionOutputReference;
    putRouteAction(value: GoogleComputeUrlMapPathMatcherPathRuleRouteAction): void;
    resetRouteAction(): void;
    get routeActionInput(): GoogleComputeUrlMapPathMatcherPathRuleRouteAction | undefined;
    private _urlRedirect;
    get urlRedirect(): GoogleComputeUrlMapPathMatcherPathRuleUrlRedirectOutputReference;
    putUrlRedirect(value: GoogleComputeUrlMapPathMatcherPathRuleUrlRedirect): void;
    resetUrlRedirect(): void;
    get urlRedirectInput(): GoogleComputeUrlMapPathMatcherPathRuleUrlRedirect | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherPathRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherPathRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherPathRuleOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_remove GoogleComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_remove GoogleComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_add GoogleComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_add GoogleComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesHeaderActionToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesHeaderAction): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesHeaderAction | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch {
    /**
    * The end of the range (exclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#range_end GoogleComputeUrlMap#range_end}
    */
    readonly rangeEnd: number;
    /**
    * The start of the range (inclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#range_start GoogleComputeUrlMap#range_start}
    */
    readonly rangeStart: number;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined);
    private _rangeEnd?;
    get rangeEnd(): number;
    set rangeEnd(value: number);
    get rangeEndInput(): number | undefined;
    private _rangeStart?;
    get rangeStart(): number;
    set rangeStart(value: number);
    get rangeStartInput(): number | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches {
    /**
    * The value should exactly match contents of exactMatch. Only one of exactMatch,
  prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#exact_match GoogleComputeUrlMap#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The name of the HTTP header to match. For matching against the HTTP request's
  authority, use a headerMatch with the header name ":authority". For matching a
  request's method, use the headerName ":method".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * If set to false, the headerMatch is considered a match if the match criteria
  above are met. If set to true, the headerMatch is considered a match if the
  match criteria above are NOT met. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#invert_match GoogleComputeUrlMap#invert_match}
    */
    readonly invertMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must start with the contents of prefixMatch. Only one of
  exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#prefix_match GoogleComputeUrlMap#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * A header with the contents of headerName must exist. The match takes place
  whether or not the request's header has a value or not. Only one of exactMatch,
  prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#present_match GoogleComputeUrlMap#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must match the regular expression specified in
  regexMatch. For regular expression grammar, please see:
  en.cppreference.com/w/cpp/regex/ecmascript  For matching against a port
  specified in the HTTP request, use a headerMatch with headerName set to PORT and
  a regular expression that satisfies the RFC2616 Host header's port specifier.
  Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
  rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#regex_match GoogleComputeUrlMap#regex_match}
    */
    readonly regexMatch?: string;
    /**
    * The value of the header must end with the contents of suffixMatch. Only one of
  exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#suffix_match GoogleComputeUrlMap#suffix_match}
    */
    readonly suffixMatch?: string;
    /**
    * range_match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#range_match GoogleComputeUrlMap#range_match}
    */
    readonly rangeMatch?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable | undefined);
    private _exactMatch?;
    get exactMatch(): string;
    set exactMatch(value: string);
    resetExactMatch(): void;
    get exactMatchInput(): string | undefined;
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _invertMatch?;
    get invertMatch(): boolean | cdktf.IResolvable;
    set invertMatch(value: boolean | cdktf.IResolvable);
    resetInvertMatch(): void;
    get invertMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string;
    set prefixMatch(value: string);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string | undefined;
    private _presentMatch?;
    get presentMatch(): boolean | cdktf.IResolvable;
    set presentMatch(value: boolean | cdktf.IResolvable);
    resetPresentMatch(): void;
    get presentMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
    private _suffixMatch?;
    get suffixMatch(): string;
    set suffixMatch(value: string);
    resetSuffixMatch(): void;
    get suffixMatchInput(): string | undefined;
    private _rangeMatch;
    get rangeMatch(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference;
    putRangeMatch(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch): void;
    resetRangeMatch(): void;
    get rangeMatchInput(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels {
    /**
    * Name of metadata label. The name can have a maximum length of 1024 characters
  and must be at least 1 character long.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#name GoogleComputeUrlMap#name}
    */
    readonly name: string;
    /**
    * The value of the label must match the specified value. value can have a maximum
  length of 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#value GoogleComputeUrlMap#value}
    */
    readonly value: string;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters {
    /**
    * Specifies how individual filterLabel matches within the list of filterLabels
  contribute towards the overall metadataFilter match. Supported values are:
    - MATCH_ANY: At least one of the filterLabels must have a matching label in the
  provided metadata.
    - MATCH_ALL: All filterLabels must have matching labels in
  the provided metadata. Possible values: ["MATCH_ALL", "MATCH_ANY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#filter_match_criteria GoogleComputeUrlMap#filter_match_criteria}
    */
    readonly filterMatchCriteria: string;
    /**
    * filter_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#filter_labels GoogleComputeUrlMap#filter_labels}
    */
    readonly filterLabels: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable | undefined);
    private _filterMatchCriteria?;
    get filterMatchCriteria(): string;
    set filterMatchCriteria(value: string);
    get filterMatchCriteriaInput(): string | undefined;
    private _filterLabels;
    get filterLabels(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsList;
    putFilterLabels(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable): void;
    get filterLabelsInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches {
    /**
    * The queryParameterMatch matches if the value of the parameter exactly matches
  the contents of exactMatch. Only one of presentMatch, exactMatch and regexMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#exact_match GoogleComputeUrlMap#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The name of the query parameter to match. The query parameter must exist in the
  request, in the absence of which the request match fails.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#name GoogleComputeUrlMap#name}
    */
    readonly name: string;
    /**
    * Specifies that the queryParameterMatch matches if the request contains the query
  parameter, irrespective of whether the parameter has a value or not. Only one of
  presentMatch, exactMatch and regexMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#present_match GoogleComputeUrlMap#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The queryParameterMatch matches if the value of the parameter matches the
  regular expression specified by regexMatch. For the regular expression grammar,
  please see en.cppreference.com/w/cpp/regex/ecmascript  Only one of presentMatch,
  exactMatch and regexMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#regex_match GoogleComputeUrlMap#regex_match}
    */
    readonly regexMatch?: string;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable | undefined);
    private _exactMatch?;
    get exactMatch(): string;
    set exactMatch(value: string);
    resetExactMatch(): void;
    get exactMatchInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _presentMatch?;
    get presentMatch(): boolean | cdktf.IResolvable;
    set presentMatch(value: boolean | cdktf.IResolvable);
    resetPresentMatch(): void;
    get presentMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesMatchRules {
    /**
    * For satisfying the matchRule condition, the path of the request must exactly
  match the value specified in fullPathMatch after removing any query parameters
  and anchor that may be part of the original URL. FullPathMatch must be between 1
  and 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must
  be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#full_path_match GoogleComputeUrlMap#full_path_match}
    */
    readonly fullPathMatch?: string;
    /**
    * Specifies that prefixMatch and fullPathMatch matches are case sensitive.
  Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#ignore_case GoogleComputeUrlMap#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * For satisfying the matchRule condition, the request's path must begin with the
  specified prefixMatch. prefixMatch must begin with a /. The value must be
  between 1 and 1024 characters. Only one of prefixMatch, fullPathMatch or
  regexMatch must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#prefix_match GoogleComputeUrlMap#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * For satisfying the matchRule condition, the path of the request must satisfy the
  regular expression specified in regexMatch after removing any query parameters
  and anchor supplied with the original URL. For regular expression grammar please
  see en.cppreference.com/w/cpp/regex/ecmascript  Only one of prefixMatch,
  fullPathMatch or regexMatch must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#regex_match GoogleComputeUrlMap#regex_match}
    */
    readonly regexMatch?: string;
    /**
    * header_matches block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_matches GoogleComputeUrlMap#header_matches}
    */
    readonly headerMatches?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable;
    /**
    * metadata_filters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#metadata_filters GoogleComputeUrlMap#metadata_filters}
    */
    readonly metadataFilters?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable;
    /**
    * query_parameter_matches block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#query_parameter_matches GoogleComputeUrlMap#query_parameter_matches}
    */
    readonly queryParameterMatches?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesMatchRulesToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable | undefined);
    private _fullPathMatch?;
    get fullPathMatch(): string;
    set fullPathMatch(value: string);
    resetFullPathMatch(): void;
    get fullPathMatchInput(): string | undefined;
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string;
    set prefixMatch(value: string);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
    private _headerMatches;
    get headerMatches(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesList;
    putHeaderMatches(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable): void;
    resetHeaderMatches(): void;
    get headerMatchesInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | undefined;
    private _metadataFilters;
    get metadataFilters(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersList;
    putMetadataFilters(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable): void;
    resetMetadataFilters(): void;
    get metadataFiltersInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | undefined;
    private _queryParameterMatches;
    get queryParameterMatches(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesList;
    putQueryParameterMatches(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable): void;
    resetQueryParameterMatches(): void;
    get queryParameterMatchesInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the
  actual request can include user credentials. This translates to the Access-
  Control-Allow-Credentials header. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_credentials GoogleComputeUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_headers GoogleComputeUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_methods GoogleComputeUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For
  regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_origin_regexes GoogleComputeUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests. An
  origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#allow_origins GoogleComputeUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled.
  which indicates that the CORS policy is in effect. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#disabled GoogleComputeUrlMap#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#expose_headers GoogleComputeUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long the results of a preflight request can be cached. This
  translates to the content for the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#max_age GoogleComputeUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request. The value must be between 200
  and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#http_status GoogleComputeUrlMap#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be
  aborted as part of fault injection. The value must be between 0.0 and 100.0
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#percentage GoogleComputeUrlMap#percentage}
    */
    readonly percentage?: number;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will
  be introduced as part of fault injection. The value must be between 0.0 and
  100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#percentage GoogleComputeUrlMap#percentage}
    */
    readonly percentage?: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#fixed_delay GoogleComputeUrlMap#fixed_delay}
    */
    readonly fixedDelay?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#abort GoogleComputeUrlMap#abort}
    */
    readonly abort?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#delay GoogleComputeUrlMap#delay}
    */
    readonly delay?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy {
    /**
    * The BackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#backend_service GoogleComputeUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#num_retries GoogleComputeUrlMap#num_retries}
    */
    readonly numRetries: number;
    /**
    * Specfies one or more conditions when this retry rule applies. Valid values are:
  
  * 5xx: Loadbalancer will attempt a retry if the backend service responds with
    any 5xx response code, or if the backend service does not respond at all,
    example: disconnects, reset, read timeout, connection failure, and refused
    streams.
  * gateway-error: Similar to 5xx, but only applies to response codes
    502, 503 or 504.
  * connect-failure: Loadbalancer will retry on failures
    connecting to backend services, for example due to connection timeouts.
  * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
    Currently the only retriable error supported is 409.
  * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
    REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
  * cancelled: Loadbalancer will retry if the gRPC status code in the response
    header is set to cancelled
  * deadline-exceeded: Loadbalancer will retry if the
    gRPC status code in the response header is set to deadline-exceeded
  * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
    header is set to resource-exhausted
  * unavailable: Loadbalancer will retry if the gRPC status code in
    the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#retry_conditions GoogleComputeUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#per_try_timeout GoogleComputeUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#nanos GoogleComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#seconds GoogleComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionTimeoutToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionTimeout): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host
  header is replaced with contents of hostRewrite. The value must be between 1 and
  255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#host_rewrite GoogleComputeUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching
  portion of the request's path is replaced by pathPrefixRewrite. The value must
  be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_prefix_rewrite GoogleComputeUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewriteToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_name GoogleComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_value GoogleComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#replace GoogleComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_remove GoogleComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_remove GoogleComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_headers_to_add GoogleComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#response_headers_to_add GoogleComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices {
    /**
    * The default BackendService resource. Before
  forwarding the request to backendService, the loadbalancer applies any relevant
  headerActions specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#backend_service GoogleComputeUrlMap#backend_service}
    */
    readonly backendService: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as weight /
  (sum of all weightedBackendService weights in routeAction) . The selection of a
  backend service is determined only for new traffic. Once a user's request has
  been directed to a backendService, subsequent requests will be sent to the same
  backendService as determined by the BackendService's session affinity policy.
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#weight GoogleComputeUrlMap#weight}
    */
    readonly weight: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_action GoogleComputeUrlMap#header_action}
    */
    readonly headerAction?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesOutputReference;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#cors_policy GoogleComputeUrlMap#cors_policy}
    */
    readonly corsPolicy?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#fault_injection_policy GoogleComputeUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#request_mirror_policy GoogleComputeUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#retry_policy GoogleComputeUrlMap#retry_policy}
    */
    readonly retryPolicy?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#timeout GoogleComputeUrlMap#timeout}
    */
    readonly timeout?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#url_rewrite GoogleComputeUrlMap#url_rewrite}
    */
    readonly urlRewrite?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#weighted_backend_services GoogleComputeUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesRouteActionToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesRouteAction): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesRouteAction | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference;
    putTimeout(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRulesUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was
  supplied in the request. The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#host_redirect GoogleComputeUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set
  to false, the URL scheme of the redirected request will remain the same as that
  of the request. This must only be set for UrlMaps used in TargetHttpProxys.
  Setting this true for TargetHttpsProxy is not permitted. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#https_redirect GoogleComputeUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was
  supplied in the request. Only one of pathRedirect or prefixRedirect must be
  specified. The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_redirect GoogleComputeUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
  retaining the remaining portion of the URL before redirecting the request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#prefix_redirect GoogleComputeUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#redirect_response_code GoogleComputeUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed
  prior to redirecting the request. If set to false, the query portion of the
  original URL is retained. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#strip_query GoogleComputeUrlMap#strip_query}
    */
    readonly stripQuery?: boolean | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesUrlRedirectToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRulesUrlRedirectOutputReference | GoogleComputeUrlMapPathMatcherRouteRulesUrlRedirect): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRulesUrlRedirect | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRulesUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    resetStripQuery(): void;
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeUrlMapPathMatcherRouteRules {
    /**
    * For routeRules within a given pathMatcher, priority determines the order
  in which load balancer will interpret routeRules. RouteRules are evaluated
  in order of priority, from the lowest to highest number. The priority of
  a rule decreases as its number increases (1, 2, 3, N+1). The first rule
  that matches the request is applied.
  
  You cannot configure two or more routeRules with the same priority.
  Priority for each rule must be set to a number between 0 and
  2147483647 inclusive.
  
  Priority numbers can have gaps, which enable you to add or remove rules
  in the future without affecting the rest of the rules. For example,
  1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which
  you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the
  future without any impact on existing rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#priority GoogleComputeUrlMap#priority}
    */
    readonly priority: number;
    /**
    * The backend service resource to which traffic is
  directed if this rule is matched. If routeAction is additionally specified,
  advanced routing actions like URL Rewrites, etc. take effect prior to sending
  the request to the backend. However, if service is specified, routeAction cannot
  contain any weightedBackendService s. Conversely, if routeAction specifies any
  weightedBackendServices, service must not be specified. Only one of urlRedirect,
  service or routeAction.weightedBackendService must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#service GoogleComputeUrlMap#service}
    */
    readonly service?: string;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_action GoogleComputeUrlMap#header_action}
    */
    readonly headerAction?: GoogleComputeUrlMapPathMatcherRouteRulesHeaderAction;
    /**
    * match_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#match_rules GoogleComputeUrlMap#match_rules}
    */
    readonly matchRules?: GoogleComputeUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable;
    /**
    * route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#route_action GoogleComputeUrlMap#route_action}
    */
    readonly routeAction?: GoogleComputeUrlMapPathMatcherRouteRulesRouteAction;
    /**
    * url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#url_redirect GoogleComputeUrlMap#url_redirect}
    */
    readonly urlRedirect?: GoogleComputeUrlMapPathMatcherRouteRulesUrlRedirect;
}
export declare function googleComputeUrlMapPathMatcherRouteRulesToTerraform(struct?: GoogleComputeUrlMapPathMatcherRouteRules | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherRouteRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcherRouteRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcherRouteRules | cdktf.IResolvable | undefined);
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeUrlMapPathMatcherRouteRulesHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeUrlMapPathMatcherRouteRulesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeUrlMapPathMatcherRouteRulesHeaderAction | undefined;
    private _matchRules;
    get matchRules(): GoogleComputeUrlMapPathMatcherRouteRulesMatchRulesList;
    putMatchRules(value: GoogleComputeUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable): void;
    resetMatchRules(): void;
    get matchRulesInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRulesMatchRules[] | undefined;
    private _routeAction;
    get routeAction(): GoogleComputeUrlMapPathMatcherRouteRulesRouteActionOutputReference;
    putRouteAction(value: GoogleComputeUrlMapPathMatcherRouteRulesRouteAction): void;
    resetRouteAction(): void;
    get routeActionInput(): GoogleComputeUrlMapPathMatcherRouteRulesRouteAction | undefined;
    private _urlRedirect;
    get urlRedirect(): GoogleComputeUrlMapPathMatcherRouteRulesUrlRedirectOutputReference;
    putUrlRedirect(value: GoogleComputeUrlMapPathMatcherRouteRulesUrlRedirect): void;
    resetUrlRedirect(): void;
    get urlRedirectInput(): GoogleComputeUrlMapPathMatcherRouteRulesUrlRedirect | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherRouteRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcherRouteRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherRouteRulesOutputReference;
}
export interface GoogleComputeUrlMapPathMatcher {
    /**
    * The backend service or backend bucket to use when none of the given paths match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#default_service GoogleComputeUrlMap#default_service}
    */
    readonly defaultService?: string;
    /**
    * An optional description of this resource. Provide this property when you create
  the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#description GoogleComputeUrlMap#description}
    */
    readonly description?: string;
    /**
    * The name to which this PathMatcher is referred by the HostRule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#name GoogleComputeUrlMap#name}
    */
    readonly name: string;
    /**
    * default_route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#default_route_action GoogleComputeUrlMap#default_route_action}
    */
    readonly defaultRouteAction?: GoogleComputeUrlMapPathMatcherDefaultRouteAction;
    /**
    * default_url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#default_url_redirect GoogleComputeUrlMap#default_url_redirect}
    */
    readonly defaultUrlRedirect?: GoogleComputeUrlMapPathMatcherDefaultUrlRedirect;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#header_action GoogleComputeUrlMap#header_action}
    */
    readonly headerAction?: GoogleComputeUrlMapPathMatcherHeaderAction;
    /**
    * path_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path_rule GoogleComputeUrlMap#path_rule}
    */
    readonly pathRule?: GoogleComputeUrlMapPathMatcherPathRule[] | cdktf.IResolvable;
    /**
    * route_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#route_rules GoogleComputeUrlMap#route_rules}
    */
    readonly routeRules?: GoogleComputeUrlMapPathMatcherRouteRules[] | cdktf.IResolvable;
}
export declare function googleComputeUrlMapPathMatcherToTerraform(struct?: GoogleComputeUrlMapPathMatcher | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapPathMatcherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapPathMatcher | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapPathMatcher | cdktf.IResolvable | undefined);
    private _defaultService?;
    get defaultService(): string;
    set defaultService(value: string);
    resetDefaultService(): void;
    get defaultServiceInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _defaultRouteAction;
    get defaultRouteAction(): GoogleComputeUrlMapPathMatcherDefaultRouteActionOutputReference;
    putDefaultRouteAction(value: GoogleComputeUrlMapPathMatcherDefaultRouteAction): void;
    resetDefaultRouteAction(): void;
    get defaultRouteActionInput(): GoogleComputeUrlMapPathMatcherDefaultRouteAction | undefined;
    private _defaultUrlRedirect;
    get defaultUrlRedirect(): GoogleComputeUrlMapPathMatcherDefaultUrlRedirectOutputReference;
    putDefaultUrlRedirect(value: GoogleComputeUrlMapPathMatcherDefaultUrlRedirect): void;
    resetDefaultUrlRedirect(): void;
    get defaultUrlRedirectInput(): GoogleComputeUrlMapPathMatcherDefaultUrlRedirect | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeUrlMapPathMatcherHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeUrlMapPathMatcherHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeUrlMapPathMatcherHeaderAction | undefined;
    private _pathRule;
    get pathRule(): GoogleComputeUrlMapPathMatcherPathRuleList;
    putPathRule(value: GoogleComputeUrlMapPathMatcherPathRule[] | cdktf.IResolvable): void;
    resetPathRule(): void;
    get pathRuleInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherPathRule[] | undefined;
    private _routeRules;
    get routeRules(): GoogleComputeUrlMapPathMatcherRouteRulesList;
    putRouteRules(value: GoogleComputeUrlMapPathMatcherRouteRules[] | cdktf.IResolvable): void;
    resetRouteRules(): void;
    get routeRulesInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcherRouteRules[] | undefined;
}
export declare class GoogleComputeUrlMapPathMatcherList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapPathMatcher[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapPathMatcherOutputReference;
}
export interface GoogleComputeUrlMapTest {
    /**
    * Description of this test case.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#description GoogleComputeUrlMap#description}
    */
    readonly description?: string;
    /**
    * Host portion of the URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#host GoogleComputeUrlMap#host}
    */
    readonly host: string;
    /**
    * Path portion of the URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#path GoogleComputeUrlMap#path}
    */
    readonly path: string;
    /**
    * The backend service or backend bucket link that should be matched by this test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#service GoogleComputeUrlMap#service}
    */
    readonly service: string;
}
export declare function googleComputeUrlMapTestToTerraform(struct?: GoogleComputeUrlMapTest | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapTestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeUrlMapTest | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapTest | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export declare class GoogleComputeUrlMapTestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeUrlMapTest[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeUrlMapTestOutputReference;
}
export interface GoogleComputeUrlMapTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#create GoogleComputeUrlMap#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#delete GoogleComputeUrlMap#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map#update GoogleComputeUrlMap#update}
    */
    readonly update?: string;
}
export declare function googleComputeUrlMapTimeoutsToTerraform(struct?: GoogleComputeUrlMapTimeoutsOutputReference | GoogleComputeUrlMapTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeUrlMapTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeUrlMapTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeUrlMapTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map google_compute_url_map}
*/
export declare class GoogleComputeUrlMap extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_url_map";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_url_map google_compute_url_map} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeUrlMapConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeUrlMapConfig);
    get creationTimestamp(): string;
    private _defaultService?;
    get defaultService(): string;
    set defaultService(value: string);
    resetDefaultService(): void;
    get defaultServiceInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get mapId(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _defaultRouteAction;
    get defaultRouteAction(): GoogleComputeUrlMapDefaultRouteActionOutputReference;
    putDefaultRouteAction(value: GoogleComputeUrlMapDefaultRouteAction): void;
    resetDefaultRouteAction(): void;
    get defaultRouteActionInput(): GoogleComputeUrlMapDefaultRouteAction | undefined;
    private _defaultUrlRedirect;
    get defaultUrlRedirect(): GoogleComputeUrlMapDefaultUrlRedirectOutputReference;
    putDefaultUrlRedirect(value: GoogleComputeUrlMapDefaultUrlRedirect): void;
    resetDefaultUrlRedirect(): void;
    get defaultUrlRedirectInput(): GoogleComputeUrlMapDefaultUrlRedirect | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeUrlMapHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeUrlMapHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeUrlMapHeaderAction | undefined;
    private _hostRule;
    get hostRule(): GoogleComputeUrlMapHostRuleList;
    putHostRule(value: GoogleComputeUrlMapHostRule[] | cdktf.IResolvable): void;
    resetHostRule(): void;
    get hostRuleInput(): cdktf.IResolvable | GoogleComputeUrlMapHostRule[] | undefined;
    private _pathMatcher;
    get pathMatcher(): GoogleComputeUrlMapPathMatcherList;
    putPathMatcher(value: GoogleComputeUrlMapPathMatcher[] | cdktf.IResolvable): void;
    resetPathMatcher(): void;
    get pathMatcherInput(): cdktf.IResolvable | GoogleComputeUrlMapPathMatcher[] | undefined;
    private _test;
    get test(): GoogleComputeUrlMapTestList;
    putTest(value: GoogleComputeUrlMapTest[] | cdktf.IResolvable): void;
    resetTest(): void;
    get testInput(): cdktf.IResolvable | GoogleComputeUrlMapTest[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeUrlMapTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeUrlMapTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeUrlMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
