import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerAzureNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#annotations GoogleContainerAzureNodePool#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Optional. The Azure availability zone of the nodes in this nodepool. When unspecified, it defaults to `1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#azure_availability_zone GoogleContainerAzureNodePool#azure_availability_zone}
    */
    readonly azureAvailabilityZone?: string;
    /**
    * The azureCluster for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#cluster GoogleContainerAzureNodePool#cluster}
    */
    readonly cluster: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#id GoogleContainerAzureNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#location GoogleContainerAzureNodePool#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#name GoogleContainerAzureNodePool#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#project GoogleContainerAzureNodePool#project}
    */
    readonly project?: string;
    /**
    * The ARM ID of the subnet where the node pool VMs run. Make sure it's a subnet under the virtual network in the cluster configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#subnet_id GoogleContainerAzureNodePool#subnet_id}
    */
    readonly subnetId: string;
    /**
    * The Kubernetes version (e.g. `1.19.10-gke.1000`) running on this node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#version GoogleContainerAzureNodePool#version}
    */
    readonly version: string;
    /**
    * autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#autoscaling GoogleContainerAzureNodePool#autoscaling}
    */
    readonly autoscaling: GoogleContainerAzureNodePoolAutoscaling;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#config GoogleContainerAzureNodePool#config}
    */
    readonly config: GoogleContainerAzureNodePoolConfigA;
    /**
    * max_pods_constraint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#max_pods_constraint GoogleContainerAzureNodePool#max_pods_constraint}
    */
    readonly maxPodsConstraint: GoogleContainerAzureNodePoolMaxPodsConstraint;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#timeouts GoogleContainerAzureNodePool#timeouts}
    */
    readonly timeouts?: GoogleContainerAzureNodePoolTimeouts;
}
export interface GoogleContainerAzureNodePoolAutoscaling {
    /**
    * Maximum number of nodes in the node pool. Must be >= min_node_count.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#max_node_count GoogleContainerAzureNodePool#max_node_count}
    */
    readonly maxNodeCount: number;
    /**
    * Minimum number of nodes in the node pool. Must be >= 1 and <= max_node_count.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#min_node_count GoogleContainerAzureNodePool#min_node_count}
    */
    readonly minNodeCount: number;
}
export declare function googleContainerAzureNodePoolAutoscalingToTerraform(struct?: GoogleContainerAzureNodePoolAutoscalingOutputReference | GoogleContainerAzureNodePoolAutoscaling): any;
export declare class GoogleContainerAzureNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureNodePoolAutoscaling | undefined;
    set internalValue(value: GoogleContainerAzureNodePoolAutoscaling | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface GoogleContainerAzureNodePoolConfigProxyConfig {
    /**
    * The ARM ID the of the resource group containing proxy keyvault. Resource group ids are formatted as `/subscriptions/<subscription-id>/resourceGroups/<resource-group-name>`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#resource_group_id GoogleContainerAzureNodePool#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * The URL the of the proxy setting secret with its version. Secret ids are formatted as `https:<key-vault-name>.vault.azure.net/secrets/<secret-name>/<secret-version>`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#secret_id GoogleContainerAzureNodePool#secret_id}
    */
    readonly secretId: string;
}
export declare function googleContainerAzureNodePoolConfigProxyConfigToTerraform(struct?: GoogleContainerAzureNodePoolConfigProxyConfigOutputReference | GoogleContainerAzureNodePoolConfigProxyConfig): any;
export declare class GoogleContainerAzureNodePoolConfigProxyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureNodePoolConfigProxyConfig | undefined;
    set internalValue(value: GoogleContainerAzureNodePoolConfigProxyConfig | undefined);
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
}
export interface GoogleContainerAzureNodePoolConfigRootVolume {
    /**
    * Optional. The size of the disk, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#size_gib GoogleContainerAzureNodePool#size_gib}
    */
    readonly sizeGib?: number;
}
export declare function googleContainerAzureNodePoolConfigRootVolumeToTerraform(struct?: GoogleContainerAzureNodePoolConfigRootVolumeOutputReference | GoogleContainerAzureNodePoolConfigRootVolume): any;
export declare class GoogleContainerAzureNodePoolConfigRootVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureNodePoolConfigRootVolume | undefined;
    set internalValue(value: GoogleContainerAzureNodePoolConfigRootVolume | undefined);
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
}
export interface GoogleContainerAzureNodePoolConfigSshConfig {
    /**
    * The SSH public key data for VMs managed by Anthos. This accepts the authorized_keys file format used in OpenSSH according to the sshd(8) manual page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#authorized_key GoogleContainerAzureNodePool#authorized_key}
    */
    readonly authorizedKey: string;
}
export declare function googleContainerAzureNodePoolConfigSshConfigToTerraform(struct?: GoogleContainerAzureNodePoolConfigSshConfigOutputReference | GoogleContainerAzureNodePoolConfigSshConfig): any;
export declare class GoogleContainerAzureNodePoolConfigSshConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureNodePoolConfigSshConfig | undefined;
    set internalValue(value: GoogleContainerAzureNodePoolConfigSshConfig | undefined);
    private _authorizedKey?;
    get authorizedKey(): string;
    set authorizedKey(value: string);
    get authorizedKeyInput(): string | undefined;
}
export interface GoogleContainerAzureNodePoolConfigA {
    /**
    * The OS image type to use on node pool instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#image_type GoogleContainerAzureNodePool#image_type}
    */
    readonly imageType?: string;
    /**
    * Optional. A set of tags to apply to all underlying Azure resources for this node pool. This currently only includes Virtual Machine Scale Sets. Specify at most 50 pairs containing alphanumerics, spaces, and symbols (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up to 255 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#tags GoogleContainerAzureNodePool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Optional. The Azure VM size name. Example: `Standard_DS2_v2`. See (/anthos/clusters/docs/azure/reference/supported-vms) for options. When unspecified, it defaults to `Standard_DS2_v2`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#vm_size GoogleContainerAzureNodePool#vm_size}
    */
    readonly vmSize?: string;
    /**
    * proxy_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#proxy_config GoogleContainerAzureNodePool#proxy_config}
    */
    readonly proxyConfig?: GoogleContainerAzureNodePoolConfigProxyConfig;
    /**
    * root_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#root_volume GoogleContainerAzureNodePool#root_volume}
    */
    readonly rootVolume?: GoogleContainerAzureNodePoolConfigRootVolume;
    /**
    * ssh_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#ssh_config GoogleContainerAzureNodePool#ssh_config}
    */
    readonly sshConfig: GoogleContainerAzureNodePoolConfigSshConfig;
}
export declare function googleContainerAzureNodePoolConfigAToTerraform(struct?: GoogleContainerAzureNodePoolConfigAOutputReference | GoogleContainerAzureNodePoolConfigA): any;
export declare class GoogleContainerAzureNodePoolConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureNodePoolConfigA | undefined;
    set internalValue(value: GoogleContainerAzureNodePoolConfigA | undefined);
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    resetVmSize(): void;
    get vmSizeInput(): string | undefined;
    private _proxyConfig;
    get proxyConfig(): GoogleContainerAzureNodePoolConfigProxyConfigOutputReference;
    putProxyConfig(value: GoogleContainerAzureNodePoolConfigProxyConfig): void;
    resetProxyConfig(): void;
    get proxyConfigInput(): GoogleContainerAzureNodePoolConfigProxyConfig | undefined;
    private _rootVolume;
    get rootVolume(): GoogleContainerAzureNodePoolConfigRootVolumeOutputReference;
    putRootVolume(value: GoogleContainerAzureNodePoolConfigRootVolume): void;
    resetRootVolume(): void;
    get rootVolumeInput(): GoogleContainerAzureNodePoolConfigRootVolume | undefined;
    private _sshConfig;
    get sshConfig(): GoogleContainerAzureNodePoolConfigSshConfigOutputReference;
    putSshConfig(value: GoogleContainerAzureNodePoolConfigSshConfig): void;
    get sshConfigInput(): GoogleContainerAzureNodePoolConfigSshConfig | undefined;
}
export interface GoogleContainerAzureNodePoolMaxPodsConstraint {
    /**
    * The maximum number of pods to schedule on a single node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#max_pods_per_node GoogleContainerAzureNodePool#max_pods_per_node}
    */
    readonly maxPodsPerNode: number;
}
export declare function googleContainerAzureNodePoolMaxPodsConstraintToTerraform(struct?: GoogleContainerAzureNodePoolMaxPodsConstraintOutputReference | GoogleContainerAzureNodePoolMaxPodsConstraint): any;
export declare class GoogleContainerAzureNodePoolMaxPodsConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureNodePoolMaxPodsConstraint | undefined;
    set internalValue(value: GoogleContainerAzureNodePoolMaxPodsConstraint | undefined);
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    get maxPodsPerNodeInput(): number | undefined;
}
export interface GoogleContainerAzureNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#create GoogleContainerAzureNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#delete GoogleContainerAzureNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool#update GoogleContainerAzureNodePool#update}
    */
    readonly update?: string;
}
export declare function googleContainerAzureNodePoolTimeoutsToTerraform(struct?: GoogleContainerAzureNodePoolTimeoutsOutputReference | GoogleContainerAzureNodePoolTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerAzureNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAzureNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool google_container_azure_node_pool}
*/
export declare class GoogleContainerAzureNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_azure_node_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_azure_node_pool google_container_azure_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerAzureNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerAzureNodePoolConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _azureAvailabilityZone?;
    get azureAvailabilityZone(): string;
    set azureAvailabilityZone(value: string);
    resetAzureAvailabilityZone(): void;
    get azureAvailabilityZoneInput(): string | undefined;
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    get createTime(): string;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _autoscaling;
    get autoscaling(): GoogleContainerAzureNodePoolAutoscalingOutputReference;
    putAutoscaling(value: GoogleContainerAzureNodePoolAutoscaling): void;
    get autoscalingInput(): GoogleContainerAzureNodePoolAutoscaling | undefined;
    private _config;
    get config(): GoogleContainerAzureNodePoolConfigAOutputReference;
    putConfig(value: GoogleContainerAzureNodePoolConfigA): void;
    get configInput(): GoogleContainerAzureNodePoolConfigA | undefined;
    private _maxPodsConstraint;
    get maxPodsConstraint(): GoogleContainerAzureNodePoolMaxPodsConstraintOutputReference;
    putMaxPodsConstraint(value: GoogleContainerAzureNodePoolMaxPodsConstraint): void;
    get maxPodsConstraintInput(): GoogleContainerAzureNodePoolMaxPodsConstraint | undefined;
    private _timeouts;
    get timeouts(): GoogleContainerAzureNodePoolTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerAzureNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerAzureNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
