import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cluster_ipv4_cidr GoogleContainerCluster#cluster_ipv4_cidr}
    */
    readonly clusterIpv4Cidr?: string;
    /**
    * The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#datapath_provider GoogleContainerCluster#datapath_provider}
    */
    readonly datapathProvider?: string;
    /**
    * The default maximum number of pods per node in this cluster. This doesn't work on "routes-based" clusters, clusters that don't have IP Aliasing enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#default_max_pods_per_node GoogleContainerCluster#default_max_pods_per_node}
    */
    readonly defaultMaxPodsPerNode?: number;
    /**
    *  Description of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#description GoogleContainerCluster#description}
    */
    readonly description?: string;
    /**
    * Enable Autopilot for this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_autopilot GoogleContainerCluster#enable_autopilot}
    */
    readonly enableAutopilot?: boolean | cdktf.IResolvable;
    /**
    * Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_binary_authorization GoogleContainerCluster#enable_binary_authorization}
    */
    readonly enableBinaryAuthorization?: boolean | cdktf.IResolvable;
    /**
    * Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_intranode_visibility GoogleContainerCluster#enable_intranode_visibility}
    */
    readonly enableIntranodeVisibility?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable Kubernetes Alpha features for this cluster. Note that when this option is enabled, the cluster cannot be upgraded and will be automatically deleted after 30 days.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_kubernetes_alpha GoogleContainerCluster#enable_kubernetes_alpha}
    */
    readonly enableKubernetesAlpha?: boolean | cdktf.IResolvable;
    /**
    * Whether L4ILB Subsetting is enabled for this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_l4_ilb_subsetting GoogleContainerCluster#enable_l4_ilb_subsetting}
    */
    readonly enableL4IlbSubsetting?: boolean | cdktf.IResolvable;
    /**
    * Whether the ABAC authorizer is enabled for this cluster. When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_legacy_abac GoogleContainerCluster#enable_legacy_abac}
    */
    readonly enableLegacyAbac?: boolean | cdktf.IResolvable;
    /**
    * Enable Shielded Nodes features on all nodes in this cluster. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_shielded_nodes GoogleContainerCluster#enable_shielded_nodes}
    */
    readonly enableShieldedNodes?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable Cloud TPU resources in this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_tpu GoogleContainerCluster#enable_tpu}
    */
    readonly enableTpu?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#id GoogleContainerCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The number of nodes to create in this cluster's default node pool. In regional or multi-zonal clusters, this is the number of nodes per zone. Must be set if node_pool is not set. If you're using google_container_node_pool objects with no default node pool, you'll need to set this to a value of at least 1, alongside setting remove_default_node_pool to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#initial_node_count GoogleContainerCluster#initial_node_count}
    */
    readonly initialNodeCount?: number;
    /**
    * The location (region or zone) in which the cluster master will be created, as well as the default node location. If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#location GoogleContainerCluster#location}
    */
    readonly location?: string;
    /**
    * The logging service that the cluster should write logs to. Available options include logging.googleapis.com(Legacy Stackdriver), logging.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Logging), and none. Defaults to logging.googleapis.com/kubernetes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#logging_service GoogleContainerCluster#logging_service}
    */
    readonly loggingService?: string;
    /**
    * The minimum version of the master. GKE will auto-update the master to new versions, so this does not guarantee the current master version--use the read-only master_version field to obtain that. If unset, the cluster's version will be set by GKE to the version of the most recent official release (which is not necessarily the latest version).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#min_master_version GoogleContainerCluster#min_master_version}
    */
    readonly minMasterVersion?: string;
    /**
    * The monitoring service that the cluster should write metrics to. Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API. VM metrics will be collected by Google Compute Engine regardless of this setting Available options include monitoring.googleapis.com(Legacy Stackdriver), monitoring.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Monitoring), and none. Defaults to monitoring.googleapis.com/kubernetes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#monitoring_service GoogleContainerCluster#monitoring_service}
    */
    readonly monitoringService?: string;
    /**
    * The name of the cluster, unique within the project and location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#name GoogleContainerCluster#name}
    */
    readonly name: string;
    /**
    * The name or self_link of the Google Compute Engine network to which the cluster is connected. For Shared VPC, set this to the self link of the shared network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#network GoogleContainerCluster#network}
    */
    readonly network?: string;
    /**
    * Determines whether alias IPs or routes will be used for pod IPs in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#networking_mode GoogleContainerCluster#networking_mode}
    */
    readonly networkingMode?: string;
    /**
    * The list of zones in which the cluster's nodes are located. Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If this is specified for a zonal cluster, omit the cluster's zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_locations GoogleContainerCluster#node_locations}
    */
    readonly nodeLocations?: string[];
    /**
    * The Kubernetes version on the nodes. Must either be unset or set to the same value as min_master_version on create. Defaults to the default version set by GKE which is not necessarily the latest version. This only affects nodes in the default node pool. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way. To update nodes in other node pools, use the version attribute on the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_version GoogleContainerCluster#node_version}
    */
    readonly nodeVersion?: string;
    /**
    * The desired state of IPv6 connectivity to Google Services. By default, no private IPv6 access to or from Google Services (all access will be via IPv4).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#private_ipv6_google_access GoogleContainerCluster#private_ipv6_google_access}
    */
    readonly privateIpv6GoogleAccess?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#project GoogleContainerCluster#project}
    */
    readonly project?: string;
    /**
    * If true, deletes the default node pool upon cluster creation. If you're using google_container_node_pool resources with no default node pool, this should be set to true, alongside setting initial_node_count to at least 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#remove_default_node_pool GoogleContainerCluster#remove_default_node_pool}
    */
    readonly removeDefaultNodePool?: boolean | cdktf.IResolvable;
    /**
    * The GCE resource labels (a map of key/value pairs) to be applied to the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#resource_labels GoogleContainerCluster#resource_labels}
    */
    readonly resourceLabels?: {
        [key: string]: string;
    };
    /**
    * The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#subnetwork GoogleContainerCluster#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * addons_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#addons_config GoogleContainerCluster#addons_config}
    */
    readonly addonsConfig?: GoogleContainerClusterAddonsConfig;
    /**
    * authenticator_groups_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#authenticator_groups_config GoogleContainerCluster#authenticator_groups_config}
    */
    readonly authenticatorGroupsConfig?: GoogleContainerClusterAuthenticatorGroupsConfig;
    /**
    * binary_authorization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#binary_authorization GoogleContainerCluster#binary_authorization}
    */
    readonly binaryAuthorization?: GoogleContainerClusterBinaryAuthorization;
    /**
    * cluster_autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cluster_autoscaling GoogleContainerCluster#cluster_autoscaling}
    */
    readonly clusterAutoscaling?: GoogleContainerClusterClusterAutoscaling;
    /**
    * cluster_telemetry block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cluster_telemetry GoogleContainerCluster#cluster_telemetry}
    */
    readonly clusterTelemetry?: GoogleContainerClusterClusterTelemetry;
    /**
    * confidential_nodes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#confidential_nodes GoogleContainerCluster#confidential_nodes}
    */
    readonly confidentialNodes?: GoogleContainerClusterConfidentialNodes;
    /**
    * cost_management_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cost_management_config GoogleContainerCluster#cost_management_config}
    */
    readonly costManagementConfig?: GoogleContainerClusterCostManagementConfig;
    /**
    * database_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#database_encryption GoogleContainerCluster#database_encryption}
    */
    readonly databaseEncryption?: GoogleContainerClusterDatabaseEncryption;
    /**
    * default_snat_status block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#default_snat_status GoogleContainerCluster#default_snat_status}
    */
    readonly defaultSnatStatus?: GoogleContainerClusterDefaultSnatStatus;
    /**
    * dns_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#dns_config GoogleContainerCluster#dns_config}
    */
    readonly dnsConfig?: GoogleContainerClusterDnsConfig;
    /**
    * identity_service_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#identity_service_config GoogleContainerCluster#identity_service_config}
    */
    readonly identityServiceConfig?: GoogleContainerClusterIdentityServiceConfig;
    /**
    * ip_allocation_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#ip_allocation_policy GoogleContainerCluster#ip_allocation_policy}
    */
    readonly ipAllocationPolicy?: GoogleContainerClusterIpAllocationPolicy;
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#logging_config GoogleContainerCluster#logging_config}
    */
    readonly loggingConfig?: GoogleContainerClusterLoggingConfig;
    /**
    * maintenance_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#maintenance_policy GoogleContainerCluster#maintenance_policy}
    */
    readonly maintenancePolicy?: GoogleContainerClusterMaintenancePolicy;
    /**
    * master_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#master_auth GoogleContainerCluster#master_auth}
    */
    readonly masterAuth?: GoogleContainerClusterMasterAuth;
    /**
    * master_authorized_networks_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#master_authorized_networks_config GoogleContainerCluster#master_authorized_networks_config}
    */
    readonly masterAuthorizedNetworksConfig?: GoogleContainerClusterMasterAuthorizedNetworksConfig;
    /**
    * mesh_certificates block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#mesh_certificates GoogleContainerCluster#mesh_certificates}
    */
    readonly meshCertificates?: GoogleContainerClusterMeshCertificates;
    /**
    * monitoring_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#monitoring_config GoogleContainerCluster#monitoring_config}
    */
    readonly monitoringConfig?: GoogleContainerClusterMonitoringConfig;
    /**
    * network_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#network_policy GoogleContainerCluster#network_policy}
    */
    readonly networkPolicy?: GoogleContainerClusterNetworkPolicy;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_config GoogleContainerCluster#node_config}
    */
    readonly nodeConfig?: GoogleContainerClusterNodeConfig;
    /**
    * node_pool block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_pool GoogleContainerCluster#node_pool}
    */
    readonly nodePool?: GoogleContainerClusterNodePool[] | cdktf.IResolvable;
    /**
    * node_pool_auto_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_pool_auto_config GoogleContainerCluster#node_pool_auto_config}
    */
    readonly nodePoolAutoConfig?: GoogleContainerClusterNodePoolAutoConfig;
    /**
    * node_pool_defaults block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_pool_defaults GoogleContainerCluster#node_pool_defaults}
    */
    readonly nodePoolDefaults?: GoogleContainerClusterNodePoolDefaults;
    /**
    * notification_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#notification_config GoogleContainerCluster#notification_config}
    */
    readonly notificationConfig?: GoogleContainerClusterNotificationConfig;
    /**
    * pod_security_policy_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#pod_security_policy_config GoogleContainerCluster#pod_security_policy_config}
    */
    readonly podSecurityPolicyConfig?: GoogleContainerClusterPodSecurityPolicyConfig;
    /**
    * private_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#private_cluster_config GoogleContainerCluster#private_cluster_config}
    */
    readonly privateClusterConfig?: GoogleContainerClusterPrivateClusterConfig;
    /**
    * release_channel block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#release_channel GoogleContainerCluster#release_channel}
    */
    readonly releaseChannel?: GoogleContainerClusterReleaseChannel;
    /**
    * resource_usage_export_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#resource_usage_export_config GoogleContainerCluster#resource_usage_export_config}
    */
    readonly resourceUsageExportConfig?: GoogleContainerClusterResourceUsageExportConfig;
    /**
    * service_external_ips_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#service_external_ips_config GoogleContainerCluster#service_external_ips_config}
    */
    readonly serviceExternalIpsConfig?: GoogleContainerClusterServiceExternalIpsConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#timeouts GoogleContainerCluster#timeouts}
    */
    readonly timeouts?: GoogleContainerClusterTimeouts;
    /**
    * tpu_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#tpu_config GoogleContainerCluster#tpu_config}
    */
    readonly tpuConfig?: GoogleContainerClusterTpuConfig;
    /**
    * vertical_pod_autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#vertical_pod_autoscaling GoogleContainerCluster#vertical_pod_autoscaling}
    */
    readonly verticalPodAutoscaling?: GoogleContainerClusterVerticalPodAutoscaling;
    /**
    * workload_identity_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#workload_identity_config GoogleContainerCluster#workload_identity_config}
    */
    readonly workloadIdentityConfig?: GoogleContainerClusterWorkloadIdentityConfig;
}
export interface GoogleContainerClusterAddonsConfigCloudrunConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#load_balancer_type GoogleContainerCluster#load_balancer_type}
    */
    readonly loadBalancerType?: string;
}
export declare function googleContainerClusterAddonsConfigCloudrunConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference | GoogleContainerClusterAddonsConfigCloudrunConfig): any;
export declare class GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigCloudrunConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigCloudrunConfig | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _loadBalancerType?;
    get loadBalancerType(): string;
    set loadBalancerType(value: string);
    resetLoadBalancerType(): void;
    get loadBalancerTypeInput(): string | undefined;
}
export interface GoogleContainerClusterAddonsConfigConfigConnectorConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigConfigConnectorConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference | GoogleContainerClusterAddonsConfigConfigConnectorConfig): any;
export declare class GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigConfigConnectorConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigConfigConnectorConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigDnsCacheConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigDnsCacheConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference | GoogleContainerClusterAddonsConfigDnsCacheConfig): any;
export declare class GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigDnsCacheConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigDnsCacheConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference | GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig): any;
export declare class GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference | GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig): any;
export declare class GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigGkeBackupAgentConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigGkeBackupAgentConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference | GoogleContainerClusterAddonsConfigGkeBackupAgentConfig): any;
export declare class GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigGkeBackupAgentConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigHorizontalPodAutoscalingToTerraform(struct?: GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference | GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling): any;
export declare class GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigHttpLoadBalancing {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigHttpLoadBalancingToTerraform(struct?: GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference | GoogleContainerClusterAddonsConfigHttpLoadBalancing): any;
export declare class GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigHttpLoadBalancing | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigHttpLoadBalancing | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigIstioConfig {
    /**
    * The authentication type between services in Istio. Available options include AUTH_MUTUAL_TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#auth GoogleContainerCluster#auth}
    */
    readonly auth?: string;
    /**
    * The status of the Istio addon, which makes it easy to set up Istio for services in a cluster. It is disabled by default. Set disabled = false to enable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigIstioConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigIstioConfigOutputReference | GoogleContainerClusterAddonsConfigIstioConfig): any;
export declare class GoogleContainerClusterAddonsConfigIstioConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigIstioConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigIstioConfig | undefined);
    private _auth?;
    get auth(): string;
    set auth(value: string);
    resetAuth(): void;
    get authInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigKalmConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigKalmConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigKalmConfigOutputReference | GoogleContainerClusterAddonsConfigKalmConfig): any;
export declare class GoogleContainerClusterAddonsConfigKalmConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigKalmConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigKalmConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigNetworkPolicyConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigNetworkPolicyConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference | GoogleContainerClusterAddonsConfigNetworkPolicyConfig): any;
export declare class GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigNetworkPolicyConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigNetworkPolicyConfig | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfig {
    /**
    * cloudrun_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cloudrun_config GoogleContainerCluster#cloudrun_config}
    */
    readonly cloudrunConfig?: GoogleContainerClusterAddonsConfigCloudrunConfig;
    /**
    * config_connector_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#config_connector_config GoogleContainerCluster#config_connector_config}
    */
    readonly configConnectorConfig?: GoogleContainerClusterAddonsConfigConfigConnectorConfig;
    /**
    * dns_cache_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#dns_cache_config GoogleContainerCluster#dns_cache_config}
    */
    readonly dnsCacheConfig?: GoogleContainerClusterAddonsConfigDnsCacheConfig;
    /**
    * gce_persistent_disk_csi_driver_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#gce_persistent_disk_csi_driver_config GoogleContainerCluster#gce_persistent_disk_csi_driver_config}
    */
    readonly gcePersistentDiskCsiDriverConfig?: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig;
    /**
    * gcp_filestore_csi_driver_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#gcp_filestore_csi_driver_config GoogleContainerCluster#gcp_filestore_csi_driver_config}
    */
    readonly gcpFilestoreCsiDriverConfig?: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig;
    /**
    * gke_backup_agent_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#gke_backup_agent_config GoogleContainerCluster#gke_backup_agent_config}
    */
    readonly gkeBackupAgentConfig?: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig;
    /**
    * horizontal_pod_autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#horizontal_pod_autoscaling GoogleContainerCluster#horizontal_pod_autoscaling}
    */
    readonly horizontalPodAutoscaling?: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling;
    /**
    * http_load_balancing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#http_load_balancing GoogleContainerCluster#http_load_balancing}
    */
    readonly httpLoadBalancing?: GoogleContainerClusterAddonsConfigHttpLoadBalancing;
    /**
    * istio_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#istio_config GoogleContainerCluster#istio_config}
    */
    readonly istioConfig?: GoogleContainerClusterAddonsConfigIstioConfig;
    /**
    * kalm_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#kalm_config GoogleContainerCluster#kalm_config}
    */
    readonly kalmConfig?: GoogleContainerClusterAddonsConfigKalmConfig;
    /**
    * network_policy_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#network_policy_config GoogleContainerCluster#network_policy_config}
    */
    readonly networkPolicyConfig?: GoogleContainerClusterAddonsConfigNetworkPolicyConfig;
}
export declare function googleContainerClusterAddonsConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigOutputReference | GoogleContainerClusterAddonsConfig): any;
export declare class GoogleContainerClusterAddonsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfig | undefined);
    private _cloudrunConfig;
    get cloudrunConfig(): GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference;
    putCloudrunConfig(value: GoogleContainerClusterAddonsConfigCloudrunConfig): void;
    resetCloudrunConfig(): void;
    get cloudrunConfigInput(): GoogleContainerClusterAddonsConfigCloudrunConfig | undefined;
    private _configConnectorConfig;
    get configConnectorConfig(): GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference;
    putConfigConnectorConfig(value: GoogleContainerClusterAddonsConfigConfigConnectorConfig): void;
    resetConfigConnectorConfig(): void;
    get configConnectorConfigInput(): GoogleContainerClusterAddonsConfigConfigConnectorConfig | undefined;
    private _dnsCacheConfig;
    get dnsCacheConfig(): GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference;
    putDnsCacheConfig(value: GoogleContainerClusterAddonsConfigDnsCacheConfig): void;
    resetDnsCacheConfig(): void;
    get dnsCacheConfigInput(): GoogleContainerClusterAddonsConfigDnsCacheConfig | undefined;
    private _gcePersistentDiskCsiDriverConfig;
    get gcePersistentDiskCsiDriverConfig(): GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference;
    putGcePersistentDiskCsiDriverConfig(value: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig): void;
    resetGcePersistentDiskCsiDriverConfig(): void;
    get gcePersistentDiskCsiDriverConfigInput(): GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig | undefined;
    private _gcpFilestoreCsiDriverConfig;
    get gcpFilestoreCsiDriverConfig(): GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference;
    putGcpFilestoreCsiDriverConfig(value: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig): void;
    resetGcpFilestoreCsiDriverConfig(): void;
    get gcpFilestoreCsiDriverConfigInput(): GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig | undefined;
    private _gkeBackupAgentConfig;
    get gkeBackupAgentConfig(): GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference;
    putGkeBackupAgentConfig(value: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig): void;
    resetGkeBackupAgentConfig(): void;
    get gkeBackupAgentConfigInput(): GoogleContainerClusterAddonsConfigGkeBackupAgentConfig | undefined;
    private _horizontalPodAutoscaling;
    get horizontalPodAutoscaling(): GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference;
    putHorizontalPodAutoscaling(value: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling): void;
    resetHorizontalPodAutoscaling(): void;
    get horizontalPodAutoscalingInput(): GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined;
    private _httpLoadBalancing;
    get httpLoadBalancing(): GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference;
    putHttpLoadBalancing(value: GoogleContainerClusterAddonsConfigHttpLoadBalancing): void;
    resetHttpLoadBalancing(): void;
    get httpLoadBalancingInput(): GoogleContainerClusterAddonsConfigHttpLoadBalancing | undefined;
    private _istioConfig;
    get istioConfig(): GoogleContainerClusterAddonsConfigIstioConfigOutputReference;
    putIstioConfig(value: GoogleContainerClusterAddonsConfigIstioConfig): void;
    resetIstioConfig(): void;
    get istioConfigInput(): GoogleContainerClusterAddonsConfigIstioConfig | undefined;
    private _kalmConfig;
    get kalmConfig(): GoogleContainerClusterAddonsConfigKalmConfigOutputReference;
    putKalmConfig(value: GoogleContainerClusterAddonsConfigKalmConfig): void;
    resetKalmConfig(): void;
    get kalmConfigInput(): GoogleContainerClusterAddonsConfigKalmConfig | undefined;
    private _networkPolicyConfig;
    get networkPolicyConfig(): GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference;
    putNetworkPolicyConfig(value: GoogleContainerClusterAddonsConfigNetworkPolicyConfig): void;
    resetNetworkPolicyConfig(): void;
    get networkPolicyConfigInput(): GoogleContainerClusterAddonsConfigNetworkPolicyConfig | undefined;
}
export interface GoogleContainerClusterAuthenticatorGroupsConfig {
    /**
    * The name of the RBAC security group for use with Google security groups in Kubernetes RBAC. Group name must be in format gke-security-groups@yourdomain.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#security_group GoogleContainerCluster#security_group}
    */
    readonly securityGroup: string;
}
export declare function googleContainerClusterAuthenticatorGroupsConfigToTerraform(struct?: GoogleContainerClusterAuthenticatorGroupsConfigOutputReference | GoogleContainerClusterAuthenticatorGroupsConfig): any;
export declare class GoogleContainerClusterAuthenticatorGroupsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAuthenticatorGroupsConfig | undefined;
    set internalValue(value: GoogleContainerClusterAuthenticatorGroupsConfig | undefined);
    private _securityGroup?;
    get securityGroup(): string;
    set securityGroup(value: string);
    get securityGroupInput(): string | undefined;
}
export interface GoogleContainerClusterBinaryAuthorization {
    /**
    * Enable Binary Authorization for this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Mode of operation for Binary Authorization policy evaluation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#evaluation_mode GoogleContainerCluster#evaluation_mode}
    */
    readonly evaluationMode?: string;
}
export declare function googleContainerClusterBinaryAuthorizationToTerraform(struct?: GoogleContainerClusterBinaryAuthorizationOutputReference | GoogleContainerClusterBinaryAuthorization): any;
export declare class GoogleContainerClusterBinaryAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterBinaryAuthorization | undefined;
    set internalValue(value: GoogleContainerClusterBinaryAuthorization | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evaluationMode?;
    get evaluationMode(): string;
    set evaluationMode(value: string);
    resetEvaluationMode(): void;
    get evaluationModeInput(): string | undefined;
}
export interface GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#boot_disk_kms_key GoogleContainerCluster#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * The default image type used by NAP once a new node pool is being created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#image_type GoogleContainerCluster#image_type}
    */
    readonly imageType?: string;
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as Intel Haswell.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#min_cpu_platform GoogleContainerCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Scopes that are used by NAP when creating node pools.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#oauth_scopes GoogleContainerCluster#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#service_account GoogleContainerCluster#service_account}
    */
    readonly serviceAccount?: string;
}
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsToTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults): any;
export declare class GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
}
export interface GoogleContainerClusterClusterAutoscalingResourceLimits {
    /**
    * Maximum amount of the resource in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#maximum GoogleContainerCluster#maximum}
    */
    readonly maximum?: number;
    /**
    * Minimum amount of the resource in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#minimum GoogleContainerCluster#minimum}
    */
    readonly minimum?: number;
    /**
    * The type of the resource. For example, cpu and memory. See the guide to using Node Auto-Provisioning for a list of types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#resource_type GoogleContainerCluster#resource_type}
    */
    readonly resourceType: string;
}
export declare function googleContainerClusterClusterAutoscalingResourceLimitsToTerraform(struct?: GoogleContainerClusterClusterAutoscalingResourceLimits | cdktf.IResolvable): any;
export declare class GoogleContainerClusterClusterAutoscalingResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterClusterAutoscalingResourceLimits | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscalingResourceLimits | cdktf.IResolvable | undefined);
    private _maximum?;
    get maximum(): number;
    set maximum(value: number);
    resetMaximum(): void;
    get maximumInput(): number | undefined;
    private _minimum?;
    get minimum(): number;
    set minimum(value: number);
    resetMinimum(): void;
    get minimumInput(): number | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    get resourceTypeInput(): string | undefined;
}
export declare class GoogleContainerClusterClusterAutoscalingResourceLimitsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterClusterAutoscalingResourceLimits[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterClusterAutoscalingResourceLimitsOutputReference;
}
export interface GoogleContainerClusterClusterAutoscaling {
    /**
    * Configuration options for the Autoscaling profile feature, which lets you choose whether the cluster autoscaler should optimize for resource utilization or resource availability when deciding to remove nodes from a cluster. Can be BALANCED or OPTIMIZE_UTILIZATION. Defaults to BALANCED.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#autoscaling_profile GoogleContainerCluster#autoscaling_profile}
    */
    readonly autoscalingProfile?: string;
    /**
    * Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * auto_provisioning_defaults block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#auto_provisioning_defaults GoogleContainerCluster#auto_provisioning_defaults}
    */
    readonly autoProvisioningDefaults?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#resource_limits GoogleContainerCluster#resource_limits}
    */
    readonly resourceLimits?: GoogleContainerClusterClusterAutoscalingResourceLimits[] | cdktf.IResolvable;
}
export declare function googleContainerClusterClusterAutoscalingToTerraform(struct?: GoogleContainerClusterClusterAutoscalingOutputReference | GoogleContainerClusterClusterAutoscaling): any;
export declare class GoogleContainerClusterClusterAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterAutoscaling | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscaling | undefined);
    private _autoscalingProfile?;
    get autoscalingProfile(): string;
    set autoscalingProfile(value: string);
    resetAutoscalingProfile(): void;
    get autoscalingProfileInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoProvisioningDefaults;
    get autoProvisioningDefaults(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference;
    putAutoProvisioningDefaults(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults): void;
    resetAutoProvisioningDefaults(): void;
    get autoProvisioningDefaultsInput(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined;
    private _resourceLimits;
    get resourceLimits(): GoogleContainerClusterClusterAutoscalingResourceLimitsList;
    putResourceLimits(value: GoogleContainerClusterClusterAutoscalingResourceLimits[] | cdktf.IResolvable): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): cdktf.IResolvable | GoogleContainerClusterClusterAutoscalingResourceLimits[] | undefined;
}
export interface GoogleContainerClusterClusterTelemetry {
    /**
    * Type of the integration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#type GoogleContainerCluster#type}
    */
    readonly type: string;
}
export declare function googleContainerClusterClusterTelemetryToTerraform(struct?: GoogleContainerClusterClusterTelemetryOutputReference | GoogleContainerClusterClusterTelemetry): any;
export declare class GoogleContainerClusterClusterTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterTelemetry | undefined;
    set internalValue(value: GoogleContainerClusterClusterTelemetry | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleContainerClusterConfidentialNodes {
    /**
    * Whether Confidential Nodes feature is enabled for all nodes in this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterConfidentialNodesToTerraform(struct?: GoogleContainerClusterConfidentialNodesOutputReference | GoogleContainerClusterConfidentialNodes): any;
export declare class GoogleContainerClusterConfidentialNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterConfidentialNodes | undefined;
    set internalValue(value: GoogleContainerClusterConfidentialNodes | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterCostManagementConfig {
    /**
    * Whether to enable GKE cost allocation. When you enable GKE cost allocation, the cluster name and namespace of your GKE workloads appear in the labels field of the billing export to BigQuery. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterCostManagementConfigToTerraform(struct?: GoogleContainerClusterCostManagementConfigOutputReference | GoogleContainerClusterCostManagementConfig): any;
export declare class GoogleContainerClusterCostManagementConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterCostManagementConfig | undefined;
    set internalValue(value: GoogleContainerClusterCostManagementConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterDatabaseEncryption {
    /**
    * The key to use to encrypt/decrypt secrets.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#key_name GoogleContainerCluster#key_name}
    */
    readonly keyName?: string;
    /**
    * ENCRYPTED or DECRYPTED.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#state GoogleContainerCluster#state}
    */
    readonly state: string;
}
export declare function googleContainerClusterDatabaseEncryptionToTerraform(struct?: GoogleContainerClusterDatabaseEncryptionOutputReference | GoogleContainerClusterDatabaseEncryption): any;
export declare class GoogleContainerClusterDatabaseEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterDatabaseEncryption | undefined;
    set internalValue(value: GoogleContainerClusterDatabaseEncryption | undefined);
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    resetKeyName(): void;
    get keyNameInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
}
export interface GoogleContainerClusterDefaultSnatStatus {
    /**
    * When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterDefaultSnatStatusToTerraform(struct?: GoogleContainerClusterDefaultSnatStatusOutputReference | GoogleContainerClusterDefaultSnatStatus): any;
export declare class GoogleContainerClusterDefaultSnatStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterDefaultSnatStatus | undefined;
    set internalValue(value: GoogleContainerClusterDefaultSnatStatus | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterDnsConfig {
    /**
    * Which in-cluster DNS provider should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cluster_dns GoogleContainerCluster#cluster_dns}
    */
    readonly clusterDns?: string;
    /**
    * The suffix used for all cluster service records.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cluster_dns_domain GoogleContainerCluster#cluster_dns_domain}
    */
    readonly clusterDnsDomain?: string;
    /**
    * The scope of access to cluster DNS records.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cluster_dns_scope GoogleContainerCluster#cluster_dns_scope}
    */
    readonly clusterDnsScope?: string;
}
export declare function googleContainerClusterDnsConfigToTerraform(struct?: GoogleContainerClusterDnsConfigOutputReference | GoogleContainerClusterDnsConfig): any;
export declare class GoogleContainerClusterDnsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterDnsConfig | undefined;
    set internalValue(value: GoogleContainerClusterDnsConfig | undefined);
    private _clusterDns?;
    get clusterDns(): string;
    set clusterDns(value: string);
    resetClusterDns(): void;
    get clusterDnsInput(): string | undefined;
    private _clusterDnsDomain?;
    get clusterDnsDomain(): string;
    set clusterDnsDomain(value: string);
    resetClusterDnsDomain(): void;
    get clusterDnsDomainInput(): string | undefined;
    private _clusterDnsScope?;
    get clusterDnsScope(): string;
    set clusterDnsScope(value: string);
    resetClusterDnsScope(): void;
    get clusterDnsScopeInput(): string | undefined;
}
export interface GoogleContainerClusterIdentityServiceConfig {
    /**
    * Whether to enable the Identity Service component.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterIdentityServiceConfigToTerraform(struct?: GoogleContainerClusterIdentityServiceConfigOutputReference | GoogleContainerClusterIdentityServiceConfig): any;
export declare class GoogleContainerClusterIdentityServiceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterIdentityServiceConfig | undefined;
    set internalValue(value: GoogleContainerClusterIdentityServiceConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterIpAllocationPolicy {
    /**
    * The IP address range for the cluster pod IPs. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cluster_ipv4_cidr_block GoogleContainerCluster#cluster_ipv4_cidr_block}
    */
    readonly clusterIpv4CidrBlock?: string;
    /**
    * The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses. Alternatively, cluster_ipv4_cidr_block can be used to automatically create a GKE-managed one.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cluster_secondary_range_name GoogleContainerCluster#cluster_secondary_range_name}
    */
    readonly clusterSecondaryRangeName?: string;
    /**
    * The IP address range of the services IPs in this cluster. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#services_ipv4_cidr_block GoogleContainerCluster#services_ipv4_cidr_block}
    */
    readonly servicesIpv4CidrBlock?: string;
    /**
    * The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs. Alternatively, services_ipv4_cidr_block can be used to automatically create a GKE-managed one.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#services_secondary_range_name GoogleContainerCluster#services_secondary_range_name}
    */
    readonly servicesSecondaryRangeName?: string;
}
export declare function googleContainerClusterIpAllocationPolicyToTerraform(struct?: GoogleContainerClusterIpAllocationPolicyOutputReference | GoogleContainerClusterIpAllocationPolicy): any;
export declare class GoogleContainerClusterIpAllocationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterIpAllocationPolicy | undefined;
    set internalValue(value: GoogleContainerClusterIpAllocationPolicy | undefined);
    private _clusterIpv4CidrBlock?;
    get clusterIpv4CidrBlock(): string;
    set clusterIpv4CidrBlock(value: string);
    resetClusterIpv4CidrBlock(): void;
    get clusterIpv4CidrBlockInput(): string | undefined;
    private _clusterSecondaryRangeName?;
    get clusterSecondaryRangeName(): string;
    set clusterSecondaryRangeName(value: string);
    resetClusterSecondaryRangeName(): void;
    get clusterSecondaryRangeNameInput(): string | undefined;
    private _servicesIpv4CidrBlock?;
    get servicesIpv4CidrBlock(): string;
    set servicesIpv4CidrBlock(value: string);
    resetServicesIpv4CidrBlock(): void;
    get servicesIpv4CidrBlockInput(): string | undefined;
    private _servicesSecondaryRangeName?;
    get servicesSecondaryRangeName(): string;
    set servicesSecondaryRangeName(value: string);
    resetServicesSecondaryRangeName(): void;
    get servicesSecondaryRangeNameInput(): string | undefined;
}
export interface GoogleContainerClusterLoggingConfig {
    /**
    * GKE components exposing logs. Valid values include SYSTEM_COMPONENTS and WORKLOADS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_components GoogleContainerCluster#enable_components}
    */
    readonly enableComponents: string[];
}
export declare function googleContainerClusterLoggingConfigToTerraform(struct?: GoogleContainerClusterLoggingConfigOutputReference | GoogleContainerClusterLoggingConfig): any;
export declare class GoogleContainerClusterLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterLoggingConfig | undefined;
    set internalValue(value: GoogleContainerClusterLoggingConfig | undefined);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    get enableComponentsInput(): string[] | undefined;
}
export interface GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#start_time GoogleContainerCluster#start_time}
    */
    readonly startTime: string;
}
export declare function googleContainerClusterMaintenancePolicyDailyMaintenanceWindowToTerraform(struct?: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference | GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow): any;
export declare class GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined;
    set internalValue(value: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined);
    get duration(): string;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions {
    /**
    * The scope of automatic upgrades to restrict in the exclusion window.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#scope GoogleContainerCluster#scope}
    */
    readonly scope: string;
}
export declare function googleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsToTerraform(struct?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsOutputReference | GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions): any;
export declare class GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions | undefined;
    set internalValue(value: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions | undefined);
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
}
export interface GoogleContainerClusterMaintenancePolicyMaintenanceExclusion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#end_time GoogleContainerCluster#end_time}
    */
    readonly endTime: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#exclusion_name GoogleContainerCluster#exclusion_name}
    */
    readonly exclusionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#start_time GoogleContainerCluster#start_time}
    */
    readonly startTime: string;
    /**
    * exclusion_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#exclusion_options GoogleContainerCluster#exclusion_options}
    */
    readonly exclusionOptions?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions;
}
export declare function googleContainerClusterMaintenancePolicyMaintenanceExclusionToTerraform(struct?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion | cdktf.IResolvable): any;
export declare class GoogleContainerClusterMaintenancePolicyMaintenanceExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterMaintenancePolicyMaintenanceExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion | cdktf.IResolvable | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    get endTimeInput(): string | undefined;
    private _exclusionName?;
    get exclusionName(): string;
    set exclusionName(value: string);
    get exclusionNameInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
    private _exclusionOptions;
    get exclusionOptions(): GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsOutputReference;
    putExclusionOptions(value: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions): void;
    resetExclusionOptions(): void;
    get exclusionOptionsInput(): GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions | undefined;
}
export declare class GoogleContainerClusterMaintenancePolicyMaintenanceExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterMaintenancePolicyMaintenanceExclusionOutputReference;
}
export interface GoogleContainerClusterMaintenancePolicyRecurringWindow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#end_time GoogleContainerCluster#end_time}
    */
    readonly endTime: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#recurrence GoogleContainerCluster#recurrence}
    */
    readonly recurrence: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#start_time GoogleContainerCluster#start_time}
    */
    readonly startTime: string;
}
export declare function googleContainerClusterMaintenancePolicyRecurringWindowToTerraform(struct?: GoogleContainerClusterMaintenancePolicyRecurringWindowOutputReference | GoogleContainerClusterMaintenancePolicyRecurringWindow): any;
export declare class GoogleContainerClusterMaintenancePolicyRecurringWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMaintenancePolicyRecurringWindow | undefined;
    set internalValue(value: GoogleContainerClusterMaintenancePolicyRecurringWindow | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    get endTimeInput(): string | undefined;
    private _recurrence?;
    get recurrence(): string;
    set recurrence(value: string);
    get recurrenceInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface GoogleContainerClusterMaintenancePolicy {
    /**
    * daily_maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#daily_maintenance_window GoogleContainerCluster#daily_maintenance_window}
    */
    readonly dailyMaintenanceWindow?: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow;
    /**
    * maintenance_exclusion block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#maintenance_exclusion GoogleContainerCluster#maintenance_exclusion}
    */
    readonly maintenanceExclusion?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion[] | cdktf.IResolvable;
    /**
    * recurring_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#recurring_window GoogleContainerCluster#recurring_window}
    */
    readonly recurringWindow?: GoogleContainerClusterMaintenancePolicyRecurringWindow;
}
export declare function googleContainerClusterMaintenancePolicyToTerraform(struct?: GoogleContainerClusterMaintenancePolicyOutputReference | GoogleContainerClusterMaintenancePolicy): any;
export declare class GoogleContainerClusterMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMaintenancePolicy | undefined;
    set internalValue(value: GoogleContainerClusterMaintenancePolicy | undefined);
    private _dailyMaintenanceWindow;
    get dailyMaintenanceWindow(): GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference;
    putDailyMaintenanceWindow(value: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow): void;
    resetDailyMaintenanceWindow(): void;
    get dailyMaintenanceWindowInput(): GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined;
    private _maintenanceExclusion;
    get maintenanceExclusion(): GoogleContainerClusterMaintenancePolicyMaintenanceExclusionList;
    putMaintenanceExclusion(value: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion[] | cdktf.IResolvable): void;
    resetMaintenanceExclusion(): void;
    get maintenanceExclusionInput(): cdktf.IResolvable | GoogleContainerClusterMaintenancePolicyMaintenanceExclusion[] | undefined;
    private _recurringWindow;
    get recurringWindow(): GoogleContainerClusterMaintenancePolicyRecurringWindowOutputReference;
    putRecurringWindow(value: GoogleContainerClusterMaintenancePolicyRecurringWindow): void;
    resetRecurringWindow(): void;
    get recurringWindowInput(): GoogleContainerClusterMaintenancePolicyRecurringWindow | undefined;
}
export interface GoogleContainerClusterMasterAuthClientCertificateConfig {
    /**
    * Whether client certificate authorization is enabled for this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#issue_client_certificate GoogleContainerCluster#issue_client_certificate}
    */
    readonly issueClientCertificate: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterMasterAuthClientCertificateConfigToTerraform(struct?: GoogleContainerClusterMasterAuthClientCertificateConfigOutputReference | GoogleContainerClusterMasterAuthClientCertificateConfig): any;
export declare class GoogleContainerClusterMasterAuthClientCertificateConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMasterAuthClientCertificateConfig | undefined;
    set internalValue(value: GoogleContainerClusterMasterAuthClientCertificateConfig | undefined);
    private _issueClientCertificate?;
    get issueClientCertificate(): boolean | cdktf.IResolvable;
    set issueClientCertificate(value: boolean | cdktf.IResolvable);
    get issueClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterMasterAuth {
    /**
    * client_certificate_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#client_certificate_config GoogleContainerCluster#client_certificate_config}
    */
    readonly clientCertificateConfig: GoogleContainerClusterMasterAuthClientCertificateConfig;
}
export declare function googleContainerClusterMasterAuthToTerraform(struct?: GoogleContainerClusterMasterAuthOutputReference | GoogleContainerClusterMasterAuth): any;
export declare class GoogleContainerClusterMasterAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMasterAuth | undefined;
    set internalValue(value: GoogleContainerClusterMasterAuth | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    private _clientCertificateConfig;
    get clientCertificateConfig(): GoogleContainerClusterMasterAuthClientCertificateConfigOutputReference;
    putClientCertificateConfig(value: GoogleContainerClusterMasterAuthClientCertificateConfig): void;
    get clientCertificateConfigInput(): GoogleContainerClusterMasterAuthClientCertificateConfig | undefined;
}
export interface GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks {
    /**
    * External network that can access Kubernetes master through HTTPS. Must be specified in CIDR notation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cidr_block GoogleContainerCluster#cidr_block}
    */
    readonly cidrBlock: string;
    /**
    * Field for users to identify CIDR blocks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#display_name GoogleContainerCluster#display_name}
    */
    readonly displayName?: string;
}
export declare function googleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksToTerraform(struct?: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable): any;
export declare class GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable | undefined);
    private _cidrBlock?;
    get cidrBlock(): string;
    set cidrBlock(value: string);
    get cidrBlockInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
}
export declare class GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksOutputReference;
}
export interface GoogleContainerClusterMasterAuthorizedNetworksConfig {
    /**
    * cidr_blocks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cidr_blocks GoogleContainerCluster#cidr_blocks}
    */
    readonly cidrBlocks?: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable;
}
export declare function googleContainerClusterMasterAuthorizedNetworksConfigToTerraform(struct?: GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference | GoogleContainerClusterMasterAuthorizedNetworksConfig): any;
export declare class GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMasterAuthorizedNetworksConfig | undefined;
    set internalValue(value: GoogleContainerClusterMasterAuthorizedNetworksConfig | undefined);
    private _cidrBlocks;
    get cidrBlocks(): GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksList;
    putCidrBlocks(value: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable): void;
    resetCidrBlocks(): void;
    get cidrBlocksInput(): cdktf.IResolvable | GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | undefined;
}
export interface GoogleContainerClusterMeshCertificates {
    /**
    * When enabled the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_certificates GoogleContainerCluster#enable_certificates}
    */
    readonly enableCertificates: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterMeshCertificatesToTerraform(struct?: GoogleContainerClusterMeshCertificatesOutputReference | GoogleContainerClusterMeshCertificates): any;
export declare class GoogleContainerClusterMeshCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMeshCertificates | undefined;
    set internalValue(value: GoogleContainerClusterMeshCertificates | undefined);
    private _enableCertificates?;
    get enableCertificates(): boolean | cdktf.IResolvable;
    set enableCertificates(value: boolean | cdktf.IResolvable);
    get enableCertificatesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterMonitoringConfigManagedPrometheus {
    /**
    * Whether or not the managed collection is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterMonitoringConfigManagedPrometheusToTerraform(struct?: GoogleContainerClusterMonitoringConfigManagedPrometheusOutputReference | GoogleContainerClusterMonitoringConfigManagedPrometheus): any;
export declare class GoogleContainerClusterMonitoringConfigManagedPrometheusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMonitoringConfigManagedPrometheus | undefined;
    set internalValue(value: GoogleContainerClusterMonitoringConfigManagedPrometheus | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterMonitoringConfig {
    /**
    * GKE components exposing metrics. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, SCHEDULER, and WORKLOADS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_components GoogleContainerCluster#enable_components}
    */
    readonly enableComponents?: string[];
    /**
    * managed_prometheus block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#managed_prometheus GoogleContainerCluster#managed_prometheus}
    */
    readonly managedPrometheus?: GoogleContainerClusterMonitoringConfigManagedPrometheus;
}
export declare function googleContainerClusterMonitoringConfigToTerraform(struct?: GoogleContainerClusterMonitoringConfigOutputReference | GoogleContainerClusterMonitoringConfig): any;
export declare class GoogleContainerClusterMonitoringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMonitoringConfig | undefined;
    set internalValue(value: GoogleContainerClusterMonitoringConfig | undefined);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    resetEnableComponents(): void;
    get enableComponentsInput(): string[] | undefined;
    private _managedPrometheus;
    get managedPrometheus(): GoogleContainerClusterMonitoringConfigManagedPrometheusOutputReference;
    putManagedPrometheus(value: GoogleContainerClusterMonitoringConfigManagedPrometheus): void;
    resetManagedPrometheus(): void;
    get managedPrometheusInput(): GoogleContainerClusterMonitoringConfigManagedPrometheus | undefined;
}
export interface GoogleContainerClusterNetworkPolicy {
    /**
    * Whether network policy is enabled on the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#provider GoogleContainerCluster#provider}
    */
    readonly provider?: string;
}
export declare function googleContainerClusterNetworkPolicyToTerraform(struct?: GoogleContainerClusterNetworkPolicyOutputReference | GoogleContainerClusterNetworkPolicy): any;
export declare class GoogleContainerClusterNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNetworkPolicy | undefined;
    set internalValue(value: GoogleContainerClusterNetworkPolicy | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _provider?;
    get provider(): string;
    set provider(value: string);
    resetProvider(): void;
    get providerInput(): string | undefined;
}
export interface GoogleContainerClusterNodeConfigGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#count GoogleContainerCluster#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#gpu_partition_size GoogleContainerCluster#gpu_partition_size}
    */
    readonly gpuPartitionSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#type GoogleContainerCluster#type}
    */
    readonly type?: string;
}
export declare function googleContainerClusterNodeConfigGuestAcceleratorToTerraform(struct?: GoogleContainerClusterNodeConfigGuestAccelerator | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodeConfigGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodeConfigGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _gpuPartitionSize?;
    get gpuPartitionSize(): string;
    set gpuPartitionSize(value: string);
    resetGpuPartitionSize(): void;
    get gpuPartitionSizeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleContainerClusterNodeConfigGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodeConfigGuestAcceleratorOutputReference;
}
export interface GoogleContainerClusterNodeConfigTaint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#effect GoogleContainerCluster#effect}
    */
    readonly effect?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#key GoogleContainerCluster#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#value GoogleContainerCluster#value}
    */
    readonly value?: string;
}
export declare function googleContainerClusterNodeConfigTaintToTerraform(struct?: GoogleContainerClusterNodeConfigTaint | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodeConfigTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodeConfigTaint | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleContainerClusterNodeConfigTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodeConfigTaintOutputReference;
}
export interface GoogleContainerClusterNodeConfigEphemeralStorageConfig {
    /**
    * Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD is 375 GB in size.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount: number;
}
export declare function googleContainerClusterNodeConfigEphemeralStorageConfigToTerraform(struct?: GoogleContainerClusterNodeConfigEphemeralStorageConfigOutputReference | GoogleContainerClusterNodeConfigEphemeralStorageConfig): any;
export declare class GoogleContainerClusterNodeConfigEphemeralStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigEphemeralStorageConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigEphemeralStorageConfig | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    get localSsdCountInput(): number | undefined;
}
export interface GoogleContainerClusterNodeConfigGcfsConfig {
    /**
    * Whether or not GCFS is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodeConfigGcfsConfigToTerraform(struct?: GoogleContainerClusterNodeConfigGcfsConfigOutputReference | GoogleContainerClusterNodeConfigGcfsConfig): any;
export declare class GoogleContainerClusterNodeConfigGcfsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigGcfsConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigGcfsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodeConfigGvnic {
    /**
    * Whether or not gvnic is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodeConfigGvnicToTerraform(struct?: GoogleContainerClusterNodeConfigGvnicOutputReference | GoogleContainerClusterNodeConfigGvnic): any;
export declare class GoogleContainerClusterNodeConfigGvnicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigGvnic | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigGvnic | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodeConfigKubeletConfig {
    /**
    * Enable CPU CFS quota enforcement for containers that specify CPU limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cpu_cfs_quota GoogleContainerCluster#cpu_cfs_quota}
    */
    readonly cpuCfsQuota?: boolean | cdktf.IResolvable;
    /**
    * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cpu_cfs_quota_period GoogleContainerCluster#cpu_cfs_quota_period}
    */
    readonly cpuCfsQuotaPeriod?: string;
    /**
    * Control the CPU management policy on the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cpu_manager_policy GoogleContainerCluster#cpu_manager_policy}
    */
    readonly cpuManagerPolicy: string;
}
export declare function googleContainerClusterNodeConfigKubeletConfigToTerraform(struct?: GoogleContainerClusterNodeConfigKubeletConfigOutputReference | GoogleContainerClusterNodeConfigKubeletConfig): any;
export declare class GoogleContainerClusterNodeConfigKubeletConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigKubeletConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigKubeletConfig | undefined);
    private _cpuCfsQuota?;
    get cpuCfsQuota(): boolean | cdktf.IResolvable;
    set cpuCfsQuota(value: boolean | cdktf.IResolvable);
    resetCpuCfsQuota(): void;
    get cpuCfsQuotaInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuCfsQuotaPeriod?;
    get cpuCfsQuotaPeriod(): string;
    set cpuCfsQuotaPeriod(value: string);
    resetCpuCfsQuotaPeriod(): void;
    get cpuCfsQuotaPeriodInput(): string | undefined;
    private _cpuManagerPolicy?;
    get cpuManagerPolicy(): string;
    set cpuManagerPolicy(value: string);
    get cpuManagerPolicyInput(): string | undefined;
}
export interface GoogleContainerClusterNodeConfigLinuxNodeConfig {
    /**
    * The Linux kernel parameters to be applied to the nodes and all pods running on the nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#sysctls GoogleContainerCluster#sysctls}
    */
    readonly sysctls: {
        [key: string]: string;
    };
}
export declare function googleContainerClusterNodeConfigLinuxNodeConfigToTerraform(struct?: GoogleContainerClusterNodeConfigLinuxNodeConfigOutputReference | GoogleContainerClusterNodeConfigLinuxNodeConfig): any;
export declare class GoogleContainerClusterNodeConfigLinuxNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigLinuxNodeConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigLinuxNodeConfig | undefined);
    private _sysctls?;
    get sysctls(): {
        [key: string]: string;
    };
    set sysctls(value: {
        [key: string]: string;
    });
    get sysctlsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleContainerClusterNodeConfigReservationAffinity {
    /**
    * Corresponds to the type of reservation consumption.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#consume_reservation_type GoogleContainerCluster#consume_reservation_type}
    */
    readonly consumeReservationType: string;
    /**
    * The label key of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#key GoogleContainerCluster#key}
    */
    readonly key?: string;
    /**
    * The label values of the reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#values GoogleContainerCluster#values}
    */
    readonly values?: string[];
}
export declare function googleContainerClusterNodeConfigReservationAffinityToTerraform(struct?: GoogleContainerClusterNodeConfigReservationAffinityOutputReference | GoogleContainerClusterNodeConfigReservationAffinity): any;
export declare class GoogleContainerClusterNodeConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigReservationAffinity | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleContainerClusterNodeConfigSandboxConfig {
    /**
    * Type of the sandbox to use for the node (e.g. 'gvisor')
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#sandbox_type GoogleContainerCluster#sandbox_type}
    */
    readonly sandboxType: string;
}
export declare function googleContainerClusterNodeConfigSandboxConfigToTerraform(struct?: GoogleContainerClusterNodeConfigSandboxConfigOutputReference | GoogleContainerClusterNodeConfigSandboxConfig): any;
export declare class GoogleContainerClusterNodeConfigSandboxConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigSandboxConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigSandboxConfig | undefined);
    private _sandboxType?;
    get sandboxType(): string;
    set sandboxType(value: string);
    get sandboxTypeInput(): string | undefined;
}
export interface GoogleContainerClusterNodeConfigShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_integrity_monitoring GoogleContainerCluster#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_secure_boot GoogleContainerCluster#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodeConfigShieldedInstanceConfigToTerraform(struct?: GoogleContainerClusterNodeConfigShieldedInstanceConfigOutputReference | GoogleContainerClusterNodeConfigShieldedInstanceConfig): any;
export declare class GoogleContainerClusterNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodeConfigWorkloadMetadataConfig {
    /**
    * Mode is the configuration for how to expose metadata to workloads running on the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#mode GoogleContainerCluster#mode}
    */
    readonly mode: string;
}
export declare function googleContainerClusterNodeConfigWorkloadMetadataConfigToTerraform(struct?: GoogleContainerClusterNodeConfigWorkloadMetadataConfigOutputReference | GoogleContainerClusterNodeConfigWorkloadMetadataConfig): any;
export declare class GoogleContainerClusterNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigWorkloadMetadataConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigWorkloadMetadataConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface GoogleContainerClusterNodeConfig {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#boot_disk_kms_key GoogleContainerCluster#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#disk_size_gb GoogleContainerCluster#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#disk_type GoogleContainerCluster#disk_type}
    */
    readonly diskType?: string;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#guest_accelerator GoogleContainerCluster#guest_accelerator}
    */
    readonly guestAccelerator?: GoogleContainerClusterNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * The image type to use for this node. Note that for a given image type, the latest version of it will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#image_type GoogleContainerCluster#image_type}
    */
    readonly imageType?: string;
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#labels GoogleContainerCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The number of local SSD disks to be attached to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount?: number;
    /**
    * The name of a Google Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#machine_type GoogleContainerCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The metadata key/value pairs assigned to instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#metadata GoogleContainerCluster#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#min_cpu_platform GoogleContainerCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on sole tenant nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_group GoogleContainerCluster#node_group}
    */
    readonly nodeGroup?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#oauth_scopes GoogleContainerCluster#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * Whether the nodes are created as preemptible VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#preemptible GoogleContainerCluster#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#service_account GoogleContainerCluster#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Whether the nodes are created as spot VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#spot GoogleContainerCluster#spot}
    */
    readonly spot?: boolean | cdktf.IResolvable;
    /**
    * The list of instance tags applied to all nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#tags GoogleContainerCluster#tags}
    */
    readonly tags?: string[];
    /**
    * List of Kubernetes taints to be applied to each node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#taint GoogleContainerCluster#taint}
    */
    readonly taint?: GoogleContainerClusterNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * ephemeral_storage_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#ephemeral_storage_config GoogleContainerCluster#ephemeral_storage_config}
    */
    readonly ephemeralStorageConfig?: GoogleContainerClusterNodeConfigEphemeralStorageConfig;
    /**
    * gcfs_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#gcfs_config GoogleContainerCluster#gcfs_config}
    */
    readonly gcfsConfig?: GoogleContainerClusterNodeConfigGcfsConfig;
    /**
    * gvnic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#gvnic GoogleContainerCluster#gvnic}
    */
    readonly gvnic?: GoogleContainerClusterNodeConfigGvnic;
    /**
    * kubelet_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#kubelet_config GoogleContainerCluster#kubelet_config}
    */
    readonly kubeletConfig?: GoogleContainerClusterNodeConfigKubeletConfig;
    /**
    * linux_node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#linux_node_config GoogleContainerCluster#linux_node_config}
    */
    readonly linuxNodeConfig?: GoogleContainerClusterNodeConfigLinuxNodeConfig;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#reservation_affinity GoogleContainerCluster#reservation_affinity}
    */
    readonly reservationAffinity?: GoogleContainerClusterNodeConfigReservationAffinity;
    /**
    * sandbox_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#sandbox_config GoogleContainerCluster#sandbox_config}
    */
    readonly sandboxConfig?: GoogleContainerClusterNodeConfigSandboxConfig;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#shielded_instance_config GoogleContainerCluster#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleContainerClusterNodeConfigShieldedInstanceConfig;
    /**
    * workload_metadata_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#workload_metadata_config GoogleContainerCluster#workload_metadata_config}
    */
    readonly workloadMetadataConfig?: GoogleContainerClusterNodeConfigWorkloadMetadataConfig;
}
export declare function googleContainerClusterNodeConfigToTerraform(struct?: GoogleContainerClusterNodeConfigOutputReference | GoogleContainerClusterNodeConfig): any;
export declare class GoogleContainerClusterNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfig | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _guestAccelerator;
    get guestAccelerator(): GoogleContainerClusterNodeConfigGuestAcceleratorList;
    putGuestAccelerator(value: GoogleContainerClusterNodeConfigGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | GoogleContainerClusterNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    resetNodeGroup(): void;
    get nodeGroupInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _spot?;
    get spot(): boolean | cdktf.IResolvable;
    set spot(value: boolean | cdktf.IResolvable);
    resetSpot(): void;
    get spotInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _taint;
    get taint(): GoogleContainerClusterNodeConfigTaintList;
    putTaint(value: GoogleContainerClusterNodeConfigTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | GoogleContainerClusterNodeConfigTaint[] | undefined;
    private _ephemeralStorageConfig;
    get ephemeralStorageConfig(): GoogleContainerClusterNodeConfigEphemeralStorageConfigOutputReference;
    putEphemeralStorageConfig(value: GoogleContainerClusterNodeConfigEphemeralStorageConfig): void;
    resetEphemeralStorageConfig(): void;
    get ephemeralStorageConfigInput(): GoogleContainerClusterNodeConfigEphemeralStorageConfig | undefined;
    private _gcfsConfig;
    get gcfsConfig(): GoogleContainerClusterNodeConfigGcfsConfigOutputReference;
    putGcfsConfig(value: GoogleContainerClusterNodeConfigGcfsConfig): void;
    resetGcfsConfig(): void;
    get gcfsConfigInput(): GoogleContainerClusterNodeConfigGcfsConfig | undefined;
    private _gvnic;
    get gvnic(): GoogleContainerClusterNodeConfigGvnicOutputReference;
    putGvnic(value: GoogleContainerClusterNodeConfigGvnic): void;
    resetGvnic(): void;
    get gvnicInput(): GoogleContainerClusterNodeConfigGvnic | undefined;
    private _kubeletConfig;
    get kubeletConfig(): GoogleContainerClusterNodeConfigKubeletConfigOutputReference;
    putKubeletConfig(value: GoogleContainerClusterNodeConfigKubeletConfig): void;
    resetKubeletConfig(): void;
    get kubeletConfigInput(): GoogleContainerClusterNodeConfigKubeletConfig | undefined;
    private _linuxNodeConfig;
    get linuxNodeConfig(): GoogleContainerClusterNodeConfigLinuxNodeConfigOutputReference;
    putLinuxNodeConfig(value: GoogleContainerClusterNodeConfigLinuxNodeConfig): void;
    resetLinuxNodeConfig(): void;
    get linuxNodeConfigInput(): GoogleContainerClusterNodeConfigLinuxNodeConfig | undefined;
    private _reservationAffinity;
    get reservationAffinity(): GoogleContainerClusterNodeConfigReservationAffinityOutputReference;
    putReservationAffinity(value: GoogleContainerClusterNodeConfigReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): GoogleContainerClusterNodeConfigReservationAffinity | undefined;
    private _sandboxConfig;
    get sandboxConfig(): GoogleContainerClusterNodeConfigSandboxConfigOutputReference;
    putSandboxConfig(value: GoogleContainerClusterNodeConfigSandboxConfig): void;
    resetSandboxConfig(): void;
    get sandboxConfigInput(): GoogleContainerClusterNodeConfigSandboxConfig | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleContainerClusterNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleContainerClusterNodeConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleContainerClusterNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig;
    get workloadMetadataConfig(): GoogleContainerClusterNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: GoogleContainerClusterNodeConfigWorkloadMetadataConfig): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): GoogleContainerClusterNodeConfigWorkloadMetadataConfig | undefined;
}
export interface GoogleContainerClusterNodePoolAutoscaling {
    /**
    * Location policy specifies the algorithm used when scaling-up the node pool. "BALANCED" - Is a best effort policy that aims to balance the sizes of available zones. "ANY" - Instructs the cluster autoscaler to prioritize utilization of unused reservations, and reduces preemption risk for Spot VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#location_policy GoogleContainerCluster#location_policy}
    */
    readonly locationPolicy?: string;
    /**
    * Maximum number of nodes per zone in the node pool. Must be >= min_node_count. Cannot be used with total limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#max_node_count GoogleContainerCluster#max_node_count}
    */
    readonly maxNodeCount?: number;
    /**
    * Minimum number of nodes per zone in the node pool. Must be >=0 and <= max_node_count. Cannot be used with total limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#min_node_count GoogleContainerCluster#min_node_count}
    */
    readonly minNodeCount?: number;
    /**
    * Maximum number of all nodes in the node pool. Must be >= total_min_node_count. Cannot be used with per zone limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#total_max_node_count GoogleContainerCluster#total_max_node_count}
    */
    readonly totalMaxNodeCount?: number;
    /**
    * Minimum number of all nodes in the node pool. Must be >=0 and <= total_max_node_count. Cannot be used with per zone limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#total_min_node_count GoogleContainerCluster#total_min_node_count}
    */
    readonly totalMinNodeCount?: number;
}
export declare function googleContainerClusterNodePoolAutoscalingToTerraform(struct?: GoogleContainerClusterNodePoolAutoscalingOutputReference | GoogleContainerClusterNodePoolAutoscaling): any;
export declare class GoogleContainerClusterNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolAutoscaling | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolAutoscaling | undefined);
    private _locationPolicy?;
    get locationPolicy(): string;
    set locationPolicy(value: string);
    resetLocationPolicy(): void;
    get locationPolicyInput(): string | undefined;
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    resetMaxNodeCount(): void;
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    resetMinNodeCount(): void;
    get minNodeCountInput(): number | undefined;
    private _totalMaxNodeCount?;
    get totalMaxNodeCount(): number;
    set totalMaxNodeCount(value: number);
    resetTotalMaxNodeCount(): void;
    get totalMaxNodeCountInput(): number | undefined;
    private _totalMinNodeCount?;
    get totalMinNodeCount(): number;
    set totalMinNodeCount(value: number);
    resetTotalMinNodeCount(): void;
    get totalMinNodeCountInput(): number | undefined;
}
export interface GoogleContainerClusterNodePoolManagement {
    /**
    * Whether the nodes will be automatically repaired.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#auto_repair GoogleContainerCluster#auto_repair}
    */
    readonly autoRepair?: boolean | cdktf.IResolvable;
    /**
    * Whether the nodes will be automatically upgraded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#auto_upgrade GoogleContainerCluster#auto_upgrade}
    */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolManagementToTerraform(struct?: GoogleContainerClusterNodePoolManagementOutputReference | GoogleContainerClusterNodePoolManagement): any;
export declare class GoogleContainerClusterNodePoolManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolManagement | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolManagement | undefined);
    private _autoRepair?;
    get autoRepair(): boolean | cdktf.IResolvable;
    set autoRepair(value: boolean | cdktf.IResolvable);
    resetAutoRepair(): void;
    get autoRepairInput(): boolean | cdktf.IResolvable | undefined;
    private _autoUpgrade?;
    get autoUpgrade(): boolean | cdktf.IResolvable;
    set autoUpgrade(value: boolean | cdktf.IResolvable);
    resetAutoUpgrade(): void;
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNetworkConfig {
    /**
    * Whether to create a new range for pod IPs in this node pool. Defaults are provided for pod_range and pod_ipv4_cidr_block if they are not specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#create_pod_range GoogleContainerCluster#create_pod_range}
    */
    readonly createPodRange?: boolean | cdktf.IResolvable;
    /**
    * The IP address range for pod IPs in this node pool. Only applicable if create_pod_range is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) to pick a specific range to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#pod_ipv4_cidr_block GoogleContainerCluster#pod_ipv4_cidr_block}
    */
    readonly podIpv4CidrBlock?: string;
    /**
    * The ID of the secondary range for pod IPs. If create_pod_range is true, this ID is used for the new range. If create_pod_range is false, uses an existing secondary range with this ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#pod_range GoogleContainerCluster#pod_range}
    */
    readonly podRange: string;
}
export declare function googleContainerClusterNodePoolNetworkConfigToTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigOutputReference | GoogleContainerClusterNodePoolNetworkConfig): any;
export declare class GoogleContainerClusterNodePoolNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNetworkConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNetworkConfig | undefined);
    private _createPodRange?;
    get createPodRange(): boolean | cdktf.IResolvable;
    set createPodRange(value: boolean | cdktf.IResolvable);
    resetCreatePodRange(): void;
    get createPodRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _podIpv4CidrBlock?;
    get podIpv4CidrBlock(): string;
    set podIpv4CidrBlock(value: string);
    resetPodIpv4CidrBlock(): void;
    get podIpv4CidrBlockInput(): string | undefined;
    private _podRange?;
    get podRange(): string;
    set podRange(value: string);
    get podRangeInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#count GoogleContainerCluster#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#gpu_partition_size GoogleContainerCluster#gpu_partition_size}
    */
    readonly gpuPartitionSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#type GoogleContainerCluster#type}
    */
    readonly type?: string;
}
export declare function googleContainerClusterNodePoolNodeConfigGuestAcceleratorToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _gpuPartitionSize?;
    get gpuPartitionSize(): string;
    set gpuPartitionSize(value: string);
    resetGpuPartitionSize(): void;
    get gpuPartitionSizeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorOutputReference;
}
export interface GoogleContainerClusterNodePoolNodeConfigTaint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#effect GoogleContainerCluster#effect}
    */
    readonly effect?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#key GoogleContainerCluster#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#value GoogleContainerCluster#value}
    */
    readonly value?: string;
}
export declare function googleContainerClusterNodePoolNodeConfigTaintToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigTaint | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolNodeConfigTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigTaint | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleContainerClusterNodePoolNodeConfigTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePoolNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolNodeConfigTaintOutputReference;
}
export interface GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig {
    /**
    * Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD is 375 GB in size.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount: number;
}
export declare function googleContainerClusterNodePoolNodeConfigEphemeralStorageConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    get localSsdCountInput(): number | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigGcfsConfig {
    /**
    * Whether or not GCFS is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolNodeConfigGcfsConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGcfsConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigGcfsConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigGcfsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigGcfsConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigGcfsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigGvnic {
    /**
    * Whether or not gvnic is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolNodeConfigGvnicToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGvnicOutputReference | GoogleContainerClusterNodePoolNodeConfigGvnic): any;
export declare class GoogleContainerClusterNodePoolNodeConfigGvnicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigGvnic | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigGvnic | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigKubeletConfig {
    /**
    * Enable CPU CFS quota enforcement for containers that specify CPU limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cpu_cfs_quota GoogleContainerCluster#cpu_cfs_quota}
    */
    readonly cpuCfsQuota?: boolean | cdktf.IResolvable;
    /**
    * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cpu_cfs_quota_period GoogleContainerCluster#cpu_cfs_quota_period}
    */
    readonly cpuCfsQuotaPeriod?: string;
    /**
    * Control the CPU management policy on the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#cpu_manager_policy GoogleContainerCluster#cpu_manager_policy}
    */
    readonly cpuManagerPolicy: string;
}
export declare function googleContainerClusterNodePoolNodeConfigKubeletConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigKubeletConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigKubeletConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigKubeletConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigKubeletConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigKubeletConfig | undefined);
    private _cpuCfsQuota?;
    get cpuCfsQuota(): boolean | cdktf.IResolvable;
    set cpuCfsQuota(value: boolean | cdktf.IResolvable);
    resetCpuCfsQuota(): void;
    get cpuCfsQuotaInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuCfsQuotaPeriod?;
    get cpuCfsQuotaPeriod(): string;
    set cpuCfsQuotaPeriod(value: string);
    resetCpuCfsQuotaPeriod(): void;
    get cpuCfsQuotaPeriodInput(): string | undefined;
    private _cpuManagerPolicy?;
    get cpuManagerPolicy(): string;
    set cpuManagerPolicy(value: string);
    get cpuManagerPolicyInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig {
    /**
    * The Linux kernel parameters to be applied to the nodes and all pods running on the nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#sysctls GoogleContainerCluster#sysctls}
    */
    readonly sysctls: {
        [key: string]: string;
    };
}
export declare function googleContainerClusterNodePoolNodeConfigLinuxNodeConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig | undefined);
    private _sysctls?;
    get sysctls(): {
        [key: string]: string;
    };
    set sysctls(value: {
        [key: string]: string;
    });
    get sysctlsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigReservationAffinity {
    /**
    * Corresponds to the type of reservation consumption.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#consume_reservation_type GoogleContainerCluster#consume_reservation_type}
    */
    readonly consumeReservationType: string;
    /**
    * The label key of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#key GoogleContainerCluster#key}
    */
    readonly key?: string;
    /**
    * The label values of the reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#values GoogleContainerCluster#values}
    */
    readonly values?: string[];
}
export declare function googleContainerClusterNodePoolNodeConfigReservationAffinityToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigReservationAffinityOutputReference | GoogleContainerClusterNodePoolNodeConfigReservationAffinity): any;
export declare class GoogleContainerClusterNodePoolNodeConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigReservationAffinity | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigSandboxConfig {
    /**
    * Type of the sandbox to use for the node (e.g. 'gvisor')
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#sandbox_type GoogleContainerCluster#sandbox_type}
    */
    readonly sandboxType: string;
}
export declare function googleContainerClusterNodePoolNodeConfigSandboxConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigSandboxConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigSandboxConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigSandboxConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigSandboxConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigSandboxConfig | undefined);
    private _sandboxType?;
    get sandboxType(): string;
    set sandboxType(value: string);
    get sandboxTypeInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_integrity_monitoring GoogleContainerCluster#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_secure_boot GoogleContainerCluster#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolNodeConfigShieldedInstanceConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig {
    /**
    * Mode is the configuration for how to expose metadata to workloads running on the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#mode GoogleContainerCluster#mode}
    */
    readonly mode: string;
}
export declare function googleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfig {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#boot_disk_kms_key GoogleContainerCluster#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#disk_size_gb GoogleContainerCluster#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#disk_type GoogleContainerCluster#disk_type}
    */
    readonly diskType?: string;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#guest_accelerator GoogleContainerCluster#guest_accelerator}
    */
    readonly guestAccelerator?: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * The image type to use for this node. Note that for a given image type, the latest version of it will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#image_type GoogleContainerCluster#image_type}
    */
    readonly imageType?: string;
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#labels GoogleContainerCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The number of local SSD disks to be attached to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount?: number;
    /**
    * The name of a Google Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#machine_type GoogleContainerCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The metadata key/value pairs assigned to instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#metadata GoogleContainerCluster#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#min_cpu_platform GoogleContainerCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on sole tenant nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_group GoogleContainerCluster#node_group}
    */
    readonly nodeGroup?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#oauth_scopes GoogleContainerCluster#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * Whether the nodes are created as preemptible VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#preemptible GoogleContainerCluster#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#service_account GoogleContainerCluster#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Whether the nodes are created as spot VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#spot GoogleContainerCluster#spot}
    */
    readonly spot?: boolean | cdktf.IResolvable;
    /**
    * The list of instance tags applied to all nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#tags GoogleContainerCluster#tags}
    */
    readonly tags?: string[];
    /**
    * List of Kubernetes taints to be applied to each node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#taint GoogleContainerCluster#taint}
    */
    readonly taint?: GoogleContainerClusterNodePoolNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * ephemeral_storage_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#ephemeral_storage_config GoogleContainerCluster#ephemeral_storage_config}
    */
    readonly ephemeralStorageConfig?: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig;
    /**
    * gcfs_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#gcfs_config GoogleContainerCluster#gcfs_config}
    */
    readonly gcfsConfig?: GoogleContainerClusterNodePoolNodeConfigGcfsConfig;
    /**
    * gvnic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#gvnic GoogleContainerCluster#gvnic}
    */
    readonly gvnic?: GoogleContainerClusterNodePoolNodeConfigGvnic;
    /**
    * kubelet_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#kubelet_config GoogleContainerCluster#kubelet_config}
    */
    readonly kubeletConfig?: GoogleContainerClusterNodePoolNodeConfigKubeletConfig;
    /**
    * linux_node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#linux_node_config GoogleContainerCluster#linux_node_config}
    */
    readonly linuxNodeConfig?: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#reservation_affinity GoogleContainerCluster#reservation_affinity}
    */
    readonly reservationAffinity?: GoogleContainerClusterNodePoolNodeConfigReservationAffinity;
    /**
    * sandbox_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#sandbox_config GoogleContainerCluster#sandbox_config}
    */
    readonly sandboxConfig?: GoogleContainerClusterNodePoolNodeConfigSandboxConfig;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#shielded_instance_config GoogleContainerCluster#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig;
    /**
    * workload_metadata_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#workload_metadata_config GoogleContainerCluster#workload_metadata_config}
    */
    readonly workloadMetadataConfig?: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig;
}
export declare function googleContainerClusterNodePoolNodeConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigOutputReference | GoogleContainerClusterNodePoolNodeConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfig | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _guestAccelerator;
    get guestAccelerator(): GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorList;
    putGuestAccelerator(value: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | GoogleContainerClusterNodePoolNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    resetNodeGroup(): void;
    get nodeGroupInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _spot?;
    get spot(): boolean | cdktf.IResolvable;
    set spot(value: boolean | cdktf.IResolvable);
    resetSpot(): void;
    get spotInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _taint;
    get taint(): GoogleContainerClusterNodePoolNodeConfigTaintList;
    putTaint(value: GoogleContainerClusterNodePoolNodeConfigTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | GoogleContainerClusterNodePoolNodeConfigTaint[] | undefined;
    private _ephemeralStorageConfig;
    get ephemeralStorageConfig(): GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfigOutputReference;
    putEphemeralStorageConfig(value: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig): void;
    resetEphemeralStorageConfig(): void;
    get ephemeralStorageConfigInput(): GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig | undefined;
    private _gcfsConfig;
    get gcfsConfig(): GoogleContainerClusterNodePoolNodeConfigGcfsConfigOutputReference;
    putGcfsConfig(value: GoogleContainerClusterNodePoolNodeConfigGcfsConfig): void;
    resetGcfsConfig(): void;
    get gcfsConfigInput(): GoogleContainerClusterNodePoolNodeConfigGcfsConfig | undefined;
    private _gvnic;
    get gvnic(): GoogleContainerClusterNodePoolNodeConfigGvnicOutputReference;
    putGvnic(value: GoogleContainerClusterNodePoolNodeConfigGvnic): void;
    resetGvnic(): void;
    get gvnicInput(): GoogleContainerClusterNodePoolNodeConfigGvnic | undefined;
    private _kubeletConfig;
    get kubeletConfig(): GoogleContainerClusterNodePoolNodeConfigKubeletConfigOutputReference;
    putKubeletConfig(value: GoogleContainerClusterNodePoolNodeConfigKubeletConfig): void;
    resetKubeletConfig(): void;
    get kubeletConfigInput(): GoogleContainerClusterNodePoolNodeConfigKubeletConfig | undefined;
    private _linuxNodeConfig;
    get linuxNodeConfig(): GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfigOutputReference;
    putLinuxNodeConfig(value: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig): void;
    resetLinuxNodeConfig(): void;
    get linuxNodeConfigInput(): GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig | undefined;
    private _reservationAffinity;
    get reservationAffinity(): GoogleContainerClusterNodePoolNodeConfigReservationAffinityOutputReference;
    putReservationAffinity(value: GoogleContainerClusterNodePoolNodeConfigReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): GoogleContainerClusterNodePoolNodeConfigReservationAffinity | undefined;
    private _sandboxConfig;
    get sandboxConfig(): GoogleContainerClusterNodePoolNodeConfigSandboxConfigOutputReference;
    putSandboxConfig(value: GoogleContainerClusterNodePoolNodeConfigSandboxConfig): void;
    resetSandboxConfig(): void;
    get sandboxConfigInput(): GoogleContainerClusterNodePoolNodeConfigSandboxConfig | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig;
    get workloadMetadataConfig(): GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined;
}
export interface GoogleContainerClusterNodePoolPlacementPolicy {
    /**
    * Type defines the type of placement policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#type GoogleContainerCluster#type}
    */
    readonly type: string;
}
export declare function googleContainerClusterNodePoolPlacementPolicyToTerraform(struct?: GoogleContainerClusterNodePoolPlacementPolicyOutputReference | GoogleContainerClusterNodePoolPlacementPolicy): any;
export declare class GoogleContainerClusterNodePoolPlacementPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolPlacementPolicy | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolPlacementPolicy | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolUpgradeSettings {
    /**
    * The number of additional nodes that can be added to the node pool during an upgrade. Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#max_surge GoogleContainerCluster#max_surge}
    */
    readonly maxSurge: number;
    /**
    * The number of nodes that can be simultaneously unavailable during an upgrade. Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#max_unavailable GoogleContainerCluster#max_unavailable}
    */
    readonly maxUnavailable: number;
}
export declare function googleContainerClusterNodePoolUpgradeSettingsToTerraform(struct?: GoogleContainerClusterNodePoolUpgradeSettingsOutputReference | GoogleContainerClusterNodePoolUpgradeSettings): any;
export declare class GoogleContainerClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolUpgradeSettings | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolUpgradeSettings | undefined);
    private _maxSurge?;
    get maxSurge(): number;
    set maxSurge(value: number);
    get maxSurgeInput(): number | undefined;
    private _maxUnavailable?;
    get maxUnavailable(): number;
    set maxUnavailable(value: number);
    get maxUnavailableInput(): number | undefined;
}
export interface GoogleContainerClusterNodePool {
    /**
    * The initial number of nodes for the pool. In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#initial_node_count GoogleContainerCluster#initial_node_count}
    */
    readonly initialNodeCount?: number;
    /**
    * The maximum number of pods per node in this node pool. Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#max_pods_per_node GoogleContainerCluster#max_pods_per_node}
    */
    readonly maxPodsPerNode?: number;
    /**
    * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#name GoogleContainerCluster#name}
    */
    readonly name?: string;
    /**
    * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#name_prefix GoogleContainerCluster#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * The number of nodes per instance group. This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_count GoogleContainerCluster#node_count}
    */
    readonly nodeCount?: number;
    /**
    * The list of zones in which the node pool's nodes should be located. Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_locations GoogleContainerCluster#node_locations}
    */
    readonly nodeLocations?: string[];
    /**
    * The Kubernetes version for the nodes in this pool. Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#version GoogleContainerCluster#version}
    */
    readonly version?: string;
    /**
    * autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#autoscaling GoogleContainerCluster#autoscaling}
    */
    readonly autoscaling?: GoogleContainerClusterNodePoolAutoscaling;
    /**
    * management block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#management GoogleContainerCluster#management}
    */
    readonly management?: GoogleContainerClusterNodePoolManagement;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#network_config GoogleContainerCluster#network_config}
    */
    readonly networkConfig?: GoogleContainerClusterNodePoolNetworkConfig;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_config GoogleContainerCluster#node_config}
    */
    readonly nodeConfig?: GoogleContainerClusterNodePoolNodeConfig;
    /**
    * placement_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#placement_policy GoogleContainerCluster#placement_policy}
    */
    readonly placementPolicy?: GoogleContainerClusterNodePoolPlacementPolicy;
    /**
    * upgrade_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#upgrade_settings GoogleContainerCluster#upgrade_settings}
    */
    readonly upgradeSettings?: GoogleContainerClusterNodePoolUpgradeSettings;
}
export declare function googleContainerClusterNodePoolToTerraform(struct?: GoogleContainerClusterNodePool | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePool | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePool | cdktf.IResolvable | undefined);
    private _initialNodeCount?;
    get initialNodeCount(): number;
    set initialNodeCount(value: number);
    resetInitialNodeCount(): void;
    get initialNodeCountInput(): number | undefined;
    get instanceGroupUrls(): string[];
    get managedInstanceGroupUrls(): string[];
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    resetMaxPodsPerNode(): void;
    get maxPodsPerNodeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeLocations?;
    get nodeLocations(): string[];
    set nodeLocations(value: string[]);
    resetNodeLocations(): void;
    get nodeLocationsInput(): string[] | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _autoscaling;
    get autoscaling(): GoogleContainerClusterNodePoolAutoscalingOutputReference;
    putAutoscaling(value: GoogleContainerClusterNodePoolAutoscaling): void;
    resetAutoscaling(): void;
    get autoscalingInput(): GoogleContainerClusterNodePoolAutoscaling | undefined;
    private _management;
    get management(): GoogleContainerClusterNodePoolManagementOutputReference;
    putManagement(value: GoogleContainerClusterNodePoolManagement): void;
    resetManagement(): void;
    get managementInput(): GoogleContainerClusterNodePoolManagement | undefined;
    private _networkConfig;
    get networkConfig(): GoogleContainerClusterNodePoolNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleContainerClusterNodePoolNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): GoogleContainerClusterNodePoolNetworkConfig | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleContainerClusterNodePoolNodeConfigOutputReference;
    putNodeConfig(value: GoogleContainerClusterNodePoolNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): GoogleContainerClusterNodePoolNodeConfig | undefined;
    private _placementPolicy;
    get placementPolicy(): GoogleContainerClusterNodePoolPlacementPolicyOutputReference;
    putPlacementPolicy(value: GoogleContainerClusterNodePoolPlacementPolicy): void;
    resetPlacementPolicy(): void;
    get placementPolicyInput(): GoogleContainerClusterNodePoolPlacementPolicy | undefined;
    private _upgradeSettings;
    get upgradeSettings(): GoogleContainerClusterNodePoolUpgradeSettingsOutputReference;
    putUpgradeSettings(value: GoogleContainerClusterNodePoolUpgradeSettings): void;
    resetUpgradeSettings(): void;
    get upgradeSettingsInput(): GoogleContainerClusterNodePoolUpgradeSettings | undefined;
}
export declare class GoogleContainerClusterNodePoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolOutputReference;
}
export interface GoogleContainerClusterNodePoolAutoConfigNetworkTags {
    /**
    * List of network tags applied to auto-provisioned node pools.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#tags GoogleContainerCluster#tags}
    */
    readonly tags?: string[];
}
export declare function googleContainerClusterNodePoolAutoConfigNetworkTagsToTerraform(struct?: GoogleContainerClusterNodePoolAutoConfigNetworkTagsOutputReference | GoogleContainerClusterNodePoolAutoConfigNetworkTags): any;
export declare class GoogleContainerClusterNodePoolAutoConfigNetworkTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolAutoConfigNetworkTags | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolAutoConfigNetworkTags | undefined);
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
}
export interface GoogleContainerClusterNodePoolAutoConfig {
    /**
    * network_tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#network_tags GoogleContainerCluster#network_tags}
    */
    readonly networkTags?: GoogleContainerClusterNodePoolAutoConfigNetworkTags;
}
export declare function googleContainerClusterNodePoolAutoConfigToTerraform(struct?: GoogleContainerClusterNodePoolAutoConfigOutputReference | GoogleContainerClusterNodePoolAutoConfig): any;
export declare class GoogleContainerClusterNodePoolAutoConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolAutoConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolAutoConfig | undefined);
    private _networkTags;
    get networkTags(): GoogleContainerClusterNodePoolAutoConfigNetworkTagsOutputReference;
    putNetworkTags(value: GoogleContainerClusterNodePoolAutoConfigNetworkTags): void;
    resetNetworkTags(): void;
    get networkTagsInput(): GoogleContainerClusterNodePoolAutoConfigNetworkTags | undefined;
}
export interface GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig {
    /**
    * Whether or not GCFS is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfigToTerraform(struct?: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfigOutputReference | GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig): any;
export declare class GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults {
    /**
    * gcfs_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#gcfs_config GoogleContainerCluster#gcfs_config}
    */
    readonly gcfsConfig?: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig;
}
export declare function googleContainerClusterNodePoolDefaultsNodeConfigDefaultsToTerraform(struct?: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsOutputReference | GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults): any;
export declare class GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults | undefined);
    private _gcfsConfig;
    get gcfsConfig(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfigOutputReference;
    putGcfsConfig(value: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig): void;
    resetGcfsConfig(): void;
    get gcfsConfigInput(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig | undefined;
}
export interface GoogleContainerClusterNodePoolDefaults {
    /**
    * node_config_defaults block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#node_config_defaults GoogleContainerCluster#node_config_defaults}
    */
    readonly nodeConfigDefaults?: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults;
}
export declare function googleContainerClusterNodePoolDefaultsToTerraform(struct?: GoogleContainerClusterNodePoolDefaultsOutputReference | GoogleContainerClusterNodePoolDefaults): any;
export declare class GoogleContainerClusterNodePoolDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolDefaults | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolDefaults | undefined);
    private _nodeConfigDefaults;
    get nodeConfigDefaults(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsOutputReference;
    putNodeConfigDefaults(value: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults): void;
    resetNodeConfigDefaults(): void;
    get nodeConfigDefaultsInput(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults | undefined;
}
export interface GoogleContainerClusterNotificationConfigPubsub {
    /**
    * Whether or not the notification config is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The pubsub topic to push upgrade notifications to. Must be in the same project as the cluster. Must be in the format: projects/{project}/topics/{topic}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#topic GoogleContainerCluster#topic}
    */
    readonly topic?: string;
}
export declare function googleContainerClusterNotificationConfigPubsubToTerraform(struct?: GoogleContainerClusterNotificationConfigPubsubOutputReference | GoogleContainerClusterNotificationConfigPubsub): any;
export declare class GoogleContainerClusterNotificationConfigPubsubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNotificationConfigPubsub | undefined;
    set internalValue(value: GoogleContainerClusterNotificationConfigPubsub | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    resetTopic(): void;
    get topicInput(): string | undefined;
}
export interface GoogleContainerClusterNotificationConfig {
    /**
    * pubsub block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#pubsub GoogleContainerCluster#pubsub}
    */
    readonly pubsub: GoogleContainerClusterNotificationConfigPubsub;
}
export declare function googleContainerClusterNotificationConfigToTerraform(struct?: GoogleContainerClusterNotificationConfigOutputReference | GoogleContainerClusterNotificationConfig): any;
export declare class GoogleContainerClusterNotificationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNotificationConfig | undefined;
    set internalValue(value: GoogleContainerClusterNotificationConfig | undefined);
    private _pubsub;
    get pubsub(): GoogleContainerClusterNotificationConfigPubsubOutputReference;
    putPubsub(value: GoogleContainerClusterNotificationConfigPubsub): void;
    get pubsubInput(): GoogleContainerClusterNotificationConfigPubsub | undefined;
}
export interface GoogleContainerClusterPodSecurityPolicyConfig {
    /**
    * Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterPodSecurityPolicyConfigToTerraform(struct?: GoogleContainerClusterPodSecurityPolicyConfigOutputReference | GoogleContainerClusterPodSecurityPolicyConfig): any;
export declare class GoogleContainerClusterPodSecurityPolicyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterPodSecurityPolicyConfig | undefined;
    set internalValue(value: GoogleContainerClusterPodSecurityPolicyConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig {
    /**
    * Whether the cluster master is accessible globally or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigToTerraform(struct?: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference | GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig): any;
export declare class GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined;
    set internalValue(value: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterPrivateClusterConfig {
    /**
    * When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled. When false, either endpoint can be used. This field only applies to private clusters, when enable_private_nodes is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_private_endpoint GoogleContainerCluster#enable_private_endpoint}
    */
    readonly enablePrivateEndpoint: boolean | cdktf.IResolvable;
    /**
    * Enables the private cluster feature, creating a private endpoint on the cluster. In a private cluster, nodes only have RFC 1918 private addresses and communicate with the master's private endpoint via private networking.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_private_nodes GoogleContainerCluster#enable_private_nodes}
    */
    readonly enablePrivateNodes?: boolean | cdktf.IResolvable;
    /**
    * The IP range in CIDR notation to use for the hosted master network. This range will be used for assigning private IP addresses to the cluster master(s) and the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network, and it must be a /28 subnet. See Private Cluster Limitations for more details. This field only applies to private clusters, when enable_private_nodes is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#master_ipv4_cidr_block GoogleContainerCluster#master_ipv4_cidr_block}
    */
    readonly masterIpv4CidrBlock?: string;
    /**
    * master_global_access_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#master_global_access_config GoogleContainerCluster#master_global_access_config}
    */
    readonly masterGlobalAccessConfig?: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig;
}
export declare function googleContainerClusterPrivateClusterConfigToTerraform(struct?: GoogleContainerClusterPrivateClusterConfigOutputReference | GoogleContainerClusterPrivateClusterConfig): any;
export declare class GoogleContainerClusterPrivateClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterPrivateClusterConfig | undefined;
    set internalValue(value: GoogleContainerClusterPrivateClusterConfig | undefined);
    private _enablePrivateEndpoint?;
    get enablePrivateEndpoint(): boolean | cdktf.IResolvable;
    set enablePrivateEndpoint(value: boolean | cdktf.IResolvable);
    get enablePrivateEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePrivateNodes?;
    get enablePrivateNodes(): boolean | cdktf.IResolvable;
    set enablePrivateNodes(value: boolean | cdktf.IResolvable);
    resetEnablePrivateNodes(): void;
    get enablePrivateNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _masterIpv4CidrBlock?;
    get masterIpv4CidrBlock(): string;
    set masterIpv4CidrBlock(value: string);
    resetMasterIpv4CidrBlock(): void;
    get masterIpv4CidrBlockInput(): string | undefined;
    get peeringName(): string;
    get privateEndpoint(): string;
    get publicEndpoint(): string;
    private _masterGlobalAccessConfig;
    get masterGlobalAccessConfig(): GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference;
    putMasterGlobalAccessConfig(value: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig): void;
    resetMasterGlobalAccessConfig(): void;
    get masterGlobalAccessConfigInput(): GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined;
}
export interface GoogleContainerClusterReleaseChannel {
    /**
    * The selected release channel. Accepted values are:
  * UNSPECIFIED: Not set.
  * RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
  * REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
  * STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#channel GoogleContainerCluster#channel}
    */
    readonly channel: string;
}
export declare function googleContainerClusterReleaseChannelToTerraform(struct?: GoogleContainerClusterReleaseChannelOutputReference | GoogleContainerClusterReleaseChannel): any;
export declare class GoogleContainerClusterReleaseChannelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterReleaseChannel | undefined;
    set internalValue(value: GoogleContainerClusterReleaseChannel | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    get channelInput(): string | undefined;
}
export interface GoogleContainerClusterResourceUsageExportConfigBigqueryDestination {
    /**
    * The ID of a BigQuery Dataset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#dataset_id GoogleContainerCluster#dataset_id}
    */
    readonly datasetId: string;
}
export declare function googleContainerClusterResourceUsageExportConfigBigqueryDestinationToTerraform(struct?: GoogleContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference | GoogleContainerClusterResourceUsageExportConfigBigqueryDestination): any;
export declare class GoogleContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterResourceUsageExportConfigBigqueryDestination | undefined;
    set internalValue(value: GoogleContainerClusterResourceUsageExportConfigBigqueryDestination | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
}
export interface GoogleContainerClusterResourceUsageExportConfig {
    /**
    * Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created in the cluster to meter network egress traffic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_network_egress_metering GoogleContainerCluster#enable_network_egress_metering}
    */
    readonly enableNetworkEgressMetering?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable resource consumption metering on this cluster. When enabled, a table will be created in the resource export BigQuery dataset to store resource consumption data. The resulting table can be joined with the resource usage table or with BigQuery billing export. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enable_resource_consumption_metering GoogleContainerCluster#enable_resource_consumption_metering}
    */
    readonly enableResourceConsumptionMetering?: boolean | cdktf.IResolvable;
    /**
    * bigquery_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#bigquery_destination GoogleContainerCluster#bigquery_destination}
    */
    readonly bigqueryDestination: GoogleContainerClusterResourceUsageExportConfigBigqueryDestination;
}
export declare function googleContainerClusterResourceUsageExportConfigToTerraform(struct?: GoogleContainerClusterResourceUsageExportConfigOutputReference | GoogleContainerClusterResourceUsageExportConfig): any;
export declare class GoogleContainerClusterResourceUsageExportConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterResourceUsageExportConfig | undefined;
    set internalValue(value: GoogleContainerClusterResourceUsageExportConfig | undefined);
    private _enableNetworkEgressMetering?;
    get enableNetworkEgressMetering(): boolean | cdktf.IResolvable;
    set enableNetworkEgressMetering(value: boolean | cdktf.IResolvable);
    resetEnableNetworkEgressMetering(): void;
    get enableNetworkEgressMeteringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableResourceConsumptionMetering?;
    get enableResourceConsumptionMetering(): boolean | cdktf.IResolvable;
    set enableResourceConsumptionMetering(value: boolean | cdktf.IResolvable);
    resetEnableResourceConsumptionMetering(): void;
    get enableResourceConsumptionMeteringInput(): boolean | cdktf.IResolvable | undefined;
    private _bigqueryDestination;
    get bigqueryDestination(): GoogleContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference;
    putBigqueryDestination(value: GoogleContainerClusterResourceUsageExportConfigBigqueryDestination): void;
    get bigqueryDestinationInput(): GoogleContainerClusterResourceUsageExportConfigBigqueryDestination | undefined;
}
export interface GoogleContainerClusterServiceExternalIpsConfig {
    /**
    * When enabled, services with exterenal ips specified will be allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterServiceExternalIpsConfigToTerraform(struct?: GoogleContainerClusterServiceExternalIpsConfigOutputReference | GoogleContainerClusterServiceExternalIpsConfig): any;
export declare class GoogleContainerClusterServiceExternalIpsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterServiceExternalIpsConfig | undefined;
    set internalValue(value: GoogleContainerClusterServiceExternalIpsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#create GoogleContainerCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#delete GoogleContainerCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#read GoogleContainerCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#update GoogleContainerCluster#update}
    */
    readonly update?: string;
}
export declare function googleContainerClusterTimeoutsToTerraform(struct?: GoogleContainerClusterTimeoutsOutputReference | GoogleContainerClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleContainerClusterTpuConfig {
    /**
    * Whether Cloud TPU integration is enabled or not
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Whether to use service networking for Cloud TPU or not
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#use_service_networking GoogleContainerCluster#use_service_networking}
    */
    readonly useServiceNetworking?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterTpuConfigToTerraform(struct?: GoogleContainerClusterTpuConfigOutputReference | GoogleContainerClusterTpuConfig): any;
export declare class GoogleContainerClusterTpuConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterTpuConfig | undefined;
    set internalValue(value: GoogleContainerClusterTpuConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get ipv4CidrBlock(): string;
    private _useServiceNetworking?;
    get useServiceNetworking(): boolean | cdktf.IResolvable;
    set useServiceNetworking(value: boolean | cdktf.IResolvable);
    resetUseServiceNetworking(): void;
    get useServiceNetworkingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterVerticalPodAutoscaling {
    /**
    * Enables vertical pod autoscaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterVerticalPodAutoscalingToTerraform(struct?: GoogleContainerClusterVerticalPodAutoscalingOutputReference | GoogleContainerClusterVerticalPodAutoscaling): any;
export declare class GoogleContainerClusterVerticalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterVerticalPodAutoscaling | undefined;
    set internalValue(value: GoogleContainerClusterVerticalPodAutoscaling | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterWorkloadIdentityConfig {
    /**
    * The workload pool to attach all Kubernetes service accounts to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster#workload_pool GoogleContainerCluster#workload_pool}
    */
    readonly workloadPool?: string;
}
export declare function googleContainerClusterWorkloadIdentityConfigToTerraform(struct?: GoogleContainerClusterWorkloadIdentityConfigOutputReference | GoogleContainerClusterWorkloadIdentityConfig): any;
export declare class GoogleContainerClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterWorkloadIdentityConfig | undefined;
    set internalValue(value: GoogleContainerClusterWorkloadIdentityConfig | undefined);
    private _workloadPool?;
    get workloadPool(): string;
    set workloadPool(value: string);
    resetWorkloadPool(): void;
    get workloadPoolInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster google_container_cluster}
*/
export declare class GoogleContainerCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_cluster google_container_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerClusterConfig);
    private _clusterIpv4Cidr?;
    get clusterIpv4Cidr(): string;
    set clusterIpv4Cidr(value: string);
    resetClusterIpv4Cidr(): void;
    get clusterIpv4CidrInput(): string | undefined;
    private _datapathProvider?;
    get datapathProvider(): string;
    set datapathProvider(value: string);
    resetDatapathProvider(): void;
    get datapathProviderInput(): string | undefined;
    private _defaultMaxPodsPerNode?;
    get defaultMaxPodsPerNode(): number;
    set defaultMaxPodsPerNode(value: number);
    resetDefaultMaxPodsPerNode(): void;
    get defaultMaxPodsPerNodeInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableAutopilot?;
    get enableAutopilot(): boolean | cdktf.IResolvable;
    set enableAutopilot(value: boolean | cdktf.IResolvable);
    resetEnableAutopilot(): void;
    get enableAutopilotInput(): boolean | cdktf.IResolvable | undefined;
    private _enableBinaryAuthorization?;
    get enableBinaryAuthorization(): boolean | cdktf.IResolvable;
    set enableBinaryAuthorization(value: boolean | cdktf.IResolvable);
    resetEnableBinaryAuthorization(): void;
    get enableBinaryAuthorizationInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIntranodeVisibility?;
    get enableIntranodeVisibility(): boolean | cdktf.IResolvable;
    set enableIntranodeVisibility(value: boolean | cdktf.IResolvable);
    resetEnableIntranodeVisibility(): void;
    get enableIntranodeVisibilityInput(): boolean | cdktf.IResolvable | undefined;
    private _enableKubernetesAlpha?;
    get enableKubernetesAlpha(): boolean | cdktf.IResolvable;
    set enableKubernetesAlpha(value: boolean | cdktf.IResolvable);
    resetEnableKubernetesAlpha(): void;
    get enableKubernetesAlphaInput(): boolean | cdktf.IResolvable | undefined;
    private _enableL4IlbSubsetting?;
    get enableL4IlbSubsetting(): boolean | cdktf.IResolvable;
    set enableL4IlbSubsetting(value: boolean | cdktf.IResolvable);
    resetEnableL4IlbSubsetting(): void;
    get enableL4IlbSubsettingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLegacyAbac?;
    get enableLegacyAbac(): boolean | cdktf.IResolvable;
    set enableLegacyAbac(value: boolean | cdktf.IResolvable);
    resetEnableLegacyAbac(): void;
    get enableLegacyAbacInput(): boolean | cdktf.IResolvable | undefined;
    private _enableShieldedNodes?;
    get enableShieldedNodes(): boolean | cdktf.IResolvable;
    set enableShieldedNodes(value: boolean | cdktf.IResolvable);
    resetEnableShieldedNodes(): void;
    get enableShieldedNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _enableTpu?;
    get enableTpu(): boolean | cdktf.IResolvable;
    set enableTpu(value: boolean | cdktf.IResolvable);
    resetEnableTpu(): void;
    get enableTpuInput(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialNodeCount?;
    get initialNodeCount(): number;
    set initialNodeCount(value: number);
    resetInitialNodeCount(): void;
    get initialNodeCountInput(): number | undefined;
    get labelFingerprint(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _loggingService?;
    get loggingService(): string;
    set loggingService(value: string);
    resetLoggingService(): void;
    get loggingServiceInput(): string | undefined;
    get masterVersion(): string;
    private _minMasterVersion?;
    get minMasterVersion(): string;
    set minMasterVersion(value: string);
    resetMinMasterVersion(): void;
    get minMasterVersionInput(): string | undefined;
    private _monitoringService?;
    get monitoringService(): string;
    set monitoringService(value: string);
    resetMonitoringService(): void;
    get monitoringServiceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkingMode?;
    get networkingMode(): string;
    set networkingMode(value: string);
    resetNetworkingMode(): void;
    get networkingModeInput(): string | undefined;
    private _nodeLocations?;
    get nodeLocations(): string[];
    set nodeLocations(value: string[]);
    resetNodeLocations(): void;
    get nodeLocationsInput(): string[] | undefined;
    private _nodeVersion?;
    get nodeVersion(): string;
    set nodeVersion(value: string);
    resetNodeVersion(): void;
    get nodeVersionInput(): string | undefined;
    get operation(): string;
    private _privateIpv6GoogleAccess?;
    get privateIpv6GoogleAccess(): string;
    set privateIpv6GoogleAccess(value: string);
    resetPrivateIpv6GoogleAccess(): void;
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _removeDefaultNodePool?;
    get removeDefaultNodePool(): boolean | cdktf.IResolvable;
    set removeDefaultNodePool(value: boolean | cdktf.IResolvable);
    resetRemoveDefaultNodePool(): void;
    get removeDefaultNodePoolInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceLabels?;
    get resourceLabels(): {
        [key: string]: string;
    };
    set resourceLabels(value: {
        [key: string]: string;
    });
    resetResourceLabels(): void;
    get resourceLabelsInput(): {
        [key: string]: string;
    } | undefined;
    get selfLink(): string;
    get servicesIpv4Cidr(): string;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    get tpuIpv4CidrBlock(): string;
    private _addonsConfig;
    get addonsConfig(): GoogleContainerClusterAddonsConfigOutputReference;
    putAddonsConfig(value: GoogleContainerClusterAddonsConfig): void;
    resetAddonsConfig(): void;
    get addonsConfigInput(): GoogleContainerClusterAddonsConfig | undefined;
    private _authenticatorGroupsConfig;
    get authenticatorGroupsConfig(): GoogleContainerClusterAuthenticatorGroupsConfigOutputReference;
    putAuthenticatorGroupsConfig(value: GoogleContainerClusterAuthenticatorGroupsConfig): void;
    resetAuthenticatorGroupsConfig(): void;
    get authenticatorGroupsConfigInput(): GoogleContainerClusterAuthenticatorGroupsConfig | undefined;
    private _binaryAuthorization;
    get binaryAuthorization(): GoogleContainerClusterBinaryAuthorizationOutputReference;
    putBinaryAuthorization(value: GoogleContainerClusterBinaryAuthorization): void;
    resetBinaryAuthorization(): void;
    get binaryAuthorizationInput(): GoogleContainerClusterBinaryAuthorization | undefined;
    private _clusterAutoscaling;
    get clusterAutoscaling(): GoogleContainerClusterClusterAutoscalingOutputReference;
    putClusterAutoscaling(value: GoogleContainerClusterClusterAutoscaling): void;
    resetClusterAutoscaling(): void;
    get clusterAutoscalingInput(): GoogleContainerClusterClusterAutoscaling | undefined;
    private _clusterTelemetry;
    get clusterTelemetry(): GoogleContainerClusterClusterTelemetryOutputReference;
    putClusterTelemetry(value: GoogleContainerClusterClusterTelemetry): void;
    resetClusterTelemetry(): void;
    get clusterTelemetryInput(): GoogleContainerClusterClusterTelemetry | undefined;
    private _confidentialNodes;
    get confidentialNodes(): GoogleContainerClusterConfidentialNodesOutputReference;
    putConfidentialNodes(value: GoogleContainerClusterConfidentialNodes): void;
    resetConfidentialNodes(): void;
    get confidentialNodesInput(): GoogleContainerClusterConfidentialNodes | undefined;
    private _costManagementConfig;
    get costManagementConfig(): GoogleContainerClusterCostManagementConfigOutputReference;
    putCostManagementConfig(value: GoogleContainerClusterCostManagementConfig): void;
    resetCostManagementConfig(): void;
    get costManagementConfigInput(): GoogleContainerClusterCostManagementConfig | undefined;
    private _databaseEncryption;
    get databaseEncryption(): GoogleContainerClusterDatabaseEncryptionOutputReference;
    putDatabaseEncryption(value: GoogleContainerClusterDatabaseEncryption): void;
    resetDatabaseEncryption(): void;
    get databaseEncryptionInput(): GoogleContainerClusterDatabaseEncryption | undefined;
    private _defaultSnatStatus;
    get defaultSnatStatus(): GoogleContainerClusterDefaultSnatStatusOutputReference;
    putDefaultSnatStatus(value: GoogleContainerClusterDefaultSnatStatus): void;
    resetDefaultSnatStatus(): void;
    get defaultSnatStatusInput(): GoogleContainerClusterDefaultSnatStatus | undefined;
    private _dnsConfig;
    get dnsConfig(): GoogleContainerClusterDnsConfigOutputReference;
    putDnsConfig(value: GoogleContainerClusterDnsConfig): void;
    resetDnsConfig(): void;
    get dnsConfigInput(): GoogleContainerClusterDnsConfig | undefined;
    private _identityServiceConfig;
    get identityServiceConfig(): GoogleContainerClusterIdentityServiceConfigOutputReference;
    putIdentityServiceConfig(value: GoogleContainerClusterIdentityServiceConfig): void;
    resetIdentityServiceConfig(): void;
    get identityServiceConfigInput(): GoogleContainerClusterIdentityServiceConfig | undefined;
    private _ipAllocationPolicy;
    get ipAllocationPolicy(): GoogleContainerClusterIpAllocationPolicyOutputReference;
    putIpAllocationPolicy(value: GoogleContainerClusterIpAllocationPolicy): void;
    resetIpAllocationPolicy(): void;
    get ipAllocationPolicyInput(): GoogleContainerClusterIpAllocationPolicy | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleContainerClusterLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleContainerClusterLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleContainerClusterLoggingConfig | undefined;
    private _maintenancePolicy;
    get maintenancePolicy(): GoogleContainerClusterMaintenancePolicyOutputReference;
    putMaintenancePolicy(value: GoogleContainerClusterMaintenancePolicy): void;
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): GoogleContainerClusterMaintenancePolicy | undefined;
    private _masterAuth;
    get masterAuth(): GoogleContainerClusterMasterAuthOutputReference;
    putMasterAuth(value: GoogleContainerClusterMasterAuth): void;
    resetMasterAuth(): void;
    get masterAuthInput(): GoogleContainerClusterMasterAuth | undefined;
    private _masterAuthorizedNetworksConfig;
    get masterAuthorizedNetworksConfig(): GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference;
    putMasterAuthorizedNetworksConfig(value: GoogleContainerClusterMasterAuthorizedNetworksConfig): void;
    resetMasterAuthorizedNetworksConfig(): void;
    get masterAuthorizedNetworksConfigInput(): GoogleContainerClusterMasterAuthorizedNetworksConfig | undefined;
    private _meshCertificates;
    get meshCertificates(): GoogleContainerClusterMeshCertificatesOutputReference;
    putMeshCertificates(value: GoogleContainerClusterMeshCertificates): void;
    resetMeshCertificates(): void;
    get meshCertificatesInput(): GoogleContainerClusterMeshCertificates | undefined;
    private _monitoringConfig;
    get monitoringConfig(): GoogleContainerClusterMonitoringConfigOutputReference;
    putMonitoringConfig(value: GoogleContainerClusterMonitoringConfig): void;
    resetMonitoringConfig(): void;
    get monitoringConfigInput(): GoogleContainerClusterMonitoringConfig | undefined;
    private _networkPolicy;
    get networkPolicy(): GoogleContainerClusterNetworkPolicyOutputReference;
    putNetworkPolicy(value: GoogleContainerClusterNetworkPolicy): void;
    resetNetworkPolicy(): void;
    get networkPolicyInput(): GoogleContainerClusterNetworkPolicy | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleContainerClusterNodeConfigOutputReference;
    putNodeConfig(value: GoogleContainerClusterNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): GoogleContainerClusterNodeConfig | undefined;
    private _nodePool;
    get nodePool(): GoogleContainerClusterNodePoolList;
    putNodePool(value: GoogleContainerClusterNodePool[] | cdktf.IResolvable): void;
    resetNodePool(): void;
    get nodePoolInput(): cdktf.IResolvable | GoogleContainerClusterNodePool[] | undefined;
    private _nodePoolAutoConfig;
    get nodePoolAutoConfig(): GoogleContainerClusterNodePoolAutoConfigOutputReference;
    putNodePoolAutoConfig(value: GoogleContainerClusterNodePoolAutoConfig): void;
    resetNodePoolAutoConfig(): void;
    get nodePoolAutoConfigInput(): GoogleContainerClusterNodePoolAutoConfig | undefined;
    private _nodePoolDefaults;
    get nodePoolDefaults(): GoogleContainerClusterNodePoolDefaultsOutputReference;
    putNodePoolDefaults(value: GoogleContainerClusterNodePoolDefaults): void;
    resetNodePoolDefaults(): void;
    get nodePoolDefaultsInput(): GoogleContainerClusterNodePoolDefaults | undefined;
    private _notificationConfig;
    get notificationConfig(): GoogleContainerClusterNotificationConfigOutputReference;
    putNotificationConfig(value: GoogleContainerClusterNotificationConfig): void;
    resetNotificationConfig(): void;
    get notificationConfigInput(): GoogleContainerClusterNotificationConfig | undefined;
    private _podSecurityPolicyConfig;
    get podSecurityPolicyConfig(): GoogleContainerClusterPodSecurityPolicyConfigOutputReference;
    putPodSecurityPolicyConfig(value: GoogleContainerClusterPodSecurityPolicyConfig): void;
    resetPodSecurityPolicyConfig(): void;
    get podSecurityPolicyConfigInput(): GoogleContainerClusterPodSecurityPolicyConfig | undefined;
    private _privateClusterConfig;
    get privateClusterConfig(): GoogleContainerClusterPrivateClusterConfigOutputReference;
    putPrivateClusterConfig(value: GoogleContainerClusterPrivateClusterConfig): void;
    resetPrivateClusterConfig(): void;
    get privateClusterConfigInput(): GoogleContainerClusterPrivateClusterConfig | undefined;
    private _releaseChannel;
    get releaseChannel(): GoogleContainerClusterReleaseChannelOutputReference;
    putReleaseChannel(value: GoogleContainerClusterReleaseChannel): void;
    resetReleaseChannel(): void;
    get releaseChannelInput(): GoogleContainerClusterReleaseChannel | undefined;
    private _resourceUsageExportConfig;
    get resourceUsageExportConfig(): GoogleContainerClusterResourceUsageExportConfigOutputReference;
    putResourceUsageExportConfig(value: GoogleContainerClusterResourceUsageExportConfig): void;
    resetResourceUsageExportConfig(): void;
    get resourceUsageExportConfigInput(): GoogleContainerClusterResourceUsageExportConfig | undefined;
    private _serviceExternalIpsConfig;
    get serviceExternalIpsConfig(): GoogleContainerClusterServiceExternalIpsConfigOutputReference;
    putServiceExternalIpsConfig(value: GoogleContainerClusterServiceExternalIpsConfig): void;
    resetServiceExternalIpsConfig(): void;
    get serviceExternalIpsConfigInput(): GoogleContainerClusterServiceExternalIpsConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleContainerClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerClusterTimeouts | undefined;
    private _tpuConfig;
    get tpuConfig(): GoogleContainerClusterTpuConfigOutputReference;
    putTpuConfig(value: GoogleContainerClusterTpuConfig): void;
    resetTpuConfig(): void;
    get tpuConfigInput(): GoogleContainerClusterTpuConfig | undefined;
    private _verticalPodAutoscaling;
    get verticalPodAutoscaling(): GoogleContainerClusterVerticalPodAutoscalingOutputReference;
    putVerticalPodAutoscaling(value: GoogleContainerClusterVerticalPodAutoscaling): void;
    resetVerticalPodAutoscaling(): void;
    get verticalPodAutoscalingInput(): GoogleContainerClusterVerticalPodAutoscaling | undefined;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): GoogleContainerClusterWorkloadIdentityConfigOutputReference;
    putWorkloadIdentityConfig(value: GoogleContainerClusterWorkloadIdentityConfig): void;
    resetWorkloadIdentityConfig(): void;
    get workloadIdentityConfigInput(): GoogleContainerClusterWorkloadIdentityConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
