import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * The cluster to create the node pool for. Cluster must be present in location provided for zonal clusters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#cluster GoogleContainerNodePool#cluster}
    */
    readonly cluster: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#id GoogleContainerNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The initial number of nodes for the pool. In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#initial_node_count GoogleContainerNodePool#initial_node_count}
    */
    readonly initialNodeCount?: number;
    /**
    * The location (region or zone) of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#location GoogleContainerNodePool#location}
    */
    readonly location?: string;
    /**
    * The maximum number of pods per node in this node pool. Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#max_pods_per_node GoogleContainerNodePool#max_pods_per_node}
    */
    readonly maxPodsPerNode?: number;
    /**
    * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#name GoogleContainerNodePool#name}
    */
    readonly name?: string;
    /**
    * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#name_prefix GoogleContainerNodePool#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * The number of nodes per instance group. This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#node_count GoogleContainerNodePool#node_count}
    */
    readonly nodeCount?: number;
    /**
    * The list of zones in which the node pool's nodes should be located. Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#node_locations GoogleContainerNodePool#node_locations}
    */
    readonly nodeLocations?: string[];
    /**
    * The ID of the project in which to create the node pool. If blank, the provider-configured project will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#project GoogleContainerNodePool#project}
    */
    readonly project?: string;
    /**
    * The Kubernetes version for the nodes in this pool. Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#version GoogleContainerNodePool#version}
    */
    readonly version?: string;
    /**
    * autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#autoscaling GoogleContainerNodePool#autoscaling}
    */
    readonly autoscaling?: GoogleContainerNodePoolAutoscaling;
    /**
    * management block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#management GoogleContainerNodePool#management}
    */
    readonly management?: GoogleContainerNodePoolManagement;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#network_config GoogleContainerNodePool#network_config}
    */
    readonly networkConfig?: GoogleContainerNodePoolNetworkConfig;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#node_config GoogleContainerNodePool#node_config}
    */
    readonly nodeConfig?: GoogleContainerNodePoolNodeConfig;
    /**
    * placement_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#placement_policy GoogleContainerNodePool#placement_policy}
    */
    readonly placementPolicy?: GoogleContainerNodePoolPlacementPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#timeouts GoogleContainerNodePool#timeouts}
    */
    readonly timeouts?: GoogleContainerNodePoolTimeouts;
    /**
    * upgrade_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#upgrade_settings GoogleContainerNodePool#upgrade_settings}
    */
    readonly upgradeSettings?: GoogleContainerNodePoolUpgradeSettings;
}
export interface GoogleContainerNodePoolAutoscaling {
    /**
    * Location policy specifies the algorithm used when scaling-up the node pool. "BALANCED" - Is a best effort policy that aims to balance the sizes of available zones. "ANY" - Instructs the cluster autoscaler to prioritize utilization of unused reservations, and reduces preemption risk for Spot VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#location_policy GoogleContainerNodePool#location_policy}
    */
    readonly locationPolicy?: string;
    /**
    * Maximum number of nodes per zone in the node pool. Must be >= min_node_count. Cannot be used with total limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#max_node_count GoogleContainerNodePool#max_node_count}
    */
    readonly maxNodeCount?: number;
    /**
    * Minimum number of nodes per zone in the node pool. Must be >=0 and <= max_node_count. Cannot be used with total limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#min_node_count GoogleContainerNodePool#min_node_count}
    */
    readonly minNodeCount?: number;
    /**
    * Maximum number of all nodes in the node pool. Must be >= total_min_node_count. Cannot be used with per zone limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#total_max_node_count GoogleContainerNodePool#total_max_node_count}
    */
    readonly totalMaxNodeCount?: number;
    /**
    * Minimum number of all nodes in the node pool. Must be >=0 and <= total_max_node_count. Cannot be used with per zone limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#total_min_node_count GoogleContainerNodePool#total_min_node_count}
    */
    readonly totalMinNodeCount?: number;
}
export declare function googleContainerNodePoolAutoscalingToTerraform(struct?: GoogleContainerNodePoolAutoscalingOutputReference | GoogleContainerNodePoolAutoscaling): any;
export declare class GoogleContainerNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolAutoscaling | undefined;
    set internalValue(value: GoogleContainerNodePoolAutoscaling | undefined);
    private _locationPolicy?;
    get locationPolicy(): string;
    set locationPolicy(value: string);
    resetLocationPolicy(): void;
    get locationPolicyInput(): string | undefined;
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    resetMaxNodeCount(): void;
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    resetMinNodeCount(): void;
    get minNodeCountInput(): number | undefined;
    private _totalMaxNodeCount?;
    get totalMaxNodeCount(): number;
    set totalMaxNodeCount(value: number);
    resetTotalMaxNodeCount(): void;
    get totalMaxNodeCountInput(): number | undefined;
    private _totalMinNodeCount?;
    get totalMinNodeCount(): number;
    set totalMinNodeCount(value: number);
    resetTotalMinNodeCount(): void;
    get totalMinNodeCountInput(): number | undefined;
}
export interface GoogleContainerNodePoolManagement {
    /**
    * Whether the nodes will be automatically repaired.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#auto_repair GoogleContainerNodePool#auto_repair}
    */
    readonly autoRepair?: boolean | cdktf.IResolvable;
    /**
    * Whether the nodes will be automatically upgraded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#auto_upgrade GoogleContainerNodePool#auto_upgrade}
    */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
}
export declare function googleContainerNodePoolManagementToTerraform(struct?: GoogleContainerNodePoolManagementOutputReference | GoogleContainerNodePoolManagement): any;
export declare class GoogleContainerNodePoolManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolManagement | undefined;
    set internalValue(value: GoogleContainerNodePoolManagement | undefined);
    private _autoRepair?;
    get autoRepair(): boolean | cdktf.IResolvable;
    set autoRepair(value: boolean | cdktf.IResolvable);
    resetAutoRepair(): void;
    get autoRepairInput(): boolean | cdktf.IResolvable | undefined;
    private _autoUpgrade?;
    get autoUpgrade(): boolean | cdktf.IResolvable;
    set autoUpgrade(value: boolean | cdktf.IResolvable);
    resetAutoUpgrade(): void;
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerNodePoolNetworkConfig {
    /**
    * Whether to create a new range for pod IPs in this node pool. Defaults are provided for pod_range and pod_ipv4_cidr_block if they are not specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#create_pod_range GoogleContainerNodePool#create_pod_range}
    */
    readonly createPodRange?: boolean | cdktf.IResolvable;
    /**
    * The IP address range for pod IPs in this node pool. Only applicable if create_pod_range is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) to pick a specific range to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#pod_ipv4_cidr_block GoogleContainerNodePool#pod_ipv4_cidr_block}
    */
    readonly podIpv4CidrBlock?: string;
    /**
    * The ID of the secondary range for pod IPs. If create_pod_range is true, this ID is used for the new range. If create_pod_range is false, uses an existing secondary range with this ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#pod_range GoogleContainerNodePool#pod_range}
    */
    readonly podRange: string;
}
export declare function googleContainerNodePoolNetworkConfigToTerraform(struct?: GoogleContainerNodePoolNetworkConfigOutputReference | GoogleContainerNodePoolNetworkConfig): any;
export declare class GoogleContainerNodePoolNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNetworkConfig | undefined;
    set internalValue(value: GoogleContainerNodePoolNetworkConfig | undefined);
    private _createPodRange?;
    get createPodRange(): boolean | cdktf.IResolvable;
    set createPodRange(value: boolean | cdktf.IResolvable);
    resetCreatePodRange(): void;
    get createPodRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _podIpv4CidrBlock?;
    get podIpv4CidrBlock(): string;
    set podIpv4CidrBlock(value: string);
    resetPodIpv4CidrBlock(): void;
    get podIpv4CidrBlockInput(): string | undefined;
    private _podRange?;
    get podRange(): string;
    set podRange(value: string);
    get podRangeInput(): string | undefined;
}
export interface GoogleContainerNodePoolNodeConfigGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#count GoogleContainerNodePool#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#gpu_partition_size GoogleContainerNodePool#gpu_partition_size}
    */
    readonly gpuPartitionSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#type GoogleContainerNodePool#type}
    */
    readonly type?: string;
}
export declare function googleContainerNodePoolNodeConfigGuestAcceleratorToTerraform(struct?: GoogleContainerNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable): any;
export declare class GoogleContainerNodePoolNodeConfigGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _gpuPartitionSize?;
    get gpuPartitionSize(): string;
    set gpuPartitionSize(value: string);
    resetGpuPartitionSize(): void;
    get gpuPartitionSizeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleContainerNodePoolNodeConfigGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerNodePoolNodeConfigGuestAcceleratorOutputReference;
}
export interface GoogleContainerNodePoolNodeConfigTaint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#effect GoogleContainerNodePool#effect}
    */
    readonly effect?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#key GoogleContainerNodePool#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#value GoogleContainerNodePool#value}
    */
    readonly value?: string;
}
export declare function googleContainerNodePoolNodeConfigTaintToTerraform(struct?: GoogleContainerNodePoolNodeConfigTaint | cdktf.IResolvable): any;
export declare class GoogleContainerNodePoolNodeConfigTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerNodePoolNodeConfigTaint | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleContainerNodePoolNodeConfigTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerNodePoolNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerNodePoolNodeConfigTaintOutputReference;
}
export interface GoogleContainerNodePoolNodeConfigEphemeralStorageConfig {
    /**
    * Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD is 375 GB in size.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#local_ssd_count GoogleContainerNodePool#local_ssd_count}
    */
    readonly localSsdCount: number;
}
export declare function googleContainerNodePoolNodeConfigEphemeralStorageConfigToTerraform(struct?: GoogleContainerNodePoolNodeConfigEphemeralStorageConfigOutputReference | GoogleContainerNodePoolNodeConfigEphemeralStorageConfig): any;
export declare class GoogleContainerNodePoolNodeConfigEphemeralStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNodeConfigEphemeralStorageConfig | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigEphemeralStorageConfig | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    get localSsdCountInput(): number | undefined;
}
export interface GoogleContainerNodePoolNodeConfigGcfsConfig {
    /**
    * Whether or not GCFS is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#enabled GoogleContainerNodePool#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerNodePoolNodeConfigGcfsConfigToTerraform(struct?: GoogleContainerNodePoolNodeConfigGcfsConfigOutputReference | GoogleContainerNodePoolNodeConfigGcfsConfig): any;
export declare class GoogleContainerNodePoolNodeConfigGcfsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNodeConfigGcfsConfig | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigGcfsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerNodePoolNodeConfigGvnic {
    /**
    * Whether or not gvnic is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#enabled GoogleContainerNodePool#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerNodePoolNodeConfigGvnicToTerraform(struct?: GoogleContainerNodePoolNodeConfigGvnicOutputReference | GoogleContainerNodePoolNodeConfigGvnic): any;
export declare class GoogleContainerNodePoolNodeConfigGvnicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNodeConfigGvnic | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigGvnic | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerNodePoolNodeConfigKubeletConfig {
    /**
    * Enable CPU CFS quota enforcement for containers that specify CPU limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#cpu_cfs_quota GoogleContainerNodePool#cpu_cfs_quota}
    */
    readonly cpuCfsQuota?: boolean | cdktf.IResolvable;
    /**
    * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#cpu_cfs_quota_period GoogleContainerNodePool#cpu_cfs_quota_period}
    */
    readonly cpuCfsQuotaPeriod?: string;
    /**
    * Control the CPU management policy on the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#cpu_manager_policy GoogleContainerNodePool#cpu_manager_policy}
    */
    readonly cpuManagerPolicy: string;
}
export declare function googleContainerNodePoolNodeConfigKubeletConfigToTerraform(struct?: GoogleContainerNodePoolNodeConfigKubeletConfigOutputReference | GoogleContainerNodePoolNodeConfigKubeletConfig): any;
export declare class GoogleContainerNodePoolNodeConfigKubeletConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNodeConfigKubeletConfig | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigKubeletConfig | undefined);
    private _cpuCfsQuota?;
    get cpuCfsQuota(): boolean | cdktf.IResolvable;
    set cpuCfsQuota(value: boolean | cdktf.IResolvable);
    resetCpuCfsQuota(): void;
    get cpuCfsQuotaInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuCfsQuotaPeriod?;
    get cpuCfsQuotaPeriod(): string;
    set cpuCfsQuotaPeriod(value: string);
    resetCpuCfsQuotaPeriod(): void;
    get cpuCfsQuotaPeriodInput(): string | undefined;
    private _cpuManagerPolicy?;
    get cpuManagerPolicy(): string;
    set cpuManagerPolicy(value: string);
    get cpuManagerPolicyInput(): string | undefined;
}
export interface GoogleContainerNodePoolNodeConfigLinuxNodeConfig {
    /**
    * The Linux kernel parameters to be applied to the nodes and all pods running on the nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#sysctls GoogleContainerNodePool#sysctls}
    */
    readonly sysctls: {
        [key: string]: string;
    };
}
export declare function googleContainerNodePoolNodeConfigLinuxNodeConfigToTerraform(struct?: GoogleContainerNodePoolNodeConfigLinuxNodeConfigOutputReference | GoogleContainerNodePoolNodeConfigLinuxNodeConfig): any;
export declare class GoogleContainerNodePoolNodeConfigLinuxNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNodeConfigLinuxNodeConfig | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigLinuxNodeConfig | undefined);
    private _sysctls?;
    get sysctls(): {
        [key: string]: string;
    };
    set sysctls(value: {
        [key: string]: string;
    });
    get sysctlsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleContainerNodePoolNodeConfigReservationAffinity {
    /**
    * Corresponds to the type of reservation consumption.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#consume_reservation_type GoogleContainerNodePool#consume_reservation_type}
    */
    readonly consumeReservationType: string;
    /**
    * The label key of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#key GoogleContainerNodePool#key}
    */
    readonly key?: string;
    /**
    * The label values of the reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#values GoogleContainerNodePool#values}
    */
    readonly values?: string[];
}
export declare function googleContainerNodePoolNodeConfigReservationAffinityToTerraform(struct?: GoogleContainerNodePoolNodeConfigReservationAffinityOutputReference | GoogleContainerNodePoolNodeConfigReservationAffinity): any;
export declare class GoogleContainerNodePoolNodeConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNodeConfigReservationAffinity | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleContainerNodePoolNodeConfigSandboxConfig {
    /**
    * Type of the sandbox to use for the node (e.g. 'gvisor')
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#sandbox_type GoogleContainerNodePool#sandbox_type}
    */
    readonly sandboxType: string;
}
export declare function googleContainerNodePoolNodeConfigSandboxConfigToTerraform(struct?: GoogleContainerNodePoolNodeConfigSandboxConfigOutputReference | GoogleContainerNodePoolNodeConfigSandboxConfig): any;
export declare class GoogleContainerNodePoolNodeConfigSandboxConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNodeConfigSandboxConfig | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigSandboxConfig | undefined);
    private _sandboxType?;
    get sandboxType(): string;
    set sandboxType(value: string);
    get sandboxTypeInput(): string | undefined;
}
export interface GoogleContainerNodePoolNodeConfigShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#enable_integrity_monitoring GoogleContainerNodePool#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#enable_secure_boot GoogleContainerNodePool#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function googleContainerNodePoolNodeConfigShieldedInstanceConfigToTerraform(struct?: GoogleContainerNodePoolNodeConfigShieldedInstanceConfigOutputReference | GoogleContainerNodePoolNodeConfigShieldedInstanceConfig): any;
export declare class GoogleContainerNodePoolNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNodeConfigShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerNodePoolNodeConfigWorkloadMetadataConfig {
    /**
    * Mode is the configuration for how to expose metadata to workloads running on the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#mode GoogleContainerNodePool#mode}
    */
    readonly mode: string;
}
export declare function googleContainerNodePoolNodeConfigWorkloadMetadataConfigToTerraform(struct?: GoogleContainerNodePoolNodeConfigWorkloadMetadataConfigOutputReference | GoogleContainerNodePoolNodeConfigWorkloadMetadataConfig): any;
export declare class GoogleContainerNodePoolNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNodeConfigWorkloadMetadataConfig | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfigWorkloadMetadataConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface GoogleContainerNodePoolNodeConfig {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#boot_disk_kms_key GoogleContainerNodePool#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#disk_size_gb GoogleContainerNodePool#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#disk_type GoogleContainerNodePool#disk_type}
    */
    readonly diskType?: string;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#guest_accelerator GoogleContainerNodePool#guest_accelerator}
    */
    readonly guestAccelerator?: GoogleContainerNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * The image type to use for this node. Note that for a given image type, the latest version of it will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#image_type GoogleContainerNodePool#image_type}
    */
    readonly imageType?: string;
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#labels GoogleContainerNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The number of local SSD disks to be attached to the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#local_ssd_count GoogleContainerNodePool#local_ssd_count}
    */
    readonly localSsdCount?: number;
    /**
    * The name of a Google Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#machine_type GoogleContainerNodePool#machine_type}
    */
    readonly machineType?: string;
    /**
    * The metadata key/value pairs assigned to instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#metadata GoogleContainerNodePool#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#min_cpu_platform GoogleContainerNodePool#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on sole tenant nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#node_group GoogleContainerNodePool#node_group}
    */
    readonly nodeGroup?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#oauth_scopes GoogleContainerNodePool#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * Whether the nodes are created as preemptible VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#preemptible GoogleContainerNodePool#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#service_account GoogleContainerNodePool#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Whether the nodes are created as spot VM instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#spot GoogleContainerNodePool#spot}
    */
    readonly spot?: boolean | cdktf.IResolvable;
    /**
    * The list of instance tags applied to all nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#tags GoogleContainerNodePool#tags}
    */
    readonly tags?: string[];
    /**
    * List of Kubernetes taints to be applied to each node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#taint GoogleContainerNodePool#taint}
    */
    readonly taint?: GoogleContainerNodePoolNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * ephemeral_storage_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#ephemeral_storage_config GoogleContainerNodePool#ephemeral_storage_config}
    */
    readonly ephemeralStorageConfig?: GoogleContainerNodePoolNodeConfigEphemeralStorageConfig;
    /**
    * gcfs_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#gcfs_config GoogleContainerNodePool#gcfs_config}
    */
    readonly gcfsConfig?: GoogleContainerNodePoolNodeConfigGcfsConfig;
    /**
    * gvnic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#gvnic GoogleContainerNodePool#gvnic}
    */
    readonly gvnic?: GoogleContainerNodePoolNodeConfigGvnic;
    /**
    * kubelet_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#kubelet_config GoogleContainerNodePool#kubelet_config}
    */
    readonly kubeletConfig?: GoogleContainerNodePoolNodeConfigKubeletConfig;
    /**
    * linux_node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#linux_node_config GoogleContainerNodePool#linux_node_config}
    */
    readonly linuxNodeConfig?: GoogleContainerNodePoolNodeConfigLinuxNodeConfig;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#reservation_affinity GoogleContainerNodePool#reservation_affinity}
    */
    readonly reservationAffinity?: GoogleContainerNodePoolNodeConfigReservationAffinity;
    /**
    * sandbox_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#sandbox_config GoogleContainerNodePool#sandbox_config}
    */
    readonly sandboxConfig?: GoogleContainerNodePoolNodeConfigSandboxConfig;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#shielded_instance_config GoogleContainerNodePool#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleContainerNodePoolNodeConfigShieldedInstanceConfig;
    /**
    * workload_metadata_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#workload_metadata_config GoogleContainerNodePool#workload_metadata_config}
    */
    readonly workloadMetadataConfig?: GoogleContainerNodePoolNodeConfigWorkloadMetadataConfig;
}
export declare function googleContainerNodePoolNodeConfigToTerraform(struct?: GoogleContainerNodePoolNodeConfigOutputReference | GoogleContainerNodePoolNodeConfig): any;
export declare class GoogleContainerNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolNodeConfig | undefined;
    set internalValue(value: GoogleContainerNodePoolNodeConfig | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _guestAccelerator;
    get guestAccelerator(): GoogleContainerNodePoolNodeConfigGuestAcceleratorList;
    putGuestAccelerator(value: GoogleContainerNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | GoogleContainerNodePoolNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    resetNodeGroup(): void;
    get nodeGroupInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _spot?;
    get spot(): boolean | cdktf.IResolvable;
    set spot(value: boolean | cdktf.IResolvable);
    resetSpot(): void;
    get spotInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _taint;
    get taint(): GoogleContainerNodePoolNodeConfigTaintList;
    putTaint(value: GoogleContainerNodePoolNodeConfigTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | GoogleContainerNodePoolNodeConfigTaint[] | undefined;
    private _ephemeralStorageConfig;
    get ephemeralStorageConfig(): GoogleContainerNodePoolNodeConfigEphemeralStorageConfigOutputReference;
    putEphemeralStorageConfig(value: GoogleContainerNodePoolNodeConfigEphemeralStorageConfig): void;
    resetEphemeralStorageConfig(): void;
    get ephemeralStorageConfigInput(): GoogleContainerNodePoolNodeConfigEphemeralStorageConfig | undefined;
    private _gcfsConfig;
    get gcfsConfig(): GoogleContainerNodePoolNodeConfigGcfsConfigOutputReference;
    putGcfsConfig(value: GoogleContainerNodePoolNodeConfigGcfsConfig): void;
    resetGcfsConfig(): void;
    get gcfsConfigInput(): GoogleContainerNodePoolNodeConfigGcfsConfig | undefined;
    private _gvnic;
    get gvnic(): GoogleContainerNodePoolNodeConfigGvnicOutputReference;
    putGvnic(value: GoogleContainerNodePoolNodeConfigGvnic): void;
    resetGvnic(): void;
    get gvnicInput(): GoogleContainerNodePoolNodeConfigGvnic | undefined;
    private _kubeletConfig;
    get kubeletConfig(): GoogleContainerNodePoolNodeConfigKubeletConfigOutputReference;
    putKubeletConfig(value: GoogleContainerNodePoolNodeConfigKubeletConfig): void;
    resetKubeletConfig(): void;
    get kubeletConfigInput(): GoogleContainerNodePoolNodeConfigKubeletConfig | undefined;
    private _linuxNodeConfig;
    get linuxNodeConfig(): GoogleContainerNodePoolNodeConfigLinuxNodeConfigOutputReference;
    putLinuxNodeConfig(value: GoogleContainerNodePoolNodeConfigLinuxNodeConfig): void;
    resetLinuxNodeConfig(): void;
    get linuxNodeConfigInput(): GoogleContainerNodePoolNodeConfigLinuxNodeConfig | undefined;
    private _reservationAffinity;
    get reservationAffinity(): GoogleContainerNodePoolNodeConfigReservationAffinityOutputReference;
    putReservationAffinity(value: GoogleContainerNodePoolNodeConfigReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): GoogleContainerNodePoolNodeConfigReservationAffinity | undefined;
    private _sandboxConfig;
    get sandboxConfig(): GoogleContainerNodePoolNodeConfigSandboxConfigOutputReference;
    putSandboxConfig(value: GoogleContainerNodePoolNodeConfigSandboxConfig): void;
    resetSandboxConfig(): void;
    get sandboxConfigInput(): GoogleContainerNodePoolNodeConfigSandboxConfig | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleContainerNodePoolNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleContainerNodePoolNodeConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleContainerNodePoolNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig;
    get workloadMetadataConfig(): GoogleContainerNodePoolNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: GoogleContainerNodePoolNodeConfigWorkloadMetadataConfig): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): GoogleContainerNodePoolNodeConfigWorkloadMetadataConfig | undefined;
}
export interface GoogleContainerNodePoolPlacementPolicy {
    /**
    * Type defines the type of placement policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#type GoogleContainerNodePool#type}
    */
    readonly type: string;
}
export declare function googleContainerNodePoolPlacementPolicyToTerraform(struct?: GoogleContainerNodePoolPlacementPolicyOutputReference | GoogleContainerNodePoolPlacementPolicy): any;
export declare class GoogleContainerNodePoolPlacementPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolPlacementPolicy | undefined;
    set internalValue(value: GoogleContainerNodePoolPlacementPolicy | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleContainerNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#create GoogleContainerNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#delete GoogleContainerNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#update GoogleContainerNodePool#update}
    */
    readonly update?: string;
}
export declare function googleContainerNodePoolTimeoutsToTerraform(struct?: GoogleContainerNodePoolTimeoutsOutputReference | GoogleContainerNodePoolTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleContainerNodePoolUpgradeSettings {
    /**
    * The number of additional nodes that can be added to the node pool during an upgrade. Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#max_surge GoogleContainerNodePool#max_surge}
    */
    readonly maxSurge: number;
    /**
    * The number of nodes that can be simultaneously unavailable during an upgrade. Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool#max_unavailable GoogleContainerNodePool#max_unavailable}
    */
    readonly maxUnavailable: number;
}
export declare function googleContainerNodePoolUpgradeSettingsToTerraform(struct?: GoogleContainerNodePoolUpgradeSettingsOutputReference | GoogleContainerNodePoolUpgradeSettings): any;
export declare class GoogleContainerNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerNodePoolUpgradeSettings | undefined;
    set internalValue(value: GoogleContainerNodePoolUpgradeSettings | undefined);
    private _maxSurge?;
    get maxSurge(): number;
    set maxSurge(value: number);
    get maxSurgeInput(): number | undefined;
    private _maxUnavailable?;
    get maxUnavailable(): number;
    set maxUnavailable(value: number);
    get maxUnavailableInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool google_container_node_pool}
*/
export declare class GoogleContainerNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_node_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_node_pool google_container_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerNodePoolConfig);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialNodeCount?;
    get initialNodeCount(): number;
    set initialNodeCount(value: number);
    resetInitialNodeCount(): void;
    get initialNodeCountInput(): number | undefined;
    get instanceGroupUrls(): string[];
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get managedInstanceGroupUrls(): string[];
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    resetMaxPodsPerNode(): void;
    get maxPodsPerNodeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeLocations?;
    get nodeLocations(): string[];
    set nodeLocations(value: string[]);
    resetNodeLocations(): void;
    get nodeLocationsInput(): string[] | undefined;
    get operation(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _autoscaling;
    get autoscaling(): GoogleContainerNodePoolAutoscalingOutputReference;
    putAutoscaling(value: GoogleContainerNodePoolAutoscaling): void;
    resetAutoscaling(): void;
    get autoscalingInput(): GoogleContainerNodePoolAutoscaling | undefined;
    private _management;
    get management(): GoogleContainerNodePoolManagementOutputReference;
    putManagement(value: GoogleContainerNodePoolManagement): void;
    resetManagement(): void;
    get managementInput(): GoogleContainerNodePoolManagement | undefined;
    private _networkConfig;
    get networkConfig(): GoogleContainerNodePoolNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleContainerNodePoolNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): GoogleContainerNodePoolNetworkConfig | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleContainerNodePoolNodeConfigOutputReference;
    putNodeConfig(value: GoogleContainerNodePoolNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): GoogleContainerNodePoolNodeConfig | undefined;
    private _placementPolicy;
    get placementPolicy(): GoogleContainerNodePoolPlacementPolicyOutputReference;
    putPlacementPolicy(value: GoogleContainerNodePoolPlacementPolicy): void;
    resetPlacementPolicy(): void;
    get placementPolicyInput(): GoogleContainerNodePoolPlacementPolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleContainerNodePoolTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerNodePoolTimeouts | undefined;
    private _upgradeSettings;
    get upgradeSettings(): GoogleContainerNodePoolUpgradeSettingsOutputReference;
    putUpgradeSettings(value: GoogleContainerNodePoolUpgradeSettings): void;
    resetUpgradeSettings(): void;
    get upgradeSettingsInput(): GoogleContainerNodePoolUpgradeSettings | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
