import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_registry#id GoogleContainerRegistry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the registry. One of ASIA, EU, US or not specified. See the official documentation for more information on registry locations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_registry#location GoogleContainerRegistry#location}
    */
    readonly location?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_registry#project GoogleContainerRegistry#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_registry google_container_registry}
*/
export declare class GoogleContainerRegistry extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_registry";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_container_registry google_container_registry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerRegistryConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleContainerRegistryConfig);
    get bucketSelfLink(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
