import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataCatalogEntryGroupIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding#entry_group GoogleDataCatalogEntryGroupIamBinding#entry_group}
    */
    readonly entryGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding#id GoogleDataCatalogEntryGroupIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding#members GoogleDataCatalogEntryGroupIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding#project GoogleDataCatalogEntryGroupIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding#region GoogleDataCatalogEntryGroupIamBinding#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding#role GoogleDataCatalogEntryGroupIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding#condition GoogleDataCatalogEntryGroupIamBinding#condition}
    */
    readonly condition?: GoogleDataCatalogEntryGroupIamBindingCondition;
}
export interface GoogleDataCatalogEntryGroupIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding#description GoogleDataCatalogEntryGroupIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding#expression GoogleDataCatalogEntryGroupIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding#title GoogleDataCatalogEntryGroupIamBinding#title}
    */
    readonly title: string;
}
export declare function googleDataCatalogEntryGroupIamBindingConditionToTerraform(struct?: GoogleDataCatalogEntryGroupIamBindingConditionOutputReference | GoogleDataCatalogEntryGroupIamBindingCondition): any;
export declare class GoogleDataCatalogEntryGroupIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataCatalogEntryGroupIamBindingCondition | undefined;
    set internalValue(value: GoogleDataCatalogEntryGroupIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding google_data_catalog_entry_group_iam_binding}
*/
export declare class GoogleDataCatalogEntryGroupIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_entry_group_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_entry_group_iam_binding google_data_catalog_entry_group_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataCatalogEntryGroupIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataCatalogEntryGroupIamBindingConfig);
    private _entryGroup?;
    get entryGroup(): string;
    set entryGroup(value: string);
    get entryGroupInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleDataCatalogEntryGroupIamBindingConditionOutputReference;
    putCondition(value: GoogleDataCatalogEntryGroupIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleDataCatalogEntryGroupIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
