import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataCatalogTagTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name for this template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#display_name GoogleDataCatalogTagTemplate#display_name}
    */
    readonly displayName?: string;
    /**
    * This confirms the deletion of any possible tags using this template. Must be set to true in order to delete the tag template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#force_delete GoogleDataCatalogTagTemplate#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#id GoogleDataCatalogTagTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#project GoogleDataCatalogTagTemplate#project}
    */
    readonly project?: string;
    /**
    * Template location region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#region GoogleDataCatalogTagTemplate#region}
    */
    readonly region?: string;
    /**
    * The id of the tag template to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#tag_template_id GoogleDataCatalogTagTemplate#tag_template_id}
    */
    readonly tagTemplateId: string;
    /**
    * fields block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#fields GoogleDataCatalogTagTemplate#fields}
    */
    readonly fields: GoogleDataCatalogTagTemplateFields[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#timeouts GoogleDataCatalogTagTemplate#timeouts}
    */
    readonly timeouts?: GoogleDataCatalogTagTemplateTimeouts;
}
export interface GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues {
    /**
    * The display name of the enum value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#display_name GoogleDataCatalogTagTemplate#display_name}
    */
    readonly displayName: string;
}
export declare function googleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValuesToTerraform(struct?: GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues | cdktf.IResolvable): any;
export declare class GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
}
export declare class GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValuesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValuesOutputReference;
}
export interface GoogleDataCatalogTagTemplateFieldsTypeEnumType {
    /**
    * allowed_values block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#allowed_values GoogleDataCatalogTagTemplate#allowed_values}
    */
    readonly allowedValues: GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[] | cdktf.IResolvable;
}
export declare function googleDataCatalogTagTemplateFieldsTypeEnumTypeToTerraform(struct?: GoogleDataCatalogTagTemplateFieldsTypeEnumTypeOutputReference | GoogleDataCatalogTagTemplateFieldsTypeEnumType): any;
export declare class GoogleDataCatalogTagTemplateFieldsTypeEnumTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataCatalogTagTemplateFieldsTypeEnumType | undefined;
    set internalValue(value: GoogleDataCatalogTagTemplateFieldsTypeEnumType | undefined);
    private _allowedValues;
    get allowedValues(): GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValuesList;
    putAllowedValues(value: GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[] | cdktf.IResolvable): void;
    get allowedValuesInput(): cdktf.IResolvable | GoogleDataCatalogTagTemplateFieldsTypeEnumTypeAllowedValues[] | undefined;
}
export interface GoogleDataCatalogTagTemplateFieldsType {
    /**
    * Represents primitive types - string, bool etc.
   Exactly one of 'primitive_type' or 'enum_type' must be set Possible values: ["DOUBLE", "STRING", "BOOL", "TIMESTAMP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#primitive_type GoogleDataCatalogTagTemplate#primitive_type}
    */
    readonly primitiveType?: string;
    /**
    * enum_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#enum_type GoogleDataCatalogTagTemplate#enum_type}
    */
    readonly enumType?: GoogleDataCatalogTagTemplateFieldsTypeEnumType;
}
export declare function googleDataCatalogTagTemplateFieldsTypeToTerraform(struct?: GoogleDataCatalogTagTemplateFieldsTypeOutputReference | GoogleDataCatalogTagTemplateFieldsType): any;
export declare class GoogleDataCatalogTagTemplateFieldsTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataCatalogTagTemplateFieldsType | undefined;
    set internalValue(value: GoogleDataCatalogTagTemplateFieldsType | undefined);
    private _primitiveType?;
    get primitiveType(): string;
    set primitiveType(value: string);
    resetPrimitiveType(): void;
    get primitiveTypeInput(): string | undefined;
    private _enumType;
    get enumType(): GoogleDataCatalogTagTemplateFieldsTypeEnumTypeOutputReference;
    putEnumType(value: GoogleDataCatalogTagTemplateFieldsTypeEnumType): void;
    resetEnumType(): void;
    get enumTypeInput(): GoogleDataCatalogTagTemplateFieldsTypeEnumType | undefined;
}
export interface GoogleDataCatalogTagTemplateFields {
    /**
    * A description for this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#description GoogleDataCatalogTagTemplate#description}
    */
    readonly description?: string;
    /**
    * The display name for this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#display_name GoogleDataCatalogTagTemplate#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#field_id GoogleDataCatalogTagTemplate#field_id}
    */
    readonly fieldId: string;
    /**
    * Whether this is a required field. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#is_required GoogleDataCatalogTagTemplate#is_required}
    */
    readonly isRequired?: boolean | cdktf.IResolvable;
    /**
    * The order of this field with respect to other fields in this tag template.
  A higher value indicates a more important field. The value can be negative.
  Multiple fields can have the same order, and field orders within a tag do not have to be sequential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#order GoogleDataCatalogTagTemplate#order}
    */
    readonly order?: number;
    /**
    * type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#type GoogleDataCatalogTagTemplate#type}
    */
    readonly type: GoogleDataCatalogTagTemplateFieldsType;
}
export declare function googleDataCatalogTagTemplateFieldsToTerraform(struct?: GoogleDataCatalogTagTemplateFields | cdktf.IResolvable): any;
export declare class GoogleDataCatalogTagTemplateFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataCatalogTagTemplateFields | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataCatalogTagTemplateFields | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _fieldId?;
    get fieldId(): string;
    set fieldId(value: string);
    get fieldIdInput(): string | undefined;
    private _isRequired?;
    get isRequired(): boolean | cdktf.IResolvable;
    set isRequired(value: boolean | cdktf.IResolvable);
    resetIsRequired(): void;
    get isRequiredInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _order?;
    get order(): number;
    set order(value: number);
    resetOrder(): void;
    get orderInput(): number | undefined;
    private _type;
    get type(): GoogleDataCatalogTagTemplateFieldsTypeOutputReference;
    putType(value: GoogleDataCatalogTagTemplateFieldsType): void;
    get typeInput(): GoogleDataCatalogTagTemplateFieldsType | undefined;
}
export declare class GoogleDataCatalogTagTemplateFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataCatalogTagTemplateFields[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataCatalogTagTemplateFieldsOutputReference;
}
export interface GoogleDataCatalogTagTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#create GoogleDataCatalogTagTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#delete GoogleDataCatalogTagTemplate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template#update GoogleDataCatalogTagTemplate#update}
    */
    readonly update?: string;
}
export declare function googleDataCatalogTagTemplateTimeoutsToTerraform(struct?: GoogleDataCatalogTagTemplateTimeoutsOutputReference | GoogleDataCatalogTagTemplateTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataCatalogTagTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataCatalogTagTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataCatalogTagTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template google_data_catalog_tag_template}
*/
export declare class GoogleDataCatalogTagTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_tag_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_tag_template google_data_catalog_tag_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataCatalogTagTemplateConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataCatalogTagTemplateConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _forceDelete?;
    get forceDelete(): boolean | cdktf.IResolvable;
    set forceDelete(value: boolean | cdktf.IResolvable);
    resetForceDelete(): void;
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tagTemplateId?;
    get tagTemplateId(): string;
    set tagTemplateId(value: string);
    get tagTemplateIdInput(): string | undefined;
    private _fields;
    get fields(): GoogleDataCatalogTagTemplateFieldsList;
    putFields(value: GoogleDataCatalogTagTemplateFields[] | cdktf.IResolvable): void;
    get fieldsInput(): cdktf.IResolvable | GoogleDataCatalogTagTemplateFields[] | undefined;
    private _timeouts;
    get timeouts(): GoogleDataCatalogTagTemplateTimeoutsOutputReference;
    putTimeouts(value: GoogleDataCatalogTagTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataCatalogTagTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
