import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataCatalogTaxonomyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of policy types that are activated for this taxonomy. If not set,
  defaults to an empty list. Possible values: ["POLICY_TYPE_UNSPECIFIED", "FINE_GRAINED_ACCESS_CONTROL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy#activated_policy_types GoogleDataCatalogTaxonomy#activated_policy_types}
    */
    readonly activatedPolicyTypes?: string[];
    /**
    * Description of this taxonomy. It must: contain only unicode characters,
  tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
  long when encoded in UTF-8. If not set, defaults to an empty description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy#description GoogleDataCatalogTaxonomy#description}
    */
    readonly description?: string;
    /**
    * User defined name of this taxonomy.
  It must: contain only unicode letters, numbers, underscores, dashes
  and spaces; not start or end with spaces; and be at most 200 bytes
  long when encoded in UTF-8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy#display_name GoogleDataCatalogTaxonomy#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy#id GoogleDataCatalogTaxonomy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy#project GoogleDataCatalogTaxonomy#project}
    */
    readonly project?: string;
    /**
    * Taxonomy location region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy#region GoogleDataCatalogTaxonomy#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy#timeouts GoogleDataCatalogTaxonomy#timeouts}
    */
    readonly timeouts?: GoogleDataCatalogTaxonomyTimeouts;
}
export interface GoogleDataCatalogTaxonomyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy#create GoogleDataCatalogTaxonomy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy#delete GoogleDataCatalogTaxonomy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy#update GoogleDataCatalogTaxonomy#update}
    */
    readonly update?: string;
}
export declare function googleDataCatalogTaxonomyTimeoutsToTerraform(struct?: GoogleDataCatalogTaxonomyTimeoutsOutputReference | GoogleDataCatalogTaxonomyTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataCatalogTaxonomyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataCatalogTaxonomyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataCatalogTaxonomyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy google_data_catalog_taxonomy}
*/
export declare class GoogleDataCatalogTaxonomy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_taxonomy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_catalog_taxonomy google_data_catalog_taxonomy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataCatalogTaxonomyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataCatalogTaxonomyConfig);
    private _activatedPolicyTypes?;
    get activatedPolicyTypes(): string[];
    set activatedPolicyTypes(value: string[]);
    resetActivatedPolicyTypes(): void;
    get activatedPolicyTypesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleDataCatalogTaxonomyTimeoutsOutputReference;
    putTimeouts(value: GoogleDataCatalogTaxonomyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataCatalogTaxonomyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
