import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataFusionInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#dataproc_service_account GoogleDataFusionInstance#dataproc_service_account}
    */
    readonly dataprocServiceAccount?: string;
    /**
    * An optional description of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#description GoogleDataFusionInstance#description}
    */
    readonly description?: string;
    /**
    * Option to enable Stackdriver Logging.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#enable_stackdriver_logging GoogleDataFusionInstance#enable_stackdriver_logging}
    */
    readonly enableStackdriverLogging?: boolean | cdktf.IResolvable;
    /**
    * Option to enable Stackdriver Monitoring.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#enable_stackdriver_monitoring GoogleDataFusionInstance#enable_stackdriver_monitoring}
    */
    readonly enableStackdriverMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#id GoogleDataFusionInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource labels for instance to use to annotate any related underlying resources,
  such as Compute Engine VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#labels GoogleDataFusionInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The ID of the instance or a fully qualified identifier for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#name GoogleDataFusionInstance#name}
    */
    readonly name: string;
    /**
    * Map of additional options used to configure the behavior of Data Fusion instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#options GoogleDataFusionInstance#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Specifies whether the Data Fusion instance should be private. If set to
  true, all Data Fusion nodes will have private IP addresses and will not be
  able to access the public internet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#private_instance GoogleDataFusionInstance#private_instance}
    */
    readonly privateInstance?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#project GoogleDataFusionInstance#project}
    */
    readonly project?: string;
    /**
    * The region of the Data Fusion instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#region GoogleDataFusionInstance#region}
    */
    readonly region?: string;
    /**
    * Represents the type of Data Fusion instance. Each type is configured with
  the default settings for processing and memory.
  - BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
  using point and click UI. However, there are certain limitations, such as fewer number
  of concurrent pipelines, no support for streaming pipelines, etc.
  - ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
  available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
  - DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
  with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
  pipelines at low cost. Possible values: ["BASIC", "ENTERPRISE", "DEVELOPER"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#type GoogleDataFusionInstance#type}
    */
    readonly type: string;
    /**
    * Current version of the Data Fusion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#version GoogleDataFusionInstance#version}
    */
    readonly version?: string;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#network_config GoogleDataFusionInstance#network_config}
    */
    readonly networkConfig?: GoogleDataFusionInstanceNetworkConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#timeouts GoogleDataFusionInstance#timeouts}
    */
    readonly timeouts?: GoogleDataFusionInstanceTimeouts;
}
export interface GoogleDataFusionInstanceNetworkConfig {
    /**
    * The IP range in CIDR notation to use for the managed Data Fusion instance
  nodes. This range must not overlap with any other ranges used in the Data Fusion instance network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#ip_allocation GoogleDataFusionInstance#ip_allocation}
    */
    readonly ipAllocation: string;
    /**
    * Name of the network in the project with which the tenant project
  will be peered for executing pipelines. In case of shared VPC where the network resides in another host
  project the network should specified in the form of projects/{host-project-id}/global/networks/{network}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#network GoogleDataFusionInstance#network}
    */
    readonly network: string;
}
export declare function googleDataFusionInstanceNetworkConfigToTerraform(struct?: GoogleDataFusionInstanceNetworkConfigOutputReference | GoogleDataFusionInstanceNetworkConfig): any;
export declare class GoogleDataFusionInstanceNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataFusionInstanceNetworkConfig | undefined;
    set internalValue(value: GoogleDataFusionInstanceNetworkConfig | undefined);
    private _ipAllocation?;
    get ipAllocation(): string;
    set ipAllocation(value: string);
    get ipAllocationInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
}
export interface GoogleDataFusionInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#create GoogleDataFusionInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#delete GoogleDataFusionInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance#update GoogleDataFusionInstance#update}
    */
    readonly update?: string;
}
export declare function googleDataFusionInstanceTimeoutsToTerraform(struct?: GoogleDataFusionInstanceTimeoutsOutputReference | GoogleDataFusionInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataFusionInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataFusionInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataFusionInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance google_data_fusion_instance}
*/
export declare class GoogleDataFusionInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_fusion_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_fusion_instance google_data_fusion_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataFusionInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataFusionInstanceConfig);
    get createTime(): string;
    private _dataprocServiceAccount?;
    get dataprocServiceAccount(): string;
    set dataprocServiceAccount(value: string);
    resetDataprocServiceAccount(): void;
    get dataprocServiceAccountInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableStackdriverLogging?;
    get enableStackdriverLogging(): boolean | cdktf.IResolvable;
    set enableStackdriverLogging(value: boolean | cdktf.IResolvable);
    resetEnableStackdriverLogging(): void;
    get enableStackdriverLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStackdriverMonitoring?;
    get enableStackdriverMonitoring(): boolean | cdktf.IResolvable;
    set enableStackdriverMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableStackdriverMonitoring(): void;
    get enableStackdriverMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    get gcsBucket(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _privateInstance?;
    get privateInstance(): boolean | cdktf.IResolvable;
    set privateInstance(value: boolean | cdktf.IResolvable);
    resetPrivateInstance(): void;
    get privateInstanceInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get serviceAccount(): string;
    get serviceEndpoint(): string;
    get state(): string;
    get stateMessage(): string;
    get tenantProjectId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _networkConfig;
    get networkConfig(): GoogleDataFusionInstanceNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleDataFusionInstanceNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): GoogleDataFusionInstanceNetworkConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleDataFusionInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleDataFusionInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataFusionInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
