import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataLossPreventionJobTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the job trigger.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#description GoogleDataLossPreventionJobTrigger#description}
    */
    readonly description?: string;
    /**
    * User set display name of the job trigger.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#display_name GoogleDataLossPreventionJobTrigger#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#id GoogleDataLossPreventionJobTrigger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The parent of the trigger, either in the format 'projects/{{project}}'
  or 'projects/{{project}}/locations/{{location}}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#parent GoogleDataLossPreventionJobTrigger#parent}
    */
    readonly parent: string;
    /**
    * Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#status GoogleDataLossPreventionJobTrigger#status}
    */
    readonly status?: string;
    /**
    * inspect_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#inspect_job GoogleDataLossPreventionJobTrigger#inspect_job}
    */
    readonly inspectJob?: GoogleDataLossPreventionJobTriggerInspectJob;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#timeouts GoogleDataLossPreventionJobTrigger#timeouts}
    */
    readonly timeouts?: GoogleDataLossPreventionJobTriggerTimeouts;
    /**
    * triggers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#triggers GoogleDataLossPreventionJobTrigger#triggers}
    */
    readonly triggers: GoogleDataLossPreventionJobTriggerTriggers[] | cdktf.IResolvable;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable {
    /**
    * Dataset ID of the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#dataset_id GoogleDataLossPreventionJobTrigger#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The Google Cloud Platform project ID of the project containing the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#project_id GoogleDataLossPreventionJobTrigger#project_id}
    */
    readonly projectId: string;
    /**
    * Name of the table. If is not set a new one will be generated for you with the following format:
  'dlp_googleapis_yyyy_mm_dd_[dlp_job_id]'. Pacific timezone will be used for generating the date details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#table_id GoogleDataLossPreventionJobTrigger#table_id}
    */
    readonly tableId?: string;
}
export declare function googleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference | GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    resetTableId(): void;
    get tableIdInput(): string | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig {
    /**
    * Schema used for writing the findings for Inspect jobs. This field is only used for
  Inspect and must be unspecified for Risk jobs. Columns are derived from the Finding
  object. If appending to an existing table, any columns from the predefined schema
  that are missing will be added. No columns in the existing table will be deleted.
  
  If unspecified, then all available columns will be used for a new table or an (existing)
  table with no schema, and no changes will be made to an existing table that has a schema.
  Only for use with external storage. Possible values: ["BASIC_COLUMNS", "GCS_COLUMNS", "DATASTORE_COLUMNS", "BIG_QUERY_COLUMNS", "ALL_COLUMNS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#output_schema GoogleDataLossPreventionJobTrigger#output_schema}
    */
    readonly outputSchema?: string;
    /**
    * table block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#table GoogleDataLossPreventionJobTrigger#table}
    */
    readonly table: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable;
}
export declare function googleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference | GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig | undefined);
    private _outputSchema?;
    get outputSchema(): string;
    set outputSchema(value: string);
    resetOutputSchema(): void;
    get outputSchemaInput(): string | undefined;
    private _table;
    get table(): GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference;
    putTable(value: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable): void;
    get tableInput(): GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindings {
    /**
    * output_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#output_config GoogleDataLossPreventionJobTrigger#output_config}
    */
    readonly outputConfig: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig;
}
export declare function googleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputReference | GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindings): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindings | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindings | undefined);
    private _outputConfig;
    get outputConfig(): GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference;
    putOutputConfig(value: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig): void;
    get outputConfigInput(): GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobActions {
    /**
    * save_findings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#save_findings GoogleDataLossPreventionJobTrigger#save_findings}
    */
    readonly saveFindings: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindings;
}
export declare function googleDataLossPreventionJobTriggerInspectJobActionsToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobActions | cdktf.IResolvable): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobActions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobActions | cdktf.IResolvable | undefined);
    private _saveFindings;
    get saveFindings(): GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputReference;
    putSaveFindings(value: GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindings): void;
    get saveFindingsInput(): GoogleDataLossPreventionJobTriggerInspectJobActionsSaveFindings | undefined;
}
export declare class GoogleDataLossPreventionJobTriggerInspectJobActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataLossPreventionJobTriggerInspectJobActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataLossPreventionJobTriggerInspectJobActionsOutputReference;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference {
    /**
    * The dataset ID of the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#dataset_id GoogleDataLossPreventionJobTrigger#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The Google Cloud Platform project ID of the project containing the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#project_id GoogleDataLossPreventionJobTrigger#project_id}
    */
    readonly projectId: string;
    /**
    * The name of the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#table_id GoogleDataLossPreventionJobTrigger#table_id}
    */
    readonly tableId: string;
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions {
    /**
    * table_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#table_reference GoogleDataLossPreventionJobTrigger#table_reference}
    */
    readonly tableReference: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference;
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined);
    private _tableReference;
    get tableReference(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference;
    putTableReference(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference): void;
    get tableReferenceInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet {
    /**
    * The name of a Cloud Storage bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#bucket_name GoogleDataLossPreventionJobTrigger#bucket_name}
    */
    readonly bucketName: string;
    /**
    * A list of regular expressions matching file paths to exclude. All files in the bucket that match at
  least one of these regular expressions will be excluded from the scan.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#exclude_regex GoogleDataLossPreventionJobTrigger#exclude_regex}
    */
    readonly excludeRegex?: string[];
    /**
    * A list of regular expressions matching file paths to include. All files in the bucket
  that match at least one of these regular expressions will be included in the set of files,
  except for those that also match an item in excludeRegex. Leaving this field empty will
  match all files by default (this is equivalent to including .* in the list)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#include_regex GoogleDataLossPreventionJobTrigger#include_regex}
    */
    readonly includeRegex?: string[];
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _excludeRegex?;
    get excludeRegex(): string[];
    set excludeRegex(value: string[]);
    resetExcludeRegex(): void;
    get excludeRegexInput(): string[] | undefined;
    private _includeRegex?;
    get includeRegex(): string[];
    set includeRegex(value: string[]);
    resetIncludeRegex(): void;
    get includeRegexInput(): string[] | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet {
    /**
    * The Cloud Storage url of the file(s) to scan, in the format 'gs://<bucket>/<path>'. Trailing wildcard
  in the path is allowed.
  
  If the url ends in a trailing slash, the bucket or directory represented by the url will be scanned
  non-recursively (content in sub-directories will not be scanned). This means that 'gs://mybucket/' is
  equivalent to 'gs://mybucket/*', and 'gs://mybucket/directory/' is equivalent to 'gs://mybucket/directory/*'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#url GoogleDataLossPreventionJobTrigger#url}
    */
    readonly url?: string;
    /**
    * regex_file_set block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#regex_file_set GoogleDataLossPreventionJobTrigger#regex_file_set}
    */
    readonly regexFileSet?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet;
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _regexFileSet;
    get regexFileSet(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference;
    putRegexFileSet(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet): void;
    resetRegexFileSet(): void;
    get regexFileSetInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions {
    /**
    * Max number of bytes to scan from a file. If a scanned file's size is bigger than this value
  then the rest of the bytes are omitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#bytes_limit_per_file GoogleDataLossPreventionJobTrigger#bytes_limit_per_file}
    */
    readonly bytesLimitPerFile?: number;
    /**
    * Max percentage of bytes to scan from a file. The rest are omitted. The number of bytes scanned is rounded down.
  Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#bytes_limit_per_file_percent GoogleDataLossPreventionJobTrigger#bytes_limit_per_file_percent}
    */
    readonly bytesLimitPerFilePercent?: number;
    /**
    * List of file type groups to include in the scan. If empty, all files are scanned and available data
  format processors are applied. In addition, the binary content of the selected files is always scanned as well.
  Images are scanned only as binary if the specified region does not support image inspection and no fileTypes were specified. Possible values: ["BINARY_FILE", "TEXT_FILE", "IMAGE", "WORD", "PDF", "AVRO", "CSV", "TSV"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#file_types GoogleDataLossPreventionJobTrigger#file_types}
    */
    readonly fileTypes?: string[];
    /**
    * Limits the number of files to scan to this percentage of the input FileSet. Number of files scanned is rounded down.
  Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#files_limit_percent GoogleDataLossPreventionJobTrigger#files_limit_percent}
    */
    readonly filesLimitPercent?: number;
    /**
    * How to sample bytes if not all bytes are scanned. Meaningful only when used in conjunction with bytesLimitPerFile.
  If not specified, scanning would start from the top. Possible values: ["TOP", "RANDOM_START"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#sample_method GoogleDataLossPreventionJobTrigger#sample_method}
    */
    readonly sampleMethod?: string;
    /**
    * file_set block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#file_set GoogleDataLossPreventionJobTrigger#file_set}
    */
    readonly fileSet: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet;
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined);
    private _bytesLimitPerFile?;
    get bytesLimitPerFile(): number;
    set bytesLimitPerFile(value: number);
    resetBytesLimitPerFile(): void;
    get bytesLimitPerFileInput(): number | undefined;
    private _bytesLimitPerFilePercent?;
    get bytesLimitPerFilePercent(): number;
    set bytesLimitPerFilePercent(value: number);
    resetBytesLimitPerFilePercent(): void;
    get bytesLimitPerFilePercentInput(): number | undefined;
    private _fileTypes?;
    get fileTypes(): string[];
    set fileTypes(value: string[]);
    resetFileTypes(): void;
    get fileTypesInput(): string[] | undefined;
    private _filesLimitPercent?;
    get filesLimitPercent(): number;
    set filesLimitPercent(value: number);
    resetFilesLimitPercent(): void;
    get filesLimitPercentInput(): number | undefined;
    private _sampleMethod?;
    get sampleMethod(): string;
    set sampleMethod(value: string);
    resetSampleMethod(): void;
    get sampleMethodInput(): string | undefined;
    private _fileSet;
    get fileSet(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference;
    putFileSet(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet): void;
    get fileSetInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind {
    /**
    * The name of the Datastore kind.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#name GoogleDataLossPreventionJobTrigger#name}
    */
    readonly name: string;
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId {
    /**
    * If not empty, the ID of the namespace to which the entities belong.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#namespace_id GoogleDataLossPreventionJobTrigger#namespace_id}
    */
    readonly namespaceId?: string;
    /**
    * The ID of the project to which the entities belong.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#project_id GoogleDataLossPreventionJobTrigger#project_id}
    */
    readonly projectId: string;
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId | undefined);
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    resetNamespaceId(): void;
    get namespaceIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions {
    /**
    * kind block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#kind GoogleDataLossPreventionJobTrigger#kind}
    */
    readonly kind: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind;
    /**
    * partition_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#partition_id GoogleDataLossPreventionJobTrigger#partition_id}
    */
    readonly partitionId: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId;
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined);
    private _kind;
    get kind(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference;
    putKind(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind): void;
    get kindInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind | undefined;
    private _partitionId;
    get partitionId(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference;
    putPartitionId(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId): void;
    get partitionIdInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField {
    /**
    * Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery.
  
  For BigQuery: Required to filter out rows based on the given start and end times. If not specified and the table was
  modified between the given start and end times, the entire table will be scanned. The valid data types of the timestamp
  field are: INTEGER, DATE, TIMESTAMP, or DATETIME BigQuery column.
  
  For Datastore. Valid data types of the timestamp field are: TIMESTAMP. Datastore entity will be scanned if the
  timestamp property does not exist or its value is empty or invalid.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#name GoogleDataLossPreventionJobTrigger#name}
    */
    readonly name: string;
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig {
    /**
    * When the job is started by a JobTrigger we will automatically figure out a valid startTime to avoid
  scanning files that have not been modified since the last time the JobTrigger executed. This will
  be based on the time of the execution of the last run of the JobTrigger.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#enable_auto_population_of_timespan_config GoogleDataLossPreventionJobTrigger#enable_auto_population_of_timespan_config}
    */
    readonly enableAutoPopulationOfTimespanConfig?: boolean | cdktf.IResolvable;
    /**
    * Exclude files or rows newer than this value. If set to zero, no upper time limit is applied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#end_time GoogleDataLossPreventionJobTrigger#end_time}
    */
    readonly endTime?: string;
    /**
    * Exclude files or rows older than this value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#start_time GoogleDataLossPreventionJobTrigger#start_time}
    */
    readonly startTime?: string;
    /**
    * timestamp_field block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#timestamp_field GoogleDataLossPreventionJobTrigger#timestamp_field}
    */
    readonly timestampField: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField;
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined);
    private _enableAutoPopulationOfTimespanConfig?;
    get enableAutoPopulationOfTimespanConfig(): boolean | cdktf.IResolvable;
    set enableAutoPopulationOfTimespanConfig(value: boolean | cdktf.IResolvable);
    resetEnableAutoPopulationOfTimespanConfig(): void;
    get enableAutoPopulationOfTimespanConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _timestampField;
    get timestampField(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference;
    putTimestampField(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField): void;
    get timestampFieldInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJobStorageConfig {
    /**
    * big_query_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#big_query_options GoogleDataLossPreventionJobTrigger#big_query_options}
    */
    readonly bigQueryOptions?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions;
    /**
    * cloud_storage_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#cloud_storage_options GoogleDataLossPreventionJobTrigger#cloud_storage_options}
    */
    readonly cloudStorageOptions?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions;
    /**
    * datastore_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#datastore_options GoogleDataLossPreventionJobTrigger#datastore_options}
    */
    readonly datastoreOptions?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions;
    /**
    * timespan_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#timespan_config GoogleDataLossPreventionJobTrigger#timespan_config}
    */
    readonly timespanConfig?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig;
}
export declare function googleDataLossPreventionJobTriggerInspectJobStorageConfigToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigOutputReference | GoogleDataLossPreventionJobTriggerInspectJobStorageConfig): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfig | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfig | undefined);
    private _bigQueryOptions;
    get bigQueryOptions(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference;
    putBigQueryOptions(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions): void;
    resetBigQueryOptions(): void;
    get bigQueryOptionsInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined;
    private _cloudStorageOptions;
    get cloudStorageOptions(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference;
    putCloudStorageOptions(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions): void;
    resetCloudStorageOptions(): void;
    get cloudStorageOptionsInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined;
    private _datastoreOptions;
    get datastoreOptions(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference;
    putDatastoreOptions(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions): void;
    resetDatastoreOptions(): void;
    get datastoreOptionsInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined;
    private _timespanConfig;
    get timespanConfig(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference;
    putTimespanConfig(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig): void;
    resetTimespanConfig(): void;
    get timespanConfigInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined;
}
export interface GoogleDataLossPreventionJobTriggerInspectJob {
    /**
    * The name of the template to run when this job is triggered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#inspect_template_name GoogleDataLossPreventionJobTrigger#inspect_template_name}
    */
    readonly inspectTemplateName: string;
    /**
    * actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#actions GoogleDataLossPreventionJobTrigger#actions}
    */
    readonly actions: GoogleDataLossPreventionJobTriggerInspectJobActions[] | cdktf.IResolvable;
    /**
    * storage_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#storage_config GoogleDataLossPreventionJobTrigger#storage_config}
    */
    readonly storageConfig: GoogleDataLossPreventionJobTriggerInspectJobStorageConfig;
}
export declare function googleDataLossPreventionJobTriggerInspectJobToTerraform(struct?: GoogleDataLossPreventionJobTriggerInspectJobOutputReference | GoogleDataLossPreventionJobTriggerInspectJob): any;
export declare class GoogleDataLossPreventionJobTriggerInspectJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerInspectJob | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerInspectJob | undefined);
    private _inspectTemplateName?;
    get inspectTemplateName(): string;
    set inspectTemplateName(value: string);
    get inspectTemplateNameInput(): string | undefined;
    private _actions;
    get actions(): GoogleDataLossPreventionJobTriggerInspectJobActionsList;
    putActions(value: GoogleDataLossPreventionJobTriggerInspectJobActions[] | cdktf.IResolvable): void;
    get actionsInput(): cdktf.IResolvable | GoogleDataLossPreventionJobTriggerInspectJobActions[] | undefined;
    private _storageConfig;
    get storageConfig(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfigOutputReference;
    putStorageConfig(value: GoogleDataLossPreventionJobTriggerInspectJobStorageConfig): void;
    get storageConfigInput(): GoogleDataLossPreventionJobTriggerInspectJobStorageConfig | undefined;
}
export interface GoogleDataLossPreventionJobTriggerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#create GoogleDataLossPreventionJobTrigger#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#delete GoogleDataLossPreventionJobTrigger#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#update GoogleDataLossPreventionJobTrigger#update}
    */
    readonly update?: string;
}
export declare function googleDataLossPreventionJobTriggerTimeoutsToTerraform(struct?: GoogleDataLossPreventionJobTriggerTimeoutsOutputReference | GoogleDataLossPreventionJobTriggerTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataLossPreventionJobTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDataLossPreventionJobTriggerTriggersSchedule {
    /**
    * With this option a job is started a regular periodic basis. For example: every day (86400 seconds).
  
  A scheduled start time will be skipped if the previous execution has not ended when its scheduled time occurs.
  
  This value must be set to a time duration greater than or equal to 1 day and can be no longer than 60 days.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#recurrence_period_duration GoogleDataLossPreventionJobTrigger#recurrence_period_duration}
    */
    readonly recurrencePeriodDuration?: string;
}
export declare function googleDataLossPreventionJobTriggerTriggersScheduleToTerraform(struct?: GoogleDataLossPreventionJobTriggerTriggersScheduleOutputReference | GoogleDataLossPreventionJobTriggerTriggersSchedule): any;
export declare class GoogleDataLossPreventionJobTriggerTriggersScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionJobTriggerTriggersSchedule | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerTriggersSchedule | undefined);
    private _recurrencePeriodDuration?;
    get recurrencePeriodDuration(): string;
    set recurrencePeriodDuration(value: string);
    resetRecurrencePeriodDuration(): void;
    get recurrencePeriodDurationInput(): string | undefined;
}
export interface GoogleDataLossPreventionJobTriggerTriggers {
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger#schedule GoogleDataLossPreventionJobTrigger#schedule}
    */
    readonly schedule?: GoogleDataLossPreventionJobTriggerTriggersSchedule;
}
export declare function googleDataLossPreventionJobTriggerTriggersToTerraform(struct?: GoogleDataLossPreventionJobTriggerTriggers | cdktf.IResolvable): any;
export declare class GoogleDataLossPreventionJobTriggerTriggersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataLossPreventionJobTriggerTriggers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataLossPreventionJobTriggerTriggers | cdktf.IResolvable | undefined);
    private _schedule;
    get schedule(): GoogleDataLossPreventionJobTriggerTriggersScheduleOutputReference;
    putSchedule(value: GoogleDataLossPreventionJobTriggerTriggersSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): GoogleDataLossPreventionJobTriggerTriggersSchedule | undefined;
}
export declare class GoogleDataLossPreventionJobTriggerTriggersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataLossPreventionJobTriggerTriggers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataLossPreventionJobTriggerTriggersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger google_data_loss_prevention_job_trigger}
*/
export declare class GoogleDataLossPreventionJobTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_loss_prevention_job_trigger";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_data_loss_prevention_job_trigger google_data_loss_prevention_job_trigger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataLossPreventionJobTriggerConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataLossPreventionJobTriggerConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastRunTime(): string;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _inspectJob;
    get inspectJob(): GoogleDataLossPreventionJobTriggerInspectJobOutputReference;
    putInspectJob(value: GoogleDataLossPreventionJobTriggerInspectJob): void;
    resetInspectJob(): void;
    get inspectJobInput(): GoogleDataLossPreventionJobTriggerInspectJob | undefined;
    private _timeouts;
    get timeouts(): GoogleDataLossPreventionJobTriggerTimeoutsOutputReference;
    putTimeouts(value: GoogleDataLossPreventionJobTriggerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataLossPreventionJobTriggerTimeouts | undefined;
    private _triggers;
    get triggers(): GoogleDataLossPreventionJobTriggerTriggersList;
    putTriggers(value: GoogleDataLossPreventionJobTriggerTriggers[] | cdktf.IResolvable): void;
    get triggersInput(): cdktf.IResolvable | GoogleDataLossPreventionJobTriggerTriggers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
