import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataplexLakeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Description of the lake.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#description GoogleDataplexLake#description}
    */
    readonly description?: string;
    /**
    * Optional. User friendly display name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#display_name GoogleDataplexLake#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#id GoogleDataplexLake#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. User-defined labels for the lake.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#labels GoogleDataplexLake#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#location GoogleDataplexLake#location}
    */
    readonly location: string;
    /**
    * The name of the lake.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#name GoogleDataplexLake#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#project GoogleDataplexLake#project}
    */
    readonly project?: string;
    /**
    * metastore block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#metastore GoogleDataplexLake#metastore}
    */
    readonly metastore?: GoogleDataplexLakeMetastore;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#timeouts GoogleDataplexLake#timeouts}
    */
    readonly timeouts?: GoogleDataplexLakeTimeouts;
}
export interface GoogleDataplexLakeAssetStatus {
}
export declare function googleDataplexLakeAssetStatusToTerraform(struct?: GoogleDataplexLakeAssetStatus): any;
export declare class GoogleDataplexLakeAssetStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexLakeAssetStatus | undefined;
    set internalValue(value: GoogleDataplexLakeAssetStatus | undefined);
    get activeAssets(): number;
    get securityPolicyApplyingAssets(): number;
    get updateTime(): string;
}
export declare class GoogleDataplexLakeAssetStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexLakeAssetStatusOutputReference;
}
export interface GoogleDataplexLakeMetastoreStatus {
}
export declare function googleDataplexLakeMetastoreStatusToTerraform(struct?: GoogleDataplexLakeMetastoreStatus): any;
export declare class GoogleDataplexLakeMetastoreStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexLakeMetastoreStatus | undefined;
    set internalValue(value: GoogleDataplexLakeMetastoreStatus | undefined);
    get endpoint(): string;
    get message(): string;
    get state(): string;
    get updateTime(): string;
}
export declare class GoogleDataplexLakeMetastoreStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexLakeMetastoreStatusOutputReference;
}
export interface GoogleDataplexLakeMetastore {
    /**
    * Optional. A relative reference to the Dataproc Metastore (https://cloud.google.com/dataproc-metastore/docs) service associated with the lake: `projects/{project_id}/locations/{location_id}/services/{service_id}`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#service GoogleDataplexLake#service}
    */
    readonly service?: string;
}
export declare function googleDataplexLakeMetastoreToTerraform(struct?: GoogleDataplexLakeMetastoreOutputReference | GoogleDataplexLakeMetastore): any;
export declare class GoogleDataplexLakeMetastoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexLakeMetastore | undefined;
    set internalValue(value: GoogleDataplexLakeMetastore | undefined);
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export interface GoogleDataplexLakeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#create GoogleDataplexLake#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#delete GoogleDataplexLake#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake#update GoogleDataplexLake#update}
    */
    readonly update?: string;
}
export declare function googleDataplexLakeTimeoutsToTerraform(struct?: GoogleDataplexLakeTimeoutsOutputReference | GoogleDataplexLakeTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataplexLakeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexLakeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataplexLakeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake google_dataplex_lake}
*/
export declare class GoogleDataplexLake extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataplex_lake";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataplex_lake google_dataplex_lake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataplexLakeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataplexLakeConfig);
    private _assetStatus;
    get assetStatus(): GoogleDataplexLakeAssetStatusList;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _metastoreStatus;
    get metastoreStatus(): GoogleDataplexLakeMetastoreStatusList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serviceAccount(): string;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _metastore;
    get metastore(): GoogleDataplexLakeMetastoreOutputReference;
    putMetastore(value: GoogleDataplexLakeMetastore): void;
    resetMetastore(): void;
    get metastoreInput(): GoogleDataplexLakeMetastore | undefined;
    private _timeouts;
    get timeouts(): GoogleDataplexLakeTimeoutsOutputReference;
    putTimeouts(value: GoogleDataplexLakeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataplexLakeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
