import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataprocClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The timeout duration which allows graceful decomissioning when you change the number of worker nodes directly through a terraform apply
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#graceful_decommission_timeout GoogleDataprocCluster#graceful_decommission_timeout}
    */
    readonly gracefulDecommissionTimeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#id GoogleDataprocCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The list of labels (key/value pairs) to be applied to instances in the cluster. GCP generates some itself including goog-dataproc-cluster-name which is the name of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#labels GoogleDataprocCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the cluster, unique within the project and zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#name GoogleDataprocCluster#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the cluster will exist. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#project GoogleDataprocCluster#project}
    */
    readonly project?: string;
    /**
    * The region in which the cluster and associated nodes will be created in. Defaults to global.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#region GoogleDataprocCluster#region}
    */
    readonly region?: string;
    /**
    * cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#cluster_config GoogleDataprocCluster#cluster_config}
    */
    readonly clusterConfig?: GoogleDataprocClusterClusterConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#timeouts GoogleDataprocCluster#timeouts}
    */
    readonly timeouts?: GoogleDataprocClusterTimeouts;
}
export interface GoogleDataprocClusterClusterConfigAutoscalingConfig {
    /**
    * The autoscaling policy used by the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#policy_uri GoogleDataprocCluster#policy_uri}
    */
    readonly policyUri: string;
}
export declare function googleDataprocClusterClusterConfigAutoscalingConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigAutoscalingConfigOutputReference | GoogleDataprocClusterClusterConfigAutoscalingConfig): any;
export declare class GoogleDataprocClusterClusterConfigAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigAutoscalingConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigAutoscalingConfig | undefined);
    private _policyUri?;
    get policyUri(): string;
    set policyUri(value: string);
    get policyUriInput(): string | undefined;
}
export interface GoogleDataprocClusterClusterConfigEncryptionConfig {
    /**
    * The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#kms_key_name GoogleDataprocCluster#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleDataprocClusterClusterConfigEncryptionConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigEncryptionConfigOutputReference | GoogleDataprocClusterClusterConfigEncryptionConfig): any;
export declare class GoogleDataprocClusterClusterConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigEncryptionConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleDataprocClusterClusterConfigEndpointConfig {
    /**
    * The flag to enable http access to specific ports on the cluster from external sources (aka Component Gateway). Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#enable_http_port_access GoogleDataprocCluster#enable_http_port_access}
    */
    readonly enableHttpPortAccess: boolean | cdktf.IResolvable;
}
export declare function googleDataprocClusterClusterConfigEndpointConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigEndpointConfigOutputReference | GoogleDataprocClusterClusterConfigEndpointConfig): any;
export declare class GoogleDataprocClusterClusterConfigEndpointConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigEndpointConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigEndpointConfig | undefined);
    private _enableHttpPortAccess?;
    get enableHttpPortAccess(): boolean | cdktf.IResolvable;
    set enableHttpPortAccess(value: boolean | cdktf.IResolvable);
    get enableHttpPortAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _httpPorts;
    get httpPorts(): cdktf.StringMap;
}
export interface GoogleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig {
    /**
    * Defines whether instances have integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#enable_integrity_monitoring GoogleDataprocCluster#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether instances have Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#enable_secure_boot GoogleDataprocCluster#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Defines whether instances have the vTPM enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#enable_vtpm GoogleDataprocCluster#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function googleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference | GoogleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig): any;
export declare class GoogleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleDataprocClusterClusterConfigGceClusterConfig {
    /**
    * By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. If set to true, all instances in the cluster will only have internal IP addresses. Note: Private Google Access (also known as privateIpGoogleAccess) must be enabled on the subnetwork that the cluster will be launched in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#internal_ip_only GoogleDataprocCluster#internal_ip_only}
    */
    readonly internalIpOnly?: boolean | cdktf.IResolvable;
    /**
    * A map of the Compute Engine metadata entries to add to all instances
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#metadata GoogleDataprocCluster#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * The name or self_link of the Google Compute Engine network to the cluster will be part of. Conflicts with subnetwork. If neither is specified, this defaults to the "default" network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#network GoogleDataprocCluster#network}
    */
    readonly network?: string;
    /**
    * The service account to be used by the Node VMs. If not specified, the "default" service account is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#service_account GoogleDataprocCluster#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs under the service_account specified. These can be either FQDNs, or scope aliases.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#service_account_scopes GoogleDataprocCluster#service_account_scopes}
    */
    readonly serviceAccountScopes?: string[];
    /**
    * The name or self_link of the Google Compute Engine subnetwork the cluster will be part of. Conflicts with network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#subnetwork GoogleDataprocCluster#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The list of instance tags applied to instances in the cluster. Tags are used to identify valid sources or targets for network firewalls.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#tags GoogleDataprocCluster#tags}
    */
    readonly tags?: string[];
    /**
    * The GCP zone where your data is stored and used (i.e. where the master and the worker nodes will be created in). If region is set to 'global' (default) then zone is mandatory, otherwise GCP is able to make use of Auto Zone Placement to determine this automatically for you. Note: This setting additionally determines and restricts which computing resources are available for use with other configs such as cluster_config.master_config.machine_type and cluster_config.worker_config.machine_type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#zone GoogleDataprocCluster#zone}
    */
    readonly zone?: string;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#shielded_instance_config GoogleDataprocCluster#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig;
}
export declare function googleDataprocClusterClusterConfigGceClusterConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigGceClusterConfigOutputReference | GoogleDataprocClusterClusterConfigGceClusterConfig): any;
export declare class GoogleDataprocClusterClusterConfigGceClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigGceClusterConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigGceClusterConfig | undefined);
    private _internalIpOnly?;
    get internalIpOnly(): boolean | cdktf.IResolvable;
    set internalIpOnly(value: boolean | cdktf.IResolvable);
    resetInternalIpOnly(): void;
    get internalIpOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    get serviceAccountScopes(): string[];
    set serviceAccountScopes(value: string[]);
    resetServiceAccountScopes(): void;
    get serviceAccountScopesInput(): string[] | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleDataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined;
}
export interface GoogleDataprocClusterClusterConfigInitializationAction {
    /**
    * The script to be executed during initialization of the cluster. The script must be a GCS file with a gs:// prefix.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#script GoogleDataprocCluster#script}
    */
    readonly script: string;
    /**
    * The maximum duration (in seconds) which script is allowed to take to execute its action. GCP will default to a predetermined computed value if not set (currently 300).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#timeout_sec GoogleDataprocCluster#timeout_sec}
    */
    readonly timeoutSec?: number;
}
export declare function googleDataprocClusterClusterConfigInitializationActionToTerraform(struct?: GoogleDataprocClusterClusterConfigInitializationAction | cdktf.IResolvable): any;
export declare class GoogleDataprocClusterClusterConfigInitializationActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocClusterClusterConfigInitializationAction | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigInitializationAction | cdktf.IResolvable | undefined);
    private _script?;
    get script(): string;
    set script(value: string);
    get scriptInput(): string | undefined;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
}
export declare class GoogleDataprocClusterClusterConfigInitializationActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocClusterClusterConfigInitializationAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocClusterClusterConfigInitializationActionOutputReference;
}
export interface GoogleDataprocClusterClusterConfigLifecycleConfig {
    /**
    * The time when cluster will be auto-deleted. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#auto_delete_time GoogleDataprocCluster#auto_delete_time}
    */
    readonly autoDeleteTime?: string;
    /**
    * The duration to keep the cluster alive while idling (no jobs running). After this TTL, the cluster will be deleted. Valid range: [10m, 14d].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#idle_delete_ttl GoogleDataprocCluster#idle_delete_ttl}
    */
    readonly idleDeleteTtl?: string;
}
export declare function googleDataprocClusterClusterConfigLifecycleConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigLifecycleConfigOutputReference | GoogleDataprocClusterClusterConfigLifecycleConfig): any;
export declare class GoogleDataprocClusterClusterConfigLifecycleConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigLifecycleConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigLifecycleConfig | undefined);
    private _autoDeleteTime?;
    get autoDeleteTime(): string;
    set autoDeleteTime(value: string);
    resetAutoDeleteTime(): void;
    get autoDeleteTimeInput(): string | undefined;
    private _idleDeleteTtl?;
    get idleDeleteTtl(): string;
    set idleDeleteTtl(value: string);
    resetIdleDeleteTtl(): void;
    get idleDeleteTtlInput(): string | undefined;
    get idleStartTime(): string;
}
export interface GoogleDataprocClusterClusterConfigMasterConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance. Often restricted to one of 1, 2, 4, or 8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#accelerator_count GoogleDataprocCluster#accelerator_count}
    */
    readonly acceleratorCount: number;
    /**
    * The short name of the accelerator type to expose to this instance. For example, nvidia-tesla-k80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#accelerator_type GoogleDataprocCluster#accelerator_type}
    */
    readonly acceleratorType: string;
}
export declare function googleDataprocClusterClusterConfigMasterConfigAcceleratorsToTerraform(struct?: GoogleDataprocClusterClusterConfigMasterConfigAccelerators | cdktf.IResolvable): any;
export declare class GoogleDataprocClusterClusterConfigMasterConfigAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocClusterClusterConfigMasterConfigAccelerators | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigMasterConfigAccelerators | cdktf.IResolvable | undefined);
    private _acceleratorCount?;
    get acceleratorCount(): number;
    set acceleratorCount(value: number);
    get acceleratorCountInput(): number | undefined;
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    get acceleratorTypeInput(): string | undefined;
}
export declare class GoogleDataprocClusterClusterConfigMasterConfigAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocClusterClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocClusterClusterConfigMasterConfigAcceleratorsOutputReference;
}
export interface GoogleDataprocClusterClusterConfigMasterConfigDiskConfig {
    /**
    * Size of the primary disk attached to each node, specified in GB. The primary disk contains the boot volume and system libraries, and the smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#boot_disk_size_gb GoogleDataprocCluster#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * The disk type of the primary disk attached to each node. Such as "pd-ssd" or "pd-standard". Defaults to "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#boot_disk_type GoogleDataprocCluster#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * The amount of local SSD disks that will be attached to each master cluster node. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#num_local_ssds GoogleDataprocCluster#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function googleDataprocClusterClusterConfigMasterConfigDiskConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigMasterConfigDiskConfigOutputReference | GoogleDataprocClusterClusterConfigMasterConfigDiskConfig): any;
export declare class GoogleDataprocClusterClusterConfigMasterConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigMasterConfigDiskConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigMasterConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface GoogleDataprocClusterClusterConfigMasterConfig {
    /**
    * The URI for the image to use for this master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#image_uri GoogleDataprocCluster#image_uri}
    */
    readonly imageUri?: string;
    /**
    * The name of a Google Compute Engine machine type to create for the master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#machine_type GoogleDataprocCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The name of a minimum generation of CPU family for the master/worker. If not specified, GCP will default to a predetermined computed value for each zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#min_cpu_platform GoogleDataprocCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Specifies the number of master/worker nodes to create. If not specified, GCP will default to a predetermined computed value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#num_instances GoogleDataprocCluster#num_instances}
    */
    readonly numInstances?: number;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#accelerators GoogleDataprocCluster#accelerators}
    */
    readonly accelerators?: GoogleDataprocClusterClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#disk_config GoogleDataprocCluster#disk_config}
    */
    readonly diskConfig?: GoogleDataprocClusterClusterConfigMasterConfigDiskConfig;
}
export declare function googleDataprocClusterClusterConfigMasterConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigMasterConfigOutputReference | GoogleDataprocClusterClusterConfigMasterConfig): any;
export declare class GoogleDataprocClusterClusterConfigMasterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigMasterConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigMasterConfig | undefined);
    private _imageUri?;
    get imageUri(): string;
    set imageUri(value: string);
    resetImageUri(): void;
    get imageUriInput(): string | undefined;
    get instanceNames(): string[];
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _accelerators;
    get accelerators(): GoogleDataprocClusterClusterConfigMasterConfigAcceleratorsList;
    putAccelerators(value: GoogleDataprocClusterClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable): void;
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | GoogleDataprocClusterClusterConfigMasterConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): GoogleDataprocClusterClusterConfigMasterConfigDiskConfigOutputReference;
    putDiskConfig(value: GoogleDataprocClusterClusterConfigMasterConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): GoogleDataprocClusterClusterConfigMasterConfigDiskConfig | undefined;
}
export interface GoogleDataprocClusterClusterConfigMetastoreConfig {
    /**
    * Resource name of an existing Dataproc Metastore service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#dataproc_metastore_service GoogleDataprocCluster#dataproc_metastore_service}
    */
    readonly dataprocMetastoreService: string;
}
export declare function googleDataprocClusterClusterConfigMetastoreConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigMetastoreConfigOutputReference | GoogleDataprocClusterClusterConfigMetastoreConfig): any;
export declare class GoogleDataprocClusterClusterConfigMetastoreConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigMetastoreConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigMetastoreConfig | undefined);
    private _dataprocMetastoreService?;
    get dataprocMetastoreService(): string;
    set dataprocMetastoreService(value: string);
    get dataprocMetastoreServiceInput(): string | undefined;
}
export interface GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig {
    /**
    * Size of the primary disk attached to each preemptible worker node, specified in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#boot_disk_size_gb GoogleDataprocCluster#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * The disk type of the primary disk attached to each preemptible worker node. Such as "pd-ssd" or "pd-standard". Defaults to "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#boot_disk_type GoogleDataprocCluster#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * The amount of local SSD disks that will be attached to each preemptible worker node. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#num_local_ssds GoogleDataprocCluster#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function googleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference | GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig): any;
export declare class GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface GoogleDataprocClusterClusterConfigPreemptibleWorkerConfig {
    /**
    * Specifies the number of preemptible nodes to create. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#num_instances GoogleDataprocCluster#num_instances}
    */
    readonly numInstances?: number;
    /**
    * Specifies the preemptibility of the secondary nodes. Defaults to PREEMPTIBLE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#preemptibility GoogleDataprocCluster#preemptibility}
    */
    readonly preemptibility?: string;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#disk_config GoogleDataprocCluster#disk_config}
    */
    readonly diskConfig?: GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig;
}
export declare function googleDataprocClusterClusterConfigPreemptibleWorkerConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference | GoogleDataprocClusterClusterConfigPreemptibleWorkerConfig): any;
export declare class GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigPreemptibleWorkerConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigPreemptibleWorkerConfig | undefined);
    get instanceNames(): string[];
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string;
    set preemptibility(value: string);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _diskConfig;
    get diskConfig(): GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined;
}
export interface GoogleDataprocClusterClusterConfigSecurityConfigKerberosConfig {
    /**
    * The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#cross_realm_trust_admin_server GoogleDataprocCluster#cross_realm_trust_admin_server}
    */
    readonly crossRealmTrustAdminServer?: string;
    /**
    * The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#cross_realm_trust_kdc GoogleDataprocCluster#cross_realm_trust_kdc}
    */
    readonly crossRealmTrustKdc?: string;
    /**
    * The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#cross_realm_trust_realm GoogleDataprocCluster#cross_realm_trust_realm}
    */
    readonly crossRealmTrustRealm?: string;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster
  Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#cross_realm_trust_shared_password_uri GoogleDataprocCluster#cross_realm_trust_shared_password_uri}
    */
    readonly crossRealmTrustSharedPasswordUri?: string;
    /**
    * Flag to indicate whether to Kerberize the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#enable_kerberos GoogleDataprocCluster#enable_kerberos}
    */
    readonly enableKerberos?: boolean | cdktf.IResolvable;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#kdc_db_key_uri GoogleDataprocCluster#kdc_db_key_uri}
    */
    readonly kdcDbKeyUri?: string;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#key_password_uri GoogleDataprocCluster#key_password_uri}
    */
    readonly keyPasswordUri?: string;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing
  the password to the user provided keystore. For the self-signed certificate, this password is generated
  by Dataproc
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#keystore_password_uri GoogleDataprocCluster#keystore_password_uri}
    */
    readonly keystorePasswordUri?: string;
    /**
    * The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#keystore_uri GoogleDataprocCluster#keystore_uri}
    */
    readonly keystoreUri?: string;
    /**
    * The uri of the KMS key used to encrypt various sensitive files.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#kms_key_uri GoogleDataprocCluster#kms_key_uri}
    */
    readonly kmsKeyUri: string;
    /**
    * The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#realm GoogleDataprocCluster#realm}
    */
    readonly realm?: string;
    /**
    * The cloud Storage URI of a KMS encrypted file containing the root principal password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#root_principal_password_uri GoogleDataprocCluster#root_principal_password_uri}
    */
    readonly rootPrincipalPasswordUri: string;
    /**
    * The lifetime of the ticket granting ticket, in hours.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#tgt_lifetime_hours GoogleDataprocCluster#tgt_lifetime_hours}
    */
    readonly tgtLifetimeHours?: number;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#truststore_password_uri GoogleDataprocCluster#truststore_password_uri}
    */
    readonly truststorePasswordUri?: string;
    /**
    * The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#truststore_uri GoogleDataprocCluster#truststore_uri}
    */
    readonly truststoreUri?: string;
}
export declare function googleDataprocClusterClusterConfigSecurityConfigKerberosConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference | GoogleDataprocClusterClusterConfigSecurityConfigKerberosConfig): any;
export declare class GoogleDataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigSecurityConfigKerberosConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigSecurityConfigKerberosConfig | undefined);
    private _crossRealmTrustAdminServer?;
    get crossRealmTrustAdminServer(): string;
    set crossRealmTrustAdminServer(value: string);
    resetCrossRealmTrustAdminServer(): void;
    get crossRealmTrustAdminServerInput(): string | undefined;
    private _crossRealmTrustKdc?;
    get crossRealmTrustKdc(): string;
    set crossRealmTrustKdc(value: string);
    resetCrossRealmTrustKdc(): void;
    get crossRealmTrustKdcInput(): string | undefined;
    private _crossRealmTrustRealm?;
    get crossRealmTrustRealm(): string;
    set crossRealmTrustRealm(value: string);
    resetCrossRealmTrustRealm(): void;
    get crossRealmTrustRealmInput(): string | undefined;
    private _crossRealmTrustSharedPasswordUri?;
    get crossRealmTrustSharedPasswordUri(): string;
    set crossRealmTrustSharedPasswordUri(value: string);
    resetCrossRealmTrustSharedPasswordUri(): void;
    get crossRealmTrustSharedPasswordUriInput(): string | undefined;
    private _enableKerberos?;
    get enableKerberos(): boolean | cdktf.IResolvable;
    set enableKerberos(value: boolean | cdktf.IResolvable);
    resetEnableKerberos(): void;
    get enableKerberosInput(): boolean | cdktf.IResolvable | undefined;
    private _kdcDbKeyUri?;
    get kdcDbKeyUri(): string;
    set kdcDbKeyUri(value: string);
    resetKdcDbKeyUri(): void;
    get kdcDbKeyUriInput(): string | undefined;
    private _keyPasswordUri?;
    get keyPasswordUri(): string;
    set keyPasswordUri(value: string);
    resetKeyPasswordUri(): void;
    get keyPasswordUriInput(): string | undefined;
    private _keystorePasswordUri?;
    get keystorePasswordUri(): string;
    set keystorePasswordUri(value: string);
    resetKeystorePasswordUri(): void;
    get keystorePasswordUriInput(): string | undefined;
    private _keystoreUri?;
    get keystoreUri(): string;
    set keystoreUri(value: string);
    resetKeystoreUri(): void;
    get keystoreUriInput(): string | undefined;
    private _kmsKeyUri?;
    get kmsKeyUri(): string;
    set kmsKeyUri(value: string);
    get kmsKeyUriInput(): string | undefined;
    private _realm?;
    get realm(): string;
    set realm(value: string);
    resetRealm(): void;
    get realmInput(): string | undefined;
    private _rootPrincipalPasswordUri?;
    get rootPrincipalPasswordUri(): string;
    set rootPrincipalPasswordUri(value: string);
    get rootPrincipalPasswordUriInput(): string | undefined;
    private _tgtLifetimeHours?;
    get tgtLifetimeHours(): number;
    set tgtLifetimeHours(value: number);
    resetTgtLifetimeHours(): void;
    get tgtLifetimeHoursInput(): number | undefined;
    private _truststorePasswordUri?;
    get truststorePasswordUri(): string;
    set truststorePasswordUri(value: string);
    resetTruststorePasswordUri(): void;
    get truststorePasswordUriInput(): string | undefined;
    private _truststoreUri?;
    get truststoreUri(): string;
    set truststoreUri(value: string);
    resetTruststoreUri(): void;
    get truststoreUriInput(): string | undefined;
}
export interface GoogleDataprocClusterClusterConfigSecurityConfig {
    /**
    * kerberos_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#kerberos_config GoogleDataprocCluster#kerberos_config}
    */
    readonly kerberosConfig: GoogleDataprocClusterClusterConfigSecurityConfigKerberosConfig;
}
export declare function googleDataprocClusterClusterConfigSecurityConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigSecurityConfigOutputReference | GoogleDataprocClusterClusterConfigSecurityConfig): any;
export declare class GoogleDataprocClusterClusterConfigSecurityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigSecurityConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigSecurityConfig | undefined);
    private _kerberosConfig;
    get kerberosConfig(): GoogleDataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference;
    putKerberosConfig(value: GoogleDataprocClusterClusterConfigSecurityConfigKerberosConfig): void;
    get kerberosConfigInput(): GoogleDataprocClusterClusterConfigSecurityConfigKerberosConfig | undefined;
}
export interface GoogleDataprocClusterClusterConfigSoftwareConfig {
    /**
    * The Cloud Dataproc image version to use for the cluster - this controls the sets of software versions installed onto the nodes when you create clusters. If not specified, defaults to the latest version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#image_version GoogleDataprocCluster#image_version}
    */
    readonly imageVersion?: string;
    /**
    * The set of optional components to activate on the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#optional_components GoogleDataprocCluster#optional_components}
    */
    readonly optionalComponents?: string[];
    /**
    * A list of override and additional properties (key/value pairs) used to modify various aspects of the common configuration files used when creating a cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#override_properties GoogleDataprocCluster#override_properties}
    */
    readonly overrideProperties?: {
        [key: string]: string;
    };
}
export declare function googleDataprocClusterClusterConfigSoftwareConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigSoftwareConfigOutputReference | GoogleDataprocClusterClusterConfigSoftwareConfig): any;
export declare class GoogleDataprocClusterClusterConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigSoftwareConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigSoftwareConfig | undefined);
    private _imageVersion?;
    get imageVersion(): string;
    set imageVersion(value: string);
    resetImageVersion(): void;
    get imageVersionInput(): string | undefined;
    private _optionalComponents?;
    get optionalComponents(): string[];
    set optionalComponents(value: string[]);
    resetOptionalComponents(): void;
    get optionalComponentsInput(): string[] | undefined;
    private _overrideProperties?;
    get overrideProperties(): {
        [key: string]: string;
    };
    set overrideProperties(value: {
        [key: string]: string;
    });
    resetOverrideProperties(): void;
    get overridePropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _properties;
    get properties(): cdktf.StringMap;
}
export interface GoogleDataprocClusterClusterConfigWorkerConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance. Often restricted to one of 1, 2, 4, or 8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#accelerator_count GoogleDataprocCluster#accelerator_count}
    */
    readonly acceleratorCount: number;
    /**
    * The short name of the accelerator type to expose to this instance. For example, nvidia-tesla-k80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#accelerator_type GoogleDataprocCluster#accelerator_type}
    */
    readonly acceleratorType: string;
}
export declare function googleDataprocClusterClusterConfigWorkerConfigAcceleratorsToTerraform(struct?: GoogleDataprocClusterClusterConfigWorkerConfigAccelerators | cdktf.IResolvable): any;
export declare class GoogleDataprocClusterClusterConfigWorkerConfigAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocClusterClusterConfigWorkerConfigAccelerators | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigWorkerConfigAccelerators | cdktf.IResolvable | undefined);
    private _acceleratorCount?;
    get acceleratorCount(): number;
    set acceleratorCount(value: number);
    get acceleratorCountInput(): number | undefined;
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    get acceleratorTypeInput(): string | undefined;
}
export declare class GoogleDataprocClusterClusterConfigWorkerConfigAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocClusterClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocClusterClusterConfigWorkerConfigAcceleratorsOutputReference;
}
export interface GoogleDataprocClusterClusterConfigWorkerConfigDiskConfig {
    /**
    * Size of the primary disk attached to each node, specified in GB. The primary disk contains the boot volume and system libraries, and the smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#boot_disk_size_gb GoogleDataprocCluster#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * The disk type of the primary disk attached to each node. Such as "pd-ssd" or "pd-standard". Defaults to "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#boot_disk_type GoogleDataprocCluster#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * The amount of local SSD disks that will be attached to each master cluster node. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#num_local_ssds GoogleDataprocCluster#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function googleDataprocClusterClusterConfigWorkerConfigDiskConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference | GoogleDataprocClusterClusterConfigWorkerConfigDiskConfig): any;
export declare class GoogleDataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigWorkerConfigDiskConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface GoogleDataprocClusterClusterConfigWorkerConfig {
    /**
    * The URI for the image to use for this master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#image_uri GoogleDataprocCluster#image_uri}
    */
    readonly imageUri?: string;
    /**
    * The name of a Google Compute Engine machine type to create for the master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#machine_type GoogleDataprocCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The name of a minimum generation of CPU family for the master/worker. If not specified, GCP will default to a predetermined computed value for each zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#min_cpu_platform GoogleDataprocCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Specifies the number of master/worker nodes to create. If not specified, GCP will default to a predetermined computed value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#num_instances GoogleDataprocCluster#num_instances}
    */
    readonly numInstances?: number;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#accelerators GoogleDataprocCluster#accelerators}
    */
    readonly accelerators?: GoogleDataprocClusterClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#disk_config GoogleDataprocCluster#disk_config}
    */
    readonly diskConfig?: GoogleDataprocClusterClusterConfigWorkerConfigDiskConfig;
}
export declare function googleDataprocClusterClusterConfigWorkerConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigWorkerConfigOutputReference | GoogleDataprocClusterClusterConfigWorkerConfig): any;
export declare class GoogleDataprocClusterClusterConfigWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfigWorkerConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfigWorkerConfig | undefined);
    private _imageUri?;
    get imageUri(): string;
    set imageUri(value: string);
    resetImageUri(): void;
    get imageUriInput(): string | undefined;
    get instanceNames(): string[];
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _accelerators;
    get accelerators(): GoogleDataprocClusterClusterConfigWorkerConfigAcceleratorsList;
    putAccelerators(value: GoogleDataprocClusterClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable): void;
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | GoogleDataprocClusterClusterConfigWorkerConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): GoogleDataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: GoogleDataprocClusterClusterConfigWorkerConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): GoogleDataprocClusterClusterConfigWorkerConfigDiskConfig | undefined;
}
export interface GoogleDataprocClusterClusterConfig {
    /**
    * The Cloud Storage staging bucket used to stage files, such as Hadoop jars, between client machines and the cluster. Note: If you don't explicitly specify a staging_bucket then GCP will auto create / assign one for you. However, you are not guaranteed an auto generated bucket which is solely dedicated to your cluster; it may be shared with other clusters in the same region/zone also choosing to use the auto generation option.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#staging_bucket GoogleDataprocCluster#staging_bucket}
    */
    readonly stagingBucket?: string;
    /**
    * The Cloud Storage temp bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. Note: If you don't explicitly specify a temp_bucket then GCP will auto create / assign one for you.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#temp_bucket GoogleDataprocCluster#temp_bucket}
    */
    readonly tempBucket?: string;
    /**
    * autoscaling_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#autoscaling_config GoogleDataprocCluster#autoscaling_config}
    */
    readonly autoscalingConfig?: GoogleDataprocClusterClusterConfigAutoscalingConfig;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#encryption_config GoogleDataprocCluster#encryption_config}
    */
    readonly encryptionConfig?: GoogleDataprocClusterClusterConfigEncryptionConfig;
    /**
    * endpoint_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#endpoint_config GoogleDataprocCluster#endpoint_config}
    */
    readonly endpointConfig?: GoogleDataprocClusterClusterConfigEndpointConfig;
    /**
    * gce_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#gce_cluster_config GoogleDataprocCluster#gce_cluster_config}
    */
    readonly gceClusterConfig?: GoogleDataprocClusterClusterConfigGceClusterConfig;
    /**
    * initialization_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#initialization_action GoogleDataprocCluster#initialization_action}
    */
    readonly initializationAction?: GoogleDataprocClusterClusterConfigInitializationAction[] | cdktf.IResolvable;
    /**
    * lifecycle_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#lifecycle_config GoogleDataprocCluster#lifecycle_config}
    */
    readonly lifecycleConfig?: GoogleDataprocClusterClusterConfigLifecycleConfig;
    /**
    * master_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#master_config GoogleDataprocCluster#master_config}
    */
    readonly masterConfig?: GoogleDataprocClusterClusterConfigMasterConfig;
    /**
    * metastore_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#metastore_config GoogleDataprocCluster#metastore_config}
    */
    readonly metastoreConfig?: GoogleDataprocClusterClusterConfigMetastoreConfig;
    /**
    * preemptible_worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#preemptible_worker_config GoogleDataprocCluster#preemptible_worker_config}
    */
    readonly preemptibleWorkerConfig?: GoogleDataprocClusterClusterConfigPreemptibleWorkerConfig;
    /**
    * security_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#security_config GoogleDataprocCluster#security_config}
    */
    readonly securityConfig?: GoogleDataprocClusterClusterConfigSecurityConfig;
    /**
    * software_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#software_config GoogleDataprocCluster#software_config}
    */
    readonly softwareConfig?: GoogleDataprocClusterClusterConfigSoftwareConfig;
    /**
    * worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#worker_config GoogleDataprocCluster#worker_config}
    */
    readonly workerConfig?: GoogleDataprocClusterClusterConfigWorkerConfig;
}
export declare function googleDataprocClusterClusterConfigToTerraform(struct?: GoogleDataprocClusterClusterConfigOutputReference | GoogleDataprocClusterClusterConfig): any;
export declare class GoogleDataprocClusterClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterClusterConfig | undefined;
    set internalValue(value: GoogleDataprocClusterClusterConfig | undefined);
    get bucket(): string;
    private _stagingBucket?;
    get stagingBucket(): string;
    set stagingBucket(value: string);
    resetStagingBucket(): void;
    get stagingBucketInput(): string | undefined;
    private _tempBucket?;
    get tempBucket(): string;
    set tempBucket(value: string);
    resetTempBucket(): void;
    get tempBucketInput(): string | undefined;
    private _autoscalingConfig;
    get autoscalingConfig(): GoogleDataprocClusterClusterConfigAutoscalingConfigOutputReference;
    putAutoscalingConfig(value: GoogleDataprocClusterClusterConfigAutoscalingConfig): void;
    resetAutoscalingConfig(): void;
    get autoscalingConfigInput(): GoogleDataprocClusterClusterConfigAutoscalingConfig | undefined;
    private _encryptionConfig;
    get encryptionConfig(): GoogleDataprocClusterClusterConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: GoogleDataprocClusterClusterConfigEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): GoogleDataprocClusterClusterConfigEncryptionConfig | undefined;
    private _endpointConfig;
    get endpointConfig(): GoogleDataprocClusterClusterConfigEndpointConfigOutputReference;
    putEndpointConfig(value: GoogleDataprocClusterClusterConfigEndpointConfig): void;
    resetEndpointConfig(): void;
    get endpointConfigInput(): GoogleDataprocClusterClusterConfigEndpointConfig | undefined;
    private _gceClusterConfig;
    get gceClusterConfig(): GoogleDataprocClusterClusterConfigGceClusterConfigOutputReference;
    putGceClusterConfig(value: GoogleDataprocClusterClusterConfigGceClusterConfig): void;
    resetGceClusterConfig(): void;
    get gceClusterConfigInput(): GoogleDataprocClusterClusterConfigGceClusterConfig | undefined;
    private _initializationAction;
    get initializationAction(): GoogleDataprocClusterClusterConfigInitializationActionList;
    putInitializationAction(value: GoogleDataprocClusterClusterConfigInitializationAction[] | cdktf.IResolvable): void;
    resetInitializationAction(): void;
    get initializationActionInput(): cdktf.IResolvable | GoogleDataprocClusterClusterConfigInitializationAction[] | undefined;
    private _lifecycleConfig;
    get lifecycleConfig(): GoogleDataprocClusterClusterConfigLifecycleConfigOutputReference;
    putLifecycleConfig(value: GoogleDataprocClusterClusterConfigLifecycleConfig): void;
    resetLifecycleConfig(): void;
    get lifecycleConfigInput(): GoogleDataprocClusterClusterConfigLifecycleConfig | undefined;
    private _masterConfig;
    get masterConfig(): GoogleDataprocClusterClusterConfigMasterConfigOutputReference;
    putMasterConfig(value: GoogleDataprocClusterClusterConfigMasterConfig): void;
    resetMasterConfig(): void;
    get masterConfigInput(): GoogleDataprocClusterClusterConfigMasterConfig | undefined;
    private _metastoreConfig;
    get metastoreConfig(): GoogleDataprocClusterClusterConfigMetastoreConfigOutputReference;
    putMetastoreConfig(value: GoogleDataprocClusterClusterConfigMetastoreConfig): void;
    resetMetastoreConfig(): void;
    get metastoreConfigInput(): GoogleDataprocClusterClusterConfigMetastoreConfig | undefined;
    private _preemptibleWorkerConfig;
    get preemptibleWorkerConfig(): GoogleDataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference;
    putPreemptibleWorkerConfig(value: GoogleDataprocClusterClusterConfigPreemptibleWorkerConfig): void;
    resetPreemptibleWorkerConfig(): void;
    get preemptibleWorkerConfigInput(): GoogleDataprocClusterClusterConfigPreemptibleWorkerConfig | undefined;
    private _securityConfig;
    get securityConfig(): GoogleDataprocClusterClusterConfigSecurityConfigOutputReference;
    putSecurityConfig(value: GoogleDataprocClusterClusterConfigSecurityConfig): void;
    resetSecurityConfig(): void;
    get securityConfigInput(): GoogleDataprocClusterClusterConfigSecurityConfig | undefined;
    private _softwareConfig;
    get softwareConfig(): GoogleDataprocClusterClusterConfigSoftwareConfigOutputReference;
    putSoftwareConfig(value: GoogleDataprocClusterClusterConfigSoftwareConfig): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): GoogleDataprocClusterClusterConfigSoftwareConfig | undefined;
    private _workerConfig;
    get workerConfig(): GoogleDataprocClusterClusterConfigWorkerConfigOutputReference;
    putWorkerConfig(value: GoogleDataprocClusterClusterConfigWorkerConfig): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): GoogleDataprocClusterClusterConfigWorkerConfig | undefined;
}
export interface GoogleDataprocClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#create GoogleDataprocCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#delete GoogleDataprocCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster#update GoogleDataprocCluster#update}
    */
    readonly update?: string;
}
export declare function googleDataprocClusterTimeoutsToTerraform(struct?: GoogleDataprocClusterTimeoutsOutputReference | GoogleDataprocClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataprocClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster google_dataproc_cluster}
*/
export declare class GoogleDataprocCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_cluster google_dataproc_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataprocClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataprocClusterConfig);
    private _gracefulDecommissionTimeout?;
    get gracefulDecommissionTimeout(): string;
    set gracefulDecommissionTimeout(value: string);
    resetGracefulDecommissionTimeout(): void;
    get gracefulDecommissionTimeoutInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _clusterConfig;
    get clusterConfig(): GoogleDataprocClusterClusterConfigOutputReference;
    putClusterConfig(value: GoogleDataprocClusterClusterConfig): void;
    resetClusterConfig(): void;
    get clusterConfigInput(): GoogleDataprocClusterClusterConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleDataprocClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleDataprocClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataprocClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
