import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataprocMetastoreFederationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the metastore federation. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
  and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
  3 and 63 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#federation_id GoogleDataprocMetastoreFederation#federation_id}
    */
    readonly federationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#id GoogleDataprocMetastoreFederation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the metastore federation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#labels GoogleDataprocMetastoreFederation#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the metastore federation should reside.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#location GoogleDataprocMetastoreFederation#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#project GoogleDataprocMetastoreFederation#project}
    */
    readonly project?: string;
    /**
    * The Apache Hive metastore version of the federation. All backend metastore versions must be compatible with the federation version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#version GoogleDataprocMetastoreFederation#version}
    */
    readonly version: string;
    /**
    * backend_metastores block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#backend_metastores GoogleDataprocMetastoreFederation#backend_metastores}
    */
    readonly backendMetastores: GoogleDataprocMetastoreFederationBackendMetastores[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#timeouts GoogleDataprocMetastoreFederation#timeouts}
    */
    readonly timeouts?: GoogleDataprocMetastoreFederationTimeouts;
}
export interface GoogleDataprocMetastoreFederationBackendMetastores {
    /**
    * The type of the backend metastore. Possible values: ["METASTORE_TYPE_UNSPECIFIED", "DATAPROC_METASTORE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#metastore_type GoogleDataprocMetastoreFederation#metastore_type}
    */
    readonly metastoreType: string;
    /**
    * The relative resource name of the metastore that is being federated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#name GoogleDataprocMetastoreFederation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#rank GoogleDataprocMetastoreFederation#rank}
    */
    readonly rank: string;
}
export declare function googleDataprocMetastoreFederationBackendMetastoresToTerraform(struct?: GoogleDataprocMetastoreFederationBackendMetastores | cdktf.IResolvable): any;
export declare class GoogleDataprocMetastoreFederationBackendMetastoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocMetastoreFederationBackendMetastores | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocMetastoreFederationBackendMetastores | cdktf.IResolvable | undefined);
    private _metastoreType?;
    get metastoreType(): string;
    set metastoreType(value: string);
    get metastoreTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rank?;
    get rank(): string;
    set rank(value: string);
    get rankInput(): string | undefined;
}
export declare class GoogleDataprocMetastoreFederationBackendMetastoresList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocMetastoreFederationBackendMetastores[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocMetastoreFederationBackendMetastoresOutputReference;
}
export interface GoogleDataprocMetastoreFederationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#create GoogleDataprocMetastoreFederation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#delete GoogleDataprocMetastoreFederation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation#update GoogleDataprocMetastoreFederation#update}
    */
    readonly update?: string;
}
export declare function googleDataprocMetastoreFederationTimeoutsToTerraform(struct?: GoogleDataprocMetastoreFederationTimeoutsOutputReference | GoogleDataprocMetastoreFederationTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataprocMetastoreFederationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocMetastoreFederationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocMetastoreFederationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation google_dataproc_metastore_federation}
*/
export declare class GoogleDataprocMetastoreFederation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_metastore_federation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_federation google_dataproc_metastore_federation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataprocMetastoreFederationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataprocMetastoreFederationConfig);
    get endpointUri(): string;
    private _federationId?;
    get federationId(): string;
    set federationId(value: string);
    get federationIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get stateMessage(): string;
    get uid(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _backendMetastores;
    get backendMetastores(): GoogleDataprocMetastoreFederationBackendMetastoresList;
    putBackendMetastores(value: GoogleDataprocMetastoreFederationBackendMetastores[] | cdktf.IResolvable): void;
    get backendMetastoresInput(): cdktf.IResolvable | GoogleDataprocMetastoreFederationBackendMetastores[] | undefined;
    private _timeouts;
    get timeouts(): GoogleDataprocMetastoreFederationTimeoutsOutputReference;
    putTimeouts(value: GoogleDataprocMetastoreFederationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataprocMetastoreFederationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
