import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataprocMetastoreServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database type that the Metastore service stores its data. Default value: "MYSQL" Possible values: ["MYSQL", "SPANNER"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#database_type GoogleDataprocMetastoreService#database_type}
    */
    readonly databaseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#id GoogleDataprocMetastoreService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the metastore service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#labels GoogleDataprocMetastoreService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the metastore service should reside.
  The default value is 'global'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#location GoogleDataprocMetastoreService#location}
    */
    readonly location?: string;
    /**
    * The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
  
  "projects/{projectNumber}/global/networks/{network_id}".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#network GoogleDataprocMetastoreService#network}
    */
    readonly network?: string;
    /**
    * The TCP port at which the metastore service is reached. Default: 9083.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#port GoogleDataprocMetastoreService#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#project GoogleDataprocMetastoreService#project}
    */
    readonly project?: string;
    /**
    * The release channel of the service. If unspecified, defaults to 'STABLE'. Default value: "STABLE" Possible values: ["CANARY", "STABLE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#release_channel GoogleDataprocMetastoreService#release_channel}
    */
    readonly releaseChannel?: string;
    /**
    * The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
  and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
  3 and 63 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#service_id GoogleDataprocMetastoreService#service_id}
    */
    readonly serviceId: string;
    /**
    * The tier of the service. Possible values: ["DEVELOPER", "ENTERPRISE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#tier GoogleDataprocMetastoreService#tier}
    */
    readonly tier?: string;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#encryption_config GoogleDataprocMetastoreService#encryption_config}
    */
    readonly encryptionConfig?: GoogleDataprocMetastoreServiceEncryptionConfig;
    /**
    * hive_metastore_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#hive_metastore_config GoogleDataprocMetastoreService#hive_metastore_config}
    */
    readonly hiveMetastoreConfig?: GoogleDataprocMetastoreServiceHiveMetastoreConfig;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#maintenance_window GoogleDataprocMetastoreService#maintenance_window}
    */
    readonly maintenanceWindow?: GoogleDataprocMetastoreServiceMaintenanceWindow;
    /**
    * metadata_integration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#metadata_integration GoogleDataprocMetastoreService#metadata_integration}
    */
    readonly metadataIntegration?: GoogleDataprocMetastoreServiceMetadataIntegration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#timeouts GoogleDataprocMetastoreService#timeouts}
    */
    readonly timeouts?: GoogleDataprocMetastoreServiceTimeouts;
}
export interface GoogleDataprocMetastoreServiceEncryptionConfig {
    /**
    * The fully qualified customer provided Cloud KMS key name to use for customer data encryption.
  Use the following format: 'projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#kms_key GoogleDataprocMetastoreService#kms_key}
    */
    readonly kmsKey: string;
}
export declare function googleDataprocMetastoreServiceEncryptionConfigToTerraform(struct?: GoogleDataprocMetastoreServiceEncryptionConfigOutputReference | GoogleDataprocMetastoreServiceEncryptionConfig): any;
export declare class GoogleDataprocMetastoreServiceEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocMetastoreServiceEncryptionConfig | undefined;
    set internalValue(value: GoogleDataprocMetastoreServiceEncryptionConfig | undefined);
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    get kmsKeyInput(): string | undefined;
}
export interface GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions {
    /**
    * A mapping of Hive metastore configuration key-value pairs to apply to the auxiliary Hive metastore (configured in hive-site.xml) in addition to the primary version's overrides.
  If keys are present in both the auxiliary version's overrides and the primary version's overrides, the value from the auxiliary version's overrides takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#config_overrides GoogleDataprocMetastoreService#config_overrides}
    */
    readonly configOverrides?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#key GoogleDataprocMetastoreService#key}
    */
    readonly key: string;
    /**
    * The Hive metastore version of the auxiliary service. It must be less than the primary Hive metastore service's version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#version GoogleDataprocMetastoreService#version}
    */
    readonly version: string;
}
export declare function googleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersionsToTerraform(struct?: GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions | cdktf.IResolvable): any;
export declare class GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions | cdktf.IResolvable | undefined);
    private _configOverrides?;
    get configOverrides(): {
        [key: string]: string;
    };
    set configOverrides(value: {
        [key: string]: string;
    });
    resetConfigOverrides(): void;
    get configOverridesInput(): {
        [key: string]: string;
    } | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export declare class GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersionsOutputReference;
}
export interface GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab {
    /**
    * The relative resource name of a Secret Manager secret version, in the following form:
  
  "projects/{projectNumber}/secrets/{secret_id}/versions/{version_id}".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#cloud_secret GoogleDataprocMetastoreService#cloud_secret}
    */
    readonly cloudSecret: string;
}
export declare function googleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabToTerraform(struct?: GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabOutputReference | GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab): any;
export declare class GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab | undefined;
    set internalValue(value: GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab | undefined);
    private _cloudSecret?;
    get cloudSecret(): string;
    set cloudSecret(value: string);
    get cloudSecretInput(): string | undefined;
}
export interface GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig {
    /**
    * A Cloud Storage URI that specifies the path to a krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf, although the file does not need to be named krb5.conf explicitly.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#krb5_config_gcs_uri GoogleDataprocMetastoreService#krb5_config_gcs_uri}
    */
    readonly krb5ConfigGcsUri: string;
    /**
    * A Kerberos principal that exists in the both the keytab the KDC to authenticate as. A typical principal is of the form "primary/instance@REALM", but there is no exact format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#principal GoogleDataprocMetastoreService#principal}
    */
    readonly principal: string;
    /**
    * keytab block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#keytab GoogleDataprocMetastoreService#keytab}
    */
    readonly keytab: GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab;
}
export declare function googleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigToTerraform(struct?: GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigOutputReference | GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig): any;
export declare class GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig | undefined;
    set internalValue(value: GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig | undefined);
    private _krb5ConfigGcsUri?;
    get krb5ConfigGcsUri(): string;
    set krb5ConfigGcsUri(value: string);
    get krb5ConfigGcsUriInput(): string | undefined;
    private _principal?;
    get principal(): string;
    set principal(value: string);
    get principalInput(): string | undefined;
    private _keytab;
    get keytab(): GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabOutputReference;
    putKeytab(value: GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab): void;
    get keytabInput(): GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab | undefined;
}
export interface GoogleDataprocMetastoreServiceHiveMetastoreConfig {
    /**
    * A mapping of Hive metastore configuration key-value pairs to apply to the Hive metastore (configured in hive-site.xml).
  The mappings override system defaults (some keys cannot be overridden)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#config_overrides GoogleDataprocMetastoreService#config_overrides}
    */
    readonly configOverrides?: {
        [key: string]: string;
    };
    /**
    * The protocol to use for the metastore service endpoint. If unspecified, defaults to 'THRIFT'. Default value: "THRIFT" Possible values: ["THRIFT", "GRPC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#endpoint_protocol GoogleDataprocMetastoreService#endpoint_protocol}
    */
    readonly endpointProtocol?: string;
    /**
    * The Hive metastore schema version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#version GoogleDataprocMetastoreService#version}
    */
    readonly version: string;
    /**
    * auxiliary_versions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#auxiliary_versions GoogleDataprocMetastoreService#auxiliary_versions}
    */
    readonly auxiliaryVersions?: GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions[] | cdktf.IResolvable;
    /**
    * kerberos_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#kerberos_config GoogleDataprocMetastoreService#kerberos_config}
    */
    readonly kerberosConfig?: GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig;
}
export declare function googleDataprocMetastoreServiceHiveMetastoreConfigToTerraform(struct?: GoogleDataprocMetastoreServiceHiveMetastoreConfigOutputReference | GoogleDataprocMetastoreServiceHiveMetastoreConfig): any;
export declare class GoogleDataprocMetastoreServiceHiveMetastoreConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocMetastoreServiceHiveMetastoreConfig | undefined;
    set internalValue(value: GoogleDataprocMetastoreServiceHiveMetastoreConfig | undefined);
    private _configOverrides?;
    get configOverrides(): {
        [key: string]: string;
    };
    set configOverrides(value: {
        [key: string]: string;
    });
    resetConfigOverrides(): void;
    get configOverridesInput(): {
        [key: string]: string;
    } | undefined;
    private _endpointProtocol?;
    get endpointProtocol(): string;
    set endpointProtocol(value: string);
    resetEndpointProtocol(): void;
    get endpointProtocolInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _auxiliaryVersions;
    get auxiliaryVersions(): GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersionsList;
    putAuxiliaryVersions(value: GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions[] | cdktf.IResolvable): void;
    resetAuxiliaryVersions(): void;
    get auxiliaryVersionsInput(): cdktf.IResolvable | GoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions[] | undefined;
    private _kerberosConfig;
    get kerberosConfig(): GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigOutputReference;
    putKerberosConfig(value: GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig): void;
    resetKerberosConfig(): void;
    get kerberosConfigInput(): GoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig | undefined;
}
export interface GoogleDataprocMetastoreServiceMaintenanceWindow {
    /**
    * The day of week, when the window starts. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#day_of_week GoogleDataprocMetastoreService#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * The hour of day (0-23) when the window starts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#hour_of_day GoogleDataprocMetastoreService#hour_of_day}
    */
    readonly hourOfDay: number;
}
export declare function googleDataprocMetastoreServiceMaintenanceWindowToTerraform(struct?: GoogleDataprocMetastoreServiceMaintenanceWindowOutputReference | GoogleDataprocMetastoreServiceMaintenanceWindow): any;
export declare class GoogleDataprocMetastoreServiceMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocMetastoreServiceMaintenanceWindow | undefined;
    set internalValue(value: GoogleDataprocMetastoreServiceMaintenanceWindow | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _hourOfDay?;
    get hourOfDay(): number;
    set hourOfDay(value: number);
    get hourOfDayInput(): number | undefined;
}
export interface GoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig {
    /**
    * Defines whether the metastore metadata should be synced to Data Catalog. The default value is to disable syncing metastore metadata to Data Catalog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#enabled GoogleDataprocMetastoreService#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfigToTerraform(struct?: GoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfigOutputReference | GoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig): any;
export declare class GoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig | undefined;
    set internalValue(value: GoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleDataprocMetastoreServiceMetadataIntegration {
    /**
    * data_catalog_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#data_catalog_config GoogleDataprocMetastoreService#data_catalog_config}
    */
    readonly dataCatalogConfig: GoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig;
}
export declare function googleDataprocMetastoreServiceMetadataIntegrationToTerraform(struct?: GoogleDataprocMetastoreServiceMetadataIntegrationOutputReference | GoogleDataprocMetastoreServiceMetadataIntegration): any;
export declare class GoogleDataprocMetastoreServiceMetadataIntegrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocMetastoreServiceMetadataIntegration | undefined;
    set internalValue(value: GoogleDataprocMetastoreServiceMetadataIntegration | undefined);
    private _dataCatalogConfig;
    get dataCatalogConfig(): GoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfigOutputReference;
    putDataCatalogConfig(value: GoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig): void;
    get dataCatalogConfigInput(): GoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig | undefined;
}
export interface GoogleDataprocMetastoreServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#create GoogleDataprocMetastoreService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#delete GoogleDataprocMetastoreService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service#update GoogleDataprocMetastoreService#update}
    */
    readonly update?: string;
}
export declare function googleDataprocMetastoreServiceTimeoutsToTerraform(struct?: GoogleDataprocMetastoreServiceTimeoutsOutputReference | GoogleDataprocMetastoreServiceTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataprocMetastoreServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocMetastoreServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocMetastoreServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service google_dataproc_metastore_service}
*/
export declare class GoogleDataprocMetastoreService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_metastore_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_metastore_service google_dataproc_metastore_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataprocMetastoreServiceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataprocMetastoreServiceConfig);
    get artifactGcsUri(): string;
    private _databaseType?;
    get databaseType(): string;
    set databaseType(value: string);
    resetDatabaseType(): void;
    get databaseTypeInput(): string | undefined;
    get endpointUri(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _releaseChannel?;
    get releaseChannel(): string;
    set releaseChannel(value: string);
    resetReleaseChannel(): void;
    get releaseChannelInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    get state(): string;
    get stateMessage(): string;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    get uid(): string;
    private _encryptionConfig;
    get encryptionConfig(): GoogleDataprocMetastoreServiceEncryptionConfigOutputReference;
    putEncryptionConfig(value: GoogleDataprocMetastoreServiceEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): GoogleDataprocMetastoreServiceEncryptionConfig | undefined;
    private _hiveMetastoreConfig;
    get hiveMetastoreConfig(): GoogleDataprocMetastoreServiceHiveMetastoreConfigOutputReference;
    putHiveMetastoreConfig(value: GoogleDataprocMetastoreServiceHiveMetastoreConfig): void;
    resetHiveMetastoreConfig(): void;
    get hiveMetastoreConfigInput(): GoogleDataprocMetastoreServiceHiveMetastoreConfig | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): GoogleDataprocMetastoreServiceMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: GoogleDataprocMetastoreServiceMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): GoogleDataprocMetastoreServiceMaintenanceWindow | undefined;
    private _metadataIntegration;
    get metadataIntegration(): GoogleDataprocMetastoreServiceMetadataIntegrationOutputReference;
    putMetadataIntegration(value: GoogleDataprocMetastoreServiceMetadataIntegration): void;
    resetMetadataIntegration(): void;
    get metadataIntegrationInput(): GoogleDataprocMetastoreServiceMetadataIntegration | undefined;
    private _timeouts;
    get timeouts(): GoogleDataprocMetastoreServiceTimeoutsOutputReference;
    putTimeouts(value: GoogleDataprocMetastoreServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataprocMetastoreServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
