import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataprocWorkflowTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see [JSON representation of duration](https://developers.google.com/protocol-buffers/docs/proto3#json)). The timeout duration must be from 10 minutes ("600s") to 24 hours ("86400s"). The timer begins when the first job is submitted. If the workflow is running at the end of the timeout period, any remaining jobs are cancelled, the workflow is ended, and if the workflow was running on a [managed cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster), the cluster is deleted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#dag_timeout GoogleDataprocWorkflowTemplate#dag_timeout}
    */
    readonly dagTimeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#id GoogleDataprocWorkflowTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. The labels to associate with this template. These labels will be propagated to all jobs and clusters created by the workflow instance. Label **keys** must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be empty, but, if present, must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#labels GoogleDataprocWorkflowTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#location GoogleDataprocWorkflowTemplate#location}
    */
    readonly location: string;
    /**
    * Output only. The resource name of the workflow template, as described in https://cloud.google.com/apis/design/resource_names. * For `projects.regions.workflowTemplates`, the resource name of the template has the following format: `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}` * For `projects.locations.workflowTemplates`, the resource name of the template has the following format: `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#name GoogleDataprocWorkflowTemplate#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#project GoogleDataprocWorkflowTemplate#project}
    */
    readonly project?: string;
    /**
    * Output only. The current version of this workflow template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#version GoogleDataprocWorkflowTemplate#version}
    */
    readonly version?: number;
    /**
    * jobs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#jobs GoogleDataprocWorkflowTemplate#jobs}
    */
    readonly jobs: GoogleDataprocWorkflowTemplateJobs[] | cdktf.IResolvable;
    /**
    * parameters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#parameters GoogleDataprocWorkflowTemplate#parameters}
    */
    readonly parameters?: GoogleDataprocWorkflowTemplateParameters[] | cdktf.IResolvable;
    /**
    * placement block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#placement GoogleDataprocWorkflowTemplate#placement}
    */
    readonly placement: GoogleDataprocWorkflowTemplatePlacement;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#timeouts GoogleDataprocWorkflowTemplate#timeouts}
    */
    readonly timeouts?: GoogleDataprocWorkflowTemplateTimeouts;
}
export interface GoogleDataprocWorkflowTemplateJobsHadoopJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#driver_log_levels GoogleDataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function googleDataprocWorkflowTemplateJobsHadoopJobLoggingConfigToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference | GoogleDataprocWorkflowTemplateJobsHadoopJobLoggingConfig): any;
export declare class GoogleDataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsHadoopJob {
    /**
    * Optional. HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#archive_uris GoogleDataprocWorkflowTemplate#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Optional. The arguments to pass to the driver. Do not include arguments, such as `-libjars` or `-Dfoo=bar`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#args GoogleDataprocWorkflowTemplate#args}
    */
    readonly args?: string[];
    /**
    * Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#file_uris GoogleDataprocWorkflowTemplate#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#jar_file_uris GoogleDataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#main_class GoogleDataprocWorkflowTemplate#main_class}
    */
    readonly mainClass?: string;
    /**
    * The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#main_jar_file_uri GoogleDataprocWorkflowTemplate#main_jar_file_uri}
    */
    readonly mainJarFileUri?: string;
    /**
    * Optional. A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#properties GoogleDataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#logging_config GoogleDataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocWorkflowTemplateJobsHadoopJobLoggingConfig;
}
export declare function googleDataprocWorkflowTemplateJobsHadoopJobToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsHadoopJobOutputReference | GoogleDataprocWorkflowTemplateJobsHadoopJob): any;
export declare class GoogleDataprocWorkflowTemplateJobsHadoopJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsHadoopJob | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsHadoopJob | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string;
    set mainClass(value: string);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string;
    set mainJarFileUri(value: string);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocWorkflowTemplateJobsHadoopJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsHiveJobQueryList {
    /**
    * Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#queries GoogleDataprocWorkflowTemplate#queries}
    */
    readonly queries: string[];
}
export declare function googleDataprocWorkflowTemplateJobsHiveJobQueryListToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsHiveJobQueryListOutputReference | GoogleDataprocWorkflowTemplateJobsHiveJobQueryList): any;
export declare class GoogleDataprocWorkflowTemplateJobsHiveJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsHiveJobQueryList | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsHiveJobQueryList | undefined);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsHiveJob {
    /**
    * Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#continue_on_failure GoogleDataprocWorkflowTemplate#continue_on_failure}
    */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
    * Optional. HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#jar_file_uris GoogleDataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * Optional. A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#properties GoogleDataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * The HCFS URI of the script that contains Hive queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#query_file_uri GoogleDataprocWorkflowTemplate#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * Optional. Mapping of query variable names to values (equivalent to the Hive command: `SET name="value";`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#script_variables GoogleDataprocWorkflowTemplate#script_variables}
    */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
    * query_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#query_list GoogleDataprocWorkflowTemplate#query_list}
    */
    readonly queryList?: GoogleDataprocWorkflowTemplateJobsHiveJobQueryList;
}
export declare function googleDataprocWorkflowTemplateJobsHiveJobToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsHiveJobOutputReference | GoogleDataprocWorkflowTemplateJobsHiveJob): any;
export declare class GoogleDataprocWorkflowTemplateJobsHiveJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsHiveJob | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsHiveJob | undefined);
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable;
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    };
    set scriptVariables(value: {
        [key: string]: string;
    });
    resetScriptVariables(): void;
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryList;
    get queryList(): GoogleDataprocWorkflowTemplateJobsHiveJobQueryListOutputReference;
    putQueryList(value: GoogleDataprocWorkflowTemplateJobsHiveJobQueryList): void;
    resetQueryList(): void;
    get queryListInput(): GoogleDataprocWorkflowTemplateJobsHiveJobQueryList | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsPigJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#driver_log_levels GoogleDataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function googleDataprocWorkflowTemplateJobsPigJobLoggingConfigToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference | GoogleDataprocWorkflowTemplateJobsPigJobLoggingConfig): any;
export declare class GoogleDataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsPigJobQueryList {
    /**
    * Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#queries GoogleDataprocWorkflowTemplate#queries}
    */
    readonly queries: string[];
}
export declare function googleDataprocWorkflowTemplateJobsPigJobQueryListToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsPigJobQueryListOutputReference | GoogleDataprocWorkflowTemplateJobsPigJobQueryList): any;
export declare class GoogleDataprocWorkflowTemplateJobsPigJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsPigJobQueryList | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsPigJobQueryList | undefined);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsPigJob {
    /**
    * Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#continue_on_failure GoogleDataprocWorkflowTemplate#continue_on_failure}
    */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
    * Optional. HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#jar_file_uris GoogleDataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * Optional. A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#properties GoogleDataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * The HCFS URI of the script that contains the Pig queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#query_file_uri GoogleDataprocWorkflowTemplate#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * Optional. Mapping of query variable names to values (equivalent to the Pig command: `name=[value]`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#script_variables GoogleDataprocWorkflowTemplate#script_variables}
    */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#logging_config GoogleDataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocWorkflowTemplateJobsPigJobLoggingConfig;
    /**
    * query_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#query_list GoogleDataprocWorkflowTemplate#query_list}
    */
    readonly queryList?: GoogleDataprocWorkflowTemplateJobsPigJobQueryList;
}
export declare function googleDataprocWorkflowTemplateJobsPigJobToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsPigJobOutputReference | GoogleDataprocWorkflowTemplateJobsPigJob): any;
export declare class GoogleDataprocWorkflowTemplateJobsPigJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsPigJob | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsPigJob | undefined);
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable;
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    };
    set scriptVariables(value: {
        [key: string]: string;
    });
    resetScriptVariables(): void;
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocWorkflowTemplateJobsPigJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined;
    private _queryList;
    get queryList(): GoogleDataprocWorkflowTemplateJobsPigJobQueryListOutputReference;
    putQueryList(value: GoogleDataprocWorkflowTemplateJobsPigJobQueryList): void;
    resetQueryList(): void;
    get queryListInput(): GoogleDataprocWorkflowTemplateJobsPigJobQueryList | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsPrestoJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#driver_log_levels GoogleDataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function googleDataprocWorkflowTemplateJobsPrestoJobLoggingConfigToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference | GoogleDataprocWorkflowTemplateJobsPrestoJobLoggingConfig): any;
export declare class GoogleDataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsPrestoJobQueryList {
    /**
    * Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#queries GoogleDataprocWorkflowTemplate#queries}
    */
    readonly queries: string[];
}
export declare function googleDataprocWorkflowTemplateJobsPrestoJobQueryListToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference | GoogleDataprocWorkflowTemplateJobsPrestoJobQueryList): any;
export declare class GoogleDataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsPrestoJobQueryList | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsPrestoJobQueryList | undefined);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsPrestoJob {
    /**
    * Optional. Presto client tags to attach to this query
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#client_tags GoogleDataprocWorkflowTemplate#client_tags}
    */
    readonly clientTags?: string[];
    /**
    * Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#continue_on_failure GoogleDataprocWorkflowTemplate#continue_on_failure}
    */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
    * Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#output_format GoogleDataprocWorkflowTemplate#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Optional. A mapping of property names to values. Used to set Presto [session properties](https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#properties GoogleDataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * The HCFS URI of the script that contains SQL queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#query_file_uri GoogleDataprocWorkflowTemplate#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#logging_config GoogleDataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocWorkflowTemplateJobsPrestoJobLoggingConfig;
    /**
    * query_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#query_list GoogleDataprocWorkflowTemplate#query_list}
    */
    readonly queryList?: GoogleDataprocWorkflowTemplateJobsPrestoJobQueryList;
}
export declare function googleDataprocWorkflowTemplateJobsPrestoJobToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsPrestoJobOutputReference | GoogleDataprocWorkflowTemplateJobsPrestoJob): any;
export declare class GoogleDataprocWorkflowTemplateJobsPrestoJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsPrestoJob | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsPrestoJob | undefined);
    private _clientTags?;
    get clientTags(): string[];
    set clientTags(value: string[]);
    resetClientTags(): void;
    get clientTagsInput(): string[] | undefined;
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable;
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocWorkflowTemplateJobsPrestoJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined;
    private _queryList;
    get queryList(): GoogleDataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference;
    putQueryList(value: GoogleDataprocWorkflowTemplateJobsPrestoJobQueryList): void;
    resetQueryList(): void;
    get queryListInput(): GoogleDataprocWorkflowTemplateJobsPrestoJobQueryList | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsPysparkJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#driver_log_levels GoogleDataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function googleDataprocWorkflowTemplateJobsPysparkJobLoggingConfigToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference | GoogleDataprocWorkflowTemplateJobsPysparkJobLoggingConfig): any;
export declare class GoogleDataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsPysparkJob {
    /**
    * Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#archive_uris GoogleDataprocWorkflowTemplate#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#args GoogleDataprocWorkflowTemplate#args}
    */
    readonly args?: string[];
    /**
    * Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#file_uris GoogleDataprocWorkflowTemplate#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#jar_file_uris GoogleDataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#main_python_file_uri GoogleDataprocWorkflowTemplate#main_python_file_uri}
    */
    readonly mainPythonFileUri: string;
    /**
    * Optional. A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#properties GoogleDataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#python_file_uris GoogleDataprocWorkflowTemplate#python_file_uris}
    */
    readonly pythonFileUris?: string[];
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#logging_config GoogleDataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocWorkflowTemplateJobsPysparkJobLoggingConfig;
}
export declare function googleDataprocWorkflowTemplateJobsPysparkJobToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsPysparkJobOutputReference | GoogleDataprocWorkflowTemplateJobsPysparkJob): any;
export declare class GoogleDataprocWorkflowTemplateJobsPysparkJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsPysparkJob | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsPysparkJob | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainPythonFileUri?;
    get mainPythonFileUri(): string;
    set mainPythonFileUri(value: string);
    get mainPythonFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _pythonFileUris?;
    get pythonFileUris(): string[];
    set pythonFileUris(value: string[]);
    resetPythonFileUris(): void;
    get pythonFileUrisInput(): string[] | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocWorkflowTemplateJobsPysparkJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsScheduling {
    /**
    * Optional. Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window. Maximum value is 10.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#max_failures_per_hour GoogleDataprocWorkflowTemplate#max_failures_per_hour}
    */
    readonly maxFailuresPerHour?: number;
    /**
    * Optional. Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#max_failures_total GoogleDataprocWorkflowTemplate#max_failures_total}
    */
    readonly maxFailuresTotal?: number;
}
export declare function googleDataprocWorkflowTemplateJobsSchedulingToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsSchedulingOutputReference | GoogleDataprocWorkflowTemplateJobsScheduling): any;
export declare class GoogleDataprocWorkflowTemplateJobsSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsScheduling | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsScheduling | undefined);
    private _maxFailuresPerHour?;
    get maxFailuresPerHour(): number;
    set maxFailuresPerHour(value: number);
    resetMaxFailuresPerHour(): void;
    get maxFailuresPerHourInput(): number | undefined;
    private _maxFailuresTotal?;
    get maxFailuresTotal(): number;
    set maxFailuresTotal(value: number);
    resetMaxFailuresTotal(): void;
    get maxFailuresTotalInput(): number | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsSparkJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#driver_log_levels GoogleDataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function googleDataprocWorkflowTemplateJobsSparkJobLoggingConfigToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference | GoogleDataprocWorkflowTemplateJobsSparkJobLoggingConfig): any;
export declare class GoogleDataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsSparkJob {
    /**
    * Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#archive_uris GoogleDataprocWorkflowTemplate#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#args GoogleDataprocWorkflowTemplate#args}
    */
    readonly args?: string[];
    /**
    * Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#file_uris GoogleDataprocWorkflowTemplate#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#jar_file_uris GoogleDataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in `jar_file_uris`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#main_class GoogleDataprocWorkflowTemplate#main_class}
    */
    readonly mainClass?: string;
    /**
    * The HCFS URI of the jar file that contains the main class.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#main_jar_file_uri GoogleDataprocWorkflowTemplate#main_jar_file_uri}
    */
    readonly mainJarFileUri?: string;
    /**
    * Optional. A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#properties GoogleDataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#logging_config GoogleDataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocWorkflowTemplateJobsSparkJobLoggingConfig;
}
export declare function googleDataprocWorkflowTemplateJobsSparkJobToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsSparkJobOutputReference | GoogleDataprocWorkflowTemplateJobsSparkJob): any;
export declare class GoogleDataprocWorkflowTemplateJobsSparkJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsSparkJob | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsSparkJob | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string;
    set mainClass(value: string);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string;
    set mainJarFileUri(value: string);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocWorkflowTemplateJobsSparkJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsSparkRJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#driver_log_levels GoogleDataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function googleDataprocWorkflowTemplateJobsSparkRJobLoggingConfigToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference | GoogleDataprocWorkflowTemplateJobsSparkRJobLoggingConfig): any;
export declare class GoogleDataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsSparkRJob {
    /**
    * Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#archive_uris GoogleDataprocWorkflowTemplate#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#args GoogleDataprocWorkflowTemplate#args}
    */
    readonly args?: string[];
    /**
    * Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#file_uris GoogleDataprocWorkflowTemplate#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#main_r_file_uri GoogleDataprocWorkflowTemplate#main_r_file_uri}
    */
    readonly mainRFileUri: string;
    /**
    * Optional. A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#properties GoogleDataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#logging_config GoogleDataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocWorkflowTemplateJobsSparkRJobLoggingConfig;
}
export declare function googleDataprocWorkflowTemplateJobsSparkRJobToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsSparkRJobOutputReference | GoogleDataprocWorkflowTemplateJobsSparkRJob): any;
export declare class GoogleDataprocWorkflowTemplateJobsSparkRJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsSparkRJob | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsSparkRJob | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _mainRFileUri?;
    get mainRFileUri(): string;
    set mainRFileUri(value: string);
    get mainRFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocWorkflowTemplateJobsSparkRJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig {
    /**
    * The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#driver_log_levels GoogleDataprocWorkflowTemplate#driver_log_levels}
    */
    readonly driverLogLevels?: {
        [key: string]: string;
    };
}
export declare function googleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference | GoogleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig): any;
export declare class GoogleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsSparkSqlJobQueryList {
    /**
    * Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#queries GoogleDataprocWorkflowTemplate#queries}
    */
    readonly queries: string[];
}
export declare function googleDataprocWorkflowTemplateJobsSparkSqlJobQueryListToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference | GoogleDataprocWorkflowTemplateJobsSparkSqlJobQueryList): any;
export declare class GoogleDataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobsSparkSqlJob {
    /**
    * Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#jar_file_uris GoogleDataprocWorkflowTemplate#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#properties GoogleDataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * The HCFS URI of the script that contains SQL queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#query_file_uri GoogleDataprocWorkflowTemplate#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#script_variables GoogleDataprocWorkflowTemplate#script_variables}
    */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#logging_config GoogleDataprocWorkflowTemplate#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig;
    /**
    * query_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#query_list GoogleDataprocWorkflowTemplate#query_list}
    */
    readonly queryList?: GoogleDataprocWorkflowTemplateJobsSparkSqlJobQueryList;
}
export declare function googleDataprocWorkflowTemplateJobsSparkSqlJobToTerraform(struct?: GoogleDataprocWorkflowTemplateJobsSparkSqlJobOutputReference | GoogleDataprocWorkflowTemplateJobsSparkSqlJob): any;
export declare class GoogleDataprocWorkflowTemplateJobsSparkSqlJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateJobsSparkSqlJob | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobsSparkSqlJob | undefined);
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    };
    set scriptVariables(value: {
        [key: string]: string;
    });
    resetScriptVariables(): void;
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined;
    private _queryList;
    get queryList(): GoogleDataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference;
    putQueryList(value: GoogleDataprocWorkflowTemplateJobsSparkSqlJobQueryList): void;
    resetQueryList(): void;
    get queryListInput(): GoogleDataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined;
}
export interface GoogleDataprocWorkflowTemplateJobs {
    /**
    * Optional. The labels to associate with this job. Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: p{Ll}p{Lo}{0,62} Label values must be between 1 and 63 characters long, and must conform to the following regular expression: [p{Ll}p{Lo}p{N}_-]{0,63} No more than 32 labels can be associated with a given job.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#labels GoogleDataprocWorkflowTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Optional. The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#prerequisite_step_ids GoogleDataprocWorkflowTemplate#prerequisite_step_ids}
    */
    readonly prerequisiteStepIds?: string[];
    /**
    * Required. The step id. The id must be unique among all jobs within the template. The step id is used as prefix for job id, as job `goog-dataproc-workflow-step-id` label, and in prerequisiteStepIds field from other steps. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#step_id GoogleDataprocWorkflowTemplate#step_id}
    */
    readonly stepId: string;
    /**
    * hadoop_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#hadoop_job GoogleDataprocWorkflowTemplate#hadoop_job}
    */
    readonly hadoopJob?: GoogleDataprocWorkflowTemplateJobsHadoopJob;
    /**
    * hive_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#hive_job GoogleDataprocWorkflowTemplate#hive_job}
    */
    readonly hiveJob?: GoogleDataprocWorkflowTemplateJobsHiveJob;
    /**
    * pig_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#pig_job GoogleDataprocWorkflowTemplate#pig_job}
    */
    readonly pigJob?: GoogleDataprocWorkflowTemplateJobsPigJob;
    /**
    * presto_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#presto_job GoogleDataprocWorkflowTemplate#presto_job}
    */
    readonly prestoJob?: GoogleDataprocWorkflowTemplateJobsPrestoJob;
    /**
    * pyspark_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#pyspark_job GoogleDataprocWorkflowTemplate#pyspark_job}
    */
    readonly pysparkJob?: GoogleDataprocWorkflowTemplateJobsPysparkJob;
    /**
    * scheduling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#scheduling GoogleDataprocWorkflowTemplate#scheduling}
    */
    readonly scheduling?: GoogleDataprocWorkflowTemplateJobsScheduling;
    /**
    * spark_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#spark_job GoogleDataprocWorkflowTemplate#spark_job}
    */
    readonly sparkJob?: GoogleDataprocWorkflowTemplateJobsSparkJob;
    /**
    * spark_r_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#spark_r_job GoogleDataprocWorkflowTemplate#spark_r_job}
    */
    readonly sparkRJob?: GoogleDataprocWorkflowTemplateJobsSparkRJob;
    /**
    * spark_sql_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#spark_sql_job GoogleDataprocWorkflowTemplate#spark_sql_job}
    */
    readonly sparkSqlJob?: GoogleDataprocWorkflowTemplateJobsSparkSqlJob;
}
export declare function googleDataprocWorkflowTemplateJobsToTerraform(struct?: GoogleDataprocWorkflowTemplateJobs | cdktf.IResolvable): any;
export declare class GoogleDataprocWorkflowTemplateJobsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocWorkflowTemplateJobs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateJobs | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _prerequisiteStepIds?;
    get prerequisiteStepIds(): string[];
    set prerequisiteStepIds(value: string[]);
    resetPrerequisiteStepIds(): void;
    get prerequisiteStepIdsInput(): string[] | undefined;
    private _stepId?;
    get stepId(): string;
    set stepId(value: string);
    get stepIdInput(): string | undefined;
    private _hadoopJob;
    get hadoopJob(): GoogleDataprocWorkflowTemplateJobsHadoopJobOutputReference;
    putHadoopJob(value: GoogleDataprocWorkflowTemplateJobsHadoopJob): void;
    resetHadoopJob(): void;
    get hadoopJobInput(): GoogleDataprocWorkflowTemplateJobsHadoopJob | undefined;
    private _hiveJob;
    get hiveJob(): GoogleDataprocWorkflowTemplateJobsHiveJobOutputReference;
    putHiveJob(value: GoogleDataprocWorkflowTemplateJobsHiveJob): void;
    resetHiveJob(): void;
    get hiveJobInput(): GoogleDataprocWorkflowTemplateJobsHiveJob | undefined;
    private _pigJob;
    get pigJob(): GoogleDataprocWorkflowTemplateJobsPigJobOutputReference;
    putPigJob(value: GoogleDataprocWorkflowTemplateJobsPigJob): void;
    resetPigJob(): void;
    get pigJobInput(): GoogleDataprocWorkflowTemplateJobsPigJob | undefined;
    private _prestoJob;
    get prestoJob(): GoogleDataprocWorkflowTemplateJobsPrestoJobOutputReference;
    putPrestoJob(value: GoogleDataprocWorkflowTemplateJobsPrestoJob): void;
    resetPrestoJob(): void;
    get prestoJobInput(): GoogleDataprocWorkflowTemplateJobsPrestoJob | undefined;
    private _pysparkJob;
    get pysparkJob(): GoogleDataprocWorkflowTemplateJobsPysparkJobOutputReference;
    putPysparkJob(value: GoogleDataprocWorkflowTemplateJobsPysparkJob): void;
    resetPysparkJob(): void;
    get pysparkJobInput(): GoogleDataprocWorkflowTemplateJobsPysparkJob | undefined;
    private _scheduling;
    get scheduling(): GoogleDataprocWorkflowTemplateJobsSchedulingOutputReference;
    putScheduling(value: GoogleDataprocWorkflowTemplateJobsScheduling): void;
    resetScheduling(): void;
    get schedulingInput(): GoogleDataprocWorkflowTemplateJobsScheduling | undefined;
    private _sparkJob;
    get sparkJob(): GoogleDataprocWorkflowTemplateJobsSparkJobOutputReference;
    putSparkJob(value: GoogleDataprocWorkflowTemplateJobsSparkJob): void;
    resetSparkJob(): void;
    get sparkJobInput(): GoogleDataprocWorkflowTemplateJobsSparkJob | undefined;
    private _sparkRJob;
    get sparkRJob(): GoogleDataprocWorkflowTemplateJobsSparkRJobOutputReference;
    putSparkRJob(value: GoogleDataprocWorkflowTemplateJobsSparkRJob): void;
    resetSparkRJob(): void;
    get sparkRJobInput(): GoogleDataprocWorkflowTemplateJobsSparkRJob | undefined;
    private _sparkSqlJob;
    get sparkSqlJob(): GoogleDataprocWorkflowTemplateJobsSparkSqlJobOutputReference;
    putSparkSqlJob(value: GoogleDataprocWorkflowTemplateJobsSparkSqlJob): void;
    resetSparkSqlJob(): void;
    get sparkSqlJobInput(): GoogleDataprocWorkflowTemplateJobsSparkSqlJob | undefined;
}
export declare class GoogleDataprocWorkflowTemplateJobsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocWorkflowTemplateJobs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocWorkflowTemplateJobsOutputReference;
}
export interface GoogleDataprocWorkflowTemplateParametersValidationRegex {
    /**
    * Required. RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#regexes GoogleDataprocWorkflowTemplate#regexes}
    */
    readonly regexes: string[];
}
export declare function googleDataprocWorkflowTemplateParametersValidationRegexToTerraform(struct?: GoogleDataprocWorkflowTemplateParametersValidationRegexOutputReference | GoogleDataprocWorkflowTemplateParametersValidationRegex): any;
export declare class GoogleDataprocWorkflowTemplateParametersValidationRegexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateParametersValidationRegex | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateParametersValidationRegex | undefined);
    private _regexes?;
    get regexes(): string[];
    set regexes(value: string[]);
    get regexesInput(): string[] | undefined;
}
export interface GoogleDataprocWorkflowTemplateParametersValidationValues {
    /**
    * Required. List of allowed values for the parameter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#values GoogleDataprocWorkflowTemplate#values}
    */
    readonly values: string[];
}
export declare function googleDataprocWorkflowTemplateParametersValidationValuesToTerraform(struct?: GoogleDataprocWorkflowTemplateParametersValidationValuesOutputReference | GoogleDataprocWorkflowTemplateParametersValidationValues): any;
export declare class GoogleDataprocWorkflowTemplateParametersValidationValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateParametersValidationValues | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateParametersValidationValues | undefined);
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface GoogleDataprocWorkflowTemplateParametersValidation {
    /**
    * regex block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#regex GoogleDataprocWorkflowTemplate#regex}
    */
    readonly regex?: GoogleDataprocWorkflowTemplateParametersValidationRegex;
    /**
    * values block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#values GoogleDataprocWorkflowTemplate#values}
    */
    readonly values?: GoogleDataprocWorkflowTemplateParametersValidationValues;
}
export declare function googleDataprocWorkflowTemplateParametersValidationToTerraform(struct?: GoogleDataprocWorkflowTemplateParametersValidationOutputReference | GoogleDataprocWorkflowTemplateParametersValidation): any;
export declare class GoogleDataprocWorkflowTemplateParametersValidationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateParametersValidation | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateParametersValidation | undefined);
    private _regex;
    get regex(): GoogleDataprocWorkflowTemplateParametersValidationRegexOutputReference;
    putRegex(value: GoogleDataprocWorkflowTemplateParametersValidationRegex): void;
    resetRegex(): void;
    get regexInput(): GoogleDataprocWorkflowTemplateParametersValidationRegex | undefined;
    private _values;
    get values(): GoogleDataprocWorkflowTemplateParametersValidationValuesOutputReference;
    putValues(value: GoogleDataprocWorkflowTemplateParametersValidationValues): void;
    resetValues(): void;
    get valuesInput(): GoogleDataprocWorkflowTemplateParametersValidationValues | undefined;
}
export interface GoogleDataprocWorkflowTemplateParameters {
    /**
    * Optional. Brief description of the parameter. Must not exceed 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#description GoogleDataprocWorkflowTemplate#description}
    */
    readonly description?: string;
    /**
    * Required. Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths. A field path is similar in syntax to a google.protobuf.FieldMask. For example, a field path that references the zone field of a workflow template's cluster selector would be specified as `placement.clusterSelector.zone`. Also, field paths can reference fields using the following syntax: * Values in maps can be referenced by key: * labels['key'] * placement.clusterSelector.clusterLabels['key'] * placement.managedCluster.labels['key'] * placement.clusterSelector.clusterLabels['key'] * jobs['step-id'].labels['key'] * Jobs in the jobs list can be referenced by step-id: * jobs['step-id'].hadoopJob.mainJarFileUri * jobs['step-id'].hiveJob.queryFileUri * jobs['step-id'].pySparkJob.mainPythonFileUri * jobs['step-id'].hadoopJob.jarFileUris[0] * jobs['step-id'].hadoopJob.archiveUris[0] * jobs['step-id'].hadoopJob.fileUris[0] * jobs['step-id'].pySparkJob.pythonFileUris[0] * Items in repeated fields can be referenced by a zero-based index: * jobs['step-id'].sparkJob.args[0] * Other examples: * jobs['step-id'].hadoopJob.properties['key'] * jobs['step-id'].hadoopJob.args[0] * jobs['step-id'].hiveJob.scriptVariables['key'] * jobs['step-id'].hadoopJob.mainJarFileUri * placement.clusterSelector.zone It may not be possible to parameterize maps and repeated fields in their entirety since only individual map values and individual items in repeated fields can be referenced. For example, the following field paths are invalid: - placement.clusterSelector.clusterLabels - jobs['step-id'].sparkJob.args
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#fields GoogleDataprocWorkflowTemplate#fields}
    */
    readonly fields: string[];
    /**
    * Required. Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#name GoogleDataprocWorkflowTemplate#name}
    */
    readonly name: string;
    /**
    * validation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#validation GoogleDataprocWorkflowTemplate#validation}
    */
    readonly validation?: GoogleDataprocWorkflowTemplateParametersValidation;
}
export declare function googleDataprocWorkflowTemplateParametersToTerraform(struct?: GoogleDataprocWorkflowTemplateParameters | cdktf.IResolvable): any;
export declare class GoogleDataprocWorkflowTemplateParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocWorkflowTemplateParameters | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateParameters | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _fields?;
    get fields(): string[];
    set fields(value: string[]);
    get fieldsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _validation;
    get validation(): GoogleDataprocWorkflowTemplateParametersValidationOutputReference;
    putValidation(value: GoogleDataprocWorkflowTemplateParametersValidation): void;
    resetValidation(): void;
    get validationInput(): GoogleDataprocWorkflowTemplateParametersValidation | undefined;
}
export declare class GoogleDataprocWorkflowTemplateParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocWorkflowTemplateParameters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocWorkflowTemplateParametersOutputReference;
}
export interface GoogleDataprocWorkflowTemplatePlacementClusterSelector {
    /**
    * Required. The cluster labels. Cluster must have all labels to match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#cluster_labels GoogleDataprocWorkflowTemplate#cluster_labels}
    */
    readonly clusterLabels: {
        [key: string]: string;
    };
    /**
    * Optional. The zone where workflow process executes. This parameter does not affect the selection of the cluster. If unspecified, the zone of the first cluster matching the selector is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#zone GoogleDataprocWorkflowTemplate#zone}
    */
    readonly zone?: string;
}
export declare function googleDataprocWorkflowTemplatePlacementClusterSelectorToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementClusterSelectorOutputReference | GoogleDataprocWorkflowTemplatePlacementClusterSelector): any;
export declare class GoogleDataprocWorkflowTemplatePlacementClusterSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementClusterSelector | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementClusterSelector | undefined);
    private _clusterLabels?;
    get clusterLabels(): {
        [key: string]: string;
    };
    set clusterLabels(value: {
        [key: string]: string;
    });
    get clusterLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig {
    /**
    * Optional. The autoscaling policy used by the cluster. Only resource names including projectid and location (region) are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]` * `projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]` Note that the policy must be in the same project and Dataproc region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#policy GoogleDataprocWorkflowTemplate#policy}
    */
    readonly policy?: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined);
    private _policy?;
    get policy(): string;
    set policy(value: string);
    resetPolicy(): void;
    get policyInput(): string | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig {
    /**
    * Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#gce_pd_kms_key_name GoogleDataprocWorkflowTemplate#gce_pd_kms_key_name}
    */
    readonly gcePdKmsKeyName?: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined);
    private _gcePdKmsKeyName?;
    get gcePdKmsKeyName(): string;
    set gcePdKmsKeyName(value: string);
    resetGcePdKmsKeyName(): void;
    get gcePdKmsKeyNameInput(): string | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig {
    /**
    * Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#enable_http_port_access GoogleDataprocWorkflowTemplate#enable_http_port_access}
    */
    readonly enableHttpPortAccess?: boolean | cdktf.IResolvable;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined);
    private _enableHttpPortAccess?;
    get enableHttpPortAccess(): boolean | cdktf.IResolvable;
    set enableHttpPortAccess(value: boolean | cdktf.IResolvable);
    resetEnableHttpPortAccess(): void;
    get enableHttpPortAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _httpPorts;
    get httpPorts(): cdktf.StringMap;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity {
    /**
    * Required. The URI of a sole-tenant [node group resource](https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that the cluster will be created on. A full URL, partial URI, or node group name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1` * `projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1` * `node-group-1`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#node_group GoogleDataprocWorkflowTemplate#node_group}
    */
    readonly nodeGroup: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined);
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    get nodeGroupInput(): string | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity {
    /**
    * Optional. Type of reservation to consume Possible values: TYPE_UNSPECIFIED, NO_RESERVATION, ANY_RESERVATION, SPECIFIC_RESERVATION
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#consume_reservation_type GoogleDataprocWorkflowTemplate#consume_reservation_type}
    */
    readonly consumeReservationType?: string;
    /**
    * Optional. Corresponds to the label key of reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#key GoogleDataprocWorkflowTemplate#key}
    */
    readonly key?: string;
    /**
    * Optional. Corresponds to the label values of reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#values GoogleDataprocWorkflowTemplate#values}
    */
    readonly values?: string[];
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    resetConsumeReservationType(): void;
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig {
    /**
    * Optional. Defines whether instances have integrity monitoring enabled. Integrity monitoring compares the most recent boot measurements to the integrity policy baseline and returns a pair of pass/fail results depending on whether they match or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#enable_integrity_monitoring GoogleDataprocWorkflowTemplate#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Optional. Defines whether the instances have Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#enable_secure_boot GoogleDataprocWorkflowTemplate#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Optional. Defines whether the instance have the vTPM enabled. Virtual Trusted Platform Module protects objects like keys, certificates and enables Measured Boot by performing the measurements needed to create a known good boot baseline, called the integrity policy baseline.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#enable_vtpm GoogleDataprocWorkflowTemplate#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig {
    /**
    * Optional. If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This `internal_ip_only` restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#internal_ip_only GoogleDataprocWorkflowTemplate#internal_ip_only}
    */
    readonly internalIpOnly?: boolean | cdktf.IResolvable;
    /**
    * The Compute Engine metadata entries to add to all instances (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#metadata GoogleDataprocWorkflowTemplate#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither `network_uri` nor `subnetwork_uri` is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for more information). A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default` * `projects/[project_id]/regions/global/default` * `default`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#network GoogleDataprocWorkflowTemplate#network}
    */
    readonly network?: string;
    /**
    * Optional. The type of IPv6 access for a cluster. Possible values: PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED, INHERIT_FROM_SUBNETWORK, OUTBOUND, BIDIRECTIONAL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#private_ipv6_google_access GoogleDataprocWorkflowTemplate#private_ipv6_google_access}
    */
    readonly privateIpv6GoogleAccess?: string;
    /**
    * Optional. The [Dataproc service account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc) (also see [VM Data Plane identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity)) used by Dataproc cluster VM instances to access Google Cloud Platform services. If not specified, the [Compute Engine default service account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#service_account GoogleDataprocWorkflowTemplate#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Optional. The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: * https://www.googleapis.com/auth/cloud.useraccounts.readonly * https://www.googleapis.com/auth/devstorage.read_write * https://www.googleapis.com/auth/logging.write If no scopes are specified, the following defaults are also provided: * https://www.googleapis.com/auth/bigquery * https://www.googleapis.com/auth/bigtable.admin.table * https://www.googleapis.com/auth/bigtable.data * https://www.googleapis.com/auth/devstorage.full_control
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#service_account_scopes GoogleDataprocWorkflowTemplate#service_account_scopes}
    */
    readonly serviceAccountScopes?: string[];
    /**
    * Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0` * `projects/[project_id]/regions/us-east1/subnetworks/sub0` * `sub0`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#subnetwork GoogleDataprocWorkflowTemplate#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The Compute Engine tags to add to all instances (see [Tagging instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#tags GoogleDataprocWorkflowTemplate#tags}
    */
    readonly tags?: string[];
    /**
    * Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]` * `projects/[project_id]/zones/[zone]` * `us-central1-f`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#zone GoogleDataprocWorkflowTemplate#zone}
    */
    readonly zone?: string;
    /**
    * node_group_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#node_group_affinity GoogleDataprocWorkflowTemplate#node_group_affinity}
    */
    readonly nodeGroupAffinity?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#reservation_affinity GoogleDataprocWorkflowTemplate#reservation_affinity}
    */
    readonly reservationAffinity?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#shielded_instance_config GoogleDataprocWorkflowTemplate#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined);
    private _internalIpOnly?;
    get internalIpOnly(): boolean | cdktf.IResolvable;
    set internalIpOnly(value: boolean | cdktf.IResolvable);
    resetInternalIpOnly(): void;
    get internalIpOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _privateIpv6GoogleAccess?;
    get privateIpv6GoogleAccess(): string;
    set privateIpv6GoogleAccess(value: string);
    resetPrivateIpv6GoogleAccess(): void;
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    get serviceAccountScopes(): string[];
    set serviceAccountScopes(value: string[]);
    resetServiceAccountScopes(): void;
    get serviceAccountScopesInput(): string[] | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _nodeGroupAffinity;
    get nodeGroupAffinity(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference;
    putNodeGroupAffinity(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity): void;
    resetNodeGroupAffinity(): void;
    get nodeGroupAffinityInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined;
    private _reservationAffinity;
    get reservationAffinity(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference;
    putReservationAffinity(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigShieldedInstanceConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget {
    /**
    * Optional. A namespace within the GKE cluster to deploy into.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#cluster_namespace GoogleDataprocWorkflowTemplate#cluster_namespace}
    */
    readonly clusterNamespace?: string;
    /**
    * Optional. The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#target_gke_cluster GoogleDataprocWorkflowTemplate#target_gke_cluster}
    */
    readonly targetGkeCluster?: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget | undefined);
    private _clusterNamespace?;
    get clusterNamespace(): string;
    set clusterNamespace(value: string);
    resetClusterNamespace(): void;
    get clusterNamespaceInput(): string | undefined;
    private _targetGkeCluster?;
    get targetGkeCluster(): string;
    set targetGkeCluster(value: string);
    resetTargetGkeCluster(): void;
    get targetGkeClusterInput(): string | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig {
    /**
    * namespaced_gke_deployment_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#namespaced_gke_deployment_target GoogleDataprocWorkflowTemplate#namespaced_gke_deployment_target}
    */
    readonly namespacedGkeDeploymentTarget?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig | undefined);
    private _namespacedGkeDeploymentTarget;
    get namespacedGkeDeploymentTarget(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetOutputReference;
    putNamespacedGkeDeploymentTarget(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget): void;
    resetNamespacedGkeDeploymentTarget(): void;
    get namespacedGkeDeploymentTargetInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTarget | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions {
    /**
    * Required. Cloud Storage URI of executable file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#executable_file GoogleDataprocWorkflowTemplate#executable_file}
    */
    readonly executableFile?: string;
    /**
    * Optional. Amount of time executable has to complete. Default is 10 minutes (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)). Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#execution_timeout GoogleDataprocWorkflowTemplate#execution_timeout}
    */
    readonly executionTimeout?: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActionsToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions | cdktf.IResolvable): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions | cdktf.IResolvable | undefined);
    private _executableFile?;
    get executableFile(): string;
    set executableFile(value: string);
    resetExecutableFile(): void;
    get executableFileInput(): string | undefined;
    private _executionTimeout?;
    get executionTimeout(): string;
    set executionTimeout(value: string);
    resetExecutionTimeout(): void;
    get executionTimeoutInput(): string | undefined;
}
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActionsOutputReference;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig {
    /**
    * Optional. The time when cluster will be auto-deleted (see JSON representation of [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#auto_delete_time GoogleDataprocWorkflowTemplate#auto_delete_time}
    */
    readonly autoDeleteTime?: string;
    /**
    * Optional. The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#auto_delete_ttl GoogleDataprocWorkflowTemplate#auto_delete_ttl}
    */
    readonly autoDeleteTtl?: string;
    /**
    * Optional. The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#idle_delete_ttl GoogleDataprocWorkflowTemplate#idle_delete_ttl}
    */
    readonly idleDeleteTtl?: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined);
    private _autoDeleteTime?;
    get autoDeleteTime(): string;
    set autoDeleteTime(value: string);
    resetAutoDeleteTime(): void;
    get autoDeleteTimeInput(): string | undefined;
    private _autoDeleteTtl?;
    get autoDeleteTtl(): string;
    set autoDeleteTtl(value: string);
    resetAutoDeleteTtl(): void;
    get autoDeleteTtlInput(): string | undefined;
    private _idleDeleteTtl?;
    get idleDeleteTtl(): string;
    set idleDeleteTtl(value: string);
    resetIdleDeleteTtl(): void;
    get idleDeleteTtlInput(): string | undefined;
    get idleStartTime(): string;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig {
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfig | undefined);
    get instanceGroupManagerName(): string;
    get instanceTemplateName(): string;
}
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigOutputReference;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#accelerator_count GoogleDataprocWorkflowTemplate#accelerator_count}
    */
    readonly acceleratorCount?: number;
    /**
    * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#accelerator_type GoogleDataprocWorkflowTemplate#accelerator_type}
    */
    readonly acceleratorType?: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorsToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators | cdktf.IResolvable): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators | cdktf.IResolvable | undefined);
    private _acceleratorCount?;
    get acceleratorCount(): number;
    set acceleratorCount(value: number);
    resetAcceleratorCount(): void;
    get acceleratorCountInput(): number | undefined;
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    resetAcceleratorType(): void;
    get acceleratorTypeInput(): string | undefined;
}
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorsOutputReference;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig {
    /**
    * Optional. Size in GB of the boot disk (default is 500GB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#boot_disk_size_gb GoogleDataprocWorkflowTemplate#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#boot_disk_type GoogleDataprocWorkflowTemplate#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#num_local_ssds GoogleDataprocWorkflowTemplate#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig {
    /**
    * Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#image GoogleDataprocWorkflowTemplate#image}
    */
    readonly image?: string;
    /**
    * Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#machine_type GoogleDataprocWorkflowTemplate#machine_type}
    */
    readonly machineType?: string;
    /**
    * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#min_cpu_platform GoogleDataprocWorkflowTemplate#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Optional. The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#num_instances GoogleDataprocWorkflowTemplate#num_instances}
    */
    readonly numInstances?: number;
    /**
    * Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#preemptibility GoogleDataprocWorkflowTemplate#preemptibility}
    */
    readonly preemptibility?: string;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#accelerators GoogleDataprocWorkflowTemplate#accelerators}
    */
    readonly accelerators?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#disk_config GoogleDataprocWorkflowTemplate#disk_config}
    */
    readonly diskConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    get instanceNames(): string[];
    get isPreemptible(): cdktf.IResolvable;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _managedGroupConfig;
    get managedGroupConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigList;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string;
    set preemptibility(value: string);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _accelerators;
    get accelerators(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorsList;
    putAccelerators(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable): void;
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference;
    putDiskConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfig {
    /**
    * Required. Resource name of an existing Dataproc Metastore service. Example: * `projects/[project_id]/locations/[dataproc_region]/services/[service-name]`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#dataproc_metastore_service GoogleDataprocWorkflowTemplate#dataproc_metastore_service}
    */
    readonly dataprocMetastoreService: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfig | undefined);
    private _dataprocMetastoreService?;
    get dataprocMetastoreService(): string;
    set dataprocMetastoreService(value: string);
    get dataprocMetastoreServiceInput(): string | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig {
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfig | undefined);
    get instanceGroupManagerName(): string;
    get instanceTemplateName(): string;
}
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigOutputReference;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#accelerator_count GoogleDataprocWorkflowTemplate#accelerator_count}
    */
    readonly acceleratorCount?: number;
    /**
    * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#accelerator_type GoogleDataprocWorkflowTemplate#accelerator_type}
    */
    readonly acceleratorType?: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorsToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators | cdktf.IResolvable): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators | cdktf.IResolvable | undefined);
    private _acceleratorCount?;
    get acceleratorCount(): number;
    set acceleratorCount(value: number);
    resetAcceleratorCount(): void;
    get acceleratorCountInput(): number | undefined;
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    resetAcceleratorType(): void;
    get acceleratorTypeInput(): string | undefined;
}
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorsOutputReference;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig {
    /**
    * Optional. Size in GB of the boot disk (default is 500GB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#boot_disk_size_gb GoogleDataprocWorkflowTemplate#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#boot_disk_type GoogleDataprocWorkflowTemplate#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#num_local_ssds GoogleDataprocWorkflowTemplate#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig {
    /**
    * Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#image GoogleDataprocWorkflowTemplate#image}
    */
    readonly image?: string;
    /**
    * Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#machine_type GoogleDataprocWorkflowTemplate#machine_type}
    */
    readonly machineType?: string;
    /**
    * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#min_cpu_platform GoogleDataprocWorkflowTemplate#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Optional. The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#num_instances GoogleDataprocWorkflowTemplate#num_instances}
    */
    readonly numInstances?: number;
    /**
    * Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#preemptibility GoogleDataprocWorkflowTemplate#preemptibility}
    */
    readonly preemptibility?: string;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#accelerators GoogleDataprocWorkflowTemplate#accelerators}
    */
    readonly accelerators?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#disk_config GoogleDataprocWorkflowTemplate#disk_config}
    */
    readonly diskConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    get instanceNames(): string[];
    get isPreemptible(): cdktf.IResolvable;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _managedGroupConfig;
    get managedGroupConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigList;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string;
    set preemptibility(value: string);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _accelerators;
    get accelerators(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorsList;
    putAccelerators(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | cdktf.IResolvable): void;
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig {
    /**
    * Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#cross_realm_trust_admin_server GoogleDataprocWorkflowTemplate#cross_realm_trust_admin_server}
    */
    readonly crossRealmTrustAdminServer?: string;
    /**
    * Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#cross_realm_trust_kdc GoogleDataprocWorkflowTemplate#cross_realm_trust_kdc}
    */
    readonly crossRealmTrustKdc?: string;
    /**
    * Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#cross_realm_trust_realm GoogleDataprocWorkflowTemplate#cross_realm_trust_realm}
    */
    readonly crossRealmTrustRealm?: string;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#cross_realm_trust_shared_password GoogleDataprocWorkflowTemplate#cross_realm_trust_shared_password}
    */
    readonly crossRealmTrustSharedPassword?: string;
    /**
    * Optional. Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#enable_kerberos GoogleDataprocWorkflowTemplate#enable_kerberos}
    */
    readonly enableKerberos?: boolean | cdktf.IResolvable;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#kdc_db_key GoogleDataprocWorkflowTemplate#kdc_db_key}
    */
    readonly kdcDbKey?: string;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#key_password GoogleDataprocWorkflowTemplate#key_password}
    */
    readonly keyPassword?: string;
    /**
    * Optional. The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#keystore GoogleDataprocWorkflowTemplate#keystore}
    */
    readonly keystore?: string;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#keystore_password GoogleDataprocWorkflowTemplate#keystore_password}
    */
    readonly keystorePassword?: string;
    /**
    * Optional. The uri of the KMS key used to encrypt various sensitive files.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#kms_key GoogleDataprocWorkflowTemplate#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Optional. The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#realm GoogleDataprocWorkflowTemplate#realm}
    */
    readonly realm?: string;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#root_principal_password GoogleDataprocWorkflowTemplate#root_principal_password}
    */
    readonly rootPrincipalPassword?: string;
    /**
    * Optional. The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#tgt_lifetime_hours GoogleDataprocWorkflowTemplate#tgt_lifetime_hours}
    */
    readonly tgtLifetimeHours?: number;
    /**
    * Optional. The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#truststore GoogleDataprocWorkflowTemplate#truststore}
    */
    readonly truststore?: string;
    /**
    * Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#truststore_password GoogleDataprocWorkflowTemplate#truststore_password}
    */
    readonly truststorePassword?: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined);
    private _crossRealmTrustAdminServer?;
    get crossRealmTrustAdminServer(): string;
    set crossRealmTrustAdminServer(value: string);
    resetCrossRealmTrustAdminServer(): void;
    get crossRealmTrustAdminServerInput(): string | undefined;
    private _crossRealmTrustKdc?;
    get crossRealmTrustKdc(): string;
    set crossRealmTrustKdc(value: string);
    resetCrossRealmTrustKdc(): void;
    get crossRealmTrustKdcInput(): string | undefined;
    private _crossRealmTrustRealm?;
    get crossRealmTrustRealm(): string;
    set crossRealmTrustRealm(value: string);
    resetCrossRealmTrustRealm(): void;
    get crossRealmTrustRealmInput(): string | undefined;
    private _crossRealmTrustSharedPassword?;
    get crossRealmTrustSharedPassword(): string;
    set crossRealmTrustSharedPassword(value: string);
    resetCrossRealmTrustSharedPassword(): void;
    get crossRealmTrustSharedPasswordInput(): string | undefined;
    private _enableKerberos?;
    get enableKerberos(): boolean | cdktf.IResolvable;
    set enableKerberos(value: boolean | cdktf.IResolvable);
    resetEnableKerberos(): void;
    get enableKerberosInput(): boolean | cdktf.IResolvable | undefined;
    private _kdcDbKey?;
    get kdcDbKey(): string;
    set kdcDbKey(value: string);
    resetKdcDbKey(): void;
    get kdcDbKeyInput(): string | undefined;
    private _keyPassword?;
    get keyPassword(): string;
    set keyPassword(value: string);
    resetKeyPassword(): void;
    get keyPasswordInput(): string | undefined;
    private _keystore?;
    get keystore(): string;
    set keystore(value: string);
    resetKeystore(): void;
    get keystoreInput(): string | undefined;
    private _keystorePassword?;
    get keystorePassword(): string;
    set keystorePassword(value: string);
    resetKeystorePassword(): void;
    get keystorePasswordInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _realm?;
    get realm(): string;
    set realm(value: string);
    resetRealm(): void;
    get realmInput(): string | undefined;
    private _rootPrincipalPassword?;
    get rootPrincipalPassword(): string;
    set rootPrincipalPassword(value: string);
    resetRootPrincipalPassword(): void;
    get rootPrincipalPasswordInput(): string | undefined;
    private _tgtLifetimeHours?;
    get tgtLifetimeHours(): number;
    set tgtLifetimeHours(value: number);
    resetTgtLifetimeHours(): void;
    get tgtLifetimeHoursInput(): number | undefined;
    private _truststore?;
    get truststore(): string;
    set truststore(value: string);
    resetTruststore(): void;
    get truststoreInput(): string | undefined;
    private _truststorePassword?;
    get truststorePassword(): string;
    set truststorePassword(value: string);
    resetTruststorePassword(): void;
    get truststorePasswordInput(): string | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig {
    /**
    * kerberos_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#kerberos_config GoogleDataprocWorkflowTemplate#kerberos_config}
    */
    readonly kerberosConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined);
    private _kerberosConfig;
    get kerberosConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference;
    putKerberosConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig): void;
    resetKerberosConfig(): void;
    get kerberosConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig {
    /**
    * Optional. The version of software inside the cluster. It must be one of the supported [Dataproc Versions](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the ["preview" version](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#image_version GoogleDataprocWorkflowTemplate#image_version}
    */
    readonly imageVersion?: string;
    /**
    * Optional. The set of components to activate on the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#optional_components GoogleDataprocWorkflowTemplate#optional_components}
    */
    readonly optionalComponents?: string[];
    /**
    * Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#properties GoogleDataprocWorkflowTemplate#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined);
    private _imageVersion?;
    get imageVersion(): string;
    set imageVersion(value: string);
    resetImageVersion(): void;
    get imageVersionInput(): string | undefined;
    private _optionalComponents?;
    get optionalComponents(): string[];
    set optionalComponents(value: string[]);
    resetOptionalComponents(): void;
    get optionalComponentsInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig {
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfig | undefined);
    get instanceGroupManagerName(): string;
    get instanceTemplateName(): string;
}
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigOutputReference;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#accelerator_count GoogleDataprocWorkflowTemplate#accelerator_count}
    */
    readonly acceleratorCount?: number;
    /**
    * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#accelerator_type GoogleDataprocWorkflowTemplate#accelerator_type}
    */
    readonly acceleratorType?: string;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorsToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators | cdktf.IResolvable): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators | cdktf.IResolvable | undefined);
    private _acceleratorCount?;
    get acceleratorCount(): number;
    set acceleratorCount(value: number);
    resetAcceleratorCount(): void;
    get acceleratorCountInput(): number | undefined;
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    resetAcceleratorType(): void;
    get acceleratorTypeInput(): string | undefined;
}
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorsOutputReference;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig {
    /**
    * Optional. Size in GB of the boot disk (default is 500GB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#boot_disk_size_gb GoogleDataprocWorkflowTemplate#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#boot_disk_type GoogleDataprocWorkflowTemplate#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#num_local_ssds GoogleDataprocWorkflowTemplate#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig {
    /**
    * Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#image GoogleDataprocWorkflowTemplate#image}
    */
    readonly image?: string;
    /**
    * Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#machine_type GoogleDataprocWorkflowTemplate#machine_type}
    */
    readonly machineType?: string;
    /**
    * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#min_cpu_platform GoogleDataprocWorkflowTemplate#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Optional. The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#num_instances GoogleDataprocWorkflowTemplate#num_instances}
    */
    readonly numInstances?: number;
    /**
    * Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#preemptibility GoogleDataprocWorkflowTemplate#preemptibility}
    */
    readonly preemptibility?: string;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#accelerators GoogleDataprocWorkflowTemplate#accelerators}
    */
    readonly accelerators?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#disk_config GoogleDataprocWorkflowTemplate#disk_config}
    */
    readonly diskConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    get instanceNames(): string[];
    get isPreemptible(): cdktf.IResolvable;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _managedGroupConfig;
    get managedGroupConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigList;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string;
    set preemptibility(value: string);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _accelerators;
    get accelerators(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorsList;
    putAccelerators(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable): void;
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedClusterConfig {
    /**
    * Optional. A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see [Dataproc staging bucket](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). **This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.**
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#staging_bucket GoogleDataprocWorkflowTemplate#staging_bucket}
    */
    readonly stagingBucket?: string;
    /**
    * Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket. **This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.**
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#temp_bucket GoogleDataprocWorkflowTemplate#temp_bucket}
    */
    readonly tempBucket?: string;
    /**
    * autoscaling_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#autoscaling_config GoogleDataprocWorkflowTemplate#autoscaling_config}
    */
    readonly autoscalingConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#encryption_config GoogleDataprocWorkflowTemplate#encryption_config}
    */
    readonly encryptionConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig;
    /**
    * endpoint_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#endpoint_config GoogleDataprocWorkflowTemplate#endpoint_config}
    */
    readonly endpointConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig;
    /**
    * gce_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#gce_cluster_config GoogleDataprocWorkflowTemplate#gce_cluster_config}
    */
    readonly gceClusterConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig;
    /**
    * gke_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#gke_cluster_config GoogleDataprocWorkflowTemplate#gke_cluster_config}
    */
    readonly gkeClusterConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig;
    /**
    * initialization_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#initialization_actions GoogleDataprocWorkflowTemplate#initialization_actions}
    */
    readonly initializationActions?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | cdktf.IResolvable;
    /**
    * lifecycle_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#lifecycle_config GoogleDataprocWorkflowTemplate#lifecycle_config}
    */
    readonly lifecycleConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig;
    /**
    * master_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#master_config GoogleDataprocWorkflowTemplate#master_config}
    */
    readonly masterConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig;
    /**
    * metastore_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#metastore_config GoogleDataprocWorkflowTemplate#metastore_config}
    */
    readonly metastoreConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfig;
    /**
    * secondary_worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#secondary_worker_config GoogleDataprocWorkflowTemplate#secondary_worker_config}
    */
    readonly secondaryWorkerConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig;
    /**
    * security_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#security_config GoogleDataprocWorkflowTemplate#security_config}
    */
    readonly securityConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig;
    /**
    * software_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#software_config GoogleDataprocWorkflowTemplate#software_config}
    */
    readonly softwareConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig;
    /**
    * worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#worker_config GoogleDataprocWorkflowTemplate#worker_config}
    */
    readonly workerConfig?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterConfigToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfig): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfig | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfig | undefined);
    private _stagingBucket?;
    get stagingBucket(): string;
    set stagingBucket(value: string);
    resetStagingBucket(): void;
    get stagingBucketInput(): string | undefined;
    private _tempBucket?;
    get tempBucket(): string;
    set tempBucket(value: string);
    resetTempBucket(): void;
    get tempBucketInput(): string | undefined;
    private _autoscalingConfig;
    get autoscalingConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference;
    putAutoscalingConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig): void;
    resetAutoscalingConfig(): void;
    get autoscalingConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined;
    private _encryptionConfig;
    get encryptionConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined;
    private _endpointConfig;
    get endpointConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference;
    putEndpointConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig): void;
    resetEndpointConfig(): void;
    get endpointConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined;
    private _gceClusterConfig;
    get gceClusterConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference;
    putGceClusterConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig): void;
    resetGceClusterConfig(): void;
    get gceClusterConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined;
    private _gkeClusterConfig;
    get gkeClusterConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigOutputReference;
    putGkeClusterConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig): void;
    resetGkeClusterConfig(): void;
    get gkeClusterConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigGkeClusterConfig | undefined;
    private _initializationActions;
    get initializationActions(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActionsList;
    putInitializationActions(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | cdktf.IResolvable): void;
    resetInitializationActions(): void;
    get initializationActionsInput(): cdktf.IResolvable | GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | undefined;
    private _lifecycleConfig;
    get lifecycleConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference;
    putLifecycleConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig): void;
    resetLifecycleConfig(): void;
    get lifecycleConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined;
    private _masterConfig;
    get masterConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference;
    putMasterConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig): void;
    resetMasterConfig(): void;
    get masterConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined;
    private _metastoreConfig;
    get metastoreConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfigOutputReference;
    putMetastoreConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfig): void;
    resetMetastoreConfig(): void;
    get metastoreConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigMetastoreConfig | undefined;
    private _secondaryWorkerConfig;
    get secondaryWorkerConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference;
    putSecondaryWorkerConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig): void;
    resetSecondaryWorkerConfig(): void;
    get secondaryWorkerConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined;
    private _securityConfig;
    get securityConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference;
    putSecurityConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig): void;
    resetSecurityConfig(): void;
    get securityConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined;
    private _softwareConfig;
    get softwareConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference;
    putSoftwareConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined;
    private _workerConfig;
    get workerConfig(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference;
    putWorkerConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacementManagedCluster {
    /**
    * Required. The cluster name prefix. A unique cluster name will be formed by appending a random suffix. The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#cluster_name GoogleDataprocWorkflowTemplate#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Optional. The labels to associate with this cluster. Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: p{Ll}p{Lo}{0,62} Label values must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: [p{Ll}p{Lo}p{N}_-]{0,63} No more than 32 labels can be associated with a given cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#labels GoogleDataprocWorkflowTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#config GoogleDataprocWorkflowTemplate#config}
    */
    readonly config: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfig;
}
export declare function googleDataprocWorkflowTemplatePlacementManagedClusterToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementManagedClusterOutputReference | GoogleDataprocWorkflowTemplatePlacementManagedCluster): any;
export declare class GoogleDataprocWorkflowTemplatePlacementManagedClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacementManagedCluster | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacementManagedCluster | undefined);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _config;
    get config(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference;
    putConfig(value: GoogleDataprocWorkflowTemplatePlacementManagedClusterConfig): void;
    get configInput(): GoogleDataprocWorkflowTemplatePlacementManagedClusterConfig | undefined;
}
export interface GoogleDataprocWorkflowTemplatePlacement {
    /**
    * cluster_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#cluster_selector GoogleDataprocWorkflowTemplate#cluster_selector}
    */
    readonly clusterSelector?: GoogleDataprocWorkflowTemplatePlacementClusterSelector;
    /**
    * managed_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#managed_cluster GoogleDataprocWorkflowTemplate#managed_cluster}
    */
    readonly managedCluster?: GoogleDataprocWorkflowTemplatePlacementManagedCluster;
}
export declare function googleDataprocWorkflowTemplatePlacementToTerraform(struct?: GoogleDataprocWorkflowTemplatePlacementOutputReference | GoogleDataprocWorkflowTemplatePlacement): any;
export declare class GoogleDataprocWorkflowTemplatePlacementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplatePlacement | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplatePlacement | undefined);
    private _clusterSelector;
    get clusterSelector(): GoogleDataprocWorkflowTemplatePlacementClusterSelectorOutputReference;
    putClusterSelector(value: GoogleDataprocWorkflowTemplatePlacementClusterSelector): void;
    resetClusterSelector(): void;
    get clusterSelectorInput(): GoogleDataprocWorkflowTemplatePlacementClusterSelector | undefined;
    private _managedCluster;
    get managedCluster(): GoogleDataprocWorkflowTemplatePlacementManagedClusterOutputReference;
    putManagedCluster(value: GoogleDataprocWorkflowTemplatePlacementManagedCluster): void;
    resetManagedCluster(): void;
    get managedClusterInput(): GoogleDataprocWorkflowTemplatePlacementManagedCluster | undefined;
}
export interface GoogleDataprocWorkflowTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#create GoogleDataprocWorkflowTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template#delete GoogleDataprocWorkflowTemplate#delete}
    */
    readonly delete?: string;
}
export declare function googleDataprocWorkflowTemplateTimeoutsToTerraform(struct?: GoogleDataprocWorkflowTemplateTimeoutsOutputReference | GoogleDataprocWorkflowTemplateTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataprocWorkflowTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocWorkflowTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocWorkflowTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template google_dataproc_workflow_template}
*/
export declare class GoogleDataprocWorkflowTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_workflow_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_dataproc_workflow_template google_dataproc_workflow_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataprocWorkflowTemplateConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataprocWorkflowTemplateConfig);
    get createTime(): string;
    private _dagTimeout?;
    get dagTimeout(): string;
    set dagTimeout(value: string);
    resetDagTimeout(): void;
    get dagTimeoutInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _jobs;
    get jobs(): GoogleDataprocWorkflowTemplateJobsList;
    putJobs(value: GoogleDataprocWorkflowTemplateJobs[] | cdktf.IResolvable): void;
    get jobsInput(): cdktf.IResolvable | GoogleDataprocWorkflowTemplateJobs[] | undefined;
    private _parameters;
    get parameters(): GoogleDataprocWorkflowTemplateParametersList;
    putParameters(value: GoogleDataprocWorkflowTemplateParameters[] | cdktf.IResolvable): void;
    resetParameters(): void;
    get parametersInput(): cdktf.IResolvable | GoogleDataprocWorkflowTemplateParameters[] | undefined;
    private _placement;
    get placement(): GoogleDataprocWorkflowTemplatePlacementOutputReference;
    putPlacement(value: GoogleDataprocWorkflowTemplatePlacement): void;
    get placementInput(): GoogleDataprocWorkflowTemplatePlacement | undefined;
    private _timeouts;
    get timeouts(): GoogleDataprocWorkflowTemplateTimeoutsOutputReference;
    putTimeouts(value: GoogleDataprocWorkflowTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataprocWorkflowTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
