import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxPageConfig extends cdktf.TerraformMetaArguments {
    /**
    * The human-readable name of the page, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#display_name GoogleDialogflowCxPage#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#id GoogleDialogflowCxPage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The language of the following fields in page:
  
  Page.entry_fulfillment.messages
  Page.entry_fulfillment.conditional_cases
  Page.event_handlers.trigger_fulfillment.messages
  Page.event_handlers.trigger_fulfillment.conditional_cases
  Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
  Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
  Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
  Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
  Page.transition_routes.trigger_fulfillment.messages
  Page.transition_routes.trigger_fulfillment.conditional_cases
  If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#language_code GoogleDialogflowCxPage#language_code}
    */
    readonly languageCode?: string;
    /**
    * The flow to create a page for.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#parent GoogleDialogflowCxPage#parent}
    */
    readonly parent?: string;
    /**
    * Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
  If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route -> page's transition route group -> flow's transition routes.
  If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
  Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#transition_route_groups GoogleDialogflowCxPage#transition_route_groups}
    */
    readonly transitionRouteGroups?: string[];
    /**
    * entry_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#entry_fulfillment GoogleDialogflowCxPage#entry_fulfillment}
    */
    readonly entryFulfillment?: GoogleDialogflowCxPageEntryFulfillment;
    /**
    * event_handlers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#event_handlers GoogleDialogflowCxPage#event_handlers}
    */
    readonly eventHandlers?: GoogleDialogflowCxPageEventHandlers[] | cdktf.IResolvable;
    /**
    * form block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#form GoogleDialogflowCxPage#form}
    */
    readonly form?: GoogleDialogflowCxPageForm;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#timeouts GoogleDialogflowCxPage#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxPageTimeouts;
    /**
    * transition_routes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#transition_routes GoogleDialogflowCxPage#transition_routes}
    */
    readonly transitionRoutes?: GoogleDialogflowCxPageTransitionRoutes[] | cdktf.IResolvable;
}
export interface GoogleDialogflowCxPageEntryFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxPageEntryFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxPageEntryFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: GoogleDialogflowCxPageEntryFulfillmentMessagesText;
}
export declare function googleDialogflowCxPageEntryFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentMessages | cdktf.IResolvable | undefined);
    private _text;
    get text(): GoogleDialogflowCxPageEntryFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxPageEntryFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxPageEntryFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageEntryFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageEntryFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxPageEntryFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#return_partial_responses GoogleDialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#tag GoogleDialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#webhook GoogleDialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#messages GoogleDialogflowCxPage#messages}
    */
    readonly messages?: GoogleDialogflowCxPageEntryFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageEntryFulfillmentToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentOutputReference | GoogleDialogflowCxPageEntryFulfillment): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxPageEntryFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxPageEntryFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxPageEntryFulfillmentMessages[] | undefined;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _text;
    get text(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#return_partial_responses GoogleDialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#tag GoogleDialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#webhook GoogleDialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#messages GoogleDialogflowCxPage#messages}
    */
    readonly messages?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillment): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | undefined;
}
export interface GoogleDialogflowCxPageEventHandlers {
    /**
    * The name of the event to handle.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#event GoogleDialogflowCxPage#event}
    */
    readonly event?: string;
    /**
    * The target flow to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#target_flow GoogleDialogflowCxPage#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#target_page GoogleDialogflowCxPage#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#trigger_fulfillment GoogleDialogflowCxPage#trigger_fulfillment}
    */
    readonly triggerFulfillment?: GoogleDialogflowCxPageEventHandlersTriggerFulfillment;
}
export declare function googleDialogflowCxPageEventHandlersToTerraform(struct?: GoogleDialogflowCxPageEventHandlers | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageEventHandlersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageEventHandlers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlers | cdktf.IResolvable | undefined);
    private _event?;
    get event(): string;
    set event(value: string);
    resetEvent(): void;
    get eventInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): GoogleDialogflowCxPageEventHandlersTriggerFulfillment | undefined;
}
export declare class GoogleDialogflowCxPageEventHandlersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageEventHandlers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageEventHandlersOutputReference;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages | cdktf.IResolvable | undefined);
    private _text;
    get text(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#return_partial_responses GoogleDialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#tag GoogleDialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#webhook GoogleDialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#messages GoogleDialogflowCxPage#messages}
    */
    readonly messages?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehavior {
    /**
    * initial_prompt_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#initial_prompt_fulfillment GoogleDialogflowCxPage#initial_prompt_fulfillment}
    */
    readonly initialPromptFulfillment?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorOutputReference | GoogleDialogflowCxPageFormParametersFillBehavior): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehavior | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehavior | undefined);
    private _initialPromptFulfillment;
    get initialPromptFulfillment(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference;
    putInitialPromptFulfillment(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment): void;
    resetInitialPromptFulfillment(): void;
    get initialPromptFulfillmentInput(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined;
}
export interface GoogleDialogflowCxPageFormParameters {
    /**
    * The human-readable name of the parameter, unique within the form.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#display_name GoogleDialogflowCxPage#display_name}
    */
    readonly displayName?: string;
    /**
    * The entity type of the parameter.
  Format: projects/-/locations/-/agents/-/entityTypes/<System Entity Type ID> for system entity types (for example, projects/-/locations/-/agents/-/entityTypes/sys.date), or projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID> for developer entity types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#entity_type GoogleDialogflowCxPage#entity_type}
    */
    readonly entityType?: string;
    /**
    * Indicates whether the parameter represents a list of values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#is_list GoogleDialogflowCxPage#is_list}
    */
    readonly isList?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the parameter content should be redacted in log.
  If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#redact GoogleDialogflowCxPage#redact}
    */
    readonly redact?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the parameter is required. Optional parameters will not trigger prompts; however, they are filled if the user specifies them.
  Required parameters must be filled before form filling concludes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#required GoogleDialogflowCxPage#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * fill_behavior block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#fill_behavior GoogleDialogflowCxPage#fill_behavior}
    */
    readonly fillBehavior?: GoogleDialogflowCxPageFormParametersFillBehavior;
}
export declare function googleDialogflowCxPageFormParametersToTerraform(struct?: GoogleDialogflowCxPageFormParameters | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageFormParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageFormParameters | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParameters | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _entityType?;
    get entityType(): string;
    set entityType(value: string);
    resetEntityType(): void;
    get entityTypeInput(): string | undefined;
    private _isList?;
    get isList(): boolean | cdktf.IResolvable;
    set isList(value: boolean | cdktf.IResolvable);
    resetIsList(): void;
    get isListInput(): boolean | cdktf.IResolvable | undefined;
    private _redact?;
    get redact(): boolean | cdktf.IResolvable;
    set redact(value: boolean | cdktf.IResolvable);
    resetRedact(): void;
    get redactInput(): boolean | cdktf.IResolvable | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _fillBehavior;
    get fillBehavior(): GoogleDialogflowCxPageFormParametersFillBehaviorOutputReference;
    putFillBehavior(value: GoogleDialogflowCxPageFormParametersFillBehavior): void;
    resetFillBehavior(): void;
    get fillBehaviorInput(): GoogleDialogflowCxPageFormParametersFillBehavior | undefined;
}
export declare class GoogleDialogflowCxPageFormParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageFormParameters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageFormParametersOutputReference;
}
export interface GoogleDialogflowCxPageForm {
    /**
    * parameters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#parameters GoogleDialogflowCxPage#parameters}
    */
    readonly parameters?: GoogleDialogflowCxPageFormParameters[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageFormToTerraform(struct?: GoogleDialogflowCxPageFormOutputReference | GoogleDialogflowCxPageForm): any;
export declare class GoogleDialogflowCxPageFormOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageForm | undefined;
    set internalValue(value: GoogleDialogflowCxPageForm | undefined);
    private _parameters;
    get parameters(): GoogleDialogflowCxPageFormParametersList;
    putParameters(value: GoogleDialogflowCxPageFormParameters[] | cdktf.IResolvable): void;
    resetParameters(): void;
    get parametersInput(): cdktf.IResolvable | GoogleDialogflowCxPageFormParameters[] | undefined;
}
export interface GoogleDialogflowCxPageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#create GoogleDialogflowCxPage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#delete GoogleDialogflowCxPage#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#update GoogleDialogflowCxPage#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxPageTimeoutsToTerraform(struct?: GoogleDialogflowCxPageTimeoutsOutputReference | GoogleDialogflowCxPageTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _text;
    get text(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#return_partial_responses GoogleDialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#tag GoogleDialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#webhook GoogleDialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#messages GoogleDialogflowCxPage#messages}
    */
    readonly messages?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutes {
    /**
    * The condition to evaluate against form parameters or session parameters.
  At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#condition GoogleDialogflowCxPage#condition}
    */
    readonly condition?: string;
    /**
    * The unique identifier of an Intent.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#intent GoogleDialogflowCxPage#intent}
    */
    readonly intent?: string;
    /**
    * The target flow to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#target_flow GoogleDialogflowCxPage#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#target_page GoogleDialogflowCxPage#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page#trigger_fulfillment GoogleDialogflowCxPage#trigger_fulfillment}
    */
    readonly triggerFulfillment?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment;
}
export declare function googleDialogflowCxPageTransitionRoutesToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutes | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageTransitionRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutes | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _intent?;
    get intent(): string;
    set intent(value: string);
    resetIntent(): void;
    get intentInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment | undefined;
}
export declare class GoogleDialogflowCxPageTransitionRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageTransitionRoutes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageTransitionRoutesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page google_dialogflow_cx_page}
*/
export declare class GoogleDialogflowCxPage extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_page";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_dialogflow_cx_page google_dialogflow_cx_page} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxPageConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxPageConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    get transitionRouteGroups(): string[];
    set transitionRouteGroups(value: string[]);
    resetTransitionRouteGroups(): void;
    get transitionRouteGroupsInput(): string[] | undefined;
    private _entryFulfillment;
    get entryFulfillment(): GoogleDialogflowCxPageEntryFulfillmentOutputReference;
    putEntryFulfillment(value: GoogleDialogflowCxPageEntryFulfillment): void;
    resetEntryFulfillment(): void;
    get entryFulfillmentInput(): GoogleDialogflowCxPageEntryFulfillment | undefined;
    private _eventHandlers;
    get eventHandlers(): GoogleDialogflowCxPageEventHandlersList;
    putEventHandlers(value: GoogleDialogflowCxPageEventHandlers[] | cdktf.IResolvable): void;
    resetEventHandlers(): void;
    get eventHandlersInput(): cdktf.IResolvable | GoogleDialogflowCxPageEventHandlers[] | undefined;
    private _form;
    get form(): GoogleDialogflowCxPageFormOutputReference;
    putForm(value: GoogleDialogflowCxPageForm): void;
    resetForm(): void;
    get formInput(): GoogleDialogflowCxPageForm | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxPageTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxPageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxPageTimeouts | undefined;
    private _transitionRoutes;
    get transitionRoutes(): GoogleDialogflowCxPageTransitionRoutesList;
    putTransitionRoutes(value: GoogleDialogflowCxPageTransitionRoutes[] | cdktf.IResolvable): void;
    resetTransitionRoutes(): void;
    get transitionRoutesInput(): cdktf.IResolvable | GoogleDialogflowCxPageTransitionRoutes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
