import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDnsManagedZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * A textual description field. Defaults to 'Managed by Terraform'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#description GoogleDnsManagedZone#description}
    */
    readonly description?: string;
    /**
    * The DNS name of this managed zone, for instance "example.com.".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#dns_name GoogleDnsManagedZone#dns_name}
    */
    readonly dnsName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#force_destroy GoogleDnsManagedZone#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#id GoogleDnsManagedZone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this ManagedZone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#labels GoogleDnsManagedZone#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * User assigned name for this resource.
  Must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#name GoogleDnsManagedZone#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#project GoogleDnsManagedZone#project}
    */
    readonly project?: string;
    /**
    * Specifies if this is a managed reverse lookup zone. If true, Cloud DNS will resolve reverse
  lookup queries using automatically configured records for VPC resources. This only applies
  to networks listed under 'private_visibility_config'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#reverse_lookup GoogleDnsManagedZone#reverse_lookup}
    */
    readonly reverseLookup?: boolean | cdktf.IResolvable;
    /**
    * The zone's visibility: public zones are exposed to the Internet,
  while private zones are visible only to Virtual Private Cloud resources. Default value: "public" Possible values: ["private", "public"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#visibility GoogleDnsManagedZone#visibility}
    */
    readonly visibility?: string;
    /**
    * dnssec_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#dnssec_config GoogleDnsManagedZone#dnssec_config}
    */
    readonly dnssecConfig?: GoogleDnsManagedZoneDnssecConfig;
    /**
    * forwarding_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#forwarding_config GoogleDnsManagedZone#forwarding_config}
    */
    readonly forwardingConfig?: GoogleDnsManagedZoneForwardingConfig;
    /**
    * peering_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#peering_config GoogleDnsManagedZone#peering_config}
    */
    readonly peeringConfig?: GoogleDnsManagedZonePeeringConfig;
    /**
    * private_visibility_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#private_visibility_config GoogleDnsManagedZone#private_visibility_config}
    */
    readonly privateVisibilityConfig?: GoogleDnsManagedZonePrivateVisibilityConfig;
    /**
    * service_directory_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#service_directory_config GoogleDnsManagedZone#service_directory_config}
    */
    readonly serviceDirectoryConfig?: GoogleDnsManagedZoneServiceDirectoryConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#timeouts GoogleDnsManagedZone#timeouts}
    */
    readonly timeouts?: GoogleDnsManagedZoneTimeouts;
}
export interface GoogleDnsManagedZoneDnssecConfigDefaultKeySpecs {
    /**
    * String mnemonic specifying the DNSSEC algorithm of this key Possible values: ["ecdsap256sha256", "ecdsap384sha384", "rsasha1", "rsasha256", "rsasha512"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#algorithm GoogleDnsManagedZone#algorithm}
    */
    readonly algorithm?: string;
    /**
    * Length of the keys in bits
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#key_length GoogleDnsManagedZone#key_length}
    */
    readonly keyLength?: number;
    /**
    * Specifies whether this is a key signing key (KSK) or a zone
  signing key (ZSK). Key signing keys have the Secure Entry
  Point flag set and, when active, will only be used to sign
  resource record sets of type DNSKEY. Zone signing keys do
  not have the Secure Entry Point flag set and will be used
  to sign all other types of resource record sets. Possible values: ["keySigning", "zoneSigning"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#key_type GoogleDnsManagedZone#key_type}
    */
    readonly keyType?: string;
    /**
    * Identifies what kind of resource this is
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#kind GoogleDnsManagedZone#kind}
    */
    readonly kind?: string;
}
export declare function googleDnsManagedZoneDnssecConfigDefaultKeySpecsToTerraform(struct?: GoogleDnsManagedZoneDnssecConfigDefaultKeySpecs | cdktf.IResolvable): any;
export declare class GoogleDnsManagedZoneDnssecConfigDefaultKeySpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDnsManagedZoneDnssecConfigDefaultKeySpecs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDnsManagedZoneDnssecConfigDefaultKeySpecs | cdktf.IResolvable | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    resetAlgorithm(): void;
    get algorithmInput(): string | undefined;
    private _keyLength?;
    get keyLength(): number;
    set keyLength(value: number);
    resetKeyLength(): void;
    get keyLengthInput(): number | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    resetKeyType(): void;
    get keyTypeInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
}
export declare class GoogleDnsManagedZoneDnssecConfigDefaultKeySpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDnsManagedZoneDnssecConfigDefaultKeySpecs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDnsManagedZoneDnssecConfigDefaultKeySpecsOutputReference;
}
export interface GoogleDnsManagedZoneDnssecConfig {
    /**
    * Identifies what kind of resource this is
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#kind GoogleDnsManagedZone#kind}
    */
    readonly kind?: string;
    /**
    * Specifies the mechanism used to provide authenticated denial-of-existence responses.
  non_existence can only be updated when the state is 'off'. Possible values: ["nsec", "nsec3"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#non_existence GoogleDnsManagedZone#non_existence}
    */
    readonly nonExistence?: string;
    /**
    * Specifies whether DNSSEC is enabled, and what mode it is in Possible values: ["off", "on", "transfer"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#state GoogleDnsManagedZone#state}
    */
    readonly state?: string;
    /**
    * default_key_specs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#default_key_specs GoogleDnsManagedZone#default_key_specs}
    */
    readonly defaultKeySpecs?: GoogleDnsManagedZoneDnssecConfigDefaultKeySpecs[] | cdktf.IResolvable;
}
export declare function googleDnsManagedZoneDnssecConfigToTerraform(struct?: GoogleDnsManagedZoneDnssecConfigOutputReference | GoogleDnsManagedZoneDnssecConfig): any;
export declare class GoogleDnsManagedZoneDnssecConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsManagedZoneDnssecConfig | undefined;
    set internalValue(value: GoogleDnsManagedZoneDnssecConfig | undefined);
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _nonExistence?;
    get nonExistence(): string;
    set nonExistence(value: string);
    resetNonExistence(): void;
    get nonExistenceInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _defaultKeySpecs;
    get defaultKeySpecs(): GoogleDnsManagedZoneDnssecConfigDefaultKeySpecsList;
    putDefaultKeySpecs(value: GoogleDnsManagedZoneDnssecConfigDefaultKeySpecs[] | cdktf.IResolvable): void;
    resetDefaultKeySpecs(): void;
    get defaultKeySpecsInput(): cdktf.IResolvable | GoogleDnsManagedZoneDnssecConfigDefaultKeySpecs[] | undefined;
}
export interface GoogleDnsManagedZoneForwardingConfigTargetNameServers {
    /**
    * Forwarding path for this TargetNameServer. If unset or 'default' Cloud DNS will make forwarding
  decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
  to the Internet. When set to 'private', Cloud DNS will always send queries through VPC for this target Possible values: ["default", "private"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#forwarding_path GoogleDnsManagedZone#forwarding_path}
    */
    readonly forwardingPath?: string;
    /**
    * IPv4 address of a target name server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#ipv4_address GoogleDnsManagedZone#ipv4_address}
    */
    readonly ipv4Address: string;
}
export declare function googleDnsManagedZoneForwardingConfigTargetNameServersToTerraform(struct?: GoogleDnsManagedZoneForwardingConfigTargetNameServers | cdktf.IResolvable): any;
export declare class GoogleDnsManagedZoneForwardingConfigTargetNameServersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDnsManagedZoneForwardingConfigTargetNameServers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDnsManagedZoneForwardingConfigTargetNameServers | cdktf.IResolvable | undefined);
    private _forwardingPath?;
    get forwardingPath(): string;
    set forwardingPath(value: string);
    resetForwardingPath(): void;
    get forwardingPathInput(): string | undefined;
    private _ipv4Address?;
    get ipv4Address(): string;
    set ipv4Address(value: string);
    get ipv4AddressInput(): string | undefined;
}
export declare class GoogleDnsManagedZoneForwardingConfigTargetNameServersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDnsManagedZoneForwardingConfigTargetNameServers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDnsManagedZoneForwardingConfigTargetNameServersOutputReference;
}
export interface GoogleDnsManagedZoneForwardingConfig {
    /**
    * target_name_servers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#target_name_servers GoogleDnsManagedZone#target_name_servers}
    */
    readonly targetNameServers: GoogleDnsManagedZoneForwardingConfigTargetNameServers[] | cdktf.IResolvable;
}
export declare function googleDnsManagedZoneForwardingConfigToTerraform(struct?: GoogleDnsManagedZoneForwardingConfigOutputReference | GoogleDnsManagedZoneForwardingConfig): any;
export declare class GoogleDnsManagedZoneForwardingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsManagedZoneForwardingConfig | undefined;
    set internalValue(value: GoogleDnsManagedZoneForwardingConfig | undefined);
    private _targetNameServers;
    get targetNameServers(): GoogleDnsManagedZoneForwardingConfigTargetNameServersList;
    putTargetNameServers(value: GoogleDnsManagedZoneForwardingConfigTargetNameServers[] | cdktf.IResolvable): void;
    get targetNameServersInput(): cdktf.IResolvable | GoogleDnsManagedZoneForwardingConfigTargetNameServers[] | undefined;
}
export interface GoogleDnsManagedZonePeeringConfigTargetNetwork {
    /**
    * The id or fully qualified URL of the VPC network to forward queries to.
  This should be formatted like 'projects/{project}/global/networks/{network}' or
  'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#network_url GoogleDnsManagedZone#network_url}
    */
    readonly networkUrl: string;
}
export declare function googleDnsManagedZonePeeringConfigTargetNetworkToTerraform(struct?: GoogleDnsManagedZonePeeringConfigTargetNetworkOutputReference | GoogleDnsManagedZonePeeringConfigTargetNetwork): any;
export declare class GoogleDnsManagedZonePeeringConfigTargetNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsManagedZonePeeringConfigTargetNetwork | undefined;
    set internalValue(value: GoogleDnsManagedZonePeeringConfigTargetNetwork | undefined);
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
}
export interface GoogleDnsManagedZonePeeringConfig {
    /**
    * target_network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#target_network GoogleDnsManagedZone#target_network}
    */
    readonly targetNetwork: GoogleDnsManagedZonePeeringConfigTargetNetwork;
}
export declare function googleDnsManagedZonePeeringConfigToTerraform(struct?: GoogleDnsManagedZonePeeringConfigOutputReference | GoogleDnsManagedZonePeeringConfig): any;
export declare class GoogleDnsManagedZonePeeringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsManagedZonePeeringConfig | undefined;
    set internalValue(value: GoogleDnsManagedZonePeeringConfig | undefined);
    private _targetNetwork;
    get targetNetwork(): GoogleDnsManagedZonePeeringConfigTargetNetworkOutputReference;
    putTargetNetwork(value: GoogleDnsManagedZonePeeringConfigTargetNetwork): void;
    get targetNetworkInput(): GoogleDnsManagedZonePeeringConfigTargetNetwork | undefined;
}
export interface GoogleDnsManagedZonePrivateVisibilityConfigNetworks {
    /**
    * The id or fully qualified URL of the VPC network to bind to.
  This should be formatted like 'projects/{project}/global/networks/{network}' or
  'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#network_url GoogleDnsManagedZone#network_url}
    */
    readonly networkUrl: string;
}
export declare function googleDnsManagedZonePrivateVisibilityConfigNetworksToTerraform(struct?: GoogleDnsManagedZonePrivateVisibilityConfigNetworks | cdktf.IResolvable): any;
export declare class GoogleDnsManagedZonePrivateVisibilityConfigNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDnsManagedZonePrivateVisibilityConfigNetworks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDnsManagedZonePrivateVisibilityConfigNetworks | cdktf.IResolvable | undefined);
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
}
export declare class GoogleDnsManagedZonePrivateVisibilityConfigNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDnsManagedZonePrivateVisibilityConfigNetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDnsManagedZonePrivateVisibilityConfigNetworksOutputReference;
}
export interface GoogleDnsManagedZonePrivateVisibilityConfig {
    /**
    * networks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#networks GoogleDnsManagedZone#networks}
    */
    readonly networks: GoogleDnsManagedZonePrivateVisibilityConfigNetworks[] | cdktf.IResolvable;
}
export declare function googleDnsManagedZonePrivateVisibilityConfigToTerraform(struct?: GoogleDnsManagedZonePrivateVisibilityConfigOutputReference | GoogleDnsManagedZonePrivateVisibilityConfig): any;
export declare class GoogleDnsManagedZonePrivateVisibilityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsManagedZonePrivateVisibilityConfig | undefined;
    set internalValue(value: GoogleDnsManagedZonePrivateVisibilityConfig | undefined);
    private _networks;
    get networks(): GoogleDnsManagedZonePrivateVisibilityConfigNetworksList;
    putNetworks(value: GoogleDnsManagedZonePrivateVisibilityConfigNetworks[] | cdktf.IResolvable): void;
    get networksInput(): cdktf.IResolvable | GoogleDnsManagedZonePrivateVisibilityConfigNetworks[] | undefined;
}
export interface GoogleDnsManagedZoneServiceDirectoryConfigNamespace {
    /**
    * The fully qualified or partial URL of the service directory namespace that should be
  associated with the zone. This should be formatted like
  'https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace_id}'
  or simply 'projects/{project}/locations/{location}/namespaces/{namespace_id}'
  Ignored for 'public' visibility zones.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#namespace_url GoogleDnsManagedZone#namespace_url}
    */
    readonly namespaceUrl: string;
}
export declare function googleDnsManagedZoneServiceDirectoryConfigNamespaceToTerraform(struct?: GoogleDnsManagedZoneServiceDirectoryConfigNamespaceOutputReference | GoogleDnsManagedZoneServiceDirectoryConfigNamespace): any;
export declare class GoogleDnsManagedZoneServiceDirectoryConfigNamespaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsManagedZoneServiceDirectoryConfigNamespace | undefined;
    set internalValue(value: GoogleDnsManagedZoneServiceDirectoryConfigNamespace | undefined);
    private _namespaceUrl?;
    get namespaceUrl(): string;
    set namespaceUrl(value: string);
    get namespaceUrlInput(): string | undefined;
}
export interface GoogleDnsManagedZoneServiceDirectoryConfig {
    /**
    * namespace block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#namespace GoogleDnsManagedZone#namespace}
    */
    readonly namespace: GoogleDnsManagedZoneServiceDirectoryConfigNamespace;
}
export declare function googleDnsManagedZoneServiceDirectoryConfigToTerraform(struct?: GoogleDnsManagedZoneServiceDirectoryConfigOutputReference | GoogleDnsManagedZoneServiceDirectoryConfig): any;
export declare class GoogleDnsManagedZoneServiceDirectoryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsManagedZoneServiceDirectoryConfig | undefined;
    set internalValue(value: GoogleDnsManagedZoneServiceDirectoryConfig | undefined);
    private _namespace;
    get namespace(): GoogleDnsManagedZoneServiceDirectoryConfigNamespaceOutputReference;
    putNamespace(value: GoogleDnsManagedZoneServiceDirectoryConfigNamespace): void;
    get namespaceInput(): GoogleDnsManagedZoneServiceDirectoryConfigNamespace | undefined;
}
export interface GoogleDnsManagedZoneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#create GoogleDnsManagedZone#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#delete GoogleDnsManagedZone#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone#update GoogleDnsManagedZone#update}
    */
    readonly update?: string;
}
export declare function googleDnsManagedZoneTimeoutsToTerraform(struct?: GoogleDnsManagedZoneTimeoutsOutputReference | GoogleDnsManagedZoneTimeouts | cdktf.IResolvable): any;
export declare class GoogleDnsManagedZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsManagedZoneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDnsManagedZoneTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone google_dns_managed_zone}
*/
export declare class GoogleDnsManagedZone extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dns_managed_zone";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_dns_managed_zone google_dns_managed_zone} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDnsManagedZoneConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDnsManagedZoneConfig);
    get creationTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dnsName?;
    get dnsName(): string;
    set dnsName(value: string);
    get dnsNameInput(): string | undefined;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get managedZoneId(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nameServers(): string[];
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _reverseLookup?;
    get reverseLookup(): boolean | cdktf.IResolvable;
    set reverseLookup(value: boolean | cdktf.IResolvable);
    resetReverseLookup(): void;
    get reverseLookupInput(): boolean | cdktf.IResolvable | undefined;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    resetVisibility(): void;
    get visibilityInput(): string | undefined;
    private _dnssecConfig;
    get dnssecConfig(): GoogleDnsManagedZoneDnssecConfigOutputReference;
    putDnssecConfig(value: GoogleDnsManagedZoneDnssecConfig): void;
    resetDnssecConfig(): void;
    get dnssecConfigInput(): GoogleDnsManagedZoneDnssecConfig | undefined;
    private _forwardingConfig;
    get forwardingConfig(): GoogleDnsManagedZoneForwardingConfigOutputReference;
    putForwardingConfig(value: GoogleDnsManagedZoneForwardingConfig): void;
    resetForwardingConfig(): void;
    get forwardingConfigInput(): GoogleDnsManagedZoneForwardingConfig | undefined;
    private _peeringConfig;
    get peeringConfig(): GoogleDnsManagedZonePeeringConfigOutputReference;
    putPeeringConfig(value: GoogleDnsManagedZonePeeringConfig): void;
    resetPeeringConfig(): void;
    get peeringConfigInput(): GoogleDnsManagedZonePeeringConfig | undefined;
    private _privateVisibilityConfig;
    get privateVisibilityConfig(): GoogleDnsManagedZonePrivateVisibilityConfigOutputReference;
    putPrivateVisibilityConfig(value: GoogleDnsManagedZonePrivateVisibilityConfig): void;
    resetPrivateVisibilityConfig(): void;
    get privateVisibilityConfigInput(): GoogleDnsManagedZonePrivateVisibilityConfig | undefined;
    private _serviceDirectoryConfig;
    get serviceDirectoryConfig(): GoogleDnsManagedZoneServiceDirectoryConfigOutputReference;
    putServiceDirectoryConfig(value: GoogleDnsManagedZoneServiceDirectoryConfig): void;
    resetServiceDirectoryConfig(): void;
    get serviceDirectoryConfigInput(): GoogleDnsManagedZoneServiceDirectoryConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleDnsManagedZoneTimeoutsOutputReference;
    putTimeouts(value: GoogleDnsManagedZoneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDnsManagedZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
