import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleEventarcTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#id GoogleEventarcTrigger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. User labels attached to the triggers that can be used to group resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#labels GoogleEventarcTrigger#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#location GoogleEventarcTrigger#location}
    */
    readonly location: string;
    /**
    * Required. The resource name of the trigger. Must be unique within the location on the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#name GoogleEventarcTrigger#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#project GoogleEventarcTrigger#project}
    */
    readonly project?: string;
    /**
    * Optional. The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#service_account GoogleEventarcTrigger#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#destination GoogleEventarcTrigger#destination}
    */
    readonly destination: GoogleEventarcTriggerDestination;
    /**
    * matching_criteria block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#matching_criteria GoogleEventarcTrigger#matching_criteria}
    */
    readonly matchingCriteria: GoogleEventarcTriggerMatchingCriteria[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#timeouts GoogleEventarcTrigger#timeouts}
    */
    readonly timeouts?: GoogleEventarcTriggerTimeouts;
    /**
    * transport block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#transport GoogleEventarcTrigger#transport}
    */
    readonly transport?: GoogleEventarcTriggerTransport;
}
export interface GoogleEventarcTriggerDestinationCloudRunService {
    /**
    * Optional. The relative path on the Cloud Run service the events should be sent to. The value must conform to the definition of URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#path GoogleEventarcTrigger#path}
    */
    readonly path?: string;
    /**
    * Required. The region the Cloud Run service is deployed in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#region GoogleEventarcTrigger#region}
    */
    readonly region?: string;
    /**
    * Required. The name of the Cloud Run service being addressed. See https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services. Only services located in the same project of the trigger object can be addressed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#service GoogleEventarcTrigger#service}
    */
    readonly service: string;
}
export declare function googleEventarcTriggerDestinationCloudRunServiceToTerraform(struct?: GoogleEventarcTriggerDestinationCloudRunServiceOutputReference | GoogleEventarcTriggerDestinationCloudRunService): any;
export declare class GoogleEventarcTriggerDestinationCloudRunServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerDestinationCloudRunService | undefined;
    set internalValue(value: GoogleEventarcTriggerDestinationCloudRunService | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export interface GoogleEventarcTriggerDestinationGke {
    /**
    * Required. The name of the cluster the GKE service is running in. The cluster must be running in the same project as the trigger being created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#cluster GoogleEventarcTrigger#cluster}
    */
    readonly cluster: string;
    /**
    * Required. The name of the Google Compute Engine in which the cluster resides, which can either be compute zone (for example, us-central1-a) for the zonal clusters or region (for example, us-central1) for regional clusters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#location GoogleEventarcTrigger#location}
    */
    readonly location: string;
    /**
    * Required. The namespace the GKE service is running in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#namespace GoogleEventarcTrigger#namespace}
    */
    readonly namespace: string;
    /**
    * Optional. The relative path on the GKE service the events should be sent to. The value must conform to the definition of a URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#path GoogleEventarcTrigger#path}
    */
    readonly path?: string;
    /**
    * Required. Name of the GKE service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#service GoogleEventarcTrigger#service}
    */
    readonly service: string;
}
export declare function googleEventarcTriggerDestinationGkeToTerraform(struct?: GoogleEventarcTriggerDestinationGkeOutputReference | GoogleEventarcTriggerDestinationGke): any;
export declare class GoogleEventarcTriggerDestinationGkeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerDestinationGke | undefined;
    set internalValue(value: GoogleEventarcTriggerDestinationGke | undefined);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export interface GoogleEventarcTriggerDestination {
    /**
    * [WARNING] Configuring a Cloud Function in Trigger is not supported as of today. The Cloud Function resource name. Format: projects/{project}/locations/{location}/functions/{function}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#cloud_function GoogleEventarcTrigger#cloud_function}
    */
    readonly cloudFunction?: string;
    /**
    * The resource name of the Workflow whose Executions are triggered by the events. The Workflow resource should be deployed in the same project as the trigger. Format: `projects/{project}/locations/{location}/workflows/{workflow}`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#workflow GoogleEventarcTrigger#workflow}
    */
    readonly workflow?: string;
    /**
    * cloud_run_service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#cloud_run_service GoogleEventarcTrigger#cloud_run_service}
    */
    readonly cloudRunService?: GoogleEventarcTriggerDestinationCloudRunService;
    /**
    * gke block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#gke GoogleEventarcTrigger#gke}
    */
    readonly gke?: GoogleEventarcTriggerDestinationGke;
}
export declare function googleEventarcTriggerDestinationToTerraform(struct?: GoogleEventarcTriggerDestinationOutputReference | GoogleEventarcTriggerDestination): any;
export declare class GoogleEventarcTriggerDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerDestination | undefined;
    set internalValue(value: GoogleEventarcTriggerDestination | undefined);
    private _cloudFunction?;
    get cloudFunction(): string;
    set cloudFunction(value: string);
    resetCloudFunction(): void;
    get cloudFunctionInput(): string | undefined;
    private _workflow?;
    get workflow(): string;
    set workflow(value: string);
    resetWorkflow(): void;
    get workflowInput(): string | undefined;
    private _cloudRunService;
    get cloudRunService(): GoogleEventarcTriggerDestinationCloudRunServiceOutputReference;
    putCloudRunService(value: GoogleEventarcTriggerDestinationCloudRunService): void;
    resetCloudRunService(): void;
    get cloudRunServiceInput(): GoogleEventarcTriggerDestinationCloudRunService | undefined;
    private _gke;
    get gke(): GoogleEventarcTriggerDestinationGkeOutputReference;
    putGke(value: GoogleEventarcTriggerDestinationGke): void;
    resetGke(): void;
    get gkeInput(): GoogleEventarcTriggerDestinationGke | undefined;
}
export interface GoogleEventarcTriggerMatchingCriteria {
    /**
    * Required. The name of a CloudEvents attribute. Currently, only a subset of attributes are supported for filtering. All triggers MUST provide a filter for the 'type' attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#attribute GoogleEventarcTrigger#attribute}
    */
    readonly attribute: string;
    /**
    * Optional. The operator used for matching the events with the value of the filter. If not specified, only events that have an exact key-value pair specified in the filter are matched. The only allowed value is `match-path-pattern`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#operator GoogleEventarcTrigger#operator}
    */
    readonly operator?: string;
    /**
    * Required. The value for the attribute. See https://cloud.google.com/eventarc/docs/creating-triggers#trigger-gcloud for available values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#value GoogleEventarcTrigger#value}
    */
    readonly value: string;
}
export declare function googleEventarcTriggerMatchingCriteriaToTerraform(struct?: GoogleEventarcTriggerMatchingCriteria | cdktf.IResolvable): any;
export declare class GoogleEventarcTriggerMatchingCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleEventarcTriggerMatchingCriteria | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEventarcTriggerMatchingCriteria | cdktf.IResolvable | undefined);
    private _attribute?;
    get attribute(): string;
    set attribute(value: string);
    get attributeInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleEventarcTriggerMatchingCriteriaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleEventarcTriggerMatchingCriteria[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleEventarcTriggerMatchingCriteriaOutputReference;
}
export interface GoogleEventarcTriggerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#create GoogleEventarcTrigger#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#delete GoogleEventarcTrigger#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#update GoogleEventarcTrigger#update}
    */
    readonly update?: string;
}
export declare function googleEventarcTriggerTimeoutsToTerraform(struct?: GoogleEventarcTriggerTimeoutsOutputReference | GoogleEventarcTriggerTimeouts | cdktf.IResolvable): any;
export declare class GoogleEventarcTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEventarcTriggerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleEventarcTriggerTransportPubsub {
    /**
    * Optional. The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{PROJECT_ID}/topics/{TOPIC_NAME}. You may set an existing topic for triggers of the type google.cloud.pubsub.topic.v1.messagePublished` only. The topic you provide here will not be deleted by Eventarc at trigger deletion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#topic GoogleEventarcTrigger#topic}
    */
    readonly topic?: string;
}
export declare function googleEventarcTriggerTransportPubsubToTerraform(struct?: GoogleEventarcTriggerTransportPubsubOutputReference | GoogleEventarcTriggerTransportPubsub): any;
export declare class GoogleEventarcTriggerTransportPubsubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerTransportPubsub | undefined;
    set internalValue(value: GoogleEventarcTriggerTransportPubsub | undefined);
    get subscription(): string;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    resetTopic(): void;
    get topicInput(): string | undefined;
}
export interface GoogleEventarcTriggerTransport {
    /**
    * pubsub block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger#pubsub GoogleEventarcTrigger#pubsub}
    */
    readonly pubsub?: GoogleEventarcTriggerTransportPubsub;
}
export declare function googleEventarcTriggerTransportToTerraform(struct?: GoogleEventarcTriggerTransportOutputReference | GoogleEventarcTriggerTransport): any;
export declare class GoogleEventarcTriggerTransportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerTransport | undefined;
    set internalValue(value: GoogleEventarcTriggerTransport | undefined);
    private _pubsub;
    get pubsub(): GoogleEventarcTriggerTransportPubsubOutputReference;
    putPubsub(value: GoogleEventarcTriggerTransportPubsub): void;
    resetPubsub(): void;
    get pubsubInput(): GoogleEventarcTriggerTransportPubsub | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger google_eventarc_trigger}
*/
export declare class GoogleEventarcTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_eventarc_trigger";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_eventarc_trigger google_eventarc_trigger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleEventarcTriggerConfig
    */
    constructor(scope: Construct, id: string, config: GoogleEventarcTriggerConfig);
    get createTime(): string;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _destination;
    get destination(): GoogleEventarcTriggerDestinationOutputReference;
    putDestination(value: GoogleEventarcTriggerDestination): void;
    get destinationInput(): GoogleEventarcTriggerDestination | undefined;
    private _matchingCriteria;
    get matchingCriteria(): GoogleEventarcTriggerMatchingCriteriaList;
    putMatchingCriteria(value: GoogleEventarcTriggerMatchingCriteria[] | cdktf.IResolvable): void;
    get matchingCriteriaInput(): cdktf.IResolvable | GoogleEventarcTriggerMatchingCriteria[] | undefined;
    private _timeouts;
    get timeouts(): GoogleEventarcTriggerTimeoutsOutputReference;
    putTimeouts(value: GoogleEventarcTriggerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleEventarcTriggerTimeouts | undefined;
    private _transport;
    get transport(): GoogleEventarcTriggerTransportOutputReference;
    putTransport(value: GoogleEventarcTriggerTransport): void;
    resetTransport(): void;
    get transportInput(): GoogleEventarcTriggerTransport | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
