import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user-assigned display name of the App.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_firebase_web_app#display_name GoogleFirebaseWebApp#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_firebase_web_app#id GoogleFirebaseWebApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_firebase_web_app#project GoogleFirebaseWebApp#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_firebase_web_app#timeouts GoogleFirebaseWebApp#timeouts}
    */
    readonly timeouts?: GoogleFirebaseWebAppTimeouts;
}
export interface GoogleFirebaseWebAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_firebase_web_app#create GoogleFirebaseWebApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_firebase_web_app#delete GoogleFirebaseWebApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_firebase_web_app#update GoogleFirebaseWebApp#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseWebAppTimeoutsToTerraform(struct?: GoogleFirebaseWebAppTimeoutsOutputReference | GoogleFirebaseWebAppTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseWebAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseWebAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_firebase_web_app google_firebase_web_app}
*/
export declare class GoogleFirebaseWebApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_web_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_firebase_web_app google_firebase_web_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseWebAppConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseWebAppConfig);
    get appId(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseWebAppTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseWebAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseWebAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
