import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGameServicesGameServerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Required. The resource name of the game server cluster
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#cluster_id GoogleGameServicesGameServerCluster#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Human readable description of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#description GoogleGameServicesGameServerCluster#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#id GoogleGameServicesGameServerCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels associated with this game server cluster. Each label is a
  key-value pair.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#labels GoogleGameServicesGameServerCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Location of the Cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#location GoogleGameServicesGameServerCluster#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#project GoogleGameServicesGameServerCluster#project}
    */
    readonly project?: string;
    /**
    * The realm id of the game server realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#realm_id GoogleGameServicesGameServerCluster#realm_id}
    */
    readonly realmId: string;
    /**
    * connection_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#connection_info GoogleGameServicesGameServerCluster#connection_info}
    */
    readonly connectionInfo: GoogleGameServicesGameServerClusterConnectionInfo;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#timeouts GoogleGameServicesGameServerCluster#timeouts}
    */
    readonly timeouts?: GoogleGameServicesGameServerClusterTimeouts;
}
export interface GoogleGameServicesGameServerClusterConnectionInfoGkeClusterReference {
    /**
    * The full or partial name of a GKE cluster, using one of the following
  forms:
  
  * 'projects/{project_id}/locations/{location}/clusters/{cluster_id}'
  * 'locations/{location}/clusters/{cluster_id}'
  * '{cluster_id}'
  
  If project and location are not specified, the project and location of the
  GameServerCluster resource are used to generate the full name of the
  GKE cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#cluster GoogleGameServicesGameServerCluster#cluster}
    */
    readonly cluster: string;
}
export declare function googleGameServicesGameServerClusterConnectionInfoGkeClusterReferenceToTerraform(struct?: GoogleGameServicesGameServerClusterConnectionInfoGkeClusterReferenceOutputReference | GoogleGameServicesGameServerClusterConnectionInfoGkeClusterReference): any;
export declare class GoogleGameServicesGameServerClusterConnectionInfoGkeClusterReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGameServicesGameServerClusterConnectionInfoGkeClusterReference | undefined;
    set internalValue(value: GoogleGameServicesGameServerClusterConnectionInfoGkeClusterReference | undefined);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
}
export interface GoogleGameServicesGameServerClusterConnectionInfo {
    /**
    * Namespace designated on the game server cluster where the game server
  instances will be created. The namespace existence will be validated
  during creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#namespace GoogleGameServicesGameServerCluster#namespace}
    */
    readonly namespace: string;
    /**
    * gke_cluster_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#gke_cluster_reference GoogleGameServicesGameServerCluster#gke_cluster_reference}
    */
    readonly gkeClusterReference: GoogleGameServicesGameServerClusterConnectionInfoGkeClusterReference;
}
export declare function googleGameServicesGameServerClusterConnectionInfoToTerraform(struct?: GoogleGameServicesGameServerClusterConnectionInfoOutputReference | GoogleGameServicesGameServerClusterConnectionInfo): any;
export declare class GoogleGameServicesGameServerClusterConnectionInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGameServicesGameServerClusterConnectionInfo | undefined;
    set internalValue(value: GoogleGameServicesGameServerClusterConnectionInfo | undefined);
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _gkeClusterReference;
    get gkeClusterReference(): GoogleGameServicesGameServerClusterConnectionInfoGkeClusterReferenceOutputReference;
    putGkeClusterReference(value: GoogleGameServicesGameServerClusterConnectionInfoGkeClusterReference): void;
    get gkeClusterReferenceInput(): GoogleGameServicesGameServerClusterConnectionInfoGkeClusterReference | undefined;
}
export interface GoogleGameServicesGameServerClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#create GoogleGameServicesGameServerCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#delete GoogleGameServicesGameServerCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster#update GoogleGameServicesGameServerCluster#update}
    */
    readonly update?: string;
}
export declare function googleGameServicesGameServerClusterTimeoutsToTerraform(struct?: GoogleGameServicesGameServerClusterTimeoutsOutputReference | GoogleGameServicesGameServerClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleGameServicesGameServerClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGameServicesGameServerClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGameServicesGameServerClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster google_game_services_game_server_cluster}
*/
export declare class GoogleGameServicesGameServerCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_game_services_game_server_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_cluster google_game_services_game_server_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGameServicesGameServerClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGameServicesGameServerClusterConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _realmId?;
    get realmId(): string;
    set realmId(value: string);
    get realmIdInput(): string | undefined;
    private _connectionInfo;
    get connectionInfo(): GoogleGameServicesGameServerClusterConnectionInfoOutputReference;
    putConnectionInfo(value: GoogleGameServicesGameServerClusterConnectionInfo): void;
    get connectionInfoInput(): GoogleGameServicesGameServerClusterConnectionInfo | undefined;
    private _timeouts;
    get timeouts(): GoogleGameServicesGameServerClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleGameServicesGameServerClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGameServicesGameServerClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
