import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGameServicesGameServerDeploymentRolloutConfig extends cdktf.TerraformMetaArguments {
    /**
    * This field points to the game server config that is
  applied by default to all realms and clusters. For example,
  
  'projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#default_game_server_config GoogleGameServicesGameServerDeploymentRollout#default_game_server_config}
    */
    readonly defaultGameServerConfig: string;
    /**
    * The deployment to rollout the new config to. Only 1 rollout must be associated with each deployment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#deployment_id GoogleGameServicesGameServerDeploymentRollout#deployment_id}
    */
    readonly deploymentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#id GoogleGameServicesGameServerDeploymentRollout#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#project GoogleGameServicesGameServerDeploymentRollout#project}
    */
    readonly project?: string;
    /**
    * game_server_config_overrides block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#game_server_config_overrides GoogleGameServicesGameServerDeploymentRollout#game_server_config_overrides}
    */
    readonly gameServerConfigOverrides?: GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#timeouts GoogleGameServicesGameServerDeploymentRollout#timeouts}
    */
    readonly timeouts?: GoogleGameServicesGameServerDeploymentRolloutTimeouts;
}
export interface GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector {
    /**
    * List of realms to match against.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#realms GoogleGameServicesGameServerDeploymentRollout#realms}
    */
    readonly realms?: string[];
}
export declare function googleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorToTerraform(struct?: GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorOutputReference | GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector): any;
export declare class GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector | undefined;
    set internalValue(value: GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector | undefined);
    private _realms?;
    get realms(): string[];
    set realms(value: string[]);
    resetRealms(): void;
    get realmsInput(): string[] | undefined;
}
export interface GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides {
    /**
    * Version of the configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#config_version GoogleGameServicesGameServerDeploymentRollout#config_version}
    */
    readonly configVersion?: string;
    /**
    * realms_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#realms_selector GoogleGameServicesGameServerDeploymentRollout#realms_selector}
    */
    readonly realmsSelector?: GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector;
}
export declare function googleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesToTerraform(struct?: GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides | cdktf.IResolvable): any;
export declare class GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides | cdktf.IResolvable | undefined);
    private _configVersion?;
    get configVersion(): string;
    set configVersion(value: string);
    resetConfigVersion(): void;
    get configVersionInput(): string | undefined;
    private _realmsSelector;
    get realmsSelector(): GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorOutputReference;
    putRealmsSelector(value: GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector): void;
    resetRealmsSelector(): void;
    get realmsSelectorInput(): GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector | undefined;
}
export declare class GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesOutputReference;
}
export interface GoogleGameServicesGameServerDeploymentRolloutTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#create GoogleGameServicesGameServerDeploymentRollout#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#delete GoogleGameServicesGameServerDeploymentRollout#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout#update GoogleGameServicesGameServerDeploymentRollout#update}
    */
    readonly update?: string;
}
export declare function googleGameServicesGameServerDeploymentRolloutTimeoutsToTerraform(struct?: GoogleGameServicesGameServerDeploymentRolloutTimeoutsOutputReference | GoogleGameServicesGameServerDeploymentRolloutTimeouts | cdktf.IResolvable): any;
export declare class GoogleGameServicesGameServerDeploymentRolloutTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGameServicesGameServerDeploymentRolloutTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGameServicesGameServerDeploymentRolloutTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout google_game_services_game_server_deployment_rollout}
*/
export declare class GoogleGameServicesGameServerDeploymentRollout extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_game_services_game_server_deployment_rollout";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment_rollout google_game_services_game_server_deployment_rollout} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGameServicesGameServerDeploymentRolloutConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGameServicesGameServerDeploymentRolloutConfig);
    private _defaultGameServerConfig?;
    get defaultGameServerConfig(): string;
    set defaultGameServerConfig(value: string);
    get defaultGameServerConfigInput(): string | undefined;
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _gameServerConfigOverrides;
    get gameServerConfigOverrides(): GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesList;
    putGameServerConfigOverrides(value: GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | cdktf.IResolvable): void;
    resetGameServerConfigOverrides(): void;
    get gameServerConfigOverridesInput(): cdktf.IResolvable | GoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | undefined;
    private _timeouts;
    get timeouts(): GoogleGameServicesGameServerDeploymentRolloutTimeoutsOutputReference;
    putTimeouts(value: GoogleGameServicesGameServerDeploymentRolloutTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGameServicesGameServerDeploymentRolloutTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
