import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGameServicesGameServerDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * A unique id for the deployment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment#deployment_id GoogleGameServicesGameServerDeployment#deployment_id}
    */
    readonly deploymentId: string;
    /**
    * Human readable description of the game server deployment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment#description GoogleGameServicesGameServerDeployment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment#id GoogleGameServicesGameServerDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels associated with this game server deployment. Each label is a
  key-value pair.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment#labels GoogleGameServicesGameServerDeployment#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Location of the Deployment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment#location GoogleGameServicesGameServerDeployment#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment#project GoogleGameServicesGameServerDeployment#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment#timeouts GoogleGameServicesGameServerDeployment#timeouts}
    */
    readonly timeouts?: GoogleGameServicesGameServerDeploymentTimeouts;
}
export interface GoogleGameServicesGameServerDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment#create GoogleGameServicesGameServerDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment#delete GoogleGameServicesGameServerDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment#update GoogleGameServicesGameServerDeployment#update}
    */
    readonly update?: string;
}
export declare function googleGameServicesGameServerDeploymentTimeoutsToTerraform(struct?: GoogleGameServicesGameServerDeploymentTimeoutsOutputReference | GoogleGameServicesGameServerDeploymentTimeouts | cdktf.IResolvable): any;
export declare class GoogleGameServicesGameServerDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGameServicesGameServerDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGameServicesGameServerDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment google_game_services_game_server_deployment}
*/
export declare class GoogleGameServicesGameServerDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_game_services_game_server_deployment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_game_services_game_server_deployment google_game_services_game_server_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGameServicesGameServerDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGameServicesGameServerDeploymentConfig);
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleGameServicesGameServerDeploymentTimeoutsOutputReference;
    putTimeouts(value: GoogleGameServicesGameServerDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGameServicesGameServerDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
