import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeHubFeatureMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the feature
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#feature GoogleGkeHubFeatureMembership#feature}
    */
    readonly feature: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#id GoogleGkeHubFeatureMembership#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the feature
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#location GoogleGkeHubFeatureMembership#location}
    */
    readonly location: string;
    /**
    * The name of the membership
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#membership GoogleGkeHubFeatureMembership#membership}
    */
    readonly membership: string;
    /**
    * The project of the feature
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#project GoogleGkeHubFeatureMembership#project}
    */
    readonly project?: string;
    /**
    * configmanagement block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#configmanagement GoogleGkeHubFeatureMembership#configmanagement}
    */
    readonly configmanagement: GoogleGkeHubFeatureMembershipConfigmanagement;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#timeouts GoogleGkeHubFeatureMembership#timeouts}
    */
    readonly timeouts?: GoogleGkeHubFeatureMembershipTimeouts;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementBinauthz {
    /**
    * Whether binauthz is enabled in this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#enabled GoogleGkeHubFeatureMembership#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementBinauthzToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementBinauthzOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementBinauthz): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementBinauthzOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementBinauthz | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementBinauthz | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit {
    /**
    * The GCP Service Account Email used for auth when secretType is gcpServiceAccount.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#gcp_service_account_email GoogleGkeHubFeatureMembership#gcp_service_account_email}
    */
    readonly gcpServiceAccountEmail?: string;
    /**
    * URL for the HTTPS proxy to be used when communicating with the Git repo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#https_proxy GoogleGkeHubFeatureMembership#https_proxy}
    */
    readonly httpsProxy?: string;
    /**
    * The path within the Git repository that represents the top level of the repo to sync. Default: the root directory of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#policy_dir GoogleGkeHubFeatureMembership#policy_dir}
    */
    readonly policyDir?: string;
    /**
    * Type of secret configured for access to the Git repo. Must be one of ssh, cookiefile, gcenode, token, gcpserviceaccount or none. The validation of this is case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#secret_type GoogleGkeHubFeatureMembership#secret_type}
    */
    readonly secretType?: string;
    /**
    * The branch of the repository to sync from. Default: master.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#sync_branch GoogleGkeHubFeatureMembership#sync_branch}
    */
    readonly syncBranch?: string;
    /**
    * The URL of the Git repository to use as the source of truth.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#sync_repo GoogleGkeHubFeatureMembership#sync_repo}
    */
    readonly syncRepo?: string;
    /**
    * Git revision (tag or hash) to check out. Default HEAD.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#sync_rev GoogleGkeHubFeatureMembership#sync_rev}
    */
    readonly syncRev?: string;
    /**
    * Period in seconds between consecutive syncs. Default: 15.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#sync_wait_secs GoogleGkeHubFeatureMembership#sync_wait_secs}
    */
    readonly syncWaitSecs?: string;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementConfigSyncGitToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGitOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit | undefined);
    private _gcpServiceAccountEmail?;
    get gcpServiceAccountEmail(): string;
    set gcpServiceAccountEmail(value: string);
    resetGcpServiceAccountEmail(): void;
    get gcpServiceAccountEmailInput(): string | undefined;
    private _httpsProxy?;
    get httpsProxy(): string;
    set httpsProxy(value: string);
    resetHttpsProxy(): void;
    get httpsProxyInput(): string | undefined;
    private _policyDir?;
    get policyDir(): string;
    set policyDir(value: string);
    resetPolicyDir(): void;
    get policyDirInput(): string | undefined;
    private _secretType?;
    get secretType(): string;
    set secretType(value: string);
    resetSecretType(): void;
    get secretTypeInput(): string | undefined;
    private _syncBranch?;
    get syncBranch(): string;
    set syncBranch(value: string);
    resetSyncBranch(): void;
    get syncBranchInput(): string | undefined;
    private _syncRepo?;
    get syncRepo(): string;
    set syncRepo(value: string);
    resetSyncRepo(): void;
    get syncRepoInput(): string | undefined;
    private _syncRev?;
    get syncRev(): string;
    set syncRev(value: string);
    resetSyncRev(): void;
    get syncRevInput(): string | undefined;
    private _syncWaitSecs?;
    get syncWaitSecs(): string;
    set syncWaitSecs(value: string);
    resetSyncWaitSecs(): void;
    get syncWaitSecsInput(): string | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementConfigSync {
    /**
    * Set to true to enable the Config Sync admission webhook to prevent drifts. If set to `false`, disables the Config Sync admission webhook and does not prevent drifts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#prevent_drift GoogleGkeHubFeatureMembership#prevent_drift}
    */
    readonly preventDrift?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the Config Sync Repo is in "hierarchical" or "unstructured" mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#source_format GoogleGkeHubFeatureMembership#source_format}
    */
    readonly sourceFormat?: string;
    /**
    * git block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#git GoogleGkeHubFeatureMembership#git}
    */
    readonly git?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementConfigSyncToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementConfigSync): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSync | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementConfigSync | undefined);
    private _preventDrift?;
    get preventDrift(): boolean | cdktf.IResolvable;
    set preventDrift(value: boolean | cdktf.IResolvable);
    resetPreventDrift(): void;
    get preventDriftInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceFormat?;
    get sourceFormat(): string;
    set sourceFormat(value: string);
    resetSourceFormat(): void;
    get sourceFormatInput(): string | undefined;
    private _git;
    get git(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGitOutputReference;
    putGit(value: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit): void;
    resetGit(): void;
    get gitInput(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController {
    /**
    * Whether hierarchical resource quota is enabled in this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#enable_hierarchical_resource_quota GoogleGkeHubFeatureMembership#enable_hierarchical_resource_quota}
    */
    readonly enableHierarchicalResourceQuota?: boolean | cdktf.IResolvable;
    /**
    * Whether pod tree labels are enabled in this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#enable_pod_tree_labels GoogleGkeHubFeatureMembership#enable_pod_tree_labels}
    */
    readonly enablePodTreeLabels?: boolean | cdktf.IResolvable;
    /**
    * Whether Hierarchy Controller is enabled in this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#enabled GoogleGkeHubFeatureMembership#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementHierarchyControllerToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementHierarchyControllerOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementHierarchyControllerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController | undefined);
    private _enableHierarchicalResourceQuota?;
    get enableHierarchicalResourceQuota(): boolean | cdktf.IResolvable;
    set enableHierarchicalResourceQuota(value: boolean | cdktf.IResolvable);
    resetEnableHierarchicalResourceQuota(): void;
    get enableHierarchicalResourceQuotaInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePodTreeLabels?;
    get enablePodTreeLabels(): boolean | cdktf.IResolvable;
    set enablePodTreeLabels(value: boolean | cdktf.IResolvable);
    resetEnablePodTreeLabels(): void;
    get enablePodTreeLabelsInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring {
    /**
    *  Specifies the list of backends Policy Controller will export to. Specifying an empty value `[]` disables metrics export.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#backends GoogleGkeHubFeatureMembership#backends}
    */
    readonly backends?: string[];
}
export declare function googleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoringToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoringOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring | undefined);
    private _backends?;
    get backends(): string[];
    set backends(value: string[]);
    resetBackends(): void;
    get backendsInput(): string[] | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementPolicyController {
    /**
    * Sets the interval for Policy Controller Audit Scans (in seconds). When set to 0, this disables audit functionality altogether.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#audit_interval_seconds GoogleGkeHubFeatureMembership#audit_interval_seconds}
    */
    readonly auditIntervalSeconds?: string;
    /**
    * Enables the installation of Policy Controller. If false, the rest of PolicyController fields take no effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#enabled GoogleGkeHubFeatureMembership#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The set of namespaces that are excluded from Policy Controller checks. Namespaces do not need to currently exist on the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#exemptable_namespaces GoogleGkeHubFeatureMembership#exemptable_namespaces}
    */
    readonly exemptableNamespaces?: string[];
    /**
    * Logs all denies and dry run failures.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#log_denies_enabled GoogleGkeHubFeatureMembership#log_denies_enabled}
    */
    readonly logDeniesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enable or disable mutation in policy controller. If true, mutation CRDs, webhook and controller deployment will be deployed to the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#mutation_enabled GoogleGkeHubFeatureMembership#mutation_enabled}
    */
    readonly mutationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enables the ability to use Constraint Templates that reference to objects other than the object currently being evaluated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#referential_rules_enabled GoogleGkeHubFeatureMembership#referential_rules_enabled}
    */
    readonly referentialRulesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Installs the default template library along with Policy Controller.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#template_library_installed GoogleGkeHubFeatureMembership#template_library_installed}
    */
    readonly templateLibraryInstalled?: boolean | cdktf.IResolvable;
    /**
    * monitoring block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#monitoring GoogleGkeHubFeatureMembership#monitoring}
    */
    readonly monitoring?: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementPolicyControllerToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementPolicyController): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyController | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementPolicyController | undefined);
    private _auditIntervalSeconds?;
    get auditIntervalSeconds(): string;
    set auditIntervalSeconds(value: string);
    resetAuditIntervalSeconds(): void;
    get auditIntervalSecondsInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exemptableNamespaces?;
    get exemptableNamespaces(): string[];
    set exemptableNamespaces(value: string[]);
    resetExemptableNamespaces(): void;
    get exemptableNamespacesInput(): string[] | undefined;
    private _logDeniesEnabled?;
    get logDeniesEnabled(): boolean | cdktf.IResolvable;
    set logDeniesEnabled(value: boolean | cdktf.IResolvable);
    resetLogDeniesEnabled(): void;
    get logDeniesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mutationEnabled?;
    get mutationEnabled(): boolean | cdktf.IResolvable;
    set mutationEnabled(value: boolean | cdktf.IResolvable);
    resetMutationEnabled(): void;
    get mutationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _referentialRulesEnabled?;
    get referentialRulesEnabled(): boolean | cdktf.IResolvable;
    set referentialRulesEnabled(value: boolean | cdktf.IResolvable);
    resetReferentialRulesEnabled(): void;
    get referentialRulesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _templateLibraryInstalled?;
    get templateLibraryInstalled(): boolean | cdktf.IResolvable;
    set templateLibraryInstalled(value: boolean | cdktf.IResolvable);
    resetTemplateLibraryInstalled(): void;
    get templateLibraryInstalledInput(): boolean | cdktf.IResolvable | undefined;
    private _monitoring;
    get monitoring(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoringOutputReference;
    putMonitoring(value: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring): void;
    resetMonitoring(): void;
    get monitoringInput(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagement {
    /**
    * Optional. Version of ACM to install. Defaults to the latest version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#version GoogleGkeHubFeatureMembership#version}
    */
    readonly version?: string;
    /**
    * binauthz block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#binauthz GoogleGkeHubFeatureMembership#binauthz}
    */
    readonly binauthz?: GoogleGkeHubFeatureMembershipConfigmanagementBinauthz;
    /**
    * config_sync block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#config_sync GoogleGkeHubFeatureMembership#config_sync}
    */
    readonly configSync?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSync;
    /**
    * hierarchy_controller block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#hierarchy_controller GoogleGkeHubFeatureMembership#hierarchy_controller}
    */
    readonly hierarchyController?: GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController;
    /**
    * policy_controller block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#policy_controller GoogleGkeHubFeatureMembership#policy_controller}
    */
    readonly policyController?: GoogleGkeHubFeatureMembershipConfigmanagementPolicyController;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementOutputReference | GoogleGkeHubFeatureMembershipConfigmanagement): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagement | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagement | undefined);
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _binauthz;
    get binauthz(): GoogleGkeHubFeatureMembershipConfigmanagementBinauthzOutputReference;
    putBinauthz(value: GoogleGkeHubFeatureMembershipConfigmanagementBinauthz): void;
    resetBinauthz(): void;
    get binauthzInput(): GoogleGkeHubFeatureMembershipConfigmanagementBinauthz | undefined;
    private _configSync;
    get configSync(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOutputReference;
    putConfigSync(value: GoogleGkeHubFeatureMembershipConfigmanagementConfigSync): void;
    resetConfigSync(): void;
    get configSyncInput(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSync | undefined;
    private _hierarchyController;
    get hierarchyController(): GoogleGkeHubFeatureMembershipConfigmanagementHierarchyControllerOutputReference;
    putHierarchyController(value: GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController): void;
    resetHierarchyController(): void;
    get hierarchyControllerInput(): GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController | undefined;
    private _policyController;
    get policyController(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerOutputReference;
    putPolicyController(value: GoogleGkeHubFeatureMembershipConfigmanagementPolicyController): void;
    resetPolicyController(): void;
    get policyControllerInput(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyController | undefined;
}
export interface GoogleGkeHubFeatureMembershipTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#create GoogleGkeHubFeatureMembership#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#delete GoogleGkeHubFeatureMembership#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership#update GoogleGkeHubFeatureMembership#update}
    */
    readonly update?: string;
}
export declare function googleGkeHubFeatureMembershipTimeoutsToTerraform(struct?: GoogleGkeHubFeatureMembershipTimeoutsOutputReference | GoogleGkeHubFeatureMembershipTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeHubFeatureMembershipTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership google_gke_hub_feature_membership}
*/
export declare class GoogleGkeHubFeatureMembership extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_hub_feature_membership";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_feature_membership google_gke_hub_feature_membership} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeHubFeatureMembershipConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeHubFeatureMembershipConfig);
    private _feature?;
    get feature(): string;
    set feature(value: string);
    get featureInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _membership?;
    get membership(): string;
    set membership(value: string);
    get membershipInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _configmanagement;
    get configmanagement(): GoogleGkeHubFeatureMembershipConfigmanagementOutputReference;
    putConfigmanagement(value: GoogleGkeHubFeatureMembershipConfigmanagement): void;
    get configmanagementInput(): GoogleGkeHubFeatureMembershipConfigmanagement | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeHubFeatureMembershipTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeHubFeatureMembershipTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeHubFeatureMembershipTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
