import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeHubMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of this entity type to be displayed on the console. This field is unavailable in v1 of the API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#description GoogleGkeHubMembership#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#id GoogleGkeHubMembership#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels to apply to this membership.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#labels GoogleGkeHubMembership#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The client-provided identifier of the membership.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#membership_id GoogleGkeHubMembership#membership_id}
    */
    readonly membershipId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#project GoogleGkeHubMembership#project}
    */
    readonly project?: string;
    /**
    * authority block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#authority GoogleGkeHubMembership#authority}
    */
    readonly authority?: GoogleGkeHubMembershipAuthority;
    /**
    * endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#endpoint GoogleGkeHubMembership#endpoint}
    */
    readonly endpoint?: GoogleGkeHubMembershipEndpoint;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#timeouts GoogleGkeHubMembership#timeouts}
    */
    readonly timeouts?: GoogleGkeHubMembershipTimeouts;
}
export interface GoogleGkeHubMembershipAuthority {
    /**
    * A JSON Web Token (JWT) issuer URI. 'issuer' must start with 'https://' and // be a valid
  with length <2000 characters. For example: 'https://container.googleapis.com/v1/projects/my-project/locations/us-west1/clusters/my-cluster' (must be 'locations' rather than 'zones'). If the cluster is provisioned with Terraform, this is '"https://container.googleapis.com/v1/${google_container_cluster.my-cluster.id}"'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#issuer GoogleGkeHubMembership#issuer}
    */
    readonly issuer: string;
}
export declare function googleGkeHubMembershipAuthorityToTerraform(struct?: GoogleGkeHubMembershipAuthorityOutputReference | GoogleGkeHubMembershipAuthority): any;
export declare class GoogleGkeHubMembershipAuthorityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubMembershipAuthority | undefined;
    set internalValue(value: GoogleGkeHubMembershipAuthority | undefined);
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
}
export interface GoogleGkeHubMembershipEndpointGkeCluster {
    /**
    * Self-link of the GCP resource for the GKE cluster.
  For example: '//container.googleapis.com/projects/my-project/zones/us-west1-a/clusters/my-cluster'.
  It can be at the most 1000 characters in length. If the cluster is provisioned with Terraform,
  this can be '"//container.googleapis.com/${google_container_cluster.my-cluster.id}"' or
  'google_container_cluster.my-cluster.id'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#resource_link GoogleGkeHubMembership#resource_link}
    */
    readonly resourceLink: string;
}
export declare function googleGkeHubMembershipEndpointGkeClusterToTerraform(struct?: GoogleGkeHubMembershipEndpointGkeClusterOutputReference | GoogleGkeHubMembershipEndpointGkeCluster): any;
export declare class GoogleGkeHubMembershipEndpointGkeClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubMembershipEndpointGkeCluster | undefined;
    set internalValue(value: GoogleGkeHubMembershipEndpointGkeCluster | undefined);
    private _resourceLink?;
    get resourceLink(): string;
    set resourceLink(value: string);
    get resourceLinkInput(): string | undefined;
}
export interface GoogleGkeHubMembershipEndpoint {
    /**
    * gke_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#gke_cluster GoogleGkeHubMembership#gke_cluster}
    */
    readonly gkeCluster?: GoogleGkeHubMembershipEndpointGkeCluster;
}
export declare function googleGkeHubMembershipEndpointToTerraform(struct?: GoogleGkeHubMembershipEndpointOutputReference | GoogleGkeHubMembershipEndpoint): any;
export declare class GoogleGkeHubMembershipEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubMembershipEndpoint | undefined;
    set internalValue(value: GoogleGkeHubMembershipEndpoint | undefined);
    private _gkeCluster;
    get gkeCluster(): GoogleGkeHubMembershipEndpointGkeClusterOutputReference;
    putGkeCluster(value: GoogleGkeHubMembershipEndpointGkeCluster): void;
    resetGkeCluster(): void;
    get gkeClusterInput(): GoogleGkeHubMembershipEndpointGkeCluster | undefined;
}
export interface GoogleGkeHubMembershipTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#create GoogleGkeHubMembership#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#delete GoogleGkeHubMembership#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership#update GoogleGkeHubMembership#update}
    */
    readonly update?: string;
}
export declare function googleGkeHubMembershipTimeoutsToTerraform(struct?: GoogleGkeHubMembershipTimeoutsOutputReference | GoogleGkeHubMembershipTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeHubMembershipTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubMembershipTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubMembershipTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership google_gke_hub_membership}
*/
export declare class GoogleGkeHubMembership extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_hub_membership";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_gke_hub_membership google_gke_hub_membership} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeHubMembershipConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeHubMembershipConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _membershipId?;
    get membershipId(): string;
    set membershipId(value: string);
    get membershipIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _authority;
    get authority(): GoogleGkeHubMembershipAuthorityOutputReference;
    putAuthority(value: GoogleGkeHubMembershipAuthority): void;
    resetAuthority(): void;
    get authorityInput(): GoogleGkeHubMembershipAuthority | undefined;
    private _endpoint;
    get endpoint(): GoogleGkeHubMembershipEndpointOutputReference;
    putEndpoint(value: GoogleGkeHubMembershipEndpoint): void;
    resetEndpoint(): void;
    get endpointInput(): GoogleGkeHubMembershipEndpoint | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeHubMembershipTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeHubMembershipTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeHubMembershipTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
