import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareConsentStoreIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member#consent_store_id GoogleHealthcareConsentStoreIamMember#consent_store_id}
    */
    readonly consentStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member#dataset GoogleHealthcareConsentStoreIamMember#dataset}
    */
    readonly dataset: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member#id GoogleHealthcareConsentStoreIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member#member GoogleHealthcareConsentStoreIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member#role GoogleHealthcareConsentStoreIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member#condition GoogleHealthcareConsentStoreIamMember#condition}
    */
    readonly condition?: GoogleHealthcareConsentStoreIamMemberCondition;
}
export interface GoogleHealthcareConsentStoreIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member#description GoogleHealthcareConsentStoreIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member#expression GoogleHealthcareConsentStoreIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member#title GoogleHealthcareConsentStoreIamMember#title}
    */
    readonly title: string;
}
export declare function googleHealthcareConsentStoreIamMemberConditionToTerraform(struct?: GoogleHealthcareConsentStoreIamMemberConditionOutputReference | GoogleHealthcareConsentStoreIamMemberCondition): any;
export declare class GoogleHealthcareConsentStoreIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareConsentStoreIamMemberCondition | undefined;
    set internalValue(value: GoogleHealthcareConsentStoreIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member google_healthcare_consent_store_iam_member}
*/
export declare class GoogleHealthcareConsentStoreIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_consent_store_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_consent_store_iam_member google_healthcare_consent_store_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareConsentStoreIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareConsentStoreIamMemberConfig);
    private _consentStoreId?;
    get consentStoreId(): string;
    set consentStoreId(value: string);
    get consentStoreIdInput(): string | undefined;
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleHealthcareConsentStoreIamMemberConditionOutputReference;
    putCondition(value: GoogleHealthcareConsentStoreIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleHealthcareConsentStoreIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
