import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareDicomStoreIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_dicom_store_iam_binding#dicom_store_id GoogleHealthcareDicomStoreIamBinding#dicom_store_id}
    */
    readonly dicomStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_dicom_store_iam_binding#id GoogleHealthcareDicomStoreIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_dicom_store_iam_binding#members GoogleHealthcareDicomStoreIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_dicom_store_iam_binding#role GoogleHealthcareDicomStoreIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_dicom_store_iam_binding#condition GoogleHealthcareDicomStoreIamBinding#condition}
    */
    readonly condition?: GoogleHealthcareDicomStoreIamBindingCondition;
}
export interface GoogleHealthcareDicomStoreIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_dicom_store_iam_binding#description GoogleHealthcareDicomStoreIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_dicom_store_iam_binding#expression GoogleHealthcareDicomStoreIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_dicom_store_iam_binding#title GoogleHealthcareDicomStoreIamBinding#title}
    */
    readonly title: string;
}
export declare function googleHealthcareDicomStoreIamBindingConditionToTerraform(struct?: GoogleHealthcareDicomStoreIamBindingConditionOutputReference | GoogleHealthcareDicomStoreIamBindingCondition): any;
export declare class GoogleHealthcareDicomStoreIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareDicomStoreIamBindingCondition | undefined;
    set internalValue(value: GoogleHealthcareDicomStoreIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_dicom_store_iam_binding google_healthcare_dicom_store_iam_binding}
*/
export declare class GoogleHealthcareDicomStoreIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_dicom_store_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_dicom_store_iam_binding google_healthcare_dicom_store_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareDicomStoreIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareDicomStoreIamBindingConfig);
    private _dicomStoreId?;
    get dicomStoreId(): string;
    set dicomStoreId(value: string);
    get dicomStoreIdInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleHealthcareDicomStoreIamBindingConditionOutputReference;
    putCondition(value: GoogleHealthcareDicomStoreIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleHealthcareDicomStoreIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
