import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareFhirStoreIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_binding#fhir_store_id GoogleHealthcareFhirStoreIamBinding#fhir_store_id}
    */
    readonly fhirStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_binding#id GoogleHealthcareFhirStoreIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_binding#members GoogleHealthcareFhirStoreIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_binding#role GoogleHealthcareFhirStoreIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_binding#condition GoogleHealthcareFhirStoreIamBinding#condition}
    */
    readonly condition?: GoogleHealthcareFhirStoreIamBindingCondition;
}
export interface GoogleHealthcareFhirStoreIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_binding#description GoogleHealthcareFhirStoreIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_binding#expression GoogleHealthcareFhirStoreIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_binding#title GoogleHealthcareFhirStoreIamBinding#title}
    */
    readonly title: string;
}
export declare function googleHealthcareFhirStoreIamBindingConditionToTerraform(struct?: GoogleHealthcareFhirStoreIamBindingConditionOutputReference | GoogleHealthcareFhirStoreIamBindingCondition): any;
export declare class GoogleHealthcareFhirStoreIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareFhirStoreIamBindingCondition | undefined;
    set internalValue(value: GoogleHealthcareFhirStoreIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_binding google_healthcare_fhir_store_iam_binding}
*/
export declare class GoogleHealthcareFhirStoreIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_fhir_store_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_binding google_healthcare_fhir_store_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareFhirStoreIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareFhirStoreIamBindingConfig);
    get etag(): string;
    private _fhirStoreId?;
    get fhirStoreId(): string;
    set fhirStoreId(value: string);
    get fhirStoreIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleHealthcareFhirStoreIamBindingConditionOutputReference;
    putCondition(value: GoogleHealthcareFhirStoreIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleHealthcareFhirStoreIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
