import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareFhirStoreIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_member#fhir_store_id GoogleHealthcareFhirStoreIamMember#fhir_store_id}
    */
    readonly fhirStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_member#id GoogleHealthcareFhirStoreIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_member#member GoogleHealthcareFhirStoreIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_member#role GoogleHealthcareFhirStoreIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_member#condition GoogleHealthcareFhirStoreIamMember#condition}
    */
    readonly condition?: GoogleHealthcareFhirStoreIamMemberCondition;
}
export interface GoogleHealthcareFhirStoreIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_member#description GoogleHealthcareFhirStoreIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_member#expression GoogleHealthcareFhirStoreIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_member#title GoogleHealthcareFhirStoreIamMember#title}
    */
    readonly title: string;
}
export declare function googleHealthcareFhirStoreIamMemberConditionToTerraform(struct?: GoogleHealthcareFhirStoreIamMemberConditionOutputReference | GoogleHealthcareFhirStoreIamMemberCondition): any;
export declare class GoogleHealthcareFhirStoreIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareFhirStoreIamMemberCondition | undefined;
    set internalValue(value: GoogleHealthcareFhirStoreIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_member google_healthcare_fhir_store_iam_member}
*/
export declare class GoogleHealthcareFhirStoreIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_fhir_store_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store_iam_member google_healthcare_fhir_store_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareFhirStoreIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareFhirStoreIamMemberConfig);
    get etag(): string;
    private _fhirStoreId?;
    get fhirStoreId(): string;
    set fhirStoreId(value: string);
    get fhirStoreIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleHealthcareFhirStoreIamMemberConditionOutputReference;
    putCondition(value: GoogleHealthcareFhirStoreIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleHealthcareFhirStoreIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
