"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleHealthcareFhirStore = exports.GoogleHealthcareFhirStoreTimeoutsOutputReference = exports.googleHealthcareFhirStoreTimeoutsToTerraform = exports.GoogleHealthcareFhirStoreStreamConfigsList = exports.GoogleHealthcareFhirStoreStreamConfigsOutputReference = exports.googleHealthcareFhirStoreStreamConfigsToTerraform = exports.GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference = exports.googleHealthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform = exports.GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference = exports.googleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform = exports.GoogleHealthcareFhirStoreNotificationConfigOutputReference = exports.googleHealthcareFhirStoreNotificationConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function googleHealthcareFhirStoreNotificationConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        pubsub_topic: cdktf.stringToTerraform(struct.pubsubTopic),
    };
}
exports.googleHealthcareFhirStoreNotificationConfigToTerraform = googleHealthcareFhirStoreNotificationConfigToTerraform;
class GoogleHealthcareFhirStoreNotificationConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._pubsubTopic !== undefined) {
            hasAnyValues = true;
            internalValueResult.pubsubTopic = this._pubsubTopic;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._pubsubTopic = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._pubsubTopic = value.pubsubTopic;
        }
    }
    get pubsubTopic() {
        return this.getStringAttribute('pubsub_topic');
    }
    set pubsubTopic(value) {
        this._pubsubTopic = value;
    }
    // Temporarily expose input value. Use with caution.
    get pubsubTopicInput() {
        return this._pubsubTopic;
    }
}
exports.GoogleHealthcareFhirStoreNotificationConfigOutputReference = GoogleHealthcareFhirStoreNotificationConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
GoogleHealthcareFhirStoreNotificationConfigOutputReference[_a] = { fqn: "@cdktf/provider-google-beta.googleHealthcareFhirStore.GoogleHealthcareFhirStoreNotificationConfigOutputReference", version: "3.0.1" };
function googleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        recursive_structure_depth: cdktf.numberToTerraform(struct.recursiveStructureDepth),
        schema_type: cdktf.stringToTerraform(struct.schemaType),
    };
}
exports.googleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform = googleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform;
class GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._recursiveStructureDepth !== undefined) {
            hasAnyValues = true;
            internalValueResult.recursiveStructureDepth = this._recursiveStructureDepth;
        }
        if (this._schemaType !== undefined) {
            hasAnyValues = true;
            internalValueResult.schemaType = this._schemaType;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._recursiveStructureDepth = undefined;
            this._schemaType = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._recursiveStructureDepth = value.recursiveStructureDepth;
            this._schemaType = value.schemaType;
        }
    }
    get recursiveStructureDepth() {
        return this.getNumberAttribute('recursive_structure_depth');
    }
    set recursiveStructureDepth(value) {
        this._recursiveStructureDepth = value;
    }
    // Temporarily expose input value. Use with caution.
    get recursiveStructureDepthInput() {
        return this._recursiveStructureDepth;
    }
    get schemaType() {
        return this.getStringAttribute('schema_type');
    }
    set schemaType(value) {
        this._schemaType = value;
    }
    resetSchemaType() {
        this._schemaType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get schemaTypeInput() {
        return this._schemaType;
    }
}
exports.GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference = GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference;
_b = JSII_RTTI_SYMBOL_1;
GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference[_b] = { fqn: "@cdktf/provider-google-beta.googleHealthcareFhirStore.GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference", version: "3.0.1" };
function googleHealthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        dataset_uri: cdktf.stringToTerraform(struct.datasetUri),
        schema_config: googleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform(struct.schemaConfig),
    };
}
exports.googleHealthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform = googleHealthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform;
class GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // schema_config - computed: false, optional: false, required: true
        this._schemaConfig = new GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference(this, "schema_config");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._datasetUri !== undefined) {
            hasAnyValues = true;
            internalValueResult.datasetUri = this._datasetUri;
        }
        if (this._schemaConfig?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.schemaConfig = this._schemaConfig?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._datasetUri = undefined;
            this._schemaConfig.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._datasetUri = value.datasetUri;
            this._schemaConfig.internalValue = value.schemaConfig;
        }
    }
    get datasetUri() {
        return this.getStringAttribute('dataset_uri');
    }
    set datasetUri(value) {
        this._datasetUri = value;
    }
    // Temporarily expose input value. Use with caution.
    get datasetUriInput() {
        return this._datasetUri;
    }
    get schemaConfig() {
        return this._schemaConfig;
    }
    putSchemaConfig(value) {
        this._schemaConfig.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get schemaConfigInput() {
        return this._schemaConfig.internalValue;
    }
}
exports.GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference = GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference;
_c = JSII_RTTI_SYMBOL_1;
GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference[_c] = { fqn: "@cdktf/provider-google-beta.googleHealthcareFhirStore.GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference", version: "3.0.1" };
function googleHealthcareFhirStoreStreamConfigsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        resource_types: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.resourceTypes),
        bigquery_destination: googleHealthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform(struct.bigqueryDestination),
    };
}
exports.googleHealthcareFhirStoreStreamConfigsToTerraform = googleHealthcareFhirStoreStreamConfigsToTerraform;
class GoogleHealthcareFhirStoreStreamConfigsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
        // bigquery_destination - computed: false, optional: false, required: true
        this._bigqueryDestination = new GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference(this, "bigquery_destination");
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._resourceTypes !== undefined) {
            hasAnyValues = true;
            internalValueResult.resourceTypes = this._resourceTypes;
        }
        if (this._bigqueryDestination?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.bigqueryDestination = this._bigqueryDestination?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._resourceTypes = undefined;
            this._bigqueryDestination.internalValue = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._resourceTypes = value.resourceTypes;
            this._bigqueryDestination.internalValue = value.bigqueryDestination;
        }
    }
    get resourceTypes() {
        return this.getListAttribute('resource_types');
    }
    set resourceTypes(value) {
        this._resourceTypes = value;
    }
    resetResourceTypes() {
        this._resourceTypes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceTypesInput() {
        return this._resourceTypes;
    }
    get bigqueryDestination() {
        return this._bigqueryDestination;
    }
    putBigqueryDestination(value) {
        this._bigqueryDestination.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryDestinationInput() {
        return this._bigqueryDestination.internalValue;
    }
}
exports.GoogleHealthcareFhirStoreStreamConfigsOutputReference = GoogleHealthcareFhirStoreStreamConfigsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
GoogleHealthcareFhirStoreStreamConfigsOutputReference[_d] = { fqn: "@cdktf/provider-google-beta.googleHealthcareFhirStore.GoogleHealthcareFhirStoreStreamConfigsOutputReference", version: "3.0.1" };
class GoogleHealthcareFhirStoreStreamConfigsList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new GoogleHealthcareFhirStoreStreamConfigsOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.GoogleHealthcareFhirStoreStreamConfigsList = GoogleHealthcareFhirStoreStreamConfigsList;
_e = JSII_RTTI_SYMBOL_1;
GoogleHealthcareFhirStoreStreamConfigsList[_e] = { fqn: "@cdktf/provider-google-beta.googleHealthcareFhirStore.GoogleHealthcareFhirStoreStreamConfigsList", version: "3.0.1" };
function googleHealthcareFhirStoreTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.googleHealthcareFhirStoreTimeoutsToTerraform = googleHealthcareFhirStoreTimeoutsToTerraform;
class GoogleHealthcareFhirStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.GoogleHealthcareFhirStoreTimeoutsOutputReference = GoogleHealthcareFhirStoreTimeoutsOutputReference;
_f = JSII_RTTI_SYMBOL_1;
GoogleHealthcareFhirStoreTimeoutsOutputReference[_f] = { fqn: "@cdktf/provider-google-beta.googleHealthcareFhirStore.GoogleHealthcareFhirStoreTimeoutsOutputReference", version: "3.0.1" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store google_healthcare_fhir_store}
*/
class GoogleHealthcareFhirStore extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_healthcare_fhir_store google_healthcare_fhir_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareFhirStoreConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_healthcare_fhir_store',
            terraformGeneratorMetadata: {
                providerName: 'google-beta',
                providerVersion: '4.38.0',
                providerVersionConstraint: '~> 4.17'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // notification_config - computed: false, optional: true, required: false
        this._notificationConfig = new GoogleHealthcareFhirStoreNotificationConfigOutputReference(this, "notification_config");
        // stream_configs - computed: false, optional: true, required: false
        this._streamConfigs = new GoogleHealthcareFhirStoreStreamConfigsList(this, "stream_configs", false);
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new GoogleHealthcareFhirStoreTimeoutsOutputReference(this, "timeouts");
        this._dataset = config.dataset;
        this._disableReferentialIntegrity = config.disableReferentialIntegrity;
        this._disableResourceVersioning = config.disableResourceVersioning;
        this._enableHistoryImport = config.enableHistoryImport;
        this._enableUpdateCreate = config.enableUpdateCreate;
        this._id = config.id;
        this._labels = config.labels;
        this._name = config.name;
        this._version = config.version;
        this._notificationConfig.internalValue = config.notificationConfig;
        this._streamConfigs.internalValue = config.streamConfigs;
        this._timeouts.internalValue = config.timeouts;
    }
    get dataset() {
        return this.getStringAttribute('dataset');
    }
    set dataset(value) {
        this._dataset = value;
    }
    // Temporarily expose input value. Use with caution.
    get datasetInput() {
        return this._dataset;
    }
    get disableReferentialIntegrity() {
        return this.getBooleanAttribute('disable_referential_integrity');
    }
    set disableReferentialIntegrity(value) {
        this._disableReferentialIntegrity = value;
    }
    resetDisableReferentialIntegrity() {
        this._disableReferentialIntegrity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableReferentialIntegrityInput() {
        return this._disableReferentialIntegrity;
    }
    get disableResourceVersioning() {
        return this.getBooleanAttribute('disable_resource_versioning');
    }
    set disableResourceVersioning(value) {
        this._disableResourceVersioning = value;
    }
    resetDisableResourceVersioning() {
        this._disableResourceVersioning = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableResourceVersioningInput() {
        return this._disableResourceVersioning;
    }
    get enableHistoryImport() {
        return this.getBooleanAttribute('enable_history_import');
    }
    set enableHistoryImport(value) {
        this._enableHistoryImport = value;
    }
    resetEnableHistoryImport() {
        this._enableHistoryImport = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableHistoryImportInput() {
        return this._enableHistoryImport;
    }
    get enableUpdateCreate() {
        return this.getBooleanAttribute('enable_update_create');
    }
    set enableUpdateCreate(value) {
        this._enableUpdateCreate = value;
    }
    resetEnableUpdateCreate() {
        this._enableUpdateCreate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableUpdateCreateInput() {
        return this._enableUpdateCreate;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // self_link - computed: true, optional: false, required: false
    get selfLink() {
        return this.getStringAttribute('self_link');
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    resetVersion() {
        this._version = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
    get notificationConfig() {
        return this._notificationConfig;
    }
    putNotificationConfig(value) {
        this._notificationConfig.internalValue = value;
    }
    resetNotificationConfig() {
        this._notificationConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notificationConfigInput() {
        return this._notificationConfig.internalValue;
    }
    get streamConfigs() {
        return this._streamConfigs;
    }
    putStreamConfigs(value) {
        this._streamConfigs.internalValue = value;
    }
    resetStreamConfigs() {
        this._streamConfigs.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get streamConfigsInput() {
        return this._streamConfigs.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            dataset: cdktf.stringToTerraform(this._dataset),
            disable_referential_integrity: cdktf.booleanToTerraform(this._disableReferentialIntegrity),
            disable_resource_versioning: cdktf.booleanToTerraform(this._disableResourceVersioning),
            enable_history_import: cdktf.booleanToTerraform(this._enableHistoryImport),
            enable_update_create: cdktf.booleanToTerraform(this._enableUpdateCreate),
            id: cdktf.stringToTerraform(this._id),
            labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._labels),
            name: cdktf.stringToTerraform(this._name),
            version: cdktf.stringToTerraform(this._version),
            notification_config: googleHealthcareFhirStoreNotificationConfigToTerraform(this._notificationConfig.internalValue),
            stream_configs: cdktf.listMapper(googleHealthcareFhirStoreStreamConfigsToTerraform, true)(this._streamConfigs.internalValue),
            timeouts: googleHealthcareFhirStoreTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.GoogleHealthcareFhirStore = GoogleHealthcareFhirStore;
_g = JSII_RTTI_SYMBOL_1;
GoogleHealthcareFhirStore[_g] = { fqn: "@cdktf/provider-google-beta.googleHealthcareFhirStore.GoogleHealthcareFhirStore", version: "3.0.1" };
// =================
// STATIC PROPERTIES
// =================
GoogleHealthcareFhirStore.tfResourceType = "google_healthcare_fhir_store";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZ29vZ2xlLWhlYWx0aGNhcmUtZmhpci1zdG9yZS9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUlBLCtCQUErQjtBQW1JL0IsU0FBZ0Isc0RBQXNELENBQUMsTUFBaUg7SUFDdEwsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxXQUFXLENBQUM7S0FDM0QsQ0FBQTtBQUNILENBQUM7QUFSRCx3SEFRQztBQUVELE1BQWEsMERBQTJELFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHakc7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLFlBQVksS0FBSyxTQUFTLEVBQUU7WUFDbkMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztTQUNyRDtRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUE4RDtRQUNyRixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7U0FDL0I7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztTQUN2QztJQUNILENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQzs7QUEzQ0gsZ0lBNENDOzs7QUF1QkQsU0FBZ0IsZ0ZBQWdGLENBQUMsTUFBcUs7SUFDcFEsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCx5QkFBeUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLHVCQUF1QixDQUFDO1FBQ25GLFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFVBQVUsQ0FBQztLQUN6RCxDQUFBO0FBQ0gsQ0FBQztBQVRELDRLQVNDO0FBRUQsTUFBYSxvRkFBcUYsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUczSDs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVBqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVE5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsd0JBQXdCLEtBQUssU0FBUyxFQUFFO1lBQy9DLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsdUJBQXVCLEdBQUcsSUFBSSxDQUFDLHdCQUF3QixDQUFDO1NBQzdFO1FBQ0QsSUFBSSxJQUFJLENBQUMsV0FBVyxLQUFLLFNBQVMsRUFBRTtZQUNsQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1NBQ25EO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQXdGO1FBQy9HLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsd0JBQXdCLEdBQUcsU0FBUyxDQUFDO1lBQzFDLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO1NBQzlCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDLHVCQUF1QixDQUFDO1lBQzlELElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztTQUNyQztJQUNILENBQUM7SUFJRCxJQUFXLHVCQUF1QjtRQUNoQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlELENBQUM7SUFDRCxJQUFXLHVCQUF1QixDQUFDLEtBQWE7UUFDOUMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQztJQUN4QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsNEJBQTRCO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLHdCQUF3QixDQUFDO0lBQ3ZDLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQWE7UUFDakMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUNNLGVBQWU7UUFDcEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxTQUFTLENBQUM7SUFDL0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7O0FBakVILG9MQWtFQzs7O0FBZ0JELFNBQWdCLG9FQUFvRSxDQUFDLE1BQTZJO0lBQ2hPLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsVUFBVSxDQUFDO1FBQ3hELGFBQWEsRUFBRSxnRkFBZ0YsQ0FBQyxNQUFPLENBQUMsWUFBWSxDQUFDO0tBQ3RILENBQUE7QUFDSCxDQUFDO0FBVEQsb0pBU0M7QUFFRCxNQUFhLHdFQUF5RSxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBRy9HOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO1FBa0Q5QixtRUFBbUU7UUFDM0Qsa0JBQWEsR0FBRyxJQUFJLG9GQUFvRixDQUFDLElBQUksRUFBRSxlQUFlLENBQUMsQ0FBQztJQTNDeEksQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLFdBQVcsS0FBSyxTQUFTLEVBQUU7WUFDbEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQztTQUNuRDtRQUNELElBQUksSUFBSSxDQUFDLGFBQWEsRUFBRSxhQUFhLEtBQUssU0FBUyxFQUFFO1lBQ25ELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLEVBQUUsYUFBYSxDQUFDO1NBQ3RFO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQTRFO1FBQ25HLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztZQUM3QixJQUFJLENBQUMsYUFBYSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7U0FDOUM7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztZQUNwQyxJQUFJLENBQUMsYUFBYSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1NBQ3ZEO0lBQ0gsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBYTtRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUNNLGVBQWUsQ0FBQyxLQUE0RTtRQUNqRyxJQUFJLENBQUMsYUFBYSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDO0lBQzFDLENBQUM7O0FBOURILDRKQStEQzs7O0FBa0JELFNBQWdCLGlEQUFpRCxDQUFDLE1BQW1FO0lBQ25JLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsY0FBYyxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxDQUFDLE1BQU8sQ0FBQyxhQUFhLENBQUM7UUFDdkYsb0JBQW9CLEVBQUUsb0VBQW9FLENBQUMsTUFBTyxDQUFDLG1CQUFtQixDQUFDO0tBQ3hILENBQUE7QUFDSCxDQUFDO0FBVEQsOEdBU0M7QUFFRCxNQUFhLHFEQUFzRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBSTVGOzs7OztNQUtFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCLEVBQUUsa0JBQTBCLEVBQUUsc0JBQStCO1FBQ3ZKLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxzQkFBc0IsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBVm5GLGtCQUFhLEdBQUcsS0FBSyxDQUFDO1FBaUU5QiwwRUFBMEU7UUFDbEUseUJBQW9CLEdBQUcsSUFBSSx3RUFBd0UsQ0FBQyxJQUFJLEVBQUUsc0JBQXNCLENBQUMsQ0FBQztJQXZEMUksQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLElBQUksQ0FBQyxlQUFlLEVBQUU7WUFDeEIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO1NBQzdCO1FBQ0QsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxjQUFjLEtBQUssU0FBUyxFQUFFO1lBQ3JDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUM7U0FDekQ7UUFDRCxJQUFJLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxhQUFhLEtBQUssU0FBUyxFQUFFO1lBQzFELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFDLG9CQUFvQixFQUFFLGFBQWEsQ0FBQztTQUNwRjtRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUE2RTtRQUNwRyxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7WUFDakMsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7WUFDaEMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7U0FDckQ7YUFDSSxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQy9DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO1NBQzlCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztZQUNqQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7WUFDMUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsbUJBQW1CLENBQUM7U0FDckU7SUFDSCxDQUFDO0lBSUQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsYUFBYSxDQUFDLEtBQWU7UUFDdEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7SUFDOUIsQ0FBQztJQUNNLGtCQUFrQjtRQUN2QixJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztJQUNsQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBSUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUNNLHNCQUFzQixDQUFDLEtBQWdFO1FBQzVGLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ2xELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx3QkFBd0I7UUFDakMsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUMsYUFBYSxDQUFDO0lBQ2pELENBQUM7O0FBN0VILHNIQThFQzs7O0FBRUQsTUFBYSwwQ0FBMkMsU0FBUSxLQUFLLENBQUMsV0FBVztJQUcvRTs7OztNQUlFO0lBQ0YsWUFBc0IsaUJBQTZDLEVBQVksa0JBQTBCLEVBQVksUUFBaUI7UUFDcEksS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxDQUFBO1FBRGxDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBNEI7UUFBWSx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7UUFBWSxhQUFRLEdBQVIsUUFBUSxDQUFTO0lBRXRJLENBQUM7SUFFRDs7TUFFRTtJQUNLLEdBQUcsQ0FBQyxLQUFhO1FBQ3RCLE9BQU8sSUFBSSxxREFBcUQsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDMUksQ0FBQzs7QUFqQkgsZ0dBa0JDOzs7QUFnQkQsU0FBZ0IsNENBQTRDLENBQUMsTUFBaUg7SUFDNUssSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxNQUFNLENBQUM7UUFDL0MsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO1FBQy9DLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztLQUNoRCxDQUFBO0FBQ0gsQ0FBQztBQVZELG9HQVVDO0FBRUQsTUFBYSxnREFBaUQsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUl2Rjs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVJqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVM5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksSUFBSSxDQUFDLGVBQWUsRUFBRTtZQUN4QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDN0I7UUFDRCxJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUF3RTtRQUMvRixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7WUFDakMsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7U0FDMUI7YUFDSSxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQy9DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO1NBQzlCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztZQUNqQyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7WUFDNUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQzVCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztTQUM3QjtJQUNILENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7O0FBcEdILDRHQXFHQzs7O0FBRUQ7O0VBRUU7QUFDRixNQUFhLHlCQUEwQixTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPcEUsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQ7Ozs7OztNQU1FO0lBQ0YsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBdUM7UUFDdEYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSw4QkFBOEI7WUFDckQsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxhQUFhO2dCQUMzQixlQUFlLEVBQUUsUUFBUTtnQkFDekIseUJBQXlCLEVBQUUsU0FBUzthQUNyQztZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixZQUFZLEVBQUUsTUFBTSxDQUFDLFlBQVk7WUFDakMsVUFBVSxFQUFFLE1BQU0sQ0FBQyxVQUFVO1lBQzdCLE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTztTQUN4QixDQUFDLENBQUM7UUFrS0wseUVBQXlFO1FBQ2pFLHdCQUFtQixHQUFHLElBQUksMERBQTBELENBQUMsSUFBSSxFQUFFLHFCQUFxQixDQUFDLENBQUM7UUFlMUgsb0VBQW9FO1FBQzVELG1CQUFjLEdBQUcsSUFBSSwwQ0FBMEMsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFldkcsOERBQThEO1FBQ3RELGNBQVMsR0FBRyxJQUFJLGdEQUFnRCxDQUFDLElBQUksRUFBRSxVQUFVLENBQUMsQ0FBQztRQWxNekYsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO1FBQy9CLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxNQUFNLENBQUMsMkJBQTJCLENBQUM7UUFDdkUsSUFBSSxDQUFDLDBCQUEwQixHQUFHLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQztRQUNuRSxJQUFJLENBQUMsb0JBQW9CLEdBQUcsTUFBTSxDQUFDLG1CQUFtQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLEdBQUcsR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDO1FBQ3JCLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO1FBQy9CLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ25FLElBQUksQ0FBQyxjQUFjLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUM7UUFDekQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQztJQUNqRCxDQUFDO0lBUUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFDRCxJQUFXLE9BQU8sQ0FBQyxLQUFhO1FBQzlCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDO0lBQ3hCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBSUQsSUFBVywyQkFBMkI7UUFDcEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsK0JBQStCLENBQUMsQ0FBQztJQUNuRSxDQUFDO0lBQ0QsSUFBVywyQkFBMkIsQ0FBQyxLQUFrQztRQUN2RSxJQUFJLENBQUMsNEJBQTRCLEdBQUcsS0FBSyxDQUFDO0lBQzVDLENBQUM7SUFDTSxnQ0FBZ0M7UUFDckMsSUFBSSxDQUFDLDRCQUE0QixHQUFHLFNBQVMsQ0FBQztJQUNoRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0NBQWdDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLDRCQUE0QixDQUFDO0lBQzNDLENBQUM7SUFJRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0lBQ2pFLENBQUM7SUFDRCxJQUFXLHlCQUF5QixDQUFDLEtBQWtDO1FBQ3JFLElBQUksQ0FBQywwQkFBMEIsR0FBRyxLQUFLLENBQUM7SUFDMUMsQ0FBQztJQUNNLDhCQUE4QjtRQUNuQyxJQUFJLENBQUMsMEJBQTBCLEdBQUcsU0FBUyxDQUFDO0lBQzlDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyw4QkFBOEI7UUFDdkMsT0FBTyxJQUFJLENBQUMsMEJBQTBCLENBQUM7SUFDekMsQ0FBQztJQUlELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUNELElBQVcsbUJBQW1CLENBQUMsS0FBa0M7UUFDL0QsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBQ00sd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxTQUFTLENBQUM7SUFDeEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDO0lBSUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUFrQztRQUM5RCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFDTSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLG1CQUFtQixHQUFHLFNBQVMsQ0FBQztJQUN2QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFJRCxJQUFXLEVBQUU7UUFDWCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBQ0QsSUFBVyxFQUFFLENBQUMsS0FBYTtRQUN6QixJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQztJQUNuQixDQUFDO0lBQ00sT0FBTztRQUNaLElBQUksQ0FBQyxHQUFHLEdBQUcsU0FBUyxDQUFDO0lBQ3ZCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQztJQUNsQixDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWdDO1FBQ2hELElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFFRCwrREFBK0Q7SUFDL0QsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUNELElBQVcsT0FBTyxDQUFDLEtBQWE7UUFDOUIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBQ00scUJBQXFCLENBQUMsS0FBa0Q7UUFDN0UsSUFBSSxDQUFDLG1CQUFtQixDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDakQsQ0FBQztJQUNNLHVCQUF1QjtRQUM1QixJQUFJLENBQUMsbUJBQW1CLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUNyRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGFBQWEsQ0FBQztJQUNoRCxDQUFDO0lBSUQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBQ00sZ0JBQWdCLENBQUMsS0FBbUU7UUFDekYsSUFBSSxDQUFDLGNBQWMsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzVDLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2hELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDLGFBQWEsQ0FBQztJQUMzQyxDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBQ00sV0FBVyxDQUFDLEtBQXdDO1FBQ3pELElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztJQUN0QyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxPQUFPLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDL0MsNkJBQTZCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztZQUMxRiwyQkFBMkIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLDBCQUEwQixDQUFDO1lBQ3RGLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUM7WUFDMUUsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztZQUN4RSxFQUFFLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7WUFDckMsTUFBTSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztZQUMvRCxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDekMsT0FBTyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQy9DLG1CQUFtQixFQUFFLHNEQUFzRCxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxhQUFhLENBQUM7WUFDbkgsY0FBYyxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsaURBQWlELEVBQUUsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxhQUFhLENBQUM7WUFDNUgsUUFBUSxFQUFFLDRDQUE0QyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDO1NBQ3JGLENBQUM7SUFDSixDQUFDOztBQXRRSCw4REF1UUM7OztBQXJRQyxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNHLHdDQUFjLEdBQUcsOEJBQThCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZUNvbmZpZyBleHRlbmRzIGNka3RmLlRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICAvKipcbiAgKiBJZGVudGlmaWVzIHRoZSBkYXRhc2V0IGFkZHJlc3NlZCBieSB0aGlzIHJlcXVlc3QuIE11c3QgYmUgaW4gdGhlIGZvcm1hdFxuJ3Byb2plY3RzL3twcm9qZWN0fS9sb2NhdGlvbnMve2xvY2F0aW9ufS9kYXRhc2V0cy97ZGF0YXNldH0nXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlI2RhdGFzZXQgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSNkYXRhc2V0fVxuICAqL1xuICByZWFkb25seSBkYXRhc2V0OiBzdHJpbmc7XG4gIC8qKlxuICAqIFdoZXRoZXIgdG8gZGlzYWJsZSByZWZlcmVudGlhbCBpbnRlZ3JpdHkgaW4gdGhpcyBGSElSIHN0b3JlLiBUaGlzIGZpZWxkIGlzIGltbXV0YWJsZSBhZnRlciBGSElSIHN0b3JlXG5jcmVhdGlvbi4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgZmFsc2UsIG1lYW5pbmcgdGhhdCB0aGUgQVBJIHdpbGwgZW5mb3JjZSByZWZlcmVudGlhbCBpbnRlZ3JpdHkgYW5kIGZhaWwgdGhlXG5yZXF1ZXN0cyB0aGF0IHdpbGwgcmVzdWx0IGluIGluY29uc2lzdGVudCBzdGF0ZSBpbiB0aGUgRkhJUiBzdG9yZS4gV2hlbiB0aGlzIGZpZWxkIGlzIHNldCB0byB0cnVlLCB0aGUgQVBJXG53aWxsIHNraXAgcmVmZXJlbnRpYWwgaW50ZWdyaXR5IGNoZWNrLiBDb25zZXF1ZW50bHksIG9wZXJhdGlvbnMgdGhhdCByZWx5IG9uIHJlZmVyZW5jZXMsIHN1Y2ggYXNcblBhdGllbnQuZ2V0JGV2ZXJ5dGhpbmcsIHdpbGwgbm90IHJldHVybiBhbGwgdGhlIHJlc3VsdHMgaWYgYnJva2VuIHJlZmVyZW5jZXMgZXhpc3QuXG5cbioqIENoYW5naW5nIHRoaXMgcHJvcGVydHkgbWF5IHJlY3JlYXRlIHRoZSBGSElSIHN0b3JlIChyZW1vdmluZyBhbGwgZGF0YSkgKipcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9oZWFsdGhjYXJlX2ZoaXJfc3RvcmUjZGlzYWJsZV9yZWZlcmVudGlhbF9pbnRlZ3JpdHkgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSNkaXNhYmxlX3JlZmVyZW50aWFsX2ludGVncml0eX1cbiAgKi9cbiAgcmVhZG9ubHkgZGlzYWJsZVJlZmVyZW50aWFsSW50ZWdyaXR5PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBXaGV0aGVyIHRvIGRpc2FibGUgcmVzb3VyY2UgdmVyc2lvbmluZyBmb3IgdGhpcyBGSElSIHN0b3JlLiBUaGlzIGZpZWxkIGNhbiBub3QgYmUgY2hhbmdlZCBhZnRlciB0aGUgY3JlYXRpb25cbm9mIEZISVIgc3RvcmUuIElmIHNldCB0byBmYWxzZSwgd2hpY2ggaXMgdGhlIGRlZmF1bHQgYmVoYXZpb3IsIGFsbCB3cml0ZSBvcGVyYXRpb25zIHdpbGwgY2F1c2UgaGlzdG9yaWNhbFxudmVyc2lvbnMgdG8gYmUgcmVjb3JkZWQgYXV0b21hdGljYWxseS4gVGhlIGhpc3RvcmljYWwgdmVyc2lvbnMgY2FuIGJlIGZldGNoZWQgdGhyb3VnaCB0aGUgaGlzdG9yeSBBUElzLCBidXRcbmNhbm5vdCBiZSB1cGRhdGVkLiBJZiBzZXQgdG8gdHJ1ZSwgbm8gaGlzdG9yaWNhbCB2ZXJzaW9ucyB3aWxsIGJlIGtlcHQuIFRoZSBzZXJ2ZXIgd2lsbCBzZW5kIGJhY2sgZXJyb3JzIGZvclxuYXR0ZW1wdHMgdG8gcmVhZCB0aGUgaGlzdG9yaWNhbCB2ZXJzaW9ucy5cblxuKiogQ2hhbmdpbmcgdGhpcyBwcm9wZXJ0eSBtYXkgcmVjcmVhdGUgdGhlIEZISVIgc3RvcmUgKHJlbW92aW5nIGFsbCBkYXRhKSAqKlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZSNkaXNhYmxlX3Jlc291cmNlX3ZlcnNpb25pbmcgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSNkaXNhYmxlX3Jlc291cmNlX3ZlcnNpb25pbmd9XG4gICovXG4gIHJlYWRvbmx5IGRpc2FibGVSZXNvdXJjZVZlcnNpb25pbmc/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFdoZXRoZXIgdG8gYWxsb3cgdGhlIGJ1bGsgaW1wb3J0IEFQSSB0byBhY2NlcHQgaGlzdG9yeSBidW5kbGVzIGFuZCBkaXJlY3RseSBpbnNlcnQgaGlzdG9yaWNhbCByZXNvdXJjZVxudmVyc2lvbnMgaW50byB0aGUgRkhJUiBzdG9yZS4gSW1wb3J0aW5nIHJlc291cmNlIGhpc3RvcmllcyBjcmVhdGVzIHJlc291cmNlIGludGVyYWN0aW9ucyB0aGF0IGFwcGVhciB0byBoYXZlXG5vY2N1cnJlZCBpbiB0aGUgcGFzdCwgd2hpY2ggY2xpZW50cyBtYXkgbm90IHdhbnQgdG8gYWxsb3cuIElmIHNldCB0byBmYWxzZSwgaGlzdG9yeSBidW5kbGVzIHdpdGhpbiBhbiBpbXBvcnRcbndpbGwgZmFpbCB3aXRoIGFuIGVycm9yLlxuXG4qKiBDaGFuZ2luZyB0aGlzIHByb3BlcnR5IG1heSByZWNyZWF0ZSB0aGUgRkhJUiBzdG9yZSAocmVtb3ZpbmcgYWxsIGRhdGEpICoqXG5cbioqIFRoaXMgcHJvcGVydHkgY2FuIGJlIGNoYW5nZWQgbWFudWFsbHkgaW4gdGhlIEdvb2dsZSBDbG91ZCBIZWFsdGhjYXJlIGFkbWluIGNvbnNvbGUgd2l0aG91dCByZWNyZWF0aW5nIHRoZSBGSElSIHN0b3JlICoqXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlI2VuYWJsZV9oaXN0b3J5X2ltcG9ydCBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlI2VuYWJsZV9oaXN0b3J5X2ltcG9ydH1cbiAgKi9cbiAgcmVhZG9ubHkgZW5hYmxlSGlzdG9yeUltcG9ydD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogV2hldGhlciB0aGlzIEZISVIgc3RvcmUgaGFzIHRoZSB1cGRhdGVDcmVhdGUgY2FwYWJpbGl0eS4gVGhpcyBkZXRlcm1pbmVzIGlmIHRoZSBjbGllbnQgY2FuIHVzZSBhbiBVcGRhdGVcbm9wZXJhdGlvbiB0byBjcmVhdGUgYSBuZXcgcmVzb3VyY2Ugd2l0aCBhIGNsaWVudC1zcGVjaWZpZWQgSUQuIElmIGZhbHNlLCBhbGwgSURzIGFyZSBzZXJ2ZXItYXNzaWduZWQgdGhyb3VnaFxudGhlIENyZWF0ZSBvcGVyYXRpb24gYW5kIGF0dGVtcHRzIHRvIFVwZGF0ZSBhIG5vbi1leGlzdGVudCByZXNvdXJjZSB3aWxsIHJldHVybiBlcnJvcnMuIFBsZWFzZSB0cmVhdCB0aGUgYXVkaXRcbmxvZ3Mgd2l0aCBhcHByb3ByaWF0ZSBsZXZlbHMgb2YgY2FyZSBpZiBjbGllbnQtc3BlY2lmaWVkIHJlc291cmNlIElEcyBjb250YWluIHNlbnNpdGl2ZSBkYXRhIHN1Y2ggYXMgcGF0aWVudFxuaWRlbnRpZmllcnMsIHRob3NlIElEcyB3aWxsIGJlIHBhcnQgb2YgdGhlIEZISVIgcmVzb3VyY2UgcGF0aCByZWNvcmRlZCBpbiBDbG91ZCBhdWRpdCBsb2dzIGFuZCBDbG91ZCBQdWIvU3ViXG5ub3RpZmljYXRpb25zLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZSNlbmFibGVfdXBkYXRlX2NyZWF0ZSBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlI2VuYWJsZV91cGRhdGVfY3JlYXRlfVxuICAqL1xuICByZWFkb25seSBlbmFibGVVcGRhdGVDcmVhdGU/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZSNpZCBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlI2lkfVxuICAqXG4gICogUGxlYXNlIGJlIGF3YXJlIHRoYXQgdGhlIGlkIGZpZWxkIGlzIGF1dG9tYXRpY2FsbHkgYWRkZWQgdG8gYWxsIHJlc291cmNlcyBpbiBUZXJyYWZvcm0gcHJvdmlkZXJzIHVzaW5nIGEgVGVycmFmb3JtIHByb3ZpZGVyIFNESyB2ZXJzaW9uIGJlbG93IDIuXG4gICogSWYgeW91IGV4cGVyaWVuY2UgcHJvYmxlbXMgc2V0dGluZyB0aGlzIHZhbHVlIGl0IG1pZ2h0IG5vdCBiZSBzZXR0YWJsZS4gUGxlYXNlIHRha2UgYSBsb29rIGF0IHRoZSBwcm92aWRlciBkb2N1bWVudGF0aW9uIHRvIGVuc3VyZSBpdCBzaG91bGQgYmUgc2V0dGFibGUuXG4gICovXG4gIHJlYWRvbmx5IGlkPzogc3RyaW5nO1xuICAvKipcbiAgKiBVc2VyLXN1cHBsaWVkIGtleS12YWx1ZSBwYWlycyB1c2VkIHRvIG9yZ2FuaXplIEZISVIgc3RvcmVzLlxuXG5MYWJlbCBrZXlzIG11c3QgYmUgYmV0d2VlbiAxIGFuZCA2MyBjaGFyYWN0ZXJzIGxvbmcsIGhhdmUgYSBVVEYtOCBlbmNvZGluZyBvZiBtYXhpbXVtIDEyOCBieXRlcywgYW5kIG11c3RcbmNvbmZvcm0gdG8gdGhlIGZvbGxvd2luZyBQQ1JFIHJlZ3VsYXIgZXhwcmVzc2lvbjogW1xccHtMbH1cXHB7TG99XVtcXHB7TGx9XFxwe0xvfVxccHtOfV8tXXswLDYyfVxuXG5MYWJlbCB2YWx1ZXMgYXJlIG9wdGlvbmFsLCBtdXN0IGJlIGJldHdlZW4gMSBhbmQgNjMgY2hhcmFjdGVycyBsb25nLCBoYXZlIGEgVVRGLTggZW5jb2Rpbmcgb2YgbWF4aW11bSAxMjhcbmJ5dGVzLCBhbmQgbXVzdCBjb25mb3JtIHRvIHRoZSBmb2xsb3dpbmcgUENSRSByZWd1bGFyIGV4cHJlc3Npb246IFtcXHB7TGx9XFxwe0xvfVxccHtOfV8tXXswLDYzfVxuXG5ObyBtb3JlIHRoYW4gNjQgbGFiZWxzIGNhbiBiZSBhc3NvY2lhdGVkIHdpdGggYSBnaXZlbiBzdG9yZS5cblxuQW4gb2JqZWN0IGNvbnRhaW5pbmcgYSBsaXN0IG9mIFwia2V5XCI6IHZhbHVlIHBhaXJzLlxuRXhhbXBsZTogeyBcIm5hbWVcIjogXCJ3cmVuY2hcIiwgXCJtYXNzXCI6IFwiMS4za2dcIiwgXCJjb3VudFwiOiBcIjNcIiB9LlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZSNsYWJlbHMgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSNsYWJlbHN9XG4gICovXG4gIHJlYWRvbmx5IGxhYmVscz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG4gIC8qKlxuICAqIFRoZSByZXNvdXJjZSBuYW1lIGZvciB0aGUgRmhpclN0b3JlLlxuXG4qKiBDaGFuZ2luZyB0aGlzIHByb3BlcnR5IG1heSByZWNyZWF0ZSB0aGUgRkhJUiBzdG9yZSAocmVtb3ZpbmcgYWxsIGRhdGEpICoqXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlI25hbWUgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSNuYW1lfVxuICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBGSElSIHNwZWNpZmljYXRpb24gdmVyc2lvbi4gRGVmYXVsdCB2YWx1ZTogXCJTVFUzXCIgUG9zc2libGUgdmFsdWVzOiBbXCJEU1RVMlwiLCBcIlNUVTNcIiwgXCJSNFwiXVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZSN2ZXJzaW9uIEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmUjdmVyc2lvbn1cbiAgKi9cbiAgcmVhZG9ubHkgdmVyc2lvbj86IHN0cmluZztcbiAgLyoqXG4gICogbm90aWZpY2F0aW9uX2NvbmZpZyBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZSNub3RpZmljYXRpb25fY29uZmlnIEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmUjbm90aWZpY2F0aW9uX2NvbmZpZ31cbiAgKi9cbiAgcmVhZG9ubHkgbm90aWZpY2F0aW9uQ29uZmlnPzogR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZU5vdGlmaWNhdGlvbkNvbmZpZztcbiAgLyoqXG4gICogc3RyZWFtX2NvbmZpZ3MgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9oZWFsdGhjYXJlX2ZoaXJfc3RvcmUjc3RyZWFtX2NvbmZpZ3MgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSNzdHJlYW1fY29uZmlnc31cbiAgKi9cbiAgcmVhZG9ubHkgc3RyZWFtQ29uZmlncz86IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVTdHJlYW1Db25maWdzW10gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogdGltZW91dHMgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9oZWFsdGhjYXJlX2ZoaXJfc3RvcmUjdGltZW91dHMgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSN0aW1lb3V0c31cbiAgKi9cbiAgcmVhZG9ubHkgdGltZW91dHM/OiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlVGltZW91dHM7XG59XG5leHBvcnQgaW50ZXJmYWNlIEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVOb3RpZmljYXRpb25Db25maWcge1xuICAvKipcbiAgKiBUaGUgQ2xvdWQgUHViL1N1YiB0b3BpYyB0aGF0IG5vdGlmaWNhdGlvbnMgb2YgY2hhbmdlcyBhcmUgcHVibGlzaGVkIG9uLiBTdXBwbGllZCBieSB0aGUgY2xpZW50LlxuUHVic3ViTWVzc2FnZS5EYXRhIHdpbGwgY29udGFpbiB0aGUgcmVzb3VyY2UgbmFtZS4gUHVic3ViTWVzc2FnZS5NZXNzYWdlSWQgaXMgdGhlIElEIG9mIHRoaXMgbWVzc2FnZS5cbkl0IGlzIGd1YXJhbnRlZWQgdG8gYmUgdW5pcXVlIHdpdGhpbiB0aGUgdG9waWMuIFB1YnN1Yk1lc3NhZ2UuUHVibGlzaFRpbWUgaXMgdGhlIHRpbWUgYXQgd2hpY2ggdGhlIG1lc3NhZ2VcbndhcyBwdWJsaXNoZWQuIE5vdGlmaWNhdGlvbnMgYXJlIG9ubHkgc2VudCBpZiB0aGUgdG9waWMgaXMgbm9uLWVtcHR5LiBUb3BpYyBuYW1lcyBtdXN0IGJlIHNjb3BlZCB0byBhXG5wcm9qZWN0LiBzZXJ2aWNlLVBST0pFQ1RfTlVNQkVSQGdjcC1zYS1oZWFsdGhjYXJlLmlhbS5nc2VydmljZWFjY291bnQuY29tIG11c3QgaGF2ZSBwdWJsaXNoZXIgcGVybWlzc2lvbnMgb24gdGhlIGdpdmVuXG5DbG91ZCBQdWIvU3ViIHRvcGljLiBOb3QgaGF2aW5nIGFkZXF1YXRlIHBlcm1pc3Npb25zIHdpbGwgY2F1c2UgdGhlIGNhbGxzIHRoYXQgc2VuZCBub3RpZmljYXRpb25zIHRvIGZhaWwuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlI3B1YnN1Yl90b3BpYyBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlI3B1YnN1Yl90b3BpY31cbiAgKi9cbiAgcmVhZG9ubHkgcHVic3ViVG9waWM6IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVOb3RpZmljYXRpb25Db25maWdUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlTm90aWZpY2F0aW9uQ29uZmlnT3V0cHV0UmVmZXJlbmNlIHwgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZU5vdGlmaWNhdGlvbkNvbmZpZyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBwdWJzdWJfdG9waWM6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucHVic3ViVG9waWMpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlTm90aWZpY2F0aW9uQ29uZmlnT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlTm90aWZpY2F0aW9uQ29uZmlnIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9wdWJzdWJUb3BpYyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wdWJzdWJUb3BpYyA9IHRoaXMuX3B1YnN1YlRvcGljO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZU5vdGlmaWNhdGlvbkNvbmZpZyB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX3B1YnN1YlRvcGljID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9wdWJzdWJUb3BpYyA9IHZhbHVlLnB1YnN1YlRvcGljO1xuICAgIH1cbiAgfVxuXG4gIC8vIHB1YnN1Yl90b3BpYyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9wdWJzdWJUb3BpYz86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcHVic3ViVG9waWMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdwdWJzdWJfdG9waWMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHB1YnN1YlRvcGljKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9wdWJzdWJUb3BpYyA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwdWJzdWJUb3BpY0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wdWJzdWJUb3BpYztcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc0JpZ3F1ZXJ5RGVzdGluYXRpb25TY2hlbWFDb25maWcge1xuICAvKipcbiAgKiBUaGUgZGVwdGggZm9yIGFsbCByZWN1cnNpdmUgc3RydWN0dXJlcyBpbiB0aGUgb3V0cHV0IGFuYWx5dGljcyBzY2hlbWEuIEZvciBleGFtcGxlLCBjb25jZXB0IGluIHRoZSBDb2RlU3lzdGVtXG5yZXNvdXJjZSBpcyBhIHJlY3Vyc2l2ZSBzdHJ1Y3R1cmU7IHdoZW4gdGhlIGRlcHRoIGlzIDIsIHRoZSBDb2RlU3lzdGVtIHRhYmxlIHdpbGwgaGF2ZSBhIGNvbHVtbiBjYWxsZWRcbmNvbmNlcHQuY29uY2VwdCBidXQgbm90IGNvbmNlcHQuY29uY2VwdC5jb25jZXB0LiBJZiBub3Qgc3BlY2lmaWVkIG9yIHNldCB0byAwLCB0aGUgc2VydmVyIHdpbGwgdXNlIHRoZSBkZWZhdWx0XG52YWx1ZSAyLiBUaGUgbWF4aW11bSBkZXB0aCBhbGxvd2VkIGlzIDUuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlI3JlY3Vyc2l2ZV9zdHJ1Y3R1cmVfZGVwdGggR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSNyZWN1cnNpdmVfc3RydWN0dXJlX2RlcHRofVxuICAqL1xuICByZWFkb25seSByZWN1cnNpdmVTdHJ1Y3R1cmVEZXB0aDogbnVtYmVyO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIG91dHB1dCBzY2hlbWEgdHlwZS5cbiAqIEFOQUxZVElDUzogQW5hbHl0aWNzIHNjaGVtYSBkZWZpbmVkIGJ5IHRoZSBGSElSIGNvbW11bml0eS5cbiAgU2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9GSElSL3NxbC1vbi1maGlyL2Jsb2IvbWFzdGVyL3NxbC1vbi1maGlyLm1kLlxuICogQU5BTFlUSUNTX1YyOiBBbmFseXRpY3MgVjIsIHNpbWlsYXIgdG8gc2NoZW1hIGRlZmluZWQgYnkgdGhlIEZISVIgY29tbXVuaXR5LCB3aXRoIGFkZGVkIHN1cHBvcnQgZm9yIGV4dGVuc2lvbnMgd2l0aCBvbmUgb3IgbW9yZSBvY2N1cnJlbmNlcyBhbmQgY29udGFpbmVkIHJlc291cmNlcyBpbiBzdHJpbmdpZmllZCBKU09OLlxuICogTE9TU0xFU1M6IEEgZGF0YS1kcml2ZW4gc2NoZW1hIGdlbmVyYXRlZCBmcm9tIHRoZSBmaWVsZHMgcHJlc2VudCBpbiB0aGUgRkhJUiBkYXRhIGJlaW5nIGV4cG9ydGVkLCB3aXRoIG5vIGFkZGl0aW9uYWwgc2ltcGxpZmljYXRpb24uIERlZmF1bHQgdmFsdWU6IFwiQU5BTFlUSUNTXCIgUG9zc2libGUgdmFsdWVzOiBbXCJBTkFMWVRJQ1NcIiwgXCJBTkFMWVRJQ1NfVjJcIiwgXCJMT1NTTEVTU1wiXVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZSNzY2hlbWFfdHlwZSBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlI3NjaGVtYV90eXBlfVxuICAqL1xuICByZWFkb25seSBzY2hlbWFUeXBlPzogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZ29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NCaWdxdWVyeURlc3RpbmF0aW9uU2NoZW1hQ29uZmlnVG9UZXJyYWZvcm0oc3RydWN0PzogR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NCaWdxdWVyeURlc3RpbmF0aW9uU2NoZW1hQ29uZmlnT3V0cHV0UmVmZXJlbmNlIHwgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NCaWdxdWVyeURlc3RpbmF0aW9uU2NoZW1hQ29uZmlnKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIHJlY3Vyc2l2ZV9zdHJ1Y3R1cmVfZGVwdGg6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEucmVjdXJzaXZlU3RydWN0dXJlRGVwdGgpLFxuICAgIHNjaGVtYV90eXBlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnNjaGVtYVR5cGUpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc0JpZ3F1ZXJ5RGVzdGluYXRpb25TY2hlbWFDb25maWdPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVTdHJlYW1Db25maWdzQmlncXVlcnlEZXN0aW5hdGlvblNjaGVtYUNvbmZpZyB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fcmVjdXJzaXZlU3RydWN0dXJlRGVwdGggIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucmVjdXJzaXZlU3RydWN0dXJlRGVwdGggPSB0aGlzLl9yZWN1cnNpdmVTdHJ1Y3R1cmVEZXB0aDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3NjaGVtYVR5cGUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuc2NoZW1hVHlwZSA9IHRoaXMuX3NjaGVtYVR5cGU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc0JpZ3F1ZXJ5RGVzdGluYXRpb25TY2hlbWFDb25maWcgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9yZWN1cnNpdmVTdHJ1Y3R1cmVEZXB0aCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NjaGVtYVR5cGUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX3JlY3Vyc2l2ZVN0cnVjdHVyZURlcHRoID0gdmFsdWUucmVjdXJzaXZlU3RydWN0dXJlRGVwdGg7XG4gICAgICB0aGlzLl9zY2hlbWFUeXBlID0gdmFsdWUuc2NoZW1hVHlwZTtcbiAgICB9XG4gIH1cblxuICAvLyByZWN1cnNpdmVfc3RydWN0dXJlX2RlcHRoIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3JlY3Vyc2l2ZVN0cnVjdHVyZURlcHRoPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCByZWN1cnNpdmVTdHJ1Y3R1cmVEZXB0aCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ3JlY3Vyc2l2ZV9zdHJ1Y3R1cmVfZGVwdGgnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlY3Vyc2l2ZVN0cnVjdHVyZURlcHRoKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9yZWN1cnNpdmVTdHJ1Y3R1cmVEZXB0aCA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZWN1cnNpdmVTdHJ1Y3R1cmVEZXB0aElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZWN1cnNpdmVTdHJ1Y3R1cmVEZXB0aDtcbiAgfVxuXG4gIC8vIHNjaGVtYV90eXBlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NjaGVtYVR5cGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHNjaGVtYVR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzY2hlbWFfdHlwZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2NoZW1hVHlwZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc2NoZW1hVHlwZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNjaGVtYVR5cGUoKSB7XG4gICAgdGhpcy5fc2NoZW1hVHlwZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc2NoZW1hVHlwZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zY2hlbWFUeXBlO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVTdHJlYW1Db25maWdzQmlncXVlcnlEZXN0aW5hdGlvbiB7XG4gIC8qKlxuICAqIEJpZ1F1ZXJ5IFVSSSB0byBhIGRhdGFzZXQsIHVwIHRvIDIwMDAgY2hhcmFjdGVycyBsb25nLCBpbiB0aGUgZm9ybWF0IGJxOi8vcHJvamVjdElkLmJxRGF0YXNldElkXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlI2RhdGFzZXRfdXJpIEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmUjZGF0YXNldF91cml9XG4gICovXG4gIHJlYWRvbmx5IGRhdGFzZXRVcmk6IHN0cmluZztcbiAgLyoqXG4gICogc2NoZW1hX2NvbmZpZyBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZSNzY2hlbWFfY29uZmlnIEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmUjc2NoZW1hX2NvbmZpZ31cbiAgKi9cbiAgcmVhZG9ubHkgc2NoZW1hQ29uZmlnOiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc0JpZ3F1ZXJ5RGVzdGluYXRpb25TY2hlbWFDb25maWc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc0JpZ3F1ZXJ5RGVzdGluYXRpb25Ub1RlcnJhZm9ybShzdHJ1Y3Q/OiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc0JpZ3F1ZXJ5RGVzdGluYXRpb25PdXRwdXRSZWZlcmVuY2UgfCBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc0JpZ3F1ZXJ5RGVzdGluYXRpb24pOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgZGF0YXNldF91cmk6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuZGF0YXNldFVyaSksXG4gICAgc2NoZW1hX2NvbmZpZzogZ29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NCaWdxdWVyeURlc3RpbmF0aW9uU2NoZW1hQ29uZmlnVG9UZXJyYWZvcm0oc3RydWN0IS5zY2hlbWFDb25maWcpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc0JpZ3F1ZXJ5RGVzdGluYXRpb25PdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVTdHJlYW1Db25maWdzQmlncXVlcnlEZXN0aW5hdGlvbiB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fZGF0YXNldFVyaSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5kYXRhc2V0VXJpID0gdGhpcy5fZGF0YXNldFVyaTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3NjaGVtYUNvbmZpZz8uaW50ZXJuYWxWYWx1ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5zY2hlbWFDb25maWcgPSB0aGlzLl9zY2hlbWFDb25maWc/LmludGVybmFsVmFsdWU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc0JpZ3F1ZXJ5RGVzdGluYXRpb24gfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9kYXRhc2V0VXJpID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fc2NoZW1hQ29uZmlnLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2RhdGFzZXRVcmkgPSB2YWx1ZS5kYXRhc2V0VXJpO1xuICAgICAgdGhpcy5fc2NoZW1hQ29uZmlnLmludGVybmFsVmFsdWUgPSB2YWx1ZS5zY2hlbWFDb25maWc7XG4gICAgfVxuICB9XG5cbiAgLy8gZGF0YXNldF91cmkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfZGF0YXNldFVyaT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZGF0YXNldFVyaSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2RhdGFzZXRfdXJpJyk7XG4gIH1cbiAgcHVibGljIHNldCBkYXRhc2V0VXJpKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kYXRhc2V0VXJpID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRhdGFzZXRVcmlJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGF0YXNldFVyaTtcbiAgfVxuXG4gIC8vIHNjaGVtYV9jb25maWcgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfc2NoZW1hQ29uZmlnID0gbmV3IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVTdHJlYW1Db25maWdzQmlncXVlcnlEZXN0aW5hdGlvblNjaGVtYUNvbmZpZ091dHB1dFJlZmVyZW5jZSh0aGlzLCBcInNjaGVtYV9jb25maWdcIik7XG4gIHB1YmxpYyBnZXQgc2NoZW1hQ29uZmlnKCkge1xuICAgIHJldHVybiB0aGlzLl9zY2hlbWFDb25maWc7XG4gIH1cbiAgcHVibGljIHB1dFNjaGVtYUNvbmZpZyh2YWx1ZTogR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NCaWdxdWVyeURlc3RpbmF0aW9uU2NoZW1hQ29uZmlnKSB7XG4gICAgdGhpcy5fc2NoZW1hQ29uZmlnLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc2NoZW1hQ29uZmlnSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NjaGVtYUNvbmZpZy5pbnRlcm5hbFZhbHVlO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVTdHJlYW1Db25maWdzIHtcbiAgLyoqXG4gICogU3VwcGx5IGEgRkhJUiByZXNvdXJjZSB0eXBlIChzdWNoIGFzIFwiUGF0aWVudFwiIG9yIFwiT2JzZXJ2YXRpb25cIikuIFNlZVxuaHR0cHM6Ly93d3cuaGw3Lm9yZy9maGlyL3ZhbHVlc2V0LXJlc291cmNlLXR5cGVzLmh0bWwgZm9yIGEgbGlzdCBvZiBhbGwgRkhJUiByZXNvdXJjZSB0eXBlcy4gVGhlIHNlcnZlciB0cmVhdHNcbmFuIGVtcHR5IGxpc3QgYXMgYW4gaW50ZW50IHRvIHN0cmVhbSBhbGwgdGhlIHN1cHBvcnRlZCByZXNvdXJjZSB0eXBlcyBpbiB0aGlzIEZISVIgc3RvcmUuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlI3Jlc291cmNlX3R5cGVzIEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmUjcmVzb3VyY2VfdHlwZXN9XG4gICovXG4gIHJlYWRvbmx5IHJlc291cmNlVHlwZXM/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogYmlncXVlcnlfZGVzdGluYXRpb24gYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9oZWFsdGhjYXJlX2ZoaXJfc3RvcmUjYmlncXVlcnlfZGVzdGluYXRpb24gR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSNiaWdxdWVyeV9kZXN0aW5hdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgYmlncXVlcnlEZXN0aW5hdGlvbjogR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NCaWdxdWVyeURlc3RpbmF0aW9uO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZ29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlncyB8IGNka3RmLklSZXNvbHZhYmxlKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIHJlc291cmNlX3R5cGVzOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtLCBmYWxzZSkoc3RydWN0IS5yZXNvdXJjZVR5cGVzKSxcbiAgICBiaWdxdWVyeV9kZXN0aW5hdGlvbjogZ29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NCaWdxdWVyeURlc3RpbmF0aW9uVG9UZXJyYWZvcm0oc3RydWN0IS5iaWdxdWVyeURlc3RpbmF0aW9uKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gIHByaXZhdGUgcmVzb2x2YWJsZVZhbHVlPzogY2RrdGYuSVJlc29sdmFibGU7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICogQHBhcmFtIGNvbXBsZXhPYmplY3RJbmRleCB0aGUgaW5kZXggb2YgdGhpcyBpdGVtIGluIHRoZSBsaXN0XG4gICogQHBhcmFtIGNvbXBsZXhPYmplY3RJc0Zyb21TZXQgd2hldGhlciB0aGUgbGlzdCBpcyB3cmFwcGluZyBhIHNldCAod2lsbCBhZGQgdG9saXN0KCkgdG8gYmUgYWJsZSB0byBhY2Nlc3MgYW4gaXRlbSB2aWEgYW4gaW5kZXgpXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLCBjb21wbGV4T2JqZWN0SW5kZXg6IG51bWJlciwgY29tcGxleE9iamVjdElzRnJvbVNldDogYm9vbGVhbikge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGNvbXBsZXhPYmplY3RJc0Zyb21TZXQsIGNvbXBsZXhPYmplY3RJbmRleCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3MgfCBjZGt0Zi5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZCB7XG4gICAgaWYgKHRoaXMucmVzb2x2YWJsZVZhbHVlKSB7XG4gICAgICByZXR1cm4gdGhpcy5yZXNvbHZhYmxlVmFsdWU7XG4gICAgfVxuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX3Jlc291cmNlVHlwZXMgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucmVzb3VyY2VUeXBlcyA9IHRoaXMuX3Jlc291cmNlVHlwZXM7XG4gICAgfVxuICAgIGlmICh0aGlzLl9iaWdxdWVyeURlc3RpbmF0aW9uPy5pbnRlcm5hbFZhbHVlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmJpZ3F1ZXJ5RGVzdGluYXRpb24gPSB0aGlzLl9iaWdxdWVyeURlc3RpbmF0aW9uPy5pbnRlcm5hbFZhbHVlO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3MgfCBjZGt0Zi5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMucmVzb2x2YWJsZVZhbHVlID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcmVzb3VyY2VUeXBlcyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2JpZ3F1ZXJ5RGVzdGluYXRpb24uaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSBpZiAoY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZSh2YWx1ZSkpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB2YWx1ZTtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9yZXNvdXJjZVR5cGVzID0gdmFsdWUucmVzb3VyY2VUeXBlcztcbiAgICAgIHRoaXMuX2JpZ3F1ZXJ5RGVzdGluYXRpb24uaW50ZXJuYWxWYWx1ZSA9IHZhbHVlLmJpZ3F1ZXJ5RGVzdGluYXRpb247XG4gICAgfVxuICB9XG5cbiAgLy8gcmVzb3VyY2VfdHlwZXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVzb3VyY2VUeXBlcz86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCByZXNvdXJjZVR5cGVzKCkge1xuICAgIHJldHVybiB0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ3Jlc291cmNlX3R5cGVzJyk7XG4gIH1cbiAgcHVibGljIHNldCByZXNvdXJjZVR5cGVzKHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX3Jlc291cmNlVHlwZXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSZXNvdXJjZVR5cGVzKCkge1xuICAgIHRoaXMuX3Jlc291cmNlVHlwZXMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlc291cmNlVHlwZXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVzb3VyY2VUeXBlcztcbiAgfVxuXG4gIC8vIGJpZ3F1ZXJ5X2Rlc3RpbmF0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX2JpZ3F1ZXJ5RGVzdGluYXRpb24gPSBuZXcgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NCaWdxdWVyeURlc3RpbmF0aW9uT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwiYmlncXVlcnlfZGVzdGluYXRpb25cIik7XG4gIHB1YmxpYyBnZXQgYmlncXVlcnlEZXN0aW5hdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5fYmlncXVlcnlEZXN0aW5hdGlvbjtcbiAgfVxuICBwdWJsaWMgcHV0QmlncXVlcnlEZXN0aW5hdGlvbih2YWx1ZTogR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NCaWdxdWVyeURlc3RpbmF0aW9uKSB7XG4gICAgdGhpcy5fYmlncXVlcnlEZXN0aW5hdGlvbi5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJpZ3F1ZXJ5RGVzdGluYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYmlncXVlcnlEZXN0aW5hdGlvbi5pbnRlcm5hbFZhbHVlO1xuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc0xpc3QgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4TGlzdCB7XG4gIHB1YmxpYyBpbnRlcm5hbFZhbHVlPyA6IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVTdHJlYW1Db25maWdzW10gfCBjZGt0Zi5JUmVzb2x2YWJsZVxuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqIEBwYXJhbSB3cmFwc1NldCB3aGV0aGVyIHRoZSBsaXN0IGlzIHdyYXBwaW5nIGEgc2V0ICh3aWxsIGFkZCB0b2xpc3QoKSB0byBiZSBhYmxlIHRvIGFjY2VzcyBhbiBpdGVtIHZpYSBhbiBpbmRleClcbiAgKi9cbiAgY29uc3RydWN0b3IocHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLCBwcm90ZWN0ZWQgd3JhcHNTZXQ6IGJvb2xlYW4pIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCB3cmFwc1NldClcbiAgfVxuXG4gIC8qKlxuICAqIEBwYXJhbSBpbmRleCB0aGUgaW5kZXggb2YgdGhlIGl0ZW0gdG8gcmV0dXJuXG4gICovXG4gIHB1YmxpYyBnZXQoaW5kZXg6IG51bWJlcik6IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVTdHJlYW1Db25maWdzT3V0cHV0UmVmZXJlbmNlIHtcbiAgICByZXR1cm4gbmV3IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVTdHJlYW1Db25maWdzT3V0cHV0UmVmZXJlbmNlKHRoaXMudGVycmFmb3JtUmVzb3VyY2UsIHRoaXMudGVycmFmb3JtQXR0cmlidXRlLCBpbmRleCwgdGhpcy53cmFwc1NldCk7XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVRpbWVvdXRzIHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlI2NyZWF0ZSBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlI2NyZWF0ZX1cbiAgKi9cbiAgcmVhZG9ubHkgY3JlYXRlPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9oZWFsdGhjYXJlX2ZoaXJfc3RvcmUjZGVsZXRlIEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmUjZGVsZXRlfVxuICAqL1xuICByZWFkb25seSBkZWxldGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZSN1cGRhdGUgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSN1cGRhdGV9XG4gICovXG4gIHJlYWRvbmx5IHVwZGF0ZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVUaW1lb3V0c1RvVGVycmFmb3JtKHN0cnVjdD86IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVUaW1lb3V0c091dHB1dFJlZmVyZW5jZSB8IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVUaW1lb3V0cyB8IGNka3RmLklSZXNvbHZhYmxlKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGNyZWF0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5jcmVhdGUpLFxuICAgIGRlbGV0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5kZWxldGUpLFxuICAgIHVwZGF0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS51cGRhdGUpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlVGltZW91dHNPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gIHByaXZhdGUgcmVzb2x2YWJsZVZhbHVlPzogY2RrdGYuSVJlc29sdmFibGU7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVUaW1lb3V0cyB8IGNka3RmLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkIHtcbiAgICBpZiAodGhpcy5yZXNvbHZhYmxlVmFsdWUpIHtcbiAgICAgIHJldHVybiB0aGlzLnJlc29sdmFibGVWYWx1ZTtcbiAgICB9XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fY3JlYXRlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmNyZWF0ZSA9IHRoaXMuX2NyZWF0ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2RlbGV0ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5kZWxldGUgPSB0aGlzLl9kZWxldGU7XG4gICAgfVxuICAgIGlmICh0aGlzLl91cGRhdGUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQudXBkYXRlID0gdGhpcy5fdXBkYXRlO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVRpbWVvdXRzIHwgY2RrdGYuSVJlc29sdmFibGUgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLnJlc29sdmFibGVWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2NyZWF0ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2RlbGV0ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3VwZGF0ZSA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSBpZiAoY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZSh2YWx1ZSkpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB2YWx1ZTtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9jcmVhdGUgPSB2YWx1ZS5jcmVhdGU7XG4gICAgICB0aGlzLl9kZWxldGUgPSB2YWx1ZS5kZWxldGU7XG4gICAgICB0aGlzLl91cGRhdGUgPSB2YWx1ZS51cGRhdGU7XG4gICAgfVxuICB9XG5cbiAgLy8gY3JlYXRlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NyZWF0ZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY3JlYXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY3JlYXRlJyk7XG4gIH1cbiAgcHVibGljIHNldCBjcmVhdGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2NyZWF0ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENyZWF0ZSgpIHtcbiAgICB0aGlzLl9jcmVhdGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNyZWF0ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jcmVhdGU7XG4gIH1cblxuICAvLyBkZWxldGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVsZXRlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBkZWxldGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdkZWxldGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlbGV0ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZGVsZXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGVsZXRlKCkge1xuICAgIHRoaXMuX2RlbGV0ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGVsZXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RlbGV0ZTtcbiAgfVxuXG4gIC8vIHVwZGF0ZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF91cGRhdGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHVwZGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3VwZGF0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgdXBkYXRlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl91cGRhdGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVcGRhdGUoKSB7XG4gICAgdGhpcy5fdXBkYXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1cGRhdGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXBkYXRlO1xuICB9XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9oZWFsdGhjYXJlX2ZoaXJfc3RvcmUgZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZX1cbiovXG5leHBvcnQgY2xhc3MgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZSBleHRlbmRzIGNka3RmLlRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgUFJPUEVSVElFU1xuICAvLyA9PT09PT09PT09PT09PT09PVxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHRmUmVzb3VyY2VUeXBlID0gXCJnb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlXCI7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9oZWFsdGhjYXJlX2ZoaXJfc3RvcmUgZ29vZ2xlX2hlYWx0aGNhcmVfZmhpcl9zdG9yZX0gUmVzb3VyY2VcbiAgKlxuICAqIEBwYXJhbSBzY29wZSBUaGUgc2NvcGUgaW4gd2hpY2ggdG8gZGVmaW5lIHRoaXMgY29uc3RydWN0XG4gICogQHBhcmFtIGlkIFRoZSBzY29wZWQgY29uc3RydWN0IElELiBNdXN0IGJlIHVuaXF1ZSBhbW9uZ3N0IHNpYmxpbmdzIGluIHRoZSBzYW1lIHNjb3BlXG4gICogQHBhcmFtIG9wdGlvbnMgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZUNvbmZpZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdnb29nbGVfaGVhbHRoY2FyZV9maGlyX3N0b3JlJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2dvb2dsZS1iZXRhJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uOiAnNC4zOC4wJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uQ29uc3RyYWludDogJ34+IDQuMTcnXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGUsXG4gICAgICBwcm92aXNpb25lcnM6IGNvbmZpZy5wcm92aXNpb25lcnMsXG4gICAgICBjb25uZWN0aW9uOiBjb25maWcuY29ubmVjdGlvbixcbiAgICAgIGZvckVhY2g6IGNvbmZpZy5mb3JFYWNoXG4gICAgfSk7XG4gICAgdGhpcy5fZGF0YXNldCA9IGNvbmZpZy5kYXRhc2V0O1xuICAgIHRoaXMuX2Rpc2FibGVSZWZlcmVudGlhbEludGVncml0eSA9IGNvbmZpZy5kaXNhYmxlUmVmZXJlbnRpYWxJbnRlZ3JpdHk7XG4gICAgdGhpcy5fZGlzYWJsZVJlc291cmNlVmVyc2lvbmluZyA9IGNvbmZpZy5kaXNhYmxlUmVzb3VyY2VWZXJzaW9uaW5nO1xuICAgIHRoaXMuX2VuYWJsZUhpc3RvcnlJbXBvcnQgPSBjb25maWcuZW5hYmxlSGlzdG9yeUltcG9ydDtcbiAgICB0aGlzLl9lbmFibGVVcGRhdGVDcmVhdGUgPSBjb25maWcuZW5hYmxlVXBkYXRlQ3JlYXRlO1xuICAgIHRoaXMuX2lkID0gY29uZmlnLmlkO1xuICAgIHRoaXMuX2xhYmVscyA9IGNvbmZpZy5sYWJlbHM7XG4gICAgdGhpcy5fbmFtZSA9IGNvbmZpZy5uYW1lO1xuICAgIHRoaXMuX3ZlcnNpb24gPSBjb25maWcudmVyc2lvbjtcbiAgICB0aGlzLl9ub3RpZmljYXRpb25Db25maWcuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5ub3RpZmljYXRpb25Db25maWc7XG4gICAgdGhpcy5fc3RyZWFtQ29uZmlncy5pbnRlcm5hbFZhbHVlID0gY29uZmlnLnN0cmVhbUNvbmZpZ3M7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy50aW1lb3V0cztcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gZGF0YXNldCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9kYXRhc2V0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBkYXRhc2V0KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGF0YXNldCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGF0YXNldCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZGF0YXNldCA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkYXRhc2V0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RhdGFzZXQ7XG4gIH1cblxuICAvLyBkaXNhYmxlX3JlZmVyZW50aWFsX2ludGVncml0eSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kaXNhYmxlUmVmZXJlbnRpYWxJbnRlZ3JpdHk/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGRpc2FibGVSZWZlcmVudGlhbEludGVncml0eSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdkaXNhYmxlX3JlZmVyZW50aWFsX2ludGVncml0eScpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGlzYWJsZVJlZmVyZW50aWFsSW50ZWdyaXR5KHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9kaXNhYmxlUmVmZXJlbnRpYWxJbnRlZ3JpdHkgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREaXNhYmxlUmVmZXJlbnRpYWxJbnRlZ3JpdHkoKSB7XG4gICAgdGhpcy5fZGlzYWJsZVJlZmVyZW50aWFsSW50ZWdyaXR5ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkaXNhYmxlUmVmZXJlbnRpYWxJbnRlZ3JpdHlJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGlzYWJsZVJlZmVyZW50aWFsSW50ZWdyaXR5O1xuICB9XG5cbiAgLy8gZGlzYWJsZV9yZXNvdXJjZV92ZXJzaW9uaW5nIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Rpc2FibGVSZXNvdXJjZVZlcnNpb25pbmc/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGRpc2FibGVSZXNvdXJjZVZlcnNpb25pbmcoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZGlzYWJsZV9yZXNvdXJjZV92ZXJzaW9uaW5nJyk7XG4gIH1cbiAgcHVibGljIHNldCBkaXNhYmxlUmVzb3VyY2VWZXJzaW9uaW5nKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9kaXNhYmxlUmVzb3VyY2VWZXJzaW9uaW5nID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGlzYWJsZVJlc291cmNlVmVyc2lvbmluZygpIHtcbiAgICB0aGlzLl9kaXNhYmxlUmVzb3VyY2VWZXJzaW9uaW5nID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkaXNhYmxlUmVzb3VyY2VWZXJzaW9uaW5nSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Rpc2FibGVSZXNvdXJjZVZlcnNpb25pbmc7XG4gIH1cblxuICAvLyBlbmFibGVfaGlzdG9yeV9pbXBvcnQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZW5hYmxlSGlzdG9yeUltcG9ydD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZW5hYmxlSGlzdG9yeUltcG9ydCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdlbmFibGVfaGlzdG9yeV9pbXBvcnQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGVuYWJsZUhpc3RvcnlJbXBvcnQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2VuYWJsZUhpc3RvcnlJbXBvcnQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRFbmFibGVIaXN0b3J5SW1wb3J0KCkge1xuICAgIHRoaXMuX2VuYWJsZUhpc3RvcnlJbXBvcnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGVuYWJsZUhpc3RvcnlJbXBvcnRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZW5hYmxlSGlzdG9yeUltcG9ydDtcbiAgfVxuXG4gIC8vIGVuYWJsZV91cGRhdGVfY3JlYXRlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2VuYWJsZVVwZGF0ZUNyZWF0ZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZW5hYmxlVXBkYXRlQ3JlYXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2VuYWJsZV91cGRhdGVfY3JlYXRlJyk7XG4gIH1cbiAgcHVibGljIHNldCBlbmFibGVVcGRhdGVDcmVhdGUodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2VuYWJsZVVwZGF0ZUNyZWF0ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEVuYWJsZVVwZGF0ZUNyZWF0ZSgpIHtcbiAgICB0aGlzLl9lbmFibGVVcGRhdGVDcmVhdGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGVuYWJsZVVwZGF0ZUNyZWF0ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9lbmFibGVVcGRhdGVDcmVhdGU7XG4gIH1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBpZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJZCgpIHtcbiAgICB0aGlzLl9pZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWQ7XG4gIH1cblxuICAvLyBsYWJlbHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbGFiZWxzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTsgXG4gIHB1YmxpYyBnZXQgbGFiZWxzKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ01hcEF0dHJpYnV0ZSgnbGFiZWxzJyk7XG4gIH1cbiAgcHVibGljIHNldCBsYWJlbHModmFsdWU6IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH0pIHtcbiAgICB0aGlzLl9sYWJlbHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRMYWJlbHMoKSB7XG4gICAgdGhpcy5fbGFiZWxzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBsYWJlbHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbGFiZWxzO1xuICB9XG5cbiAgLy8gbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9uYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBuYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbmFtZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBuYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX25hbWU7XG4gIH1cblxuICAvLyBzZWxmX2xpbmsgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBzZWxmTGluaygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3NlbGZfbGluaycpO1xuICB9XG5cbiAgLy8gdmVyc2lvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF92ZXJzaW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB2ZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndmVyc2lvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgdmVyc2lvbih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdmVyc2lvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFZlcnNpb24oKSB7XG4gICAgdGhpcy5fdmVyc2lvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdmVyc2lvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl92ZXJzaW9uO1xuICB9XG5cbiAgLy8gbm90aWZpY2F0aW9uX2NvbmZpZyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ub3RpZmljYXRpb25Db25maWcgPSBuZXcgR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZU5vdGlmaWNhdGlvbkNvbmZpZ091dHB1dFJlZmVyZW5jZSh0aGlzLCBcIm5vdGlmaWNhdGlvbl9jb25maWdcIik7XG4gIHB1YmxpYyBnZXQgbm90aWZpY2F0aW9uQ29uZmlnKCkge1xuICAgIHJldHVybiB0aGlzLl9ub3RpZmljYXRpb25Db25maWc7XG4gIH1cbiAgcHVibGljIHB1dE5vdGlmaWNhdGlvbkNvbmZpZyh2YWx1ZTogR29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZU5vdGlmaWNhdGlvbkNvbmZpZykge1xuICAgIHRoaXMuX25vdGlmaWNhdGlvbkNvbmZpZy5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Tm90aWZpY2F0aW9uQ29uZmlnKCkge1xuICAgIHRoaXMuX25vdGlmaWNhdGlvbkNvbmZpZy5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBub3RpZmljYXRpb25Db25maWdJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbm90aWZpY2F0aW9uQ29uZmlnLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyBzdHJlYW1fY29uZmlncyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zdHJlYW1Db25maWdzID0gbmV3IEdvb2dsZUhlYWx0aGNhcmVGaGlyU3RvcmVTdHJlYW1Db25maWdzTGlzdCh0aGlzLCBcInN0cmVhbV9jb25maWdzXCIsIGZhbHNlKTtcbiAgcHVibGljIGdldCBzdHJlYW1Db25maWdzKCkge1xuICAgIHJldHVybiB0aGlzLl9zdHJlYW1Db25maWdzO1xuICB9XG4gIHB1YmxpYyBwdXRTdHJlYW1Db25maWdzKHZhbHVlOiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlU3RyZWFtQ29uZmlnc1tdIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9zdHJlYW1Db25maWdzLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTdHJlYW1Db25maWdzKCkge1xuICAgIHRoaXMuX3N0cmVhbUNvbmZpZ3MuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RyZWFtQ29uZmlnc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zdHJlYW1Db25maWdzLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyB0aW1lb3V0cyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90aW1lb3V0cyA9IG5ldyBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlVGltZW91dHNPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJ0aW1lb3V0c1wiKTtcbiAgcHVibGljIGdldCB0aW1lb3V0cygpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHM7XG4gIH1cbiAgcHVibGljIHB1dFRpbWVvdXRzKHZhbHVlOiBHb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlVGltZW91dHMpIHtcbiAgICB0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VGltZW91dHMoKSB7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGltZW91dHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgZGF0YXNldDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fZGF0YXNldCksXG4gICAgICBkaXNhYmxlX3JlZmVyZW50aWFsX2ludGVncml0eTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2Rpc2FibGVSZWZlcmVudGlhbEludGVncml0eSksXG4gICAgICBkaXNhYmxlX3Jlc291cmNlX3ZlcnNpb25pbmc6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9kaXNhYmxlUmVzb3VyY2VWZXJzaW9uaW5nKSxcbiAgICAgIGVuYWJsZV9oaXN0b3J5X2ltcG9ydDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2VuYWJsZUhpc3RvcnlJbXBvcnQpLFxuICAgICAgZW5hYmxlX3VwZGF0ZV9jcmVhdGU6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9lbmFibGVVcGRhdGVDcmVhdGUpLFxuICAgICAgaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2lkKSxcbiAgICAgIGxhYmVsczogY2RrdGYuaGFzaE1hcHBlcihjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSkodGhpcy5fbGFiZWxzKSxcbiAgICAgIG5hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX25hbWUpLFxuICAgICAgdmVyc2lvbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fdmVyc2lvbiksXG4gICAgICBub3RpZmljYXRpb25fY29uZmlnOiBnb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlTm90aWZpY2F0aW9uQ29uZmlnVG9UZXJyYWZvcm0odGhpcy5fbm90aWZpY2F0aW9uQ29uZmlnLmludGVybmFsVmFsdWUpLFxuICAgICAgc3RyZWFtX2NvbmZpZ3M6IGNka3RmLmxpc3RNYXBwZXIoZ29vZ2xlSGVhbHRoY2FyZUZoaXJTdG9yZVN0cmVhbUNvbmZpZ3NUb1RlcnJhZm9ybSwgdHJ1ZSkodGhpcy5fc3RyZWFtQ29uZmlncy5pbnRlcm5hbFZhbHVlKSxcbiAgICAgIHRpbWVvdXRzOiBnb29nbGVIZWFsdGhjYXJlRmhpclN0b3JlVGltZW91dHNUb1RlcnJhZm9ybSh0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlKSxcbiAgICB9O1xuICB9XG59XG4iXX0=