import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIapClientConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifier of the brand to which this client
  is attached to. The format is
  'projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_iap_client#brand GoogleIapClient#brand}
    */
    readonly brand: string;
    /**
    * Human-friendly name given to the OAuth client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_iap_client#display_name GoogleIapClient#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_iap_client#id GoogleIapClient#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_iap_client#timeouts GoogleIapClient#timeouts}
    */
    readonly timeouts?: GoogleIapClientTimeouts;
}
export interface GoogleIapClientTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_iap_client#create GoogleIapClient#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_iap_client#delete GoogleIapClient#delete}
    */
    readonly delete?: string;
}
export declare function googleIapClientTimeoutsToTerraform(struct?: GoogleIapClientTimeoutsOutputReference | GoogleIapClientTimeouts | cdktf.IResolvable): any;
export declare class GoogleIapClientTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIapClientTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIapClientTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_iap_client google_iap_client}
*/
export declare class GoogleIapClient extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iap_client";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_iap_client google_iap_client} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIapClientConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIapClientConfig);
    private _brand?;
    get brand(): string;
    set brand(value: string);
    get brandInput(): string | undefined;
    get clientId(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get secret(): string;
    private _timeouts;
    get timeouts(): GoogleIapClientTimeoutsOutputReference;
    putTimeouts(value: GoogleIapClientTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIapClientTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
