import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIdentityPlatformInboundSamlConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human friendly display name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#display_name GoogleIdentityPlatformInboundSamlConfig#display_name}
    */
    readonly displayName: string;
    /**
    * If this config allows users to sign in with the provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#enabled GoogleIdentityPlatformInboundSamlConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#id GoogleIdentityPlatformInboundSamlConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the InboundSamlConfig resource. Must start with 'saml.' and can only have alphanumeric characters,
  hyphens, underscores or periods. The part after 'saml.' must also start with a lowercase letter, end with an
  alphanumeric character, and have at least 2 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#name GoogleIdentityPlatformInboundSamlConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#project GoogleIdentityPlatformInboundSamlConfig#project}
    */
    readonly project?: string;
    /**
    * idp_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#idp_config GoogleIdentityPlatformInboundSamlConfig#idp_config}
    */
    readonly idpConfig: GoogleIdentityPlatformInboundSamlConfigIdpConfig;
    /**
    * sp_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#sp_config GoogleIdentityPlatformInboundSamlConfig#sp_config}
    */
    readonly spConfig: GoogleIdentityPlatformInboundSamlConfigSpConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#timeouts GoogleIdentityPlatformInboundSamlConfig#timeouts}
    */
    readonly timeouts?: GoogleIdentityPlatformInboundSamlConfigTimeouts;
}
export interface GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificates {
    /**
    * The IdP's x509 certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#x509_certificate GoogleIdentityPlatformInboundSamlConfig#x509_certificate}
    */
    readonly x509Certificate?: string;
}
export declare function googleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificatesToTerraform(struct?: GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificates | cdktf.IResolvable): any;
export declare class GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificates | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificates | cdktf.IResolvable | undefined);
    private _x509Certificate?;
    get x509Certificate(): string;
    set x509Certificate(value: string);
    resetX509Certificate(): void;
    get x509CertificateInput(): string | undefined;
}
export declare class GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificatesOutputReference;
}
export interface GoogleIdentityPlatformInboundSamlConfigIdpConfig {
    /**
    * Unique identifier for all SAML entities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#idp_entity_id GoogleIdentityPlatformInboundSamlConfig#idp_entity_id}
    */
    readonly idpEntityId: string;
    /**
    * Indicates if outbounding SAMLRequest should be signed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#sign_request GoogleIdentityPlatformInboundSamlConfig#sign_request}
    */
    readonly signRequest?: boolean | cdktf.IResolvable;
    /**
    * URL to send Authentication request to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#sso_url GoogleIdentityPlatformInboundSamlConfig#sso_url}
    */
    readonly ssoUrl: string;
    /**
    * idp_certificates block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#idp_certificates GoogleIdentityPlatformInboundSamlConfig#idp_certificates}
    */
    readonly idpCertificates: GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable;
}
export declare function googleIdentityPlatformInboundSamlConfigIdpConfigToTerraform(struct?: GoogleIdentityPlatformInboundSamlConfigIdpConfigOutputReference | GoogleIdentityPlatformInboundSamlConfigIdpConfig): any;
export declare class GoogleIdentityPlatformInboundSamlConfigIdpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformInboundSamlConfigIdpConfig | undefined;
    set internalValue(value: GoogleIdentityPlatformInboundSamlConfigIdpConfig | undefined);
    private _idpEntityId?;
    get idpEntityId(): string;
    set idpEntityId(value: string);
    get idpEntityIdInput(): string | undefined;
    private _signRequest?;
    get signRequest(): boolean | cdktf.IResolvable;
    set signRequest(value: boolean | cdktf.IResolvable);
    resetSignRequest(): void;
    get signRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _ssoUrl?;
    get ssoUrl(): string;
    set ssoUrl(value: string);
    get ssoUrlInput(): string | undefined;
    private _idpCertificates;
    get idpCertificates(): GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificatesList;
    putIdpCertificates(value: GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable): void;
    get idpCertificatesInput(): cdktf.IResolvable | GoogleIdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | undefined;
}
export interface GoogleIdentityPlatformInboundSamlConfigSpConfigSpCertificates {
}
export declare function googleIdentityPlatformInboundSamlConfigSpConfigSpCertificatesToTerraform(struct?: GoogleIdentityPlatformInboundSamlConfigSpConfigSpCertificates): any;
export declare class GoogleIdentityPlatformInboundSamlConfigSpConfigSpCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIdentityPlatformInboundSamlConfigSpConfigSpCertificates | undefined;
    set internalValue(value: GoogleIdentityPlatformInboundSamlConfigSpConfigSpCertificates | undefined);
    get x509Certificate(): string;
}
export declare class GoogleIdentityPlatformInboundSamlConfigSpConfigSpCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIdentityPlatformInboundSamlConfigSpConfigSpCertificatesOutputReference;
}
export interface GoogleIdentityPlatformInboundSamlConfigSpConfig {
    /**
    * Callback URI where responses from IDP are handled. Must start with 'https://'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#callback_uri GoogleIdentityPlatformInboundSamlConfig#callback_uri}
    */
    readonly callbackUri?: string;
    /**
    * Unique identifier for all SAML entities.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#sp_entity_id GoogleIdentityPlatformInboundSamlConfig#sp_entity_id}
    */
    readonly spEntityId?: string;
}
export declare function googleIdentityPlatformInboundSamlConfigSpConfigToTerraform(struct?: GoogleIdentityPlatformInboundSamlConfigSpConfigOutputReference | GoogleIdentityPlatformInboundSamlConfigSpConfig): any;
export declare class GoogleIdentityPlatformInboundSamlConfigSpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformInboundSamlConfigSpConfig | undefined;
    set internalValue(value: GoogleIdentityPlatformInboundSamlConfigSpConfig | undefined);
    private _callbackUri?;
    get callbackUri(): string;
    set callbackUri(value: string);
    resetCallbackUri(): void;
    get callbackUriInput(): string | undefined;
    private _spCertificates;
    get spCertificates(): GoogleIdentityPlatformInboundSamlConfigSpConfigSpCertificatesList;
    private _spEntityId?;
    get spEntityId(): string;
    set spEntityId(value: string);
    resetSpEntityId(): void;
    get spEntityIdInput(): string | undefined;
}
export interface GoogleIdentityPlatformInboundSamlConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#create GoogleIdentityPlatformInboundSamlConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#delete GoogleIdentityPlatformInboundSamlConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config#update GoogleIdentityPlatformInboundSamlConfig#update}
    */
    readonly update?: string;
}
export declare function googleIdentityPlatformInboundSamlConfigTimeoutsToTerraform(struct?: GoogleIdentityPlatformInboundSamlConfigTimeoutsOutputReference | GoogleIdentityPlatformInboundSamlConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleIdentityPlatformInboundSamlConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformInboundSamlConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIdentityPlatformInboundSamlConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config google_identity_platform_inbound_saml_config}
*/
export declare class GoogleIdentityPlatformInboundSamlConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_identity_platform_inbound_saml_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_inbound_saml_config google_identity_platform_inbound_saml_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIdentityPlatformInboundSamlConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIdentityPlatformInboundSamlConfigConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _idpConfig;
    get idpConfig(): GoogleIdentityPlatformInboundSamlConfigIdpConfigOutputReference;
    putIdpConfig(value: GoogleIdentityPlatformInboundSamlConfigIdpConfig): void;
    get idpConfigInput(): GoogleIdentityPlatformInboundSamlConfigIdpConfig | undefined;
    private _spConfig;
    get spConfig(): GoogleIdentityPlatformInboundSamlConfigSpConfigOutputReference;
    putSpConfig(value: GoogleIdentityPlatformInboundSamlConfigSpConfig): void;
    get spConfigInput(): GoogleIdentityPlatformInboundSamlConfigSpConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleIdentityPlatformInboundSamlConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleIdentityPlatformInboundSamlConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIdentityPlatformInboundSamlConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
