import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIdentityPlatformTenantConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether to allow email/password user authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant#allow_password_signup GoogleIdentityPlatformTenant#allow_password_signup}
    */
    readonly allowPasswordSignup?: boolean | cdktf.IResolvable;
    /**
    * Whether authentication is disabled for the tenant. If true, the users under
  the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
  are not able to manage its users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant#disable_auth GoogleIdentityPlatformTenant#disable_auth}
    */
    readonly disableAuth?: boolean | cdktf.IResolvable;
    /**
    * Human friendly display name of the tenant.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant#display_name GoogleIdentityPlatformTenant#display_name}
    */
    readonly displayName: string;
    /**
    * Whether to enable email link user authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant#enable_email_link_signin GoogleIdentityPlatformTenant#enable_email_link_signin}
    */
    readonly enableEmailLinkSignin?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant#id GoogleIdentityPlatformTenant#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant#project GoogleIdentityPlatformTenant#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant#timeouts GoogleIdentityPlatformTenant#timeouts}
    */
    readonly timeouts?: GoogleIdentityPlatformTenantTimeouts;
}
export interface GoogleIdentityPlatformTenantTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant#create GoogleIdentityPlatformTenant#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant#delete GoogleIdentityPlatformTenant#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant#update GoogleIdentityPlatformTenant#update}
    */
    readonly update?: string;
}
export declare function googleIdentityPlatformTenantTimeoutsToTerraform(struct?: GoogleIdentityPlatformTenantTimeoutsOutputReference | GoogleIdentityPlatformTenantTimeouts | cdktf.IResolvable): any;
export declare class GoogleIdentityPlatformTenantTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformTenantTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIdentityPlatformTenantTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant google_identity_platform_tenant}
*/
export declare class GoogleIdentityPlatformTenant extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_identity_platform_tenant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_identity_platform_tenant google_identity_platform_tenant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIdentityPlatformTenantConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIdentityPlatformTenantConfig);
    private _allowPasswordSignup?;
    get allowPasswordSignup(): boolean | cdktf.IResolvable;
    set allowPasswordSignup(value: boolean | cdktf.IResolvable);
    resetAllowPasswordSignup(): void;
    get allowPasswordSignupInput(): boolean | cdktf.IResolvable | undefined;
    private _disableAuth?;
    get disableAuth(): boolean | cdktf.IResolvable;
    set disableAuth(value: boolean | cdktf.IResolvable);
    resetDisableAuth(): void;
    get disableAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableEmailLinkSignin?;
    get enableEmailLinkSignin(): boolean | cdktf.IResolvable;
    set enableEmailLinkSignin(value: boolean | cdktf.IResolvable);
    resetEnableEmailLinkSignin(): void;
    get enableEmailLinkSigninInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleIdentityPlatformTenantTimeoutsOutputReference;
    putTimeouts(value: GoogleIdentityPlatformTenantTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIdentityPlatformTenantTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
