import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleKmsKeyRingIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_key_ring_iam_member#id GoogleKmsKeyRingIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_key_ring_iam_member#key_ring_id GoogleKmsKeyRingIamMember#key_ring_id}
    */
    readonly keyRingId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_key_ring_iam_member#member GoogleKmsKeyRingIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_key_ring_iam_member#role GoogleKmsKeyRingIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_key_ring_iam_member#condition GoogleKmsKeyRingIamMember#condition}
    */
    readonly condition?: GoogleKmsKeyRingIamMemberCondition;
}
export interface GoogleKmsKeyRingIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_key_ring_iam_member#description GoogleKmsKeyRingIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_key_ring_iam_member#expression GoogleKmsKeyRingIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_key_ring_iam_member#title GoogleKmsKeyRingIamMember#title}
    */
    readonly title: string;
}
export declare function googleKmsKeyRingIamMemberConditionToTerraform(struct?: GoogleKmsKeyRingIamMemberConditionOutputReference | GoogleKmsKeyRingIamMemberCondition): any;
export declare class GoogleKmsKeyRingIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleKmsKeyRingIamMemberCondition | undefined;
    set internalValue(value: GoogleKmsKeyRingIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_key_ring_iam_member google_kms_key_ring_iam_member}
*/
export declare class GoogleKmsKeyRingIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_key_ring_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_key_ring_iam_member google_kms_key_ring_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleKmsKeyRingIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleKmsKeyRingIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyRingId?;
    get keyRingId(): string;
    set keyRingId(value: string);
    get keyRingIdInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleKmsKeyRingIamMemberConditionOutputReference;
    putCondition(value: GoogleKmsKeyRingIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleKmsKeyRingIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
