import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleKmsSecretCiphertextConfig extends cdktf.TerraformMetaArguments {
    /**
    * The additional authenticated data used for integrity checks during encryption and decryption.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_secret_ciphertext#additional_authenticated_data GoogleKmsSecretCiphertext#additional_authenticated_data}
    */
    readonly additionalAuthenticatedData?: string;
    /**
    * The full name of the CryptoKey that will be used to encrypt the provided plaintext.
  Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}/cryptoKeys/{{cryptoKey}}''
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_secret_ciphertext#crypto_key GoogleKmsSecretCiphertext#crypto_key}
    */
    readonly cryptoKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_secret_ciphertext#id GoogleKmsSecretCiphertext#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The plaintext to be encrypted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_secret_ciphertext#plaintext GoogleKmsSecretCiphertext#plaintext}
    */
    readonly plaintext: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_secret_ciphertext#timeouts GoogleKmsSecretCiphertext#timeouts}
    */
    readonly timeouts?: GoogleKmsSecretCiphertextTimeouts;
}
export interface GoogleKmsSecretCiphertextTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_secret_ciphertext#create GoogleKmsSecretCiphertext#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_secret_ciphertext#delete GoogleKmsSecretCiphertext#delete}
    */
    readonly delete?: string;
}
export declare function googleKmsSecretCiphertextTimeoutsToTerraform(struct?: GoogleKmsSecretCiphertextTimeoutsOutputReference | GoogleKmsSecretCiphertextTimeouts | cdktf.IResolvable): any;
export declare class GoogleKmsSecretCiphertextTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleKmsSecretCiphertextTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleKmsSecretCiphertextTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_secret_ciphertext google_kms_secret_ciphertext}
*/
export declare class GoogleKmsSecretCiphertext extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_secret_ciphertext";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_kms_secret_ciphertext google_kms_secret_ciphertext} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleKmsSecretCiphertextConfig
    */
    constructor(scope: Construct, id: string, config: GoogleKmsSecretCiphertextConfig);
    private _additionalAuthenticatedData?;
    get additionalAuthenticatedData(): string;
    set additionalAuthenticatedData(value: string);
    resetAdditionalAuthenticatedData(): void;
    get additionalAuthenticatedDataInput(): string | undefined;
    get ciphertext(): string;
    private _cryptoKey?;
    get cryptoKey(): string;
    set cryptoKey(value: string);
    get cryptoKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _plaintext?;
    get plaintext(): string;
    set plaintext(value: string);
    get plaintextInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleKmsSecretCiphertextTimeoutsOutputReference;
    putTimeouts(value: GoogleKmsSecretCiphertextTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleKmsSecretCiphertextTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
