import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingBillingAccountBucketConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The parent resource that contains the logging bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_bucket_config#billing_account GoogleLoggingBillingAccountBucketConfig#billing_account}
    */
    readonly billingAccount: string;
    /**
    * The name of the logging bucket. Logging automatically creates two log buckets: _Required and _Default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_bucket_config#bucket_id GoogleLoggingBillingAccountBucketConfig#bucket_id}
    */
    readonly bucketId: string;
    /**
    * An optional description for this bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_bucket_config#description GoogleLoggingBillingAccountBucketConfig#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_bucket_config#id GoogleLoggingBillingAccountBucketConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_bucket_config#location GoogleLoggingBillingAccountBucketConfig#location}
    */
    readonly location: string;
    /**
    * Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_bucket_config#retention_days GoogleLoggingBillingAccountBucketConfig#retention_days}
    */
    readonly retentionDays?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_bucket_config google_logging_billing_account_bucket_config}
*/
export declare class GoogleLoggingBillingAccountBucketConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_billing_account_bucket_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_bucket_config google_logging_billing_account_bucket_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingBillingAccountBucketConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingBillingAccountBucketConfigConfig);
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    get billingAccountInput(): string | undefined;
    private _bucketId?;
    get bucketId(): string;
    set bucketId(value: string);
    get bucketIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lifecycleState(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _retentionDays?;
    get retentionDays(): number;
    set retentionDays(value: number);
    resetRetentionDays(): void;
    get retentionDaysInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
