import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingBillingAccountSinkConfig extends cdktf.TerraformMetaArguments {
    /**
    * The billing account exported to the sink.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#billing_account GoogleLoggingBillingAccountSink#billing_account}
    */
    readonly billingAccount: string;
    /**
    * A description of this sink. The maximum length of the description is 8000 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#description GoogleLoggingBillingAccountSink#description}
    */
    readonly description?: string;
    /**
    * The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, or a BigQuery dataset. Examples: "storage.googleapis.com/[GCS_BUCKET]" "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]" "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]" The writer associated with the sink must have access to write to the above resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#destination GoogleLoggingBillingAccountSink#destination}
    */
    readonly destination: string;
    /**
    * If set to True, then this sink is disabled and it does not export any log entries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#disabled GoogleLoggingBillingAccountSink#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The filter to apply when exporting logs. Only log entries that match the filter are exported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#filter GoogleLoggingBillingAccountSink#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#id GoogleLoggingBillingAccountSink#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the logging sink.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#name GoogleLoggingBillingAccountSink#name}
    */
    readonly name: string;
    /**
    * bigquery_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#bigquery_options GoogleLoggingBillingAccountSink#bigquery_options}
    */
    readonly bigqueryOptions?: GoogleLoggingBillingAccountSinkBigqueryOptions;
    /**
    * exclusions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#exclusions GoogleLoggingBillingAccountSink#exclusions}
    */
    readonly exclusions?: GoogleLoggingBillingAccountSinkExclusions[] | cdktf.IResolvable;
}
export interface GoogleLoggingBillingAccountSinkBigqueryOptions {
    /**
    * Whether to use BigQuery's partition tables. By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned tables the date suffix is no longer present and special query syntax has to be used instead. In both cases, tables are sharded based on UTC timezone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#use_partitioned_tables GoogleLoggingBillingAccountSink#use_partitioned_tables}
    */
    readonly usePartitionedTables: boolean | cdktf.IResolvable;
}
export declare function googleLoggingBillingAccountSinkBigqueryOptionsToTerraform(struct?: GoogleLoggingBillingAccountSinkBigqueryOptionsOutputReference | GoogleLoggingBillingAccountSinkBigqueryOptions): any;
export declare class GoogleLoggingBillingAccountSinkBigqueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingBillingAccountSinkBigqueryOptions | undefined;
    set internalValue(value: GoogleLoggingBillingAccountSinkBigqueryOptions | undefined);
    private _usePartitionedTables?;
    get usePartitionedTables(): boolean | cdktf.IResolvable;
    set usePartitionedTables(value: boolean | cdktf.IResolvable);
    get usePartitionedTablesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleLoggingBillingAccountSinkExclusions {
    /**
    * A description of this exclusion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#description GoogleLoggingBillingAccountSink#description}
    */
    readonly description?: string;
    /**
    * If set to True, then this exclusion is disabled and it does not exclude any log entries
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#disabled GoogleLoggingBillingAccountSink#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#filter GoogleLoggingBillingAccountSink#filter}
    */
    readonly filter: string;
    /**
    * A client-assigned identifier, such as "load-balancer-exclusion". Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink#name GoogleLoggingBillingAccountSink#name}
    */
    readonly name: string;
}
export declare function googleLoggingBillingAccountSinkExclusionsToTerraform(struct?: GoogleLoggingBillingAccountSinkExclusions | cdktf.IResolvable): any;
export declare class GoogleLoggingBillingAccountSinkExclusionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleLoggingBillingAccountSinkExclusions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingBillingAccountSinkExclusions | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class GoogleLoggingBillingAccountSinkExclusionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleLoggingBillingAccountSinkExclusions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleLoggingBillingAccountSinkExclusionsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink google_logging_billing_account_sink}
*/
export declare class GoogleLoggingBillingAccountSink extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_billing_account_sink";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_billing_account_sink google_logging_billing_account_sink} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingBillingAccountSinkConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingBillingAccountSinkConfig);
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    get billingAccountInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get writerIdentity(): string;
    private _bigqueryOptions;
    get bigqueryOptions(): GoogleLoggingBillingAccountSinkBigqueryOptionsOutputReference;
    putBigqueryOptions(value: GoogleLoggingBillingAccountSinkBigqueryOptions): void;
    resetBigqueryOptions(): void;
    get bigqueryOptionsInput(): GoogleLoggingBillingAccountSinkBigqueryOptions | undefined;
    private _exclusions;
    get exclusions(): GoogleLoggingBillingAccountSinkExclusionsList;
    putExclusions(value: GoogleLoggingBillingAccountSinkExclusions[] | cdktf.IResolvable): void;
    resetExclusions(): void;
    get exclusionsInput(): cdktf.IResolvable | GoogleLoggingBillingAccountSinkExclusions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
