import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingLogViewConfig extends cdktf.TerraformMetaArguments {
    /**
    * The bucket of the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#bucket GoogleLoggingLogView#bucket}
    */
    readonly bucket: string;
    /**
    * Describes this view.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#description GoogleLoggingLogView#description}
    */
    readonly description?: string;
    /**
    * Filter that restricts which log entries in a bucket are visible in this view. Filters are restricted to be a logical AND of ==/!= of any of the following: - originating project/folder/organization/billing account. - resource type - log id For example: SOURCE("projects/myproject") AND resource.type = "gce_instance" AND LOG_ID("stdout")
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#filter GoogleLoggingLogView#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#id GoogleLoggingLogView#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the resource. The supported locations are: global, us-central1, us-east1, us-west1, asia-east1, europe-west1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#location GoogleLoggingLogView#location}
    */
    readonly location?: string;
    /**
    * The resource name of the view. For example: `projects/my-project/locations/global/buckets/my-bucket/views/my-view`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#name GoogleLoggingLogView#name}
    */
    readonly name: string;
    /**
    * The parent of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#parent GoogleLoggingLogView#parent}
    */
    readonly parent?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#timeouts GoogleLoggingLogView#timeouts}
    */
    readonly timeouts?: GoogleLoggingLogViewTimeouts;
}
export interface GoogleLoggingLogViewTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#create GoogleLoggingLogView#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#delete GoogleLoggingLogView#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view#update GoogleLoggingLogView#update}
    */
    readonly update?: string;
}
export declare function googleLoggingLogViewTimeoutsToTerraform(struct?: GoogleLoggingLogViewTimeoutsOutputReference | GoogleLoggingLogViewTimeouts | cdktf.IResolvable): any;
export declare class GoogleLoggingLogViewTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingLogViewTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingLogViewTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view google_logging_log_view}
*/
export declare class GoogleLoggingLogView extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_log_view";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_log_view google_logging_log_view} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingLogViewConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingLogViewConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleLoggingLogViewTimeoutsOutputReference;
    putTimeouts(value: GoogleLoggingLogViewTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleLoggingLogViewTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
