import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingOrganizationExclusionConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_organization_exclusion#description GoogleLoggingOrganizationExclusion#description}
    */
    readonly description?: string;
    /**
    * Whether this exclusion rule should be disabled or not. This defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_organization_exclusion#disabled GoogleLoggingOrganizationExclusion#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The filter to apply when excluding logs. Only log entries that match the filter are excluded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_organization_exclusion#filter GoogleLoggingOrganizationExclusion#filter}
    */
    readonly filter: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_organization_exclusion#id GoogleLoggingOrganizationExclusion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the logging exclusion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_organization_exclusion#name GoogleLoggingOrganizationExclusion#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_organization_exclusion#org_id GoogleLoggingOrganizationExclusion#org_id}
    */
    readonly orgId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_organization_exclusion google_logging_organization_exclusion}
*/
export declare class GoogleLoggingOrganizationExclusion extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_organization_exclusion";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_logging_organization_exclusion google_logging_organization_exclusion} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingOrganizationExclusionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingOrganizationExclusionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
