import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMonitoringNotificationChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional human-readable description of this notification channel. This description may provide additional details, beyond the display name, for the channel. This may not exceed 1024 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#description GoogleMonitoringNotificationChannel#description}
    */
    readonly description?: string;
    /**
    * An optional human-readable name for this notification channel. It is recommended that you specify a non-empty and unique name in order to make it easier to identify the channels in your project, though this is not enforced. The display name is limited to 512 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#display_name GoogleMonitoringNotificationChannel#display_name}
    */
    readonly displayName?: string;
    /**
    * Whether notifications are forwarded to the described channel. This makes it possible to disable delivery of notifications to a particular channel without removing the channel from all alerting policies that reference the channel. This is a more convenient approach when the change is temporary and you want to receive notifications from the same set of alerting policies on the channel at some point in the future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#enabled GoogleMonitoringNotificationChannel#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#force_delete GoogleMonitoringNotificationChannel#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#id GoogleMonitoringNotificationChannel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Configuration fields that define the channel and its behavior. The
  permissible and required labels are specified in the
  NotificationChannelDescriptor corresponding to the type field.
  
  Labels with sensitive data are obfuscated by the API and therefore Terraform cannot
  determine if there are upstream changes to these fields. They can also be configured via
  the sensitive_labels block, but cannot be configured in both places.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#labels GoogleMonitoringNotificationChannel#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#project GoogleMonitoringNotificationChannel#project}
    */
    readonly project?: string;
    /**
    * The type of the notification channel. This field matches the value of the NotificationChannelDescriptor.type field. See https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list to get the list of valid values such as "email", "slack", etc...
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#type GoogleMonitoringNotificationChannel#type}
    */
    readonly type: string;
    /**
    * User-supplied key/value data that does not need to conform to the corresponding NotificationChannelDescriptor's schema, unlike the labels field. This field is intended to be used for organizing and identifying the NotificationChannel objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#user_labels GoogleMonitoringNotificationChannel#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * sensitive_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#sensitive_labels GoogleMonitoringNotificationChannel#sensitive_labels}
    */
    readonly sensitiveLabels?: GoogleMonitoringNotificationChannelSensitiveLabels;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#timeouts GoogleMonitoringNotificationChannel#timeouts}
    */
    readonly timeouts?: GoogleMonitoringNotificationChannelTimeouts;
}
export interface GoogleMonitoringNotificationChannelSensitiveLabels {
    /**
    * An authorization token for a notification channel. Channel types that support this field include: slack
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#auth_token GoogleMonitoringNotificationChannel#auth_token}
    */
    readonly authToken?: string;
    /**
    * An password for a notification channel. Channel types that support this field include: webhook_basicauth
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#password GoogleMonitoringNotificationChannel#password}
    */
    readonly password?: string;
    /**
    * An servicekey token for a notification channel. Channel types that support this field include: pagerduty
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#service_key GoogleMonitoringNotificationChannel#service_key}
    */
    readonly serviceKey?: string;
}
export declare function googleMonitoringNotificationChannelSensitiveLabelsToTerraform(struct?: GoogleMonitoringNotificationChannelSensitiveLabelsOutputReference | GoogleMonitoringNotificationChannelSensitiveLabels): any;
export declare class GoogleMonitoringNotificationChannelSensitiveLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringNotificationChannelSensitiveLabels | undefined;
    set internalValue(value: GoogleMonitoringNotificationChannelSensitiveLabels | undefined);
    private _authToken?;
    get authToken(): string;
    set authToken(value: string);
    resetAuthToken(): void;
    get authTokenInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _serviceKey?;
    get serviceKey(): string;
    set serviceKey(value: string);
    resetServiceKey(): void;
    get serviceKeyInput(): string | undefined;
}
export interface GoogleMonitoringNotificationChannelTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#create GoogleMonitoringNotificationChannel#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#delete GoogleMonitoringNotificationChannel#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel#update GoogleMonitoringNotificationChannel#update}
    */
    readonly update?: string;
}
export declare function googleMonitoringNotificationChannelTimeoutsToTerraform(struct?: GoogleMonitoringNotificationChannelTimeoutsOutputReference | GoogleMonitoringNotificationChannelTimeouts | cdktf.IResolvable): any;
export declare class GoogleMonitoringNotificationChannelTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringNotificationChannelTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringNotificationChannelTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel google_monitoring_notification_channel}
*/
export declare class GoogleMonitoringNotificationChannel extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_notification_channel";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_monitoring_notification_channel google_monitoring_notification_channel} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMonitoringNotificationChannelConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMonitoringNotificationChannelConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _forceDelete?;
    get forceDelete(): boolean | cdktf.IResolvable;
    set forceDelete(value: boolean | cdktf.IResolvable);
    resetForceDelete(): void;
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    get verificationStatus(): string;
    private _sensitiveLabels;
    get sensitiveLabels(): GoogleMonitoringNotificationChannelSensitiveLabelsOutputReference;
    putSensitiveLabels(value: GoogleMonitoringNotificationChannelSensitiveLabels): void;
    resetSensitiveLabels(): void;
    get sensitiveLabelsInput(): GoogleMonitoringNotificationChannelSensitiveLabels | undefined;
    private _timeouts;
    get timeouts(): GoogleMonitoringNotificationChannelTimeoutsOutputReference;
    putTimeouts(value: GoogleMonitoringNotificationChannelTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMonitoringNotificationChannelTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
