import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkConnectivityHubConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of the hub.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub#description GoogleNetworkConnectivityHub#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub#id GoogleNetworkConnectivityHub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub#labels GoogleNetworkConnectivityHub#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Immutable. The name of the hub. Hub names must be unique. They use the following form: `projects/{project_number}/locations/global/hubs/{hub_id}`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub#name GoogleNetworkConnectivityHub#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub#project GoogleNetworkConnectivityHub#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub#timeouts GoogleNetworkConnectivityHub#timeouts}
    */
    readonly timeouts?: GoogleNetworkConnectivityHubTimeouts;
}
export interface GoogleNetworkConnectivityHubRoutingVpcs {
}
export declare function googleNetworkConnectivityHubRoutingVpcsToTerraform(struct?: GoogleNetworkConnectivityHubRoutingVpcs): any;
export declare class GoogleNetworkConnectivityHubRoutingVpcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkConnectivityHubRoutingVpcs | undefined;
    set internalValue(value: GoogleNetworkConnectivityHubRoutingVpcs | undefined);
    get uri(): string;
}
export declare class GoogleNetworkConnectivityHubRoutingVpcsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkConnectivityHubRoutingVpcsOutputReference;
}
export interface GoogleNetworkConnectivityHubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub#create GoogleNetworkConnectivityHub#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub#delete GoogleNetworkConnectivityHub#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub#update GoogleNetworkConnectivityHub#update}
    */
    readonly update?: string;
}
export declare function googleNetworkConnectivityHubTimeoutsToTerraform(struct?: GoogleNetworkConnectivityHubTimeoutsOutputReference | GoogleNetworkConnectivityHubTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkConnectivityHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivityHubTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkConnectivityHubTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub google_network_connectivity_hub}
*/
export declare class GoogleNetworkConnectivityHub extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_connectivity_hub";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_hub google_network_connectivity_hub} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkConnectivityHubConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkConnectivityHubConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _routingVpcs;
    get routingVpcs(): GoogleNetworkConnectivityHubRoutingVpcsList;
    get state(): string;
    get uniqueId(): string;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleNetworkConnectivityHubTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkConnectivityHubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkConnectivityHubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
