import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkConnectivitySpokeConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of the spoke.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#description GoogleNetworkConnectivitySpoke#description}
    */
    readonly description?: string;
    /**
    * Immutable. The URI of the hub that this spoke is attached to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#hub GoogleNetworkConnectivitySpoke#hub}
    */
    readonly hub: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#id GoogleNetworkConnectivitySpoke#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#labels GoogleNetworkConnectivitySpoke#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#location GoogleNetworkConnectivitySpoke#location}
    */
    readonly location: string;
    /**
    * Immutable. The name of the spoke. Spoke names must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#name GoogleNetworkConnectivitySpoke#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#project GoogleNetworkConnectivitySpoke#project}
    */
    readonly project?: string;
    /**
    * linked_interconnect_attachments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#linked_interconnect_attachments GoogleNetworkConnectivitySpoke#linked_interconnect_attachments}
    */
    readonly linkedInterconnectAttachments?: GoogleNetworkConnectivitySpokeLinkedInterconnectAttachments;
    /**
    * linked_router_appliance_instances block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#linked_router_appliance_instances GoogleNetworkConnectivitySpoke#linked_router_appliance_instances}
    */
    readonly linkedRouterApplianceInstances?: GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstances;
    /**
    * linked_vpn_tunnels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#linked_vpn_tunnels GoogleNetworkConnectivitySpoke#linked_vpn_tunnels}
    */
    readonly linkedVpnTunnels?: GoogleNetworkConnectivitySpokeLinkedVpnTunnels;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#timeouts GoogleNetworkConnectivitySpoke#timeouts}
    */
    readonly timeouts?: GoogleNetworkConnectivitySpokeTimeouts;
}
export interface GoogleNetworkConnectivitySpokeLinkedInterconnectAttachments {
    /**
    * A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#site_to_site_data_transfer GoogleNetworkConnectivitySpoke#site_to_site_data_transfer}
    */
    readonly siteToSiteDataTransfer: boolean | cdktf.IResolvable;
    /**
    * The URIs of linked interconnect attachment resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#uris GoogleNetworkConnectivitySpoke#uris}
    */
    readonly uris: string[];
}
export declare function googleNetworkConnectivitySpokeLinkedInterconnectAttachmentsToTerraform(struct?: GoogleNetworkConnectivitySpokeLinkedInterconnectAttachmentsOutputReference | GoogleNetworkConnectivitySpokeLinkedInterconnectAttachments): any;
export declare class GoogleNetworkConnectivitySpokeLinkedInterconnectAttachmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivitySpokeLinkedInterconnectAttachments | undefined;
    set internalValue(value: GoogleNetworkConnectivitySpokeLinkedInterconnectAttachments | undefined);
    private _siteToSiteDataTransfer?;
    get siteToSiteDataTransfer(): boolean | cdktf.IResolvable;
    set siteToSiteDataTransfer(value: boolean | cdktf.IResolvable);
    get siteToSiteDataTransferInput(): boolean | cdktf.IResolvable | undefined;
    private _uris?;
    get uris(): string[];
    set uris(value: string[]);
    get urisInput(): string[] | undefined;
}
export interface GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances {
    /**
    * The IP address on the VM to use for peering.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#ip_address GoogleNetworkConnectivitySpoke#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The URI of the virtual machine resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#virtual_machine GoogleNetworkConnectivitySpoke#virtual_machine}
    */
    readonly virtualMachine?: string;
}
export declare function googleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstancesToTerraform(struct?: GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances | cdktf.IResolvable): any;
export declare class GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstancesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances | cdktf.IResolvable | undefined);
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _virtualMachine?;
    get virtualMachine(): string;
    set virtualMachine(value: string);
    resetVirtualMachine(): void;
    get virtualMachineInput(): string | undefined;
}
export declare class GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstancesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstancesOutputReference;
}
export interface GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstances {
    /**
    * A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#site_to_site_data_transfer GoogleNetworkConnectivitySpoke#site_to_site_data_transfer}
    */
    readonly siteToSiteDataTransfer: boolean | cdktf.IResolvable;
    /**
    * instances block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#instances GoogleNetworkConnectivitySpoke#instances}
    */
    readonly instances: GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances[] | cdktf.IResolvable;
}
export declare function googleNetworkConnectivitySpokeLinkedRouterApplianceInstancesToTerraform(struct?: GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesOutputReference | GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstances): any;
export declare class GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstances | undefined;
    set internalValue(value: GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstances | undefined);
    private _siteToSiteDataTransfer?;
    get siteToSiteDataTransfer(): boolean | cdktf.IResolvable;
    set siteToSiteDataTransfer(value: boolean | cdktf.IResolvable);
    get siteToSiteDataTransferInput(): boolean | cdktf.IResolvable | undefined;
    private _instances;
    get instances(): GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstancesList;
    putInstances(value: GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances[] | cdktf.IResolvable): void;
    get instancesInput(): cdktf.IResolvable | GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances[] | undefined;
}
export interface GoogleNetworkConnectivitySpokeLinkedVpnTunnels {
    /**
    * A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#site_to_site_data_transfer GoogleNetworkConnectivitySpoke#site_to_site_data_transfer}
    */
    readonly siteToSiteDataTransfer: boolean | cdktf.IResolvable;
    /**
    * The URIs of linked VPN tunnel resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#uris GoogleNetworkConnectivitySpoke#uris}
    */
    readonly uris: string[];
}
export declare function googleNetworkConnectivitySpokeLinkedVpnTunnelsToTerraform(struct?: GoogleNetworkConnectivitySpokeLinkedVpnTunnelsOutputReference | GoogleNetworkConnectivitySpokeLinkedVpnTunnels): any;
export declare class GoogleNetworkConnectivitySpokeLinkedVpnTunnelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivitySpokeLinkedVpnTunnels | undefined;
    set internalValue(value: GoogleNetworkConnectivitySpokeLinkedVpnTunnels | undefined);
    private _siteToSiteDataTransfer?;
    get siteToSiteDataTransfer(): boolean | cdktf.IResolvable;
    set siteToSiteDataTransfer(value: boolean | cdktf.IResolvable);
    get siteToSiteDataTransferInput(): boolean | cdktf.IResolvable | undefined;
    private _uris?;
    get uris(): string[];
    set uris(value: string[]);
    get urisInput(): string[] | undefined;
}
export interface GoogleNetworkConnectivitySpokeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#create GoogleNetworkConnectivitySpoke#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#delete GoogleNetworkConnectivitySpoke#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke#update GoogleNetworkConnectivitySpoke#update}
    */
    readonly update?: string;
}
export declare function googleNetworkConnectivitySpokeTimeoutsToTerraform(struct?: GoogleNetworkConnectivitySpokeTimeoutsOutputReference | GoogleNetworkConnectivitySpokeTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkConnectivitySpokeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkConnectivitySpokeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkConnectivitySpokeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke google_network_connectivity_spoke}
*/
export declare class GoogleNetworkConnectivitySpoke extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_connectivity_spoke";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_connectivity_spoke google_network_connectivity_spoke} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkConnectivitySpokeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkConnectivitySpokeConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hub?;
    get hub(): string;
    set hub(value: string);
    get hubInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get uniqueId(): string;
    get updateTime(): string;
    private _linkedInterconnectAttachments;
    get linkedInterconnectAttachments(): GoogleNetworkConnectivitySpokeLinkedInterconnectAttachmentsOutputReference;
    putLinkedInterconnectAttachments(value: GoogleNetworkConnectivitySpokeLinkedInterconnectAttachments): void;
    resetLinkedInterconnectAttachments(): void;
    get linkedInterconnectAttachmentsInput(): GoogleNetworkConnectivitySpokeLinkedInterconnectAttachments | undefined;
    private _linkedRouterApplianceInstances;
    get linkedRouterApplianceInstances(): GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstancesOutputReference;
    putLinkedRouterApplianceInstances(value: GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstances): void;
    resetLinkedRouterApplianceInstances(): void;
    get linkedRouterApplianceInstancesInput(): GoogleNetworkConnectivitySpokeLinkedRouterApplianceInstances | undefined;
    private _linkedVpnTunnels;
    get linkedVpnTunnels(): GoogleNetworkConnectivitySpokeLinkedVpnTunnelsOutputReference;
    putLinkedVpnTunnels(value: GoogleNetworkConnectivitySpokeLinkedVpnTunnels): void;
    resetLinkedVpnTunnels(): void;
    get linkedVpnTunnelsInput(): GoogleNetworkConnectivitySpokeLinkedVpnTunnels | undefined;
    private _timeouts;
    get timeouts(): GoogleNetworkConnectivitySpokeTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkConnectivitySpokeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkConnectivitySpokeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
