"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleNetworkServicesEdgeCacheOrigin = exports.GoogleNetworkServicesEdgeCacheOriginTimeoutsOutputReference = exports.googleNetworkServicesEdgeCacheOriginTimeoutsToTerraform = exports.GoogleNetworkServicesEdgeCacheOriginTimeoutOutputReference = exports.googleNetworkServicesEdgeCacheOriginTimeoutToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function googleNetworkServicesEdgeCacheOriginTimeoutToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        connect_timeout: cdktf.stringToTerraform(struct.connectTimeout),
        max_attempts_timeout: cdktf.stringToTerraform(struct.maxAttemptsTimeout),
        read_timeout: cdktf.stringToTerraform(struct.readTimeout),
        response_timeout: cdktf.stringToTerraform(struct.responseTimeout),
    };
}
exports.googleNetworkServicesEdgeCacheOriginTimeoutToTerraform = googleNetworkServicesEdgeCacheOriginTimeoutToTerraform;
class GoogleNetworkServicesEdgeCacheOriginTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._connectTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.connectTimeout = this._connectTimeout;
        }
        if (this._maxAttemptsTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxAttemptsTimeout = this._maxAttemptsTimeout;
        }
        if (this._readTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.readTimeout = this._readTimeout;
        }
        if (this._responseTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.responseTimeout = this._responseTimeout;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._connectTimeout = undefined;
            this._maxAttemptsTimeout = undefined;
            this._readTimeout = undefined;
            this._responseTimeout = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._connectTimeout = value.connectTimeout;
            this._maxAttemptsTimeout = value.maxAttemptsTimeout;
            this._readTimeout = value.readTimeout;
            this._responseTimeout = value.responseTimeout;
        }
    }
    get connectTimeout() {
        return this.getStringAttribute('connect_timeout');
    }
    set connectTimeout(value) {
        this._connectTimeout = value;
    }
    resetConnectTimeout() {
        this._connectTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get connectTimeoutInput() {
        return this._connectTimeout;
    }
    get maxAttemptsTimeout() {
        return this.getStringAttribute('max_attempts_timeout');
    }
    set maxAttemptsTimeout(value) {
        this._maxAttemptsTimeout = value;
    }
    resetMaxAttemptsTimeout() {
        this._maxAttemptsTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxAttemptsTimeoutInput() {
        return this._maxAttemptsTimeout;
    }
    get readTimeout() {
        return this.getStringAttribute('read_timeout');
    }
    set readTimeout(value) {
        this._readTimeout = value;
    }
    resetReadTimeout() {
        this._readTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readTimeoutInput() {
        return this._readTimeout;
    }
    get responseTimeout() {
        return this.getStringAttribute('response_timeout');
    }
    set responseTimeout(value) {
        this._responseTimeout = value;
    }
    resetResponseTimeout() {
        this._responseTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get responseTimeoutInput() {
        return this._responseTimeout;
    }
}
exports.GoogleNetworkServicesEdgeCacheOriginTimeoutOutputReference = GoogleNetworkServicesEdgeCacheOriginTimeoutOutputReference;
_a = JSII_RTTI_SYMBOL_1;
GoogleNetworkServicesEdgeCacheOriginTimeoutOutputReference[_a] = { fqn: "@cdktf/provider-google-beta.googleNetworkServicesEdgeCacheOrigin.GoogleNetworkServicesEdgeCacheOriginTimeoutOutputReference", version: "3.0.1" };
function googleNetworkServicesEdgeCacheOriginTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.googleNetworkServicesEdgeCacheOriginTimeoutsToTerraform = googleNetworkServicesEdgeCacheOriginTimeoutsToTerraform;
class GoogleNetworkServicesEdgeCacheOriginTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.GoogleNetworkServicesEdgeCacheOriginTimeoutsOutputReference = GoogleNetworkServicesEdgeCacheOriginTimeoutsOutputReference;
_b = JSII_RTTI_SYMBOL_1;
GoogleNetworkServicesEdgeCacheOriginTimeoutsOutputReference[_b] = { fqn: "@cdktf/provider-google-beta.googleNetworkServicesEdgeCacheOrigin.GoogleNetworkServicesEdgeCacheOriginTimeoutsOutputReference", version: "3.0.1" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_services_edge_cache_origin google_network_services_edge_cache_origin}
*/
class GoogleNetworkServicesEdgeCacheOrigin extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_network_services_edge_cache_origin google_network_services_edge_cache_origin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkServicesEdgeCacheOriginConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_network_services_edge_cache_origin',
            terraformGeneratorMetadata: {
                providerName: 'google-beta',
                providerVersion: '4.38.0',
                providerVersionConstraint: '~> 4.17'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // timeout - computed: false, optional: true, required: false
        this._timeout = new GoogleNetworkServicesEdgeCacheOriginTimeoutOutputReference(this, "timeout");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new GoogleNetworkServicesEdgeCacheOriginTimeoutsOutputReference(this, "timeouts");
        this._description = config.description;
        this._failoverOrigin = config.failoverOrigin;
        this._id = config.id;
        this._labels = config.labels;
        this._maxAttempts = config.maxAttempts;
        this._name = config.name;
        this._originAddress = config.originAddress;
        this._port = config.port;
        this._project = config.project;
        this._protocol = config.protocol;
        this._retryConditions = config.retryConditions;
        this._timeout.internalValue = config.timeout;
        this._timeouts.internalValue = config.timeouts;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get failoverOrigin() {
        return this.getStringAttribute('failover_origin');
    }
    set failoverOrigin(value) {
        this._failoverOrigin = value;
    }
    resetFailoverOrigin() {
        this._failoverOrigin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failoverOriginInput() {
        return this._failoverOrigin;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get maxAttempts() {
        return this.getNumberAttribute('max_attempts');
    }
    set maxAttempts(value) {
        this._maxAttempts = value;
    }
    resetMaxAttempts() {
        this._maxAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxAttemptsInput() {
        return this._maxAttempts;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get originAddress() {
        return this.getStringAttribute('origin_address');
    }
    set originAddress(value) {
        this._originAddress = value;
    }
    // Temporarily expose input value. Use with caution.
    get originAddressInput() {
        return this._originAddress;
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get protocol() {
        return this.getStringAttribute('protocol');
    }
    set protocol(value) {
        this._protocol = value;
    }
    resetProtocol() {
        this._protocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protocolInput() {
        return this._protocol;
    }
    get retryConditions() {
        return this.getListAttribute('retry_conditions');
    }
    set retryConditions(value) {
        this._retryConditions = value;
    }
    resetRetryConditions() {
        this._retryConditions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retryConditionsInput() {
        return this._retryConditions;
    }
    get timeout() {
        return this._timeout;
    }
    putTimeout(value) {
        this._timeout.internalValue = value;
    }
    resetTimeout() {
        this._timeout.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutInput() {
        return this._timeout.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            description: cdktf.stringToTerraform(this._description),
            failover_origin: cdktf.stringToTerraform(this._failoverOrigin),
            id: cdktf.stringToTerraform(this._id),
            labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._labels),
            max_attempts: cdktf.numberToTerraform(this._maxAttempts),
            name: cdktf.stringToTerraform(this._name),
            origin_address: cdktf.stringToTerraform(this._originAddress),
            port: cdktf.numberToTerraform(this._port),
            project: cdktf.stringToTerraform(this._project),
            protocol: cdktf.stringToTerraform(this._protocol),
            retry_conditions: cdktf.listMapper(cdktf.stringToTerraform, false)(this._retryConditions),
            timeout: googleNetworkServicesEdgeCacheOriginTimeoutToTerraform(this._timeout.internalValue),
            timeouts: googleNetworkServicesEdgeCacheOriginTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.GoogleNetworkServicesEdgeCacheOrigin = GoogleNetworkServicesEdgeCacheOrigin;
_c = JSII_RTTI_SYMBOL_1;
GoogleNetworkServicesEdgeCacheOrigin[_c] = { fqn: "@cdktf/provider-google-beta.googleNetworkServicesEdgeCacheOrigin.GoogleNetworkServicesEdgeCacheOrigin", version: "3.0.1" };
// =================
// STATIC PROPERTIES
// =================
GoogleNetworkServicesEdgeCacheOrigin.tfResourceType = "google_network_services_edge_cache_origin";
//# sourceMappingURL=data:application/json;base64,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